/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.CFG;
import age.of.civilizations2.jakowski.lukasz.Game_Calendar;
import age.of.civilizations2.jakowski.lukasz.HistoryLog;
import age.of.civilizations2.jakowski.lukasz.SaveManager;
import age.of.civilizations2.jakowski.lukasz.Timelapse_Capitals;
import age.of.civilizations2.jakowski.lukasz.Timelapse_GameData;
import age.of.civilizations2.jakowski.lukasz.Timelapse_Owners_GameData;
import age.of.civilizations2.jakowski.lukasz.Timelapse_Stats_GameData;
import age.of.civilizations2.jakowski.lukasz.Timelapse_TurnChanges;
import age.of.civilizations2.jakowski.lukasz.Timelapse_TurnChanges_GameData;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class TimelapseManager {
    protected Timelapse_GameData timelapseGameData = new Timelapse_GameData();
    protected Timelapse_Owners_GameData timelapseOwnersGameData = new Timelapse_Owners_GameData();
    protected Timelapse_TurnChanges_GameData timelapseTurnChanges = new Timelapse_TurnChanges_GameData();
    protected Timelapse_Stats_GameData timelapseStatsGD = new Timelapse_Stats_GameData();
    protected static int SOURCE = 0;
    protected static final int[] TIME_REQUIRED_TO_ACTION = new int[]{1, 2000, 1500, 1000, 750, 500, 250};
    protected static final int MAX_SPEED = 6;
    protected static int SPEED = 1;
    protected static boolean PAUSE = true;
    protected static long TIME_PAST = 0L;
    protected static long TIME_LAST_UPDATE = 0L;
    protected List<Integer> timelineOwners = new ArrayList<Integer>();
    protected List<Boolean> timelineOwners_IsOccupied = new ArrayList<Boolean>();
    protected List<Integer> timelineOwners_Capitals = new ArrayList<Integer>();
    protected Timelapse_TurnChanges_GameData timelineOwners_Changes = new Timelapse_TurnChanges_GameData();
    protected int iTimelineTurnID = 0;

    TimelapseManager() {
    }

    protected final void updateTime() {
        block5: {
            try {
                TIME_PAST += System.currentTimeMillis() - TIME_LAST_UPDATE;
                TIME_LAST_UPDATE = System.currentTimeMillis();
                if (this.timePasted()) {
                    TIME_PAST = 0L;
                    this.loadNextTurn();
                }
            }
            catch (NullPointerException nullPointerException) {
                if (CFG.LOGS) {
                    CFG.exceptionStack(nullPointerException);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (!CFG.LOGS) break block5;
                CFG.exceptionStack(indexOutOfBoundsException);
            }
        }
    }

    private final boolean timePasted() {
        return TIME_PAST > (long)this.getRequiredTime();
    }

    protected final int getRequiredTime() {
        return TIME_REQUIRED_TO_ACTION[SPEED];
    }

    protected final float getTimePerc() {
        return Math.min((float)TIME_PAST / (float)this.getRequiredTime(), 1.0f);
    }

    protected final void resetTime() {
        TIME_PAST = 0L;
        TIME_LAST_UPDATE = System.currentTimeMillis();
    }

    protected void pauseUnpause() {
        PAUSE = !PAUSE;
        boolean bl = PAUSE;
        if (!PAUSE) {
            if (this.iTimelineTurnID >= this.timelineOwners_Changes.lTurnChanges.size() - 1) {
                this.buildTimeline();
                PAUSE = false;
                if (CFG.menuManager.getInGame_Timeline()) {
                    CFG.menuManager.getInGame_Timeline_UpdateLanguage();
                } else if (CFG.menuManager.getInVictory()) {
                    CFG.menuManager.getInGame_Victory_UpdateLanguage();
                }
            }
            TIME_LAST_UPDATE = System.currentTimeMillis();
        }
    }

    protected void updateSpeed(int n) {
        float f = this.getTimePerc();
        if ((SPEED += n) < 1) {
            SPEED = 1;
        } else if (SPEED > 6) {
            SPEED = 6;
        }
        TIME_PAST = (long)((float)TIME_REQUIRED_TO_ACTION[SPEED] * f);
    }

    protected final void buildTimeline() {
        int n;
        int n2;
        int n3;
        this.clearTimeline();
        this.iTimelineTurnID = 0;
        this.resetTime();
        PAUSE = true;
        if (CFG.FOG_OF_WAR == 2) {
            for (n3 = 0; n3 < this.timelapseOwnersGameData.lProvinceOwnersAtBeginning.size(); ++n3) {
                if (CFG.game.getPlayer(CFG.PLAYER_TURNID).getMetProvince(n3)) {
                    this.timelineOwners.add(this.timelapseOwnersGameData.lProvinceOwnersAtBeginning.get(n3));
                } else {
                    this.timelineOwners.add(0);
                }
                this.timelineOwners_IsOccupied.add(false);
            }
            for (n3 = 0; n3 < this.timelapseGameData.lCivsCapitals.size(); ++n3) {
                n2 = this.timelapseGameData.lCivsCapitals.get(n3).getCapitalID(this.iTimelineTurnID + 1);
                if (n2 >= 0 && this.timelineOwners.get(n2) == n3 + 1 && CFG.game.getPlayer(CFG.PLAYER_TURNID).getMetCivilization(n3 + 1)) {
                    this.timelineOwners_Capitals.add(n2);
                    continue;
                }
                this.timelineOwners_Capitals.add(-1);
            }
        } else {
            for (n3 = 0; n3 < this.timelapseOwnersGameData.lProvinceOwnersAtBeginning.size(); ++n3) {
                this.timelineOwners.add(this.timelapseOwnersGameData.lProvinceOwnersAtBeginning.get(n3));
                this.timelineOwners_IsOccupied.add(false);
            }
            for (n3 = 0; n3 < this.timelapseGameData.lCivsCapitals.size(); ++n3) {
                n2 = this.timelapseGameData.lCivsCapitals.get(n3).getCapitalID(this.iTimelineTurnID + 1);
                if (n2 >= 0 && this.timelineOwners.get(n2) == n3 + 1) {
                    this.timelineOwners_Capitals.add(n2);
                    continue;
                }
                this.timelineOwners_Capitals.add(-1);
            }
        }
        if (SaveManager.saveTag != null) {
            n = 0;
            try {
                FileHandle fileHandle = null;
                fileHandle = CFG.readLocalFiles() ? Gdx.files.local("saves/games/" + CFG.map.getFile_ActiveMap_Path() + SaveManager.saveTag + "/TS/TURN/Age_of_Civilizations") : Gdx.files.internal("saves/games/" + CFG.map.getFile_ActiveMap_Path() + SaveManager.saveTag + "/TS/TURN/Age_of_Civilizations");
                String string = fileHandle.readString();
                n = Integer.parseInt(string) + 1;
                for (int i = 0; i < n; ++i) {
                    FileHandle fileHandle2 = null;
                    fileHandle2 = CFG.readLocalFiles() ? Gdx.files.local("saves/games/" + CFG.map.getFile_ActiveMap_Path() + SaveManager.saveTag + "/TS/TURN/" + SaveManager.saveTag + "_C_" + i) : Gdx.files.internal("saves/games/" + CFG.map.getFile_ActiveMap_Path() + SaveManager.saveTag + "/TS/TURN/" + SaveManager.saveTag + "_C_" + i);
                    Timelapse_TurnChanges_GameData timelapse_TurnChanges_GameData = (Timelapse_TurnChanges_GameData)CFG.deserialize(fileHandle2.readBytes());
                    for (int j = 0; j < timelapse_TurnChanges_GameData.lTurnChanges.size(); ++j) {
                        this.timelineOwners_Changes.lTurnChanges.add(timelapse_TurnChanges_GameData.lTurnChanges.get(j));
                    }
                }
            }
            catch (GdxRuntimeException gdxRuntimeException) {
                CFG.exceptionStack(gdxRuntimeException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                CFG.exceptionStack(classNotFoundException);
            }
            catch (IOException iOException) {
                CFG.exceptionStack(iOException);
            }
        }
        for (n = 0; n < this.timelapseTurnChanges.lTurnChanges.size(); ++n) {
            this.timelineOwners_Changes.lTurnChanges.add(this.timelapseTurnChanges.lTurnChanges.get(n));
        }
    }

    protected final void clearTimeline() {
        this.timelineOwners.clear();
        this.timelineOwners_IsOccupied.clear();
        this.timelineOwners_Capitals.clear();
        this.timelineOwners_Changes.lTurnChanges.clear();
    }

    protected final void clearTimeline_Statistics() {
        this.timelapseStatsGD.lProvinces.clear();
        this.timelapseStatsGD.lPopulation.clear();
        this.timelapseStatsGD.lRank.clear();
        this.timelapseStatsGD.lTechnologyLevel.clear();
        this.timelapseStatsGD.lPlayers_Income.clear();
        this.timelapseStatsGD.lPlayers_Balance.clear();
        this.timelapseStatsGD.lPlayers_MilitarySpendings.clear();
        this.timelapseStatsGD.lHistory = new ArrayList<List<HistoryLog>>();
    }

    protected final void loadNextTurn() {
        if (this.iTimelineTurnID < this.timelineOwners_Changes.lTurnChanges.size() - 1) {
            this.timelineOwners_Capitals.clear();
            if (CFG.FOG_OF_WAR == 2) {
                int n;
                for (n = 0; n < this.timelineOwners_Changes.lTurnChanges.get(this.iTimelineTurnID).size(); ++n) {
                    if (!CFG.game.getPlayer(CFG.PLAYER_TURNID).getMetProvince(this.timelineOwners_Changes.lTurnChanges.get((int)this.iTimelineTurnID).get((int)n).iProvinceID)) continue;
                    this.timelineOwners.set(this.timelineOwners_Changes.lTurnChanges.get((int)this.iTimelineTurnID).get((int)n).iProvinceID, this.timelineOwners_Changes.lTurnChanges.get((int)this.iTimelineTurnID).get((int)n).iToCivID);
                    this.timelineOwners_IsOccupied.set(this.timelineOwners_Changes.lTurnChanges.get((int)this.iTimelineTurnID).get((int)n).iProvinceID, this.timelineOwners_Changes.lTurnChanges.get((int)this.iTimelineTurnID).get((int)n).isOccupied);
                }
                for (n = 0; n < this.timelapseGameData.lCivsCapitals.size(); ++n) {
                    int n2 = this.timelapseGameData.lCivsCapitals.get(n).getCapitalID(this.iTimelineTurnID + 1);
                    if (n2 >= 0 && this.timelineOwners.get(n2) == n + 1 && CFG.game.getPlayer(CFG.PLAYER_TURNID).getMetCivilization(n + 1)) {
                        this.timelineOwners_Capitals.add(n2);
                        continue;
                    }
                    this.timelineOwners_Capitals.add(-1);
                }
            } else {
                int n;
                for (n = 0; n < this.timelineOwners_Changes.lTurnChanges.get(this.iTimelineTurnID).size(); ++n) {
                    this.timelineOwners.set(this.timelineOwners_Changes.lTurnChanges.get((int)this.iTimelineTurnID).get((int)n).iProvinceID, this.timelineOwners_Changes.lTurnChanges.get((int)this.iTimelineTurnID).get((int)n).iToCivID);
                    this.timelineOwners_IsOccupied.set(this.timelineOwners_Changes.lTurnChanges.get((int)this.iTimelineTurnID).get((int)n).iProvinceID, this.timelineOwners_Changes.lTurnChanges.get((int)this.iTimelineTurnID).get((int)n).isOccupied);
                }
                for (n = 0; n < this.timelapseGameData.lCivsCapitals.size(); ++n) {
                    int n3 = this.timelapseGameData.lCivsCapitals.get(n).getCapitalID(this.iTimelineTurnID + 1);
                    if (n3 >= 0 && this.timelineOwners.get(n3) == n + 1) {
                        this.timelineOwners_Capitals.add(n3);
                        continue;
                    }
                    this.timelineOwners_Capitals.add(-1);
                }
            }
            ++this.iTimelineTurnID;
            if (CFG.menuManager.getInGame_Timeline()) {
                CFG.menuManager.getInGame_Timeline_UpdateLanguage();
            } else if (CFG.menuManager.getInVictory()) {
                CFG.menuManager.getInGame_Victory_UpdateLanguage();
                CFG.map.getMapCoordinates().centerToCivilizationBox_Timeline(CFG.game.getPlayer(CFG.PLAYER_TURNID).getCivID(), true);
            }
        } else {
            PAUSE = true;
        }
    }

    protected final void newGame() {
        int n;
        this.timelapseOwnersGameData.lProvinceOwnersAtBeginning.clear();
        this.timelapseGameData.lCivsCapitals.clear();
        this.timelapseTurnChanges.lTurnChanges.clear();
        this.clearTimeline();
        this.clearTimeline_Statistics();
        for (n = 0; n < CFG.game.getProvincesSize(); ++n) {
            if (CFG.game.getProvince(n).getSeaProvince()) {
                this.timelapseOwnersGameData.lProvinceOwnersAtBeginning.add(0);
                continue;
            }
            if (CFG.game.getProvince(n).getWasteland() >= 0) {
                this.timelapseOwnersGameData.lProvinceOwnersAtBeginning.add(-1);
                continue;
            }
            this.timelapseOwnersGameData.lProvinceOwnersAtBeginning.add(CFG.game.getProvince(n).getCivID());
        }
        for (n = 1; n < CFG.game.getCivsSize(); ++n) {
            this.timelapseGameData.lCivsCapitals.add(new Timelapse_Capitals(CFG.game.getCiv(n).getCapitalProvinceID(), 1));
        }
        this.timelapseTurnChanges.lTurnChanges.add(new ArrayList());
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
        for (int i = 0; i < CFG.game.getCivsSize(); ++i) {
            arrayList.add(CFG.game.getCiv(i).getNumOfProvinces());
            arrayList2.add(CFG.game.getCiv(i).countPopulation() + (long)CFG.game.getCiv(i).getNumOfUnits());
            arrayList3.add(CFG.game.getCiv(i).getRankScore());
            arrayList4.add((int)(CFG.game.getCiv(i).getTechnologyLevel() * 100.0f));
        }
        this.timelapseStatsGD.addProvinces(arrayList);
        this.timelapseStatsGD.addPopulation(arrayList2);
        this.timelapseStatsGD.addRank(arrayList3);
        this.timelapseStatsGD.addTechLevel(arrayList4);
    }

    protected final void newTurn() {
        this.timelapseTurnChanges.lTurnChanges.add(new ArrayList());
        this.updateTurnStatistics();
    }

    protected final void addChange(int n, int n2, boolean bl) {
        int n3 = this.timelapseTurnChanges.lTurnChanges.size() - 1;
        for (int i = 0; i < this.timelapseTurnChanges.lTurnChanges.get(n3).size(); ++i) {
            if (this.timelapseTurnChanges.lTurnChanges.get((int)n3).get((int)i).iProvinceID != n) continue;
            this.timelapseTurnChanges.lTurnChanges.get((int)n3).get((int)i).iToCivID = n2;
            this.timelapseTurnChanges.lTurnChanges.get((int)n3).get((int)i).isOccupied = bl;
            return;
        }
        this.timelapseTurnChanges.lTurnChanges.get(n3).add(new Timelapse_TurnChanges(n, n2, bl));
    }

    protected final void updateTurnStatistics() {
        try {
            for (int i = 1; i < CFG.game.getCivsSize(); ++i) {
                this.timelapseGameData.lCivsCapitals.get(i - 1).updateCapital(CFG.game.getCiv(i).getCapitalProvinceID(), Game_Calendar.TURN_ID);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            for (int i = this.timelapseGameData.lCivsCapitals.size() + 1; i < CFG.game.getCivsSize(); ++i) {
                this.timelapseGameData.lCivsCapitals.add(new Timelapse_Capitals(CFG.game.getCiv(i).getCapitalProvinceID(), Game_Calendar.TURN_ID));
            }
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
        for (int i = 0; i < CFG.game.getCivsSize(); ++i) {
            arrayList.add(CFG.game.getCiv(i).getNumOfProvinces());
            arrayList2.add(CFG.game.getCiv(i).countPopulation() + (long)CFG.game.getCiv(i).getNumOfUnits());
            arrayList3.add(CFG.game.getCiv(i).getRankScore());
            arrayList4.add((int)(CFG.game.getCiv(i).getTechnologyLevel() * 100.0f));
        }
        this.timelapseStatsGD.addProvinces(arrayList);
        this.timelapseStatsGD.addPopulation(arrayList2);
        this.timelapseStatsGD.addRank(arrayList3);
        this.timelapseStatsGD.addTechLevel(arrayList4);
        ArrayList<Integer> arrayList5 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList6 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList7 = new ArrayList<Integer>();
        for (int i = 0; i < CFG.game.getPlayersSize(); ++i) {
            arrayList5.add(CFG.game.getCiv((int)CFG.game.getPlayer((int)i).getCivID()).iIncomeTaxation + CFG.game.getCiv((int)CFG.game.getPlayer((int)i).getCivID()).iIncomeProduction);
            arrayList7.add((int)CFG.game_NextTurnUpdate.getMilitaryUpkeep_Total(CFG.game.getPlayer(i).getCivID()));
            arrayList6.add((int)CFG.game_NextTurnUpdate.getIncome(CFG.game.getPlayer(i).getCivID()) - (int)CFG.game_NextTurnUpdate.getExpenses(CFG.game.getPlayer(i).getCivID()));
        }
        this.timelapseStatsGD.lPlayers_Income.add(arrayList5);
        this.timelapseStatsGD.lPlayers_Balance.add(arrayList6);
        this.timelapseStatsGD.lPlayers_MilitarySpendings.add(arrayList7);
        if (this.timelapseStatsGD.lPlayers_Income.size() > CFG.settingsManager.GRAPH_DATA_LIMIT_PLAYER_DATA) {
            this.timelapseStatsGD.lPlayers_Income.remove(0);
        }
        if (this.timelapseStatsGD.lPlayers_Balance.size() > CFG.settingsManager.GRAPH_DATA_LIMIT_PLAYER_DATA) {
            this.timelapseStatsGD.lPlayers_Balance.remove(0);
        }
        if (this.timelapseStatsGD.lPlayers_MilitarySpendings.size() > CFG.settingsManager.GRAPH_DATA_LIMIT_PLAYER_DATA) {
            this.timelapseStatsGD.lPlayers_MilitarySpendings.remove(0);
        }
    }

    protected final int getNumOfProvinces(int n) {
        int n2 = 0;
        try {
            for (int i = this.timelineOwners.size() - 1; i >= 0; --i) {
                if (this.timelineOwners.get(i) != n) continue;
                ++n2;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return n2;
    }

    protected final int getPlayerIncome(int n, int n2) {
        try {
            return this.timelapseStatsGD.lPlayers_Income.get(n2).get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            try {
                if (n2 >= this.timelapseStatsGD.lPlayers_Income.size()) {
                    return this.timelapseStatsGD.lPlayers_Income.get(this.timelapseStatsGD.lPlayers_Income.size() - 1).get(n);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException2) {
                // empty catch block
            }
            return 0;
        }
    }
}

