/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.AoCGame;
import age.of.civilizations2.jakowski.lukasz.CFG;
import age.of.civilizations2.jakowski.lukasz.Color_GameData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

class Alliance
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String sAllianceName;
    private Color_GameData allianceColor;
    private List<Integer> lCivilizations;
    private int iCivilizationsSize;
    private int iFormationTurnID = 1;

    protected Alliance(String string) {
        this.sAllianceName = string;
        this.lCivilizations = new ArrayList<Integer>();
        this.iCivilizationsSize = 0;
        this.allianceColor = CFG.getRandomColorGameData();
    }

    protected final void addCivilization(int n) {
        int n2;
        for (n2 = 0; n2 < this.iCivilizationsSize; ++n2) {
            if (this.lCivilizations.get(n2) != n) continue;
            return;
        }
        this.lCivilizations.add(n);
        this.iCivilizationsSize = this.lCivilizations.size();
        for (n2 = 0; n2 < this.iCivilizationsSize - 1; ++n2) {
            CFG.game.setCivRelation_OfCivB(this.lCivilizations.get(n2), n, Math.min(CFG.game.getCivRelation_OfCivB(this.lCivilizations.get(n2), n), 65.0f));
            CFG.game.setCivRelation_OfCivB(n, this.lCivilizations.get(n2), Math.min(CFG.game.getCivRelation_OfCivB(n, this.lCivilizations.get(n2)), 65.0f));
        }
        if (CFG.isDesktop() && (CFG.menuManager.getInGameView() || CFG.menuManager.getInNextPlayerTurn()) && CFG.game.getCiv(n).getControlledByPlayer() && AoCGame.steamGame != null) {
            AoCGame.steamGame.uploadAlliance();
        }
    }

    protected final void removeCivilization(int n) {
        for (int i = 0; i < this.iCivilizationsSize; ++i) {
            if (this.lCivilizations.get(i) != n) continue;
            this.lCivilizations.remove(i);
            this.iCivilizationsSize = this.lCivilizations.size();
            for (int j = 0; j < this.iCivilizationsSize; ++j) {
                if (!(CFG.game.getCivRelation_OfCivB(this.lCivilizations.get(j), n) > 0.0f) && !(CFG.game.getCivRelation_OfCivB(n, this.lCivilizations.get(j)) > 0.0f)) continue;
                CFG.game.setCivRelation_OfCivB(this.lCivilizations.get(j), n, 0.0f);
                CFG.game.setCivRelation_OfCivB(n, this.lCivilizations.get(j), 0.0f);
            }
            return;
        }
    }

    protected final void updateCivilizationID(int n, int n2) {
        block2: {
            try {
                this.lCivilizations.set(n, n2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (!CFG.LOGS) break block2;
                CFG.exceptionStack(indexOutOfBoundsException);
            }
        }
    }

    protected final void moveUp(int n) {
        if (n == 0) {
            return;
        }
        int n2 = this.lCivilizations.get(n - 1);
        this.lCivilizations.set(n - 1, this.lCivilizations.get(n));
        this.lCivilizations.set(n, n2);
    }

    protected final void moveDown(int n) {
        int n2 = this.lCivilizations.get(n + 1);
        this.lCivilizations.set(n + 1, this.lCivilizations.get(n));
        this.lCivilizations.set(n, n2);
    }

    protected final void updateCivsIDs_AfterRemoveCiv(int n) {
        for (int i = 0; i < this.getCivilizationsSize(); ++i) {
            if (this.getCivilization(i) <= n) continue;
            this.lCivilizations.set(i, this.lCivilizations.get(i) - 1);
        }
    }

    protected final String getAllianceName() {
        return this.sAllianceName;
    }

    protected final void setAllianceName(String string) {
        this.sAllianceName = string;
    }

    protected final int getCivilization(int n) {
        return this.lCivilizations.get(n);
    }

    protected final int getCivilizationsSize() {
        return this.iCivilizationsSize;
    }

    protected final Color_GameData getColorOfAlliance() {
        return this.allianceColor;
    }

    protected final void setColorOfAlliance(Color_GameData color_GameData) {
        this.allianceColor = color_GameData;
    }

    protected final int getFormationTurnID() {
        return this.iFormationTurnID;
    }

    protected final void setFormationTurnID(int n) {
        this.iFormationTurnID = n;
    }

    protected final int countProvinces() {
        int n = 0;
        for (int i = 0; i < this.getCivilizationsSize(); ++i) {
            n += CFG.game.getCiv(this.getCivilization(i)).getNumOfProvinces();
        }
        return n;
    }

    protected final long countPopulation() {
        long l = 0L;
        for (int i = 0; i < this.getCivilizationsSize(); ++i) {
            l += CFG.game.getCiv(this.getCivilization(i)).countPopulation();
        }
        return l;
    }

    protected final int countEconomy() {
        int n = 0;
        for (int i = 0; i < this.getCivilizationsSize(); ++i) {
            n = (int)((long)n + CFG.game.getCiv(this.getCivilization(i)).countEconomy());
        }
        return n;
    }
}

