/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.CFG;
import age.of.civilizations2.jakowski.lukasz.Graph;
import age.of.civilizations2.jakowski.lukasz.GraphLine;
import age.of.civilizations2.jakowski.lukasz.ImageManager;
import age.of.civilizations2.jakowski.lukasz.Images;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.utils.ScissorStack;
import java.util.ArrayList;
import java.util.List;

class GraphData {
    private static final float ALPHA_CIV_LINE = 0.8f;
    private int iCivID;
    private List<Long> lPointsY;
    private int iPointsSize = 0;
    private List<GraphLine> lGraphLines;
    private int iBeginTurnID;
    private boolean drawData = true;
    private boolean visible = true;
    private boolean backAnimation = false;
    protected static final int ANIMATION_TIME = 750;
    private long lTime = 0L;

    protected GraphData(int n, List<Long> list, int n2) {
        this.iCivID = n;
        this.iPointsSize = list.size();
        this.lPointsY = new ArrayList<Long>();
        this.lGraphLines = new ArrayList<GraphLine>();
        for (int i = 0; i < this.iPointsSize; ++i) {
            this.lPointsY.add(list.get(i));
        }
        this.iBeginTurnID = n2;
        this.drawData = false;
    }

    protected final void draw(SpriteBatch spriteBatch, int n, int n2, int n3, int n4, List<Integer> list, int n5, boolean bl, int n6) {
        if (this.lTime + 750L >= System.currentTimeMillis()) {
            this.drawAnimation(spriteBatch, n, n2, n3, n4, list, n5, bl, n6);
        } else {
            this.drawGraphData(spriteBatch, n, n2 - n6, list, n5, bl);
        }
    }

    protected final void drawAnimation(SpriteBatch spriteBatch, int n, int n2, int n3, int n4, List<Integer> list, int n5, boolean bl, int n6) {
        Rectangle rectangle = this.backAnimation ? new Rectangle(n, CFG.GAME_HEIGHT - n2, n3 - (int)((float)n3 * ((float)(System.currentTimeMillis() - this.lTime) / 750.0f)), -n4) : new Rectangle(n, CFG.GAME_HEIGHT - n2, (int)((float)n3 * ((float)(System.currentTimeMillis() - this.lTime) / 750.0f)), -n4);
        spriteBatch.flush();
        ScissorStack.pushScissors(rectangle);
        this.drawGraphData(spriteBatch, n, n2 - n6, list, n5, true);
        CFG.setRender_3(true);
        try {
            spriteBatch.flush();
            ScissorStack.popScissors();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private final void drawGraphData(SpriteBatch spriteBatch, int n, int n2, List<Integer> list, int n3, boolean bl) {
        try {
            spriteBatch.setColor(new Color((float)CFG.game.getCiv(this.iCivID).getR() / 255.0f, (float)CFG.game.getCiv(this.iCivID).getG() / 255.0f, (float)CFG.game.getCiv(this.iCivID).getB() / 255.0f, bl ? 1.0f : 0.8f));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            spriteBatch.setColor(new Color(0.05882353f, 0.05882353f, 0.05882353f, bl ? 1.0f : 0.8f));
        }
        for (int i = 0; i < this.iPointsSize - 1; ++i) {
            this.lGraphLines.get(i).draw(spriteBatch, n + list.get(this.iBeginTurnID + i), n2, n3);
        }
    }

    protected final void drawCivButton(SpriteBatch spriteBatch, int n, int n2, boolean bl) {
        spriteBatch.setColor(new Color(Graph.GRAPH_BG_COLOR.r, Graph.GRAPH_BG_COLOR.g, Graph.GRAPH_BG_COLOR.b, bl ? Graph.GRAPH_BG_COLOR.a * 2.0f : (this.drawData ? Graph.GRAPH_BG_COLOR.a : Graph.GRAPH_BG_COLOR.a / 4.0f)));
        ImageManager.getImage(Images.pix255_255_255).draw(spriteBatch, n, n2, Graph.getGraphButtonWidth(), Graph.getGraphButtonHeight());
        spriteBatch.setColor(new Color(Graph.GRAPH_BORDERS_COLOR.r, Graph.GRAPH_BORDERS_COLOR.g, Graph.GRAPH_BORDERS_COLOR.b, this.drawData ? Graph.GRAPH_BORDERS_COLOR.a : 0.25f));
        try {
            spriteBatch.setColor(new Color((float)CFG.game.getCiv(this.iCivID).getR() / 255.0f, (float)CFG.game.getCiv(this.iCivID).getG() / 255.0f, (float)CFG.game.getCiv(this.iCivID).getB() / 255.0f, this.drawData ? 0.8f : 0.4f));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            spriteBatch.setColor(new Color(0.05882353f, 0.05882353f, 0.05882353f, this.drawData ? 0.8f : 0.4f));
        }
        ImageManager.getImage(Images.pix255_255_255).draw(spriteBatch, n, n2, CFG.CIV_COLOR_WIDTH, Graph.getGraphButtonHeight());
        spriteBatch.setColor(this.drawData ? Color.WHITE : new Color(1.0f, 1.0f, 1.0f, 0.25f));
        try {
            CFG.game.getCiv(this.iCivID).getFlag().draw(spriteBatch, n + Graph.getGraphButtonWidth() / 2 - CFG.CIV_FLAG_WIDTH / 2, n2 + Graph.getGraphButtonHeight() / 2 - CFG.CIV_FLAG_HEIGHT / 2 - CFG.game.getCiv(this.iCivID).getFlag().getHeight(), CFG.CIV_FLAG_WIDTH, CFG.CIV_FLAG_HEIGHT);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            ImageManager.getImage(Images.randomCivilizationFlag).draw(spriteBatch, n + Graph.getGraphButtonWidth() / 2 - CFG.CIV_FLAG_WIDTH / 2, n2 + Graph.getGraphButtonHeight() / 2 - CFG.CIV_FLAG_HEIGHT / 2 - ImageManager.getImage(Images.randomCivilizationFlag).getHeight(), CFG.CIV_FLAG_WIDTH, CFG.CIV_FLAG_HEIGHT);
        }
        ImageManager.getImage(Images.flag_rect).draw(spriteBatch, n + Graph.getGraphButtonWidth() / 2 - CFG.CIV_FLAG_WIDTH / 2, n2 + Graph.getGraphButtonHeight() / 2 - CFG.CIV_FLAG_HEIGHT / 2);
        spriteBatch.setColor(Color.WHITE);
    }

    protected final void buildGraph(int n, long l, long l2, List<Integer> list) {
        this.lGraphLines.clear();
        for (int i = 0; i < this.iPointsSize - 1; ++i) {
            this.lGraphLines.add(new GraphLine(list.get(this.iBeginTurnID + i), (int)((float)n - (float)n * (100.0f * (float)this.lPointsY.get(i).longValue()) / (float)(l2 - l) / 100.0f), list.get(this.iBeginTurnID + i + 1), (int)((float)n - (float)n * (100.0f * (float)this.lPointsY.get(i + 1).longValue()) / (float)(l2 - l) / 100.0f)));
        }
    }

    protected final long getPointY(int n) {
        try {
            return this.lPointsY.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return 0L;
        }
    }

    protected final int getPointsSize() {
        return this.iPointsSize;
    }

    protected final int getCivID() {
        return this.iCivID;
    }

    protected final int getBeginTurnID() {
        return this.iBeginTurnID;
    }

    protected final boolean getDrawData() {
        return this.drawData;
    }

    protected final void setDrawData(boolean bl) {
        if (bl != this.drawData) {
            this.lTime = this.lTime > System.currentTimeMillis() - 750L && (this.drawData || this.backAnimation) ? System.currentTimeMillis() - (750L - (System.currentTimeMillis() - this.lTime)) : System.currentTimeMillis();
            CFG.setRender_3(true);
            this.backAnimation = !bl;
        }
        this.drawData = bl;
    }

    protected final boolean getVisible() {
        return this.visible;
    }

    protected final void setVisible(boolean bl) {
        this.visible = bl;
    }

    protected final boolean getBackAnimation() {
        return this.backAnimation;
    }

    protected final void setBackAnimation(boolean bl) {
        this.backAnimation = bl;
    }

    protected final long getTime() {
        return this.lTime;
    }
}

