/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.BuildingsManager;
import age.of.civilizations2.jakowski.lukasz.CFG;
import age.of.civilizations2.jakowski.lukasz.Game_Calendar;
import age.of.civilizations2.jakowski.lukasz.Message_HighInflation;
import com.badlogic.gdx.Gdx;
import java.util.ArrayList;

class Game_NextTurnUpdate {
    protected static int INFLATION_PEAK_VALUE = 100;
    protected static final float INFLATION_STARTS_AT = 0.235f;
    protected static final float INFLATION_MODIFIER = 18.12746f;
    protected static float LEAGUE_BUDGET = 1.0f;
    protected static final float TAXES_INFLUENCE_POP = 0.3f;
    protected static final float TAXES_INFLUENCE_PRODUCTION = 0.175f;
    protected static final int PERCENTAGE_OF_INCOME_FOR_LORD_DEFAULT = 9;
    protected static final int PERCENTAGE_OF_INCOME_FOR_LORD_MAX = 20;
    protected static final int PERCENTAGE_OF_INCOME_FOR_LORD_MIN = 0;
    protected static final float PERCENTAGE_OF_INCOME_FOR_WAR_REPARATIONS = 0.08f;
    protected static final float EMPLOYEMENT_PER_ECONOMY = 1.025f;
    protected static final float EMPLOYEMENT_PER_ECONOMY_OLD = 1.775f;
    protected static final float DEFENSIVE_POSITION_MILITARY_UPKEEP_PER_TUR = 0.008f;
    protected static final int BUDGET_MAX = 200;

    Game_NextTurnUpdate() {
    }

    protected final void updatePlayableProvinces() {
        int n;
        CFG.oAI.PLAYABLE_PROVINCES = 0;
        for (n = 0; n < CFG.game.getProvincesSize(); ++n) {
            if (CFG.game.getProvince(n).getSeaProvince() || CFG.game.getProvince(n).getWasteland() >= 0) continue;
            ++CFG.oAI.PLAYABLE_PROVINCES;
        }
        CFG.oAI.NUM_OF_CIVS_IN_THE_GAME = 0;
        for (n = 1; n < CFG.game.getCivsSize(); ++n) {
            if (CFG.game.getCiv(n).getNumOfProvinces() <= 0) continue;
            ++CFG.oAI.NUM_OF_CIVS_IN_THE_GAME;
        }
        CFG.oAI.NUM_OF_CIVS_IN_THE_GAME = Math.max(1, CFG.oAI.NUM_OF_CIVS_IN_THE_GAME);
        CFG.oAI.updateMinRivals();
    }

    protected final void updateInflationPeakValue() {
        int n;
        INFLATION_PEAK_VALUE = 1;
        for (n = 1; n < CFG.game.getCivsSize(); ++n) {
            if (CFG.game.getCiv(n).getNumOfProvinces() <= 0) continue;
            INFLATION_PEAK_VALUE = Math.max(INFLATION_PEAK_VALUE, CFG.game.getCiv((int)n).iIncomeTaxation + CFG.game.getCiv((int)n).iIncomeProduction);
            LEAGUE_BUDGET = (int)Math.max(LEAGUE_BUDGET, (float)(CFG.game.getCiv((int)n).iIncomeTaxation + CFG.game.getCiv((int)n).iIncomeProduction - CFG.game.getCiv((int)n).iAdministrationCosts));
        }
        LEAGUE_BUDGET = (int)(LEAGUE_BUDGET * 0.9f);
        for (n = 1; n < CFG.game.getCivsSize(); ++n) {
            if (CFG.game.getCiv(n).getNumOfProvinces() <= 0) continue;
            CFG.game.getCiv((int)n).iLeague = Math.min((int)((float)Math.max(CFG.game.getCiv((int)n).iIncomeTaxation + CFG.game.getCiv((int)n).iIncomeProduction - CFG.game.getCiv((int)n).iAdministrationCosts, 0) / LEAGUE_BUDGET * 10.0f), 10);
        }
        for (n = 0; n < CFG.game.getPlayersSize(); ++n) {
            if (!(this.getInflationPerc(CFG.game.getPlayer(n).getCivID()) > 0.0049f)) continue;
            CFG.game.getCiv((int)CFG.game.getPlayer((int)n).getCivID()).getCivilization_Diplomacy_GameData().messageBox.addMessage(new Message_HighInflation(CFG.game.getPlayer(n).getCivID(), 0));
        }
    }

    protected final void updateCivs_Money() {
        int n;
        Gdx.app.log("AoC", "updateCivs_Money 0000");
        for (n = 1; n < CFG.game.getCivsSize(); ++n) {
            this.getBalance_UpdateBudget_Prepare(n);
        }
        Gdx.app.log("AoC", "updateCivs_Money 11111");
        for (n = 1; n < CFG.game.getCivsSize(); ++n) {
            if (CFG.game.getCiv(n).getNumOfProvinces() <= 0) continue;
            CFG.game.getCiv(n).setMoney(CFG.game.getCiv(n).getMoney() + (long)this.getBalance(n));
            CFG.game.getCiv(n).updateLoansNextTurn();
        }
        Gdx.app.log("AoC", "updateCivs_Money END");
    }

    protected final void updateProvinceStability() {
        int n;
        for (n = 1; n < CFG.game.getCivsSize(); ++n) {
            CFG.game.getCiv((int)n).lProvincesWithLowStability.clear();
            CFG.game.getCiv((int)n).fStability = 0.0f;
        }
        for (n = 0; n < CFG.game.getProvincesSize(); ++n) {
            if (CFG.game.getProvince(n).getSeaProvince() || CFG.game.getProvince(n).getWasteland() >= 0) continue;
            CFG.game.getProvince(n).updateProvinceStability();
            if (CFG.game.getProvince(n).getCivID() <= 0) continue;
            CFG.game.getCiv((int)CFG.game.getProvince((int)n).getCivID()).fStability += CFG.game.getProvince(n).getProvinceStability();
        }
        for (n = 1; n < CFG.game.getCivsSize(); ++n) {
            for (int i = CFG.game.getCiv((int)n).lProvincesWithLowStability.size() - 1; i >= 0; --i) {
                if (!CFG.game.getCiv(n).isAssimilateOrganized(CFG.game.getCiv((int)n).lProvincesWithLowStability.get(i))) continue;
                CFG.game.getCiv((int)n).lProvincesWithLowStability.remove(i);
            }
            CFG.game.getCiv(n).setStability(CFG.game.getCiv((int)n).fStability / (float)CFG.game.getCiv(n).getNumOfProvinces());
        }
    }

    protected final int getBalance(int n) {
        return (int)(this.getIncome(n) - this.getExpenses(n));
    }

    protected final int getAdministration_Capital(int n) {
        return CFG.game.getCiv(n).getCapitalProvinceID() < 0 ? (CFG.game.getCiv(n).getNumOfProvinces() > 0 ? CFG.game.getCiv(n).getProvinceID(0) : 0) : CFG.game.getCiv(n).getCapitalProvinceID();
    }

    protected final void getBalance_UpdateBudget_Prepare(int n) {
        CFG.game.getCiv((int)n).iIncomeTaxation = 0;
        CFG.game.getCiv((int)n).iIncomeProduction = 0;
        CFG.game.getCiv((int)n).iAdministrationCosts = 0;
        int n2 = this.getAdministration_Capital(n);
        float f = this.taxIncome_Modifier(n);
        for (int i = 0; i < CFG.game.getCiv(n).getNumOfProvinces(); ++i) {
            CFG.game.getProvince((int)CFG.game.getCiv((int)n).getProvinceID((int)i)).iIncome_Taxation = this.getProvinceIncome_Taxation(CFG.game.getCiv(n).getProvinceID(i), n, f);
            CFG.game.getProvince((int)CFG.game.getCiv((int)n).getProvinceID((int)i)).iIncome_Production = this.getProvinceIncome_Production(CFG.game.getCiv(n).getProvinceID(i), n, f);
            CFG.game.getProvince((int)CFG.game.getCiv((int)n).getProvinceID((int)i)).iAdministrationCost = Math.min(CFG.game.getProvince((int)CFG.game.getCiv((int)n).getProvinceID((int)i)).iIncome_Taxation + CFG.game.getProvince((int)CFG.game.getCiv((int)n).getProvinceID((int)i)).iIncome_Production, this.getProvinceAdministration(CFG.game.getCiv(n).getProvinceID(i), n2));
            CFG.game.getCiv((int)n).iIncomeTaxation = (int)((float)CFG.game.getCiv((int)n).iIncomeTaxation + CFG.game.getProvince((int)CFG.game.getCiv((int)n).getProvinceID((int)i)).iIncome_Taxation);
            CFG.game.getCiv((int)n).iIncomeProduction = (int)((float)CFG.game.getCiv((int)n).iIncomeProduction + CFG.game.getProvince((int)CFG.game.getCiv((int)n).getProvinceID((int)i)).iIncome_Production);
            CFG.game.getCiv((int)n).iAdministrationCosts = (int)((float)CFG.game.getCiv((int)n).iAdministrationCosts + CFG.game.getProvince((int)CFG.game.getCiv((int)n).getProvinceID((int)i)).iAdministrationCost);
            if (CFG.game.getProvince(CFG.game.getCiv(n).getProvinceID(i)).getBalance_LastTurn() < 0) {
                ++CFG.game.getProvince((int)CFG.game.getCiv((int)n).getProvinceID((int)i)).saveProvinceData.iNumOfTurnsWithBalanceOnMinus;
                continue;
            }
            CFG.game.getProvince((int)CFG.game.getCiv((int)n).getProvinceID((int)i)).saveProvinceData.iNumOfTurnsWithBalanceOnMinus = 0;
        }
        CFG.game.getCiv((int)n).iBudget = (int)(this.getIncome(n) - (float)CFG.game.getCiv((int)n).iAdministrationCosts);
    }

    protected final float getHappinessChange_ByTaxation(int n) {
        return 0.042f + ((CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)n).getIdeologyID()).ACCEPTABLE_TAXATION + CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)n).getIdeologyID()).ACCEPTABLE_TAXATION * CFG.game.getCiv(n).getTechnologyLevel() / 21.73f) * 100.0f - CFG.game.getCiv(n).getTaxationLevel() * 100.0f) * (CFG.game.getCiv(n).getTaxationLevel() > CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)n).getIdeologyID()).ACCEPTABLE_TAXATION ? 1.45f : 1.0f) * 0.02675f;
    }

    protected final float getHappinessChange_ByTaxation_Occupied(int n) {
        return 0.034f + ((CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)n).getIdeologyID()).ACCEPTABLE_TAXATION + CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)n).getIdeologyID()).ACCEPTABLE_TAXATION * CFG.game.getCiv(n).getTechnologyLevel() / 21.73f) * 100.0f - CFG.game.getCiv(n).getTaxationLevel() * 100.0f) * (CFG.game.getCiv(n).getTaxationLevel() > CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)n).getIdeologyID()).ACCEPTABLE_TAXATION ? 1.45f : 1.0f) * 0.02675f;
    }

    protected float taxIncome_Modifier(int n) {
        if (CFG.game.getCiv(n).getControlledByPlayer()) {
            switch (CFG.DIFFICULTY) {
                case 0: {
                    return 1.25f;
                }
                case 2: {
                    return 1.0f;
                }
                case 3: {
                    return 0.975f;
                }
                case 4: {
                    return 0.95f;
                }
            }
            return 1.025f;
        }
        switch (CFG.DIFFICULTY) {
            case 0: {
                return 0.925f;
            }
            case 2: {
                return 1.025f;
            }
            case 3: {
                return 1.04f;
            }
            case 4: {
                return 1.065f;
            }
        }
        return 1.0f;
    }

    protected final int getMilitarySpendings(int n, int n2) {
        return Math.max(0, (int)(this.getMilitaryUpkeep_Total(n) / (float)n2 * 100.0f));
    }

    protected final float getIncome(int n) {
        float f = 0.0f;
        f += (float)CFG.game.getCiv((int)n).iIncomeTaxation;
        f += (float)CFG.game.getCiv((int)n).iIncomeProduction;
        f += this.getIncome_FromVassalsOfCiv(n);
        f += this.getIncome_Debuff_IsVassal(n);
        f += this.getIncome_Buff_WarReparations(n);
        return (int)(f += this.getIncome_Debuff_WarReparations(n));
    }

    protected final float getIncome_TaxesLevel(int n) {
        return this.getIncome_TaxesLevel_Taxation(n) + this.getIncome_TaxesLevel_Production(n);
    }

    protected final float getIncome_TaxesLevel_Taxation(int n) {
        float f = 0.0f;
        for (int i = 0; i < CFG.game.getCiv(n).getNumOfProvinces(); ++i) {
            f += this.getProvinceIncome_Taxation(CFG.game.getCiv(n).getProvinceID(i));
        }
        return f;
    }

    protected final float getIncome_TaxesLevel_Production(int n) {
        float f = 0.0f;
        for (int i = 0; i < CFG.game.getCiv(n).getNumOfProvinces(); ++i) {
            f += this.getProvinceIncome_Production(CFG.game.getCiv(n).getProvinceID(i));
        }
        return f;
    }

    protected final float getIncome_Debuff_IsVassal(int n) {
        if (CFG.game.getCiv(n).getPuppetOfCivID() != n) {
            return -this.getIncome_Vassals(CFG.game.getCiv(n).getPuppetOfCivID(), n);
        }
        return 0.0f;
    }

    protected final float getIncome_FromVassalsOfCiv(int n) {
        float f = 0.0f;
        for (int i = CFG.game.getCiv((int)n).civGameData.lVassals.size() - 1; i >= 0; --i) {
            f += this.getIncome_Vassals(n, CFG.game.getCiv((int)n).civGameData.lVassals.get((int)i).iCivID);
        }
        return f;
    }

    protected final float getIncome_Debuff_WarReparations(int n) {
        float f = 0.0f;
        for (int i = CFG.game.getCiv(n).getWarReparationsPaysSize() - 1; i >= 0; --i) {
            f -= this.getWarReparationsMoney(n);
        }
        return f;
    }

    protected final float getIncome_Buff_WarReparations(int n) {
        float f = 0.0f;
        for (int i = CFG.game.getCiv(n).getWarReparationsGetsSize() - 1; i >= 0; --i) {
            f += this.getWarReparationsMoney(CFG.game.getCiv((int)n).getWarReparationsGets((int)i).iFromCivID);
        }
        return f;
    }

    protected final float getIncome_Vassals(int n, int n2) {
        if (CFG.game.getCiv(n2).getPuppetOfCivID() == n) {
            return this.getVassalizationMoney(n2);
        }
        return 0.0f;
    }

    protected final float getVassalizationMoney(int n) {
        return (float)CFG.game.getCiv((int)n).iIncomeTaxation * ((float)CFG.game.getCiv(CFG.game.getCiv(n).getPuppetOfCivID()).getVassal_Tribute(n) / 100.0f);
    }

    protected final float getWarReparationsMoney(int n) {
        return (float)CFG.game.getCiv((int)n).iIncomeTaxation * 0.08f;
    }

    protected final float getProvinceIncomeAndExpenses_Total(int n) {
        return this.getProvinceIncome_Taxation(n) + this.getProvinceIncome_Production(n) - (CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getCapitalProvinceID() >= 0 ? this.getProvinceAdministration(n, CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getCapitalProvinceID()) : 0.0f);
    }

    protected final float getProvinceIncome_Taxation(int n) {
        return this.getProvinceIncome_Taxation(n, CFG.game.getProvince(n).getCivID(), this.taxIncome_Modifier(CFG.game.getProvince(n).getCivID()));
    }

    protected final float getProvinceIncome_Taxation(int n, int n2, float f) {
        if (CFG.game.getProvince(n).isOccupied()) {
            return this.getProvinceAdministration(n, CFG.game_NextTurnUpdate.getAdministration_Capital(n2));
        }
        return (float)(Math.pow((float)this.getProvince_EmploymentPopulation(n) * (CFG.gameAges.getAge_IncomeTaxation_Base(Game_Calendar.CURRENT_AGEID) + CFG.gameAges.getAge_IncomeTaxation_PerTechnology(Game_Calendar.CURRENT_AGEID) * CFG.game.getCiv(n2).getTechnologyLevel() * 21.923813f), 0.8386) + Math.pow((float)this.getProvince_UnemploymentPopulation(n) * (CFG.gameAges.getAge_IncomeTaxation_Base(Game_Calendar.CURRENT_AGEID) + CFG.gameAges.getAge_IncomeTaxation_PerTechnology(Game_Calendar.CURRENT_AGEID) * CFG.game.getCiv(n2).getTechnologyLevel() * 21.923813f), 0.7936)) * CFG.gameAges.getAge_TreasuryModifier(Game_Calendar.CURRENT_AGEID) * (0.675f + 0.325f * CFG.game.getProvince(n).getProvinceStability()) * (CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)n2).getIdeologyID()).INCOME_TAXATION + CFG.game.getCiv(n2).getModifier_IncomeTaxation() + (CFG.game.getProvince(n).getIsCapital() ? 0.1f : 0.0f) + -0.16584f + 0.3674786f * CFG.game.getProvince(n).getHappiness()) * (0.7f + 0.3f * CFG.game.getCiv(n2).getTaxationLevel()) * f * Game_Calendar.GAME_SPEED;
    }

    protected final int getProvince_EmploymentPopulation(int n) {
        return (int)Math.min((float)CFG.game.getProvince(n).getPopulationData().getPopulation(), (float)CFG.game.getProvince(n).getEconomy() * (1.775f + 0.1725f * CFG.game.getProvince(n).getDevelopmentLevel() + 0.0925f * CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getTechnologyLevel()));
    }

    protected final int getProvince_UnemploymentPopulation(int n) {
        return Math.max(CFG.game.getProvince(n).getPopulationData().getPopulation() - this.getProvince_EmploymentPopulation(n), 0);
    }

    protected final long getEmploymentPopulation(int n) {
        long l = 0L;
        for (int i = 0; i < CFG.game.getCiv(n).getNumOfProvinces(); ++i) {
            l += (long)this.getProvince_EmploymentPopulation(CFG.game.getCiv(n).getProvinceID(i));
        }
        return l;
    }

    protected final long getUnemploymentPopulation(int n) {
        long l = 0L;
        for (int i = 0; i < CFG.game.getCiv(n).getNumOfProvinces(); ++i) {
            l += (long)this.getProvince_UnemploymentPopulation(CFG.game.getCiv(n).getProvinceID(i));
        }
        return l;
    }

    protected final float getProvinceIncome_Production(int n) {
        return this.getProvinceIncome_Production(n, CFG.game.getProvince(n).getCivID(), this.taxIncome_Modifier(CFG.game.getProvince(n).getCivID()));
    }

    protected final float getProvinceIncome_Production(int n, int n2, float f) {
        if (CFG.game.getProvince(n).isOccupied()) {
            return (float)((int)Math.min((float)CFG.game.getProvince(n).getPopulationData().getPopulation() * (1.025f + 0.1725f * CFG.game.getProvince(n).getDevelopmentLevel() + 0.0425f * CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getTechnologyLevel()), (float)CFG.game.getProvince(n).getEconomy())) * (CFG.gameAges.getAge_IncomeProduction_Base(Game_Calendar.CURRENT_AGEID) + CFG.gameAges.getAge_IncomeProduction_PerDevelopment(Game_Calendar.CURRENT_AGEID) * CFG.game.getProvince(n).getDevelopmentLevel()) * (0.0685f + 0.575f * CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getTechnologyLevel() + 0.8625f * CFG.game.getProvince(n).getDevelopmentLevel()) * (0.425f + 0.575f * CFG.game.getProvince(n).getProvinceStability()) * CFG.gameAges.getAge_TreasuryModifier_Production(Game_Calendar.CURRENT_AGEID) * (CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)CFG.game.getProvince((int)n).getCivID()).getIdeologyID()).INCOME_PRODUCTION + BuildingsManager.getPort_IncomeProduction(CFG.game.getProvince(n).getLevelOfPort()) + CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getModifier_IncomeProduction() + (CFG.game.getProvince(n).getIsCapital() ? 0.2f : 0.0f) + BuildingsManager.getWorkshop_IncomeProduction(CFG.game.getProvince(n).getLevelOfWorkshop())) * (0.825f + 0.175f * CFG.game.getCiv(n2).getTaxationLevel()) * f * Game_Calendar.GAME_SPEED * 0.1f;
        }
        return (float)((int)Math.min((float)CFG.game.getProvince(n).getPopulationData().getPopulation() * (1.025f + 0.1725f * CFG.game.getProvince(n).getDevelopmentLevel() + 0.0425f * CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getTechnologyLevel()), (float)CFG.game.getProvince(n).getEconomy())) * (CFG.gameAges.getAge_IncomeProduction_Base(Game_Calendar.CURRENT_AGEID) + CFG.gameAges.getAge_IncomeProduction_PerDevelopment(Game_Calendar.CURRENT_AGEID) * CFG.game.getProvince(n).getDevelopmentLevel()) * (0.0685f + 0.575f * CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getTechnologyLevel() + 0.8625f * CFG.game.getProvince(n).getDevelopmentLevel()) * (0.425f + 0.575f * CFG.game.getProvince(n).getProvinceStability()) * CFG.gameAges.getAge_TreasuryModifier_Production(Game_Calendar.CURRENT_AGEID) * (CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)CFG.game.getProvince((int)n).getCivID()).getIdeologyID()).INCOME_PRODUCTION + BuildingsManager.getPort_IncomeProduction(CFG.game.getProvince(n).getLevelOfPort()) + CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getModifier_IncomeProduction() + (CFG.game.getProvince(n).getIsCapital() ? 0.2f : 0.0f) + BuildingsManager.getWorkshop_IncomeProduction(CFG.game.getProvince(n).getLevelOfWorkshop())) * (0.825f + 0.175f * CFG.game.getCiv(n2).getTaxationLevel()) * f * Game_Calendar.GAME_SPEED;
    }

    protected final float getExpenses(int n) {
        float f = 0.0f;
        f += (float)CFG.game.getCiv((int)n).iAdministrationCosts;
        f += this.getMilitaryUpkeep_Total(n);
        f += this.getInvestments_Total(n, CFG.game.getCiv((int)n).iBudget);
        f += this.getGoodsSpendings(n, CFG.game.getCiv((int)n).iBudget);
        f += this.getInterestCost(n);
        f += this.getInflation(n);
        return (int)Math.ceil(f += (float)CFG.game.getCiv(n).getLoans_GoldTotalPerTurn());
    }

    protected final float getExpenses_Budget(int n) {
        float f = 0.0f;
        return (int)Math.ceil(f += (float)CFG.game.getCiv((int)n).iAdministrationCosts);
    }

    protected final float getInflation(int n) {
        if (CFG.game.getCiv(n).getMoney() < 0L) {
            return 0.0f;
        }
        try {
            if ((float)CFG.game.getCiv(n).getMoney() / (((float)INFLATION_PEAK_VALUE * 1.1275f + (float)(CFG.game.getCiv((int)n).iIncomeTaxation + CFG.game.getCiv((int)n).iIncomeProduction) * 0.4f) * 18.12746f) > 0.235f) {
                return 1.0f + (float)CFG.game.getCiv(n).getMoney() * ((float)CFG.game.getCiv(n).getMoney() / ((float)INFLATION_PEAK_VALUE * 18.12746f) - 0.235f) * 0.0679248f;
            }
        }
        catch (ArithmeticException arithmeticException) {
            return 0.0f;
        }
        return 0.0f;
    }

    protected final float getInflationPerc(int n) {
        return Math.max(this.getInflation(n) / (float)CFG.game.getCiv(n).getMoney(), 0.0f);
    }

    protected final float getInterestCost(int n) {
        if (CFG.game.getCiv(n).getMoney() < 0L) {
            return Math.min((float)Math.abs(CFG.game.getCiv(n).getMoney()) * 0.01274f, Math.abs((float)CFG.game.getCiv((int)n).iBudget * 0.075f));
        }
        return 0.0f;
    }

    protected final float getAdministrationCost_Update(int n) {
        float f;
        block3: {
            f = 0.0f;
            try {
                for (int i = 0; i < CFG.game.getCiv(n).getNumOfProvinces(); ++i) {
                    f += this.getProvinceAdministration(CFG.game.getCiv(n).getProvinceID(i), CFG.game_NextTurnUpdate.getAdministration_Capital(n));
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (!CFG.LOGS) break block3;
                CFG.exceptionStack(indexOutOfBoundsException);
            }
        }
        return f;
    }

    protected final float getProvinceAdministration(int n, int n2) {
        return (float)Math.pow((float)CFG.game.getProvince(n).getEconomy() * Math.min(1.0f, (float)CFG.game.getProvince(n).getEconomy() / (float)CFG.game.getProvince(n).getPopulationData().getPopulation()) * 0.003248f + (float)CFG.game.getProvince(n).getPopulationData().getPopulation() * (0.0024f + 7.25E-4f * CFG.game.getProvince(n).getDevelopmentLevel()), 0.93478) * (1.0f + (this.getDistanceFromCapital_PercOfMax(n2, n) / (1.5275f + CFG.game.getProvince(n).getProvinceStability() / 8.0f) * CFG.gameAges.getAge_AdministrationCost_Distance(Game_Calendar.CURRENT_AGEID) + 0.13468f - 0.13468f * CFG.game.getProvince(n).getHappiness()) * CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)CFG.game.getProvince((int)n).getCivID()).getIdeologyID()).ADMINISTRATION_COST_DISTANCE) * (0.9325f + 0.0715f * CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getTaxationLevel() + 0.0325f * (1.0f - CFG.game.getProvince(n).getProvinceStability())) * CFG.gameAges.getAge_TreasuryModifier_Administration(Game_Calendar.CURRENT_AGEID) * (CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)CFG.game.getProvince((int)n).getCivID()).getIdeologyID()).ADMINISTRATION_COST + CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getModifier_Administation()) * (n == n2 ? CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)CFG.game.getProvince((int)n).getCivID()).getIdeologyID()).ADMINISTRATION_COST_CAPITAL : 1.0f) * Game_Calendar.GAME_SPEED;
    }

    protected final float getDistanceFromCapital(int n, int n2) {
        try {
            if (CFG.map.getMapWorldMap(CFG.map.getActiveMapID())) {
                return Math.min(Math.min((float)Math.sqrt(Math.pow(CFG.game.getProvince(n2).getCenterX_Real() + CFG.map.getMapBG().getWidth_Real() - CFG.game.getProvince(n).getCenterX_Real(), 2.0) + Math.pow(CFG.game.getProvince(n2).getCenterY_Real() - CFG.game.getProvince(n).getCenterY_Real(), 2.0)), (float)Math.sqrt(Math.pow(CFG.game.getProvince(n2).getCenterX_Real() - (CFG.game.getProvince(n).getCenterX_Real() + CFG.map.getMapBG().getWidth_Real()), 2.0) + Math.pow(CFG.game.getProvince(n2).getCenterY_Real() - CFG.game.getProvince(n).getCenterY_Real(), 2.0))), (float)Math.sqrt(Math.pow(CFG.game.getProvince(n2).getCenterX_Real() - CFG.game.getProvince(n).getCenterX_Real(), 2.0) + Math.pow(CFG.game.getProvince(n2).getCenterY_Real() - CFG.game.getProvince(n).getCenterY_Real(), 2.0)));
            }
            return (float)Math.sqrt(Math.pow(CFG.game.getProvince(n2).getCenterX_Real() - CFG.game.getProvince(n).getCenterX_Real(), 2.0) + Math.pow(CFG.game.getProvince(n2).getCenterY_Real() - CFG.game.getProvince(n).getCenterY_Real(), 2.0));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return CFG.map.getMapBG().getMaxDistance();
        }
    }

    protected final float getDistanceFromCapital_PercOfMax(int n, int n2) {
        return this.getDistanceFromCapital(n, n2) / (float)CFG.map.getMapBG().getMaxDistance();
    }

    protected final float getDistanceFromAToB_PercOfMax(int n, int n2) {
        return this.getDistanceFromCapital(n, n2) / (float)CFG.map.getMapBG().getMaxDistance();
    }

    protected final float getMilitaryUpkeep_Total(int n) {
        int n2;
        float f = 0.0f;
        for (n2 = 0; n2 < CFG.game.getCiv(n).getNumOfProvinces(); ++n2) {
            f += this.getMilitaryUpkeep(CFG.game.getCiv(n).getProvinceID(n2), n);
        }
        for (n2 = 0; n2 < CFG.game.getCiv(n).getArmyInAnotherProvinceSize(); ++n2) {
            f += this.getMilitaryUpkeep(CFG.game.getCiv(n).getArmyInAnotherProvince(n2), n);
        }
        for (n2 = 0; n2 < CFG.game.getCiv(n).getMoveUnitsSize(); ++n2) {
            f += this.getMilitaryUpkeep(CFG.game.getCiv(n).getMoveUnits(n2).getFromProvinceID(), CFG.game.getCiv(n).getMoveUnits(n2).getNumOfUnits(), n);
        }
        for (n2 = 0; n2 < CFG.game.getCiv(n).getMoveUnitsPlunderSize(); ++n2) {
            f += this.getMilitaryUpkeep(CFG.game.getCiv(n).getMoveUnits_Plunder(n2).getFromProvinceID(), CFG.game.getCiv(n).getMoveUnits_Plunder(n2).getNumOfUnits(), n);
        }
        return (int)Math.ceil(f);
    }

    protected final float getMilitaryUpkeep(int n, int n2) {
        return this.getMilitaryUpkeep(n, CFG.game.getProvince(n).getArmyCivID(n2), n2);
    }

    protected final float getMilitaryUpkeep_WithAllRecruitmentsInProcess(int n, int n2, int n3) {
        int n4 = 0;
        for (int i = 0; i < CFG.game.getCiv(n3).getRecruitArmySize(); ++i) {
            if (CFG.game.getCiv(n3).getRecruitArmy(i).getProvinceID() == n) continue;
            n4 = (int)((float)n4 + this.getMilitaryUpkeep(CFG.game.getCiv(n3).getRecruitArmy(i).getProvinceID(), CFG.game.getCiv(n3).getRecruitArmy(i).getArmy(), n3));
        }
        return (float)n4 + this.getMilitaryUpkeep(n, n2, n3);
    }

    protected final float getMilitaryUpkeep_WithAllRecruitmentsInProcess_Disband(int n, int n2, int n3) {
        int n4 = 0;
        for (int i = 0; i < CFG.game.getCiv(n3).getRecruitArmySize(); ++i) {
            if (CFG.game.getCiv(n3).getRecruitArmy(i).getProvinceID() == n) continue;
            n4 = (int)((float)n4 + this.getMilitaryUpkeep(CFG.game.getCiv(n3).getRecruitArmy(i).getProvinceID(), CFG.game.getCiv(n3).getRecruitArmy(i).getArmy(), n3));
        }
        return (float)n4 - this.getMilitaryUpkeep(n, n2, n3);
    }

    protected final float getMilitaryUpkeep(int n, int n2, int n3) {
        return (float)Math.pow((float)n2 * CFG.gameAges.getAge_MilitaryUpkeep(Game_Calendar.CURRENT_AGEID), 1.03f - 0.1275f * CFG.game.getProvince(n).getDevelopmentLevel() - 0.10479f * CFG.game.getCiv(n3).getTechnologyLevel()) * (1.0f + CFG.terrainTypesManager.getMilitaryUpkeep(CFG.game.getProvince(n).getTerrainTypeID())) * CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)n3).getIdeologyID()).MILITARY_UPKEEP * CFG.gameAges.getAge_TreasuryModifier_MilitaryUpkeep(Game_Calendar.CURRENT_AGEID) * (1.0f + (float)CFG.game.getCiv(n3).getNumOfProvinces() / (float)CFG.game.getProvincesSize() * 0.425f + CFG.game.getCiv(n3).getWarWeariness() + CFG.game.getCiv(n3).getModifier_MilitaryUpkeep() - BuildingsManager.getSupply_Bonus(CFG.game.getProvince(n).getLevelOfSupply())) * Game_Calendar.GAME_SPEED * (1.0f - this.getMilitaryUpkeep_DefensivePosition(n));
    }

    protected final float getMilitaryUpkeep_WithoutDefensivePosition(int n, int n2, int n3) {
        return (float)Math.pow((float)n2 * CFG.gameAges.getAge_MilitaryUpkeep(Game_Calendar.CURRENT_AGEID), 1.03f - 0.1275f * CFG.game.getProvince(n).getDevelopmentLevel() - 0.10479f * CFG.game.getCiv(n3).getTechnologyLevel()) * (1.0f + CFG.terrainTypesManager.getMilitaryUpkeep(CFG.game.getProvince(n).getTerrainTypeID())) * CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)n3).getIdeologyID()).MILITARY_UPKEEP * CFG.gameAges.getAge_TreasuryModifier_MilitaryUpkeep(Game_Calendar.CURRENT_AGEID) * (1.0f + (float)CFG.game.getCiv(n3).getNumOfProvinces() / (float)CFG.game.getProvincesSize() * 0.425f + CFG.game.getCiv(n3).getWarWeariness() + CFG.game.getCiv(n3).getModifier_MilitaryUpkeep() - BuildingsManager.getSupply_Bonus(CFG.game.getProvince(n).getLevelOfSupply())) * Game_Calendar.GAME_SPEED;
    }

    protected final float getMilitaryUpkeep_DefensivePosition(int n) {
        return 0.008f * (float)CFG.game.getProvince(n).getDefensivePosition();
    }

    protected final float getInvestments_Total(int n, int n2) {
        return this.getResearchSpendings(n, n2) + this.getInvestmentsSpendings(n, n2);
    }

    protected final float getResearchSpendings(int n, int n2) {
        return (float)n2 * CFG.game.getCiv(n).getSpendings_Research();
    }

    protected final float getGoodsSpendings(int n, int n2) {
        return (float)n2 * CFG.game.getCiv(n).getSpendings_Goods();
    }

    protected final float getInvestmentsSpendings(int n, int n2) {
        return (float)n2 * CFG.game.getCiv(n).getSpendings_Investments();
    }

    protected final void updateSpendingsOfCiv(int n, int n2) {
        if (CFG.game.getCiv(n).getCapitalProvinceID() >= 0 && CFG.game.getCiv(n).getNumOfProvinces() > 0) {
            int n3;
            if (CFG.game.getCiv(n).getMoney() < -500L) {
                CFG.game.getCiv(n).setSpendings_Research(0.0f);
            }
            if (n2 <= 0) {
                CFG.game.getCiv(n).setSpendings_Goods(0.0f);
                CFG.game.getCiv(n).setSpendings_Research(0.0f);
                CFG.game.getCiv(n).setSpendings_Investments(0.0f);
            }
            if ((n3 = this.getMilitarySpendings(n, n2)) + (int)(CFG.game.getCiv(n).getSpendings_Goods() * 100.0f) > 200) {
                CFG.game.getCiv(n).setSpendings_Goods((float)(200 - n3) / 100.0f);
            }
            if ((n3 += (int)(CFG.game.getCiv(n).getSpendings_Goods() * 100.0f)) + (int)(CFG.game.getCiv(n).getSpendings_Research() * 100.0f) + (int)(CFG.game.getCiv(n).getSpendings_Investments() * 100.0f) > 200) {
                if (n3 > 200) {
                    CFG.game.getCiv(n).setSpendings_Research(0.0f);
                    CFG.game.getCiv(n).setSpendings_Investments(0.0f);
                    return;
                }
                int n4 = (int)(CFG.game.getCiv(n).getSpendings_Research() * 100.0f) + (int)(CFG.game.getCiv(n).getSpendings_Investments() * 100.0f) + n3 - 200;
                int n5 = (int)(CFG.game.getCiv(n).getSpendings_Research() * 100.0f);
                CFG.game.getCiv(n).setSpendings_Research(CFG.game.getCiv(n).getSpendings_Research() - (float)n4 / 2.0f / 100.0f);
                n4 -= (int)((float)n5 - CFG.game.getCiv(n).getSpendings_Research() * 100.0f);
                if ((float)n4 < CFG.game.getCiv(n).getSpendings_Investments() * 100.0f) {
                    CFG.game.getCiv(n).setSpendings_Investments(CFG.game.getCiv(n).getSpendings_Investments() - (float)n4 / 100.0f);
                } else {
                    CFG.game.getCiv(n).setSpendings_Investments(0.0f);
                    CFG.game.getCiv(n).setSpendings_Research(CFG.game.getCiv(n).getSpendings_Research() - (float)(n4 -= (int)(CFG.game.getCiv(n).getSpendings_Investments() * 100.0f)) / 100.0f);
                }
            }
        }
    }

    protected final void updateCities() {
        for (int i = 1; i < CFG.game.getCivsSize(); ++i) {
            this.updateCities(i);
        }
    }

    protected final void updateCities(int n) {
        int n2;
        int n3;
        int n4 = (int)Math.ceil((float)(CFG.game.getCiv(n).getNumOfProvinces() * CFG.settingsManager.PERCETANGE_OF_CITIES_ON_MAP) / 100.0f);
        int n5 = 1;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n3 = 0; n3 < CFG.game.getCiv(n).getNumOfProvinces(); ++n3) {
            arrayList.add(CFG.game.getCiv(n).getProvinceID(n3));
            CFG.game.getProvince(CFG.game.getCiv(n).getProvinceID(n3)).setDrawCities(CFG.game.getProvince(CFG.game.getCiv(n).getProvinceID(n3)).getLevelOfPort() > 0 || CFG.game.getProvince(CFG.game.getCiv(n).getProvinceID(n3)).getLevelOfArmoury() > 0);
            if (CFG.game.getProvince(CFG.game.getCiv(n).getProvinceID(n3)).isOccupied() || n5 >= CFG.game.getProvince(CFG.game.getCiv(n).getProvinceID(n3)).getPopulationData().getPopulation()) continue;
            n5 = CFG.game.getProvince(CFG.game.getCiv(n).getProvinceID(n3)).getPopulationData().getPopulation();
        }
        for (n3 = 0; n3 < CFG.game.getCiv(n).getNumOfProvinces(); ++n3) {
            for (n2 = 0; n2 < CFG.game.getProvince(CFG.game.getCiv(n).getProvinceID(n3)).getCitiesSize(); ++n2) {
                if (CFG.game.getProvince(CFG.game.getCiv(n).getProvinceID(n3)).getCity(n2).getCityLevel() == CFG.getEditorCityLevel(0)) continue;
                CFG.game.getProvince(CFG.game.getCiv(n).getProvinceID(n3)).getCity(n2).setCityLevel(this.getLevelOfCity(n5, CFG.game.getProvince(CFG.game.getCiv(n).getProvinceID(n3)).getPopulationData().getPopulation(), n2));
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            int n6 = 0;
            int n7 = CFG.game.getProvince((Integer)arrayList.get(n6)).getPopulationData().getPopulation();
            int n8 = arrayList.size();
            for (int i = 1; i < n8; ++i) {
                if (n7 >= CFG.game.getProvince((Integer)arrayList.get(i)).getPopulationData().getPopulation()) continue;
                n6 = i;
                n7 = CFG.game.getProvince((Integer)arrayList.get(n6)).getPopulationData().getPopulation();
            }
            CFG.game.getProvince((Integer)arrayList.get(n6)).setDrawCities(true);
            arrayList.remove(n6);
        }
        if (CFG.game.getCiv(n).getCapitalProvinceID() >= 0) {
            CFG.game.getProvince(CFG.game.getCiv(n).getCapitalProvinceID()).setDrawCities(true);
        }
        arrayList.clear();
    }

    protected int getLevelOfCity(int n, int n2, int n3) {
        float f = (float)n2 / (float)n;
        int n4 = 4;
        n4 = f >= 0.765f ? 1 : (f >= 0.575f ? 2 : (f >= 0.325f ? 3 : 4));
        return CFG.getEditorCityLevel(n4);
    }

    protected final void buildLevelsOfCities() {
        int n;
        for (n = 0; n < CFG.game.getProvincesSize(); ++n) {
            for (int i = 0; i < CFG.game.getProvince(n).getCitiesSize(); ++i) {
                CFG.game.getProvince(n).getCity(i).setCityLevel(CFG.getEditorCityLevel(4));
            }
        }
        for (n = 1; n < CFG.game.getCivsSize(); ++n) {
            this.buildLevelsOfCities(n);
        }
    }

    protected final void buildLevelsOfCities(int n) {
        block7: {
            int n2;
            int n3 = 0;
            for (n2 = 0; n2 < CFG.game.getCiv(n).getNumOfProvinces(); ++n2) {
                if (n3 >= CFG.game.getProvince(CFG.game.getCiv(n).getProvinceID(n2)).getPopulationData().getPopulation()) continue;
                n3 = CFG.game.getProvince(CFG.game.getCiv(n).getProvinceID(n2)).getPopulationData().getPopulation();
            }
            for (n2 = 0; n2 < CFG.game.getCiv(n).getNumOfProvinces(); ++n2) {
                for (int i = 0; i < CFG.game.getProvince(CFG.game.getCiv(n).getProvinceID(n2)).getCitiesSize(); ++i) {
                    CFG.game.getProvince(CFG.game.getCiv(n).getProvinceID(n2)).getCity(i).setCityLevel(CFG.getCityLevel_Population(n3, CFG.game.getProvince(CFG.game.getCiv(n).getProvinceID(n2)).getPopulationData().getPopulation(), i));
                }
            }
            try {
                CFG.game.getProvince(CFG.game.getCiv(n).getCapitalProvinceID()).getCity(0).setCityLevel(CFG.getEditorCityLevel(0));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (CFG.LOGS) {
                    CFG.exceptionStack(indexOutOfBoundsException);
                }
            }
            catch (NullPointerException nullPointerException) {
                if (!CFG.LOGS) break block7;
                CFG.exceptionStack(nullPointerException);
            }
        }
    }
}

