/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.Buildings;
import age.of.civilizations2.jakowski.lukasz.CFG;
import age.of.civilizations2.jakowski.lukasz.Construction_GameData;
import age.of.civilizations2.jakowski.lukasz.Construction_GameData_Armoury;
import age.of.civilizations2.jakowski.lukasz.Construction_GameData_Farm;
import age.of.civilizations2.jakowski.lukasz.Construction_GameData_Fort;
import age.of.civilizations2.jakowski.lukasz.Construction_GameData_Library;
import age.of.civilizations2.jakowski.lukasz.Construction_GameData_Supply;
import age.of.civilizations2.jakowski.lukasz.Construction_GameData_Tower;
import age.of.civilizations2.jakowski.lukasz.Construction_GameData_Workshop;
import age.of.civilizations2.jakowski.lukasz.Message_Bulit_Armoury;
import age.of.civilizations2.jakowski.lukasz.Message_Bulit_Farm;
import age.of.civilizations2.jakowski.lukasz.Message_Bulit_Fort;
import age.of.civilizations2.jakowski.lukasz.Message_Bulit_Library;
import age.of.civilizations2.jakowski.lukasz.Message_Bulit_Port;
import age.of.civilizations2.jakowski.lukasz.Message_Bulit_Supply;
import age.of.civilizations2.jakowski.lukasz.Message_Bulit_Tower;
import age.of.civilizations2.jakowski.lukasz.Message_Bulit_Workshop;

class BuildingsManager {
    protected static Buildings ACTIVE_BUILDING = Buildings.FORT;
    protected static int iBuildInProvinceID = 0;
    protected static final int BONUS_CAPITAL_DEFENSE = 15;
    protected static final int BONUS_CAPITAL_ATTACK_FROM_CAPITAL = 10;
    protected static final int DESTROY_MOVEMENT_COST = 4;
    private static final String[] FORT_NAMES = new String[]{"", "Castle", "Fortress"};
    private static final float[] FORT_BUILD_COST = new float[]{0.0f, 0.05f, 0.0865f};
    private static final int[] FORT_BUILD_MOVEMENT_COST = new int[]{0, 12, 14};
    private static final int[] FORT_DEFENSE_BONUS = new int[]{0, 15, 30};
    private static final int[] FORT_MAINTENANCE_COST = new int[]{0, 60, 125};
    private static final float[] FORT_TECH_LEVEL = new float[]{0.0f, 0.25f, 0.5f};
    private static final int[] FORT_CONSTRUCTION = new int[]{0, 2, 3};
    private static final String[] TOWER_NAMES = new String[]{"", "WatchTower"};
    private static final float[] TOWER_BUILD_COST = new float[]{0.0f, 0.0425f};
    private static final int[] TOWER_BUILD_MOVEMENT_COST = new int[]{0, 16};
    private static final int[] TOWER_DEFENSE_BONUS = new int[]{0, 10};
    private static final int[] TOWER_MAINTENANCE_COST = new int[]{0, 35};
    private static final float[] TOWER_TECHNOLOGY_LEVEL = new float[]{0.0f, 0.2f};
    private static final int[] TOWER_CONSTRUCTION = new int[]{0, 1};
    private static final String[] PORT_NAMES = new String[]{"", "Port"};
    private static final float[] PORT_BUILD_COST = new float[]{0.0f, 0.0685f};
    private static final int[] PORT_BUILD_MOVEMENT_COST = new int[]{0, 16};
    private static final int[] PORT_MAINTENANCE_COST = new int[]{0, 35};
    private static final float[] PORT_TECHNOLOGY_LEVEL = new float[]{0.0f, 0.25f};
    private static final float[] PORT_INCOME_PRODUCTION = new float[]{0.0f, 0.1f};
    private static final int[] PORT_CONSTRUCTION = new int[]{0, 1};
    private static final String[] FARM_NAMES = new String[]{"", "Farm", "Farm", "Farm", "Farm", "Farm"};
    private static final float[] FARM_BUILD_COST = new float[]{0.0f, 0.0625f, 0.0765f, 0.1115f, 0.165f, 0.215f};
    private static final int[] FARM_BUILD_MOVEMENT_COST = new int[]{0, 14, 16, 18, 24, 26};
    private static final float[] FARM_GROWTH_RATE_BONUS = new float[]{0.0f, 0.1f, 0.2f, 0.3f, 0.4f, 0.55f};
    private static final int[] FARM_MAINTENANCE_COST = new int[]{0, 35, 50, 55, 65, 75};
    private static final float[] FARM_TECHNOLOGY_LEVEL = new float[]{0.0f, 0.15f, 0.3f, 0.4f, 0.55f, 0.7f};
    private static final int[] FARM_CONSTRUCTION = new int[]{0, 1, 2, 3, 4, 5};
    private static final String[] LIBRARY_NAMES = new String[]{"", "Library", "University", "ResearchLab"};
    private static final float[] LIBRARY_BUILD_COST = new float[]{0.0f, 0.08f, 0.1425f, 0.2125f};
    private static final int[] LIBRARY_BUILD_MOVEMENT_COST = new int[]{0, 10, 16, 20};
    private static final int[] LIBRARY_RESEARCH_PER_POPULATION = new int[]{0, 725, 425, 225};
    private static final float[] LIBRARY_TECH_LEVEL = new float[]{0.0f, 0.25f, 0.5f, 0.85f};
    private static final int[] LIBRARY_CONSTRUCTION = new int[]{0, 2, 3, 4};
    private static final String[] ARMOURY_NAMES = new String[]{"", "Armoury"};
    private static final float[] ARMOURY_BUILD_COST = new float[]{0.0f, 0.095f};
    private static final int[] ARMOURY_BUILD_MOVEMENT_COST = new int[]{0, 28};
    private static final float[] ARMOURY_TECH_LEVEL = new float[]{0.0f, 0.4f};
    private static final int[] ARMOURY_CONSTRUCTION = new int[]{0, 4};
    private static final String[] WORKSHOP_NAMES = new String[]{"", "Workshop", "Workshop", "Workshop"};
    private static final float[] WORKSHOP_BUILD_COST = new float[]{0.0f, 0.06f, 0.1f, 0.15f};
    private static final int[] WORKSHOP_BUILD_MOVEMENT_COST = new int[]{0, 18, 24, 30};
    private static final float[] WORKSHOP_INCOME_PRODUCTION = new float[]{0.0f, 0.1f, 0.2f, 0.35f};
    private static final int[] WORKSHOP_MAINTENANCE_COST = new int[]{0, 35, 50, 70};
    private static final float[] WORKSHOP_TECHNOLOGY_LEVEL = new float[]{0.0f, 0.4f, 0.65f, 0.8f};
    private static final int[] WORKSHOP_CONSTRUCTION = new int[]{0, 2, 3, 3};
    private static final String[] SUPPLY_NAMES = new String[]{"", "SupplyCamp"};
    private static final float[] SUPPLY_BUILD_COST = new float[]{0.0f, 0.01675f};
    private static final int[] SUPPLY_BUILD_MOVEMENT_COST = new int[]{0, 14};
    private static final float[] SUPPLY_TECH_LEVEL = new float[]{0.0f, 0.3f};
    private static final int[] SUPPLY_CONSTRUCTION = new int[]{0, 3};
    private static final float[] SUPPLY_BONUS = new float[]{0.0f, 0.2f};

    BuildingsManager() {
    }

    protected static final int getFort_MaxLevel() {
        return FORT_NAMES.length - 1;
    }

    protected static final int getFort_MaxLevel_CanBuild(int n) {
        for (int i = 0; i < FORT_TECH_LEVEL.length; ++i) {
            if (!(FORT_TECH_LEVEL[i] > CFG.game.getCiv(n).getTechnologyLevel())) continue;
            return i - 1;
        }
        return BuildingsManager.getFort_MaxLevel();
    }

    protected static final String getFort_Name(int n) {
        try {
            return FORT_NAMES[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return FORT_NAMES[FORT_NAMES.length - 1];
        }
    }

    protected static final int getFort_BuildCost(int n, int n2) {
        try {
            int n3 = 0;
            for (int i = 0; i < CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getNumOfProvinces(); ++i) {
                if (CFG.game.getProvince(CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getProvinceID(i)).getLevelOfFort() <= 0) continue;
                n3 += CFG.game.getProvince(CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getProvinceID(i)).getLevelOfFort();
            }
            return (int)(((float)CFG.game.getGameScenarios().getScenario_StartingPopulation() * (FORT_BUILD_COST[n] + 0.004721f * (float)n3) + (float)CFG.game.getGameScenarios().getScenario_StartingPopulation() * (0.0275f * (1.0f - CFG.game.getProvince(n2).getDevelopmentLevel()))) * (1.0f + CFG.terrainTypesManager.getBuildCost(CFG.game.getProvince(n2).getTerrainTypeID())));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final int getFort_BuildMovementCost(int n) {
        try {
            return FORT_BUILD_MOVEMENT_COST[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final int getFort_DefenseBonus(int n) {
        try {
            return FORT_DEFENSE_BONUS[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final int getFort_MaitenanceCost(int n) {
        try {
            return FORT_MAINTENANCE_COST[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final float getFort_TechLevel(int n) {
        try {
            return FORT_TECH_LEVEL[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0.0f;
        }
    }

    protected static final int getFort_Construction(int n) {
        try {
            return FORT_CONSTRUCTION[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final boolean canBuildFort(int n) {
        return CFG.game.getProvince(n).getLevelOfFort() < BuildingsManager.getFort_MaxLevel() && CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getTechnologyLevel() >= BuildingsManager.getFort_TechLevel(CFG.game.getProvince(n).getLevelOfFort() + 1) && CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getMovePoints() >= BuildingsManager.getFort_BuildMovementCost(CFG.game.getProvince(n).getLevelOfFort() + 1);
    }

    protected static final boolean constructFort(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfFort() < BuildingsManager.getFort_MaxLevel() && CFG.game.getCiv(n2).getTechnologyLevel() >= BuildingsManager.getFort_TechLevel(CFG.game.getProvince(n).getLevelOfFort() + 1)) {
            if (CFG.game.getCiv(n2).getMovePoints() >= BuildingsManager.getFort_BuildMovementCost(CFG.game.getProvince(n).getLevelOfFort() + 1) && CFG.game.getCiv(n2).getMoney() >= (long)BuildingsManager.getFort_BuildCost(CFG.game.getProvince(n).getLevelOfFort() + 1, n)) {
                CFG.game.getCiv(n2).setMovePoints(CFG.game.getCiv(n2).getMovePoints() - BuildingsManager.getFort_BuildMovementCost(CFG.game.getProvince(n).getLevelOfFort() + 1));
                CFG.game.getCiv(n2).setMoney(CFG.game.getCiv(n2).getMoney() - (long)BuildingsManager.getFort_BuildCost(CFG.game.getProvince(n).getLevelOfFort() + 1, n));
                CFG.game.getCiv(n2).addNewConstruction(new Construction_GameData_Fort(n, BuildingsManager.getFort_Construction(CFG.game.getProvince(n).getLevelOfFort() + 1)));
                return true;
            }
            return false;
        }
        return false;
    }

    protected static final boolean buildFort(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfFort() < BuildingsManager.getFort_MaxLevel()) {
            CFG.game.getProvince(n).setLevelOfFort(CFG.game.getProvince(n).getLevelOfFort() + 1);
            ++CFG.game.getCiv((int)n2).civGameData.iNumOfBuildingsConstructed;
            for (int i = 0; i < CFG.game.getPlayersSize(); ++i) {
                if (CFG.game.getCiv(CFG.game.getPlayer(CFG.PLAYER_TURNID).getCivID()).getNumOfProvinces() <= 0) continue;
                CFG.game.getProvince(n).updateFogOfWar(i);
            }
            CFG.game.getCiv((int)n2).getCivilization_Diplomacy_GameData().messageBox.addMessage(new Message_Bulit_Fort(n2, n));
            return true;
        }
        return false;
    }

    protected static final boolean destroyFort(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfFort() > 0) {
            if (CFG.game.getCiv(n2).getMovePoints() >= 4) {
                CFG.game.getCiv(n2).setMovePoints(CFG.game.getCiv(n2).getMovePoints() - 4);
                CFG.game.getProvince(n).setLevelOfFort(0);
                return true;
            }
            return false;
        }
        return false;
    }

    protected static final boolean destroyTower(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfWatchTower() > 0) {
            if (CFG.game.getCiv(n2).getMovePoints() >= 4) {
                CFG.game.getCiv(n2).setMovePoints(CFG.game.getCiv(n2).getMovePoints() - 4);
                CFG.game.getProvince(n).setLevelOfWatchTower(0);
                if (CFG.game.getCiv(n2).getControlledByPlayer()) {
                    CFG.game.getProvince(n).updateFogOfWar(CFG.game.getPlayerID_ByCivID(n2));
                }
                return true;
            }
            return false;
        }
        return false;
    }

    protected static final boolean destroyPort(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfPort() > 0) {
            if (CFG.game.getCiv(n2).getMovePoints() >= 4) {
                CFG.game.getCiv(n2).setMovePoints(CFG.game.getCiv(n2).getMovePoints() - 4);
                CFG.game.getProvince(n).setLevelOfPort(0);
                return true;
            }
            return false;
        }
        return false;
    }

    protected static final boolean destroyFarm(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfFarm() > 0) {
            if (CFG.game.getCiv(n2).getMovePoints() >= 4) {
                CFG.game.getCiv(n2).setMovePoints(CFG.game.getCiv(n2).getMovePoints() - 4);
                CFG.game.getProvince(n).setLevelOfFarm(0);
                return true;
            }
            return false;
        }
        return false;
    }

    protected static final boolean destroyWorkshop(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfWorkshop() > 0) {
            if (CFG.game.getCiv(n2).getMovePoints() >= 4) {
                CFG.game.getCiv(n2).setMovePoints(CFG.game.getCiv(n2).getMovePoints() - 4);
                CFG.game.getProvince(n).setLevelOfWorkshop(0);
                return true;
            }
            return false;
        }
        return false;
    }

    protected static final boolean destroyLibrary(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfLibrary() > 0) {
            if (CFG.game.getCiv(n2).getMovePoints() >= 4) {
                CFG.game.getCiv(n2).setMovePoints(CFG.game.getCiv(n2).getMovePoints() - 4);
                CFG.game.getProvince(n).setLevelOfLibrary(0);
                return true;
            }
            return false;
        }
        return false;
    }

    protected static final boolean destroyArmoury(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfArmoury() > 0) {
            if (CFG.game.getCiv(n2).getMovePoints() >= 4) {
                CFG.game.getCiv(n2).setMovePoints(CFG.game.getCiv(n2).getMovePoints() - 4);
                CFG.game.getProvince(n).setLevelOfArmoury(0);
                return true;
            }
            return false;
        }
        return false;
    }

    protected static final boolean destroySupply(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfSupply() > 0) {
            if (CFG.game.getCiv(n2).getMovePoints() >= 4) {
                CFG.game.getCiv(n2).setMovePoints(CFG.game.getCiv(n2).getMovePoints() - 4);
                CFG.game.getProvince(n).setLevelOfSupply(0);
                return true;
            }
            return false;
        }
        return false;
    }

    protected static final int getTower_MaxLevel() {
        return TOWER_NAMES.length - 1;
    }

    protected static final int getTower_MaxLevel_CanBuild(int n) {
        for (int i = 0; i < TOWER_TECHNOLOGY_LEVEL.length; ++i) {
            if (!(TOWER_TECHNOLOGY_LEVEL[i] > CFG.game.getCiv(n).getTechnologyLevel())) continue;
            return i - 1;
        }
        return BuildingsManager.getTower_MaxLevel();
    }

    protected static final String getTower_Name(int n) {
        try {
            return TOWER_NAMES[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return TOWER_NAMES[TOWER_NAMES.length - 1];
        }
    }

    protected static final int getTower_BuildCost(int n, int n2) {
        try {
            int n3 = 0;
            for (int i = 0; i < CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getNumOfProvinces(); ++i) {
                if (CFG.game.getProvince(CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getProvinceID(i)).getLevelOfWatchTower() <= 0) continue;
                ++n3;
            }
            return (int)(((float)CFG.game.getGameScenarios().getScenario_StartingPopulation() * (TOWER_BUILD_COST[n] + 0.005314f * (float)n3) + (float)CFG.game.getGameScenarios().getScenario_StartingPopulation() * (0.01f * (1.0f - CFG.game.getProvince(n2).getDevelopmentLevel()))) * (1.0f + CFG.terrainTypesManager.getBuildCost(CFG.game.getProvince(n2).getTerrainTypeID())));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final int getTower_BuildMovementCost(int n) {
        try {
            return TOWER_BUILD_MOVEMENT_COST[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final int getTower_MaitenanceCost(int n) {
        try {
            return TOWER_MAINTENANCE_COST[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final float getTower_TechLevel(int n) {
        try {
            return TOWER_TECHNOLOGY_LEVEL[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0.0f;
        }
    }

    protected static final int getTower_DefenseBonus(int n) {
        try {
            return TOWER_DEFENSE_BONUS[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final int getTower_Construction(int n) {
        try {
            return TOWER_CONSTRUCTION[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final boolean canBuildTower(int n) {
        return CFG.game.getProvince(n).getLevelOfWatchTower() < BuildingsManager.getTower_MaxLevel() && CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getTechnologyLevel() >= BuildingsManager.getTower_TechLevel(CFG.game.getProvince(n).getLevelOfWatchTower() + 1) && CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getMovePoints() >= BuildingsManager.getTower_BuildMovementCost(CFG.game.getProvince(n).getLevelOfWatchTower() + 1);
    }

    protected static final boolean constructTower(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfWatchTower() < BuildingsManager.getTower_MaxLevel() && CFG.game.getCiv(n2).getTechnologyLevel() >= BuildingsManager.getTower_TechLevel(CFG.game.getProvince(n).getLevelOfWatchTower() + 1)) {
            if (CFG.game.getCiv(n2).getMovePoints() >= BuildingsManager.getTower_BuildMovementCost(CFG.game.getProvince(n).getLevelOfWatchTower() + 1) && CFG.game.getCiv(n2).getMoney() >= (long)BuildingsManager.getTower_BuildCost(CFG.game.getProvince(n).getLevelOfWatchTower() + 1, n)) {
                CFG.game.getCiv(n2).setMovePoints(CFG.game.getCiv(n2).getMovePoints() - BuildingsManager.getTower_BuildMovementCost(CFG.game.getProvince(n).getLevelOfWatchTower() + 1));
                CFG.game.getCiv(n2).setMoney(CFG.game.getCiv(n2).getMoney() - (long)BuildingsManager.getTower_BuildCost(CFG.game.getProvince(n).getLevelOfWatchTower() + 1, n));
                CFG.game.getCiv(n2).addNewConstruction(new Construction_GameData_Tower(n, BuildingsManager.getTower_Construction(CFG.game.getProvince(n).getLevelOfWatchTower() + 1)));
                return true;
            }
            return false;
        }
        return false;
    }

    protected static final boolean buildTower(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfWatchTower() < BuildingsManager.getTower_MaxLevel()) {
            CFG.game.getProvince(n).setLevelOfWatchTower(CFG.game.getProvince(n).getLevelOfWatchTower() + 1);
            ++CFG.game.getCiv((int)n2).civGameData.iNumOfBuildingsConstructed;
            for (int i = 0; i < CFG.game.getPlayersSize(); ++i) {
                if (CFG.game.getCiv(CFG.game.getPlayer(CFG.PLAYER_TURNID).getCivID()).getNumOfProvinces() <= 0) continue;
                for (int j = 0; j < CFG.game.getProvince(n).getNeighboringProvincesSize(); ++j) {
                    CFG.game.getProvince(CFG.game.getProvince(n).getNeighboringProvinces(j)).updateFogOfWar(i);
                }
            }
            CFG.game.getCiv((int)n2).getCivilization_Diplomacy_GameData().messageBox.addMessage(new Message_Bulit_Tower(n2, n));
            return true;
        }
        return false;
    }

    protected static final int getPort_MaxLevel() {
        return PORT_NAMES.length - 1;
    }

    protected static final String getPort_Name(int n) {
        try {
            return PORT_NAMES[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return PORT_NAMES[PORT_NAMES.length - 1];
        }
    }

    protected static final int getPort_BuildCost(int n, int n2) {
        try {
            int n3 = 0;
            for (int i = 0; i < CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getNumOfProvinces(); ++i) {
                if (CFG.game.getProvince(CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getProvinceID(i)).getLevelOfPort() <= 0) continue;
                ++n3;
            }
            return (int)(((float)CFG.game.getGameScenarios().getScenario_StartingPopulation() * (PORT_BUILD_COST[n] + 0.00325f * (float)n3) + (float)CFG.game.getGameScenarios().getScenario_StartingPopulation() * (0.015f * (1.0f - CFG.game.getProvince(n2).getDevelopmentLevel()))) * (1.0f + CFG.terrainTypesManager.getBuildCost(CFG.game.getProvince(n2).getTerrainTypeID())));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final int getPort_BuildMovementCost(int n) {
        try {
            return PORT_BUILD_MOVEMENT_COST[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final int getPort_MaitenanceCost(int n) {
        try {
            return PORT_MAINTENANCE_COST[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final int getPort_Construction(int n) {
        try {
            return PORT_CONSTRUCTION[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final float getPort_TechLevel(int n) {
        try {
            return PORT_TECHNOLOGY_LEVEL[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0.0f;
        }
    }

    protected static final float getPort_IncomeProduction(int n) {
        try {
            return PORT_INCOME_PRODUCTION[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return 0.0f;
        }
    }

    protected static final boolean canBuildPort(int n) {
        return CFG.game.getProvince(n).getLevelOfPort() < BuildingsManager.getPort_MaxLevel() && CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getTechnologyLevel() >= BuildingsManager.getPort_TechLevel(CFG.game.getProvince(n).getLevelOfPort() + 1) && CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getMovePoints() >= BuildingsManager.getPort_BuildMovementCost(CFG.game.getProvince(n).getLevelOfPort() + 1) && CFG.game.getProvince(n).getNeighboringSeaProvincesSize() > 0;
    }

    protected static final boolean constructPort(int n, int n2) {
        if (CFG.game.getProvince(n).getLevelOfPort() >= 0 && CFG.game.getProvince(n).getLevelOfPort() < BuildingsManager.getPort_MaxLevel() && CFG.game.getCiv(n2).getTechnologyLevel() >= BuildingsManager.getPort_TechLevel(CFG.game.getProvince(n).getLevelOfPort() + 1)) {
            if (CFG.game.getCiv(n2).getMovePoints() >= BuildingsManager.getPort_BuildMovementCost(CFG.game.getProvince(n).getLevelOfPort() + 1) && CFG.game.getCiv(n2).getMoney() >= (long)BuildingsManager.getPort_BuildCost(CFG.game.getProvince(n).getLevelOfPort() + 1, n)) {
                CFG.game.getCiv(n2).setMovePoints(CFG.game.getCiv(n2).getMovePoints() - BuildingsManager.getPort_BuildMovementCost(CFG.game.getProvince(n).getLevelOfPort() + 1));
                CFG.game.getCiv(n2).setMoney(CFG.game.getCiv(n2).getMoney() - (long)BuildingsManager.getPort_BuildCost(CFG.game.getProvince(n).getLevelOfPort() + 1, n));
                CFG.game.getCiv(n2).addNewConstruction(new Construction_GameData(n, BuildingsManager.getPort_Construction(CFG.game.getProvince(n).getLevelOfPort() + 1)));
                return true;
            }
            return false;
        }
        return false;
    }

    protected static final boolean buildPort(int n, int n2) {
        if (CFG.game.getProvince(n).getLevelOfPort() >= 0 && CFG.game.getProvince(n).getLevelOfPort() < BuildingsManager.getPort_MaxLevel()) {
            CFG.game.getProvince(n).setLevelOfPort(CFG.game.getProvince(n).getLevelOfPort() + 1);
            ++CFG.game.getCiv((int)n2).civGameData.iNumOfBuildingsConstructed;
            CFG.game.getCiv((int)n2).getCivilization_Diplomacy_GameData().messageBox.addMessage(new Message_Bulit_Port(n2, n));
            return true;
        }
        return false;
    }

    protected static final int getFarm_MaxLevel() {
        return FARM_NAMES.length - 1;
    }

    protected static final int getFarm_MaxLevel_CanBuild(int n) {
        for (int i = 0; i < FARM_TECHNOLOGY_LEVEL.length; ++i) {
            if (!(FARM_TECHNOLOGY_LEVEL[i] > CFG.game.getCiv(n).getTechnologyLevel())) continue;
            return i - 1;
        }
        return BuildingsManager.getFarm_MaxLevel();
    }

    protected static final String getFarm_Name(int n) {
        try {
            return FARM_NAMES[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return FARM_NAMES[FARM_NAMES.length - 1];
        }
    }

    protected static final int getFarm_BuildCost(int n, int n2) {
        try {
            int n3 = 0;
            for (int i = 0; i < CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getNumOfProvinces(); ++i) {
                if (CFG.game.getProvince(CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getProvinceID(i)).getLevelOfFarm() <= 0) continue;
                n3 += CFG.game.getProvince(CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getProvinceID(i)).getLevelOfFarm();
            }
            return (int)(((float)CFG.game.getGameScenarios().getScenario_StartingPopulation() * (FARM_BUILD_COST[n] + 0.00215f * (float)n3) + (float)CFG.game.getGameScenarios().getScenario_StartingPopulation() * (0.015f * (1.0f - CFG.game.getProvince(n2).getDevelopmentLevel()))) * (1.0f + CFG.terrainTypesManager.getBuildCost(CFG.game.getProvince(n2).getTerrainTypeID())));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final int getFarm_Construction(int n) {
        try {
            return FARM_CONSTRUCTION[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final int getFarm_BuildMovementCost(int n) {
        try {
            return FARM_BUILD_MOVEMENT_COST[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final float getFarm_TechLevel(int n) {
        try {
            return FARM_TECHNOLOGY_LEVEL[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0.0f;
        }
    }

    protected static final float getFarm_GrowthRateBonus(int n) {
        try {
            return FARM_GROWTH_RATE_BONUS[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return FARM_GROWTH_RATE_BONUS[FARM_GROWTH_RATE_BONUS.length - 1];
        }
    }

    protected static final int getFarm_MaitenanceCost(int n) {
        try {
            return FARM_MAINTENANCE_COST[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final boolean constructFarm(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfFarm() < BuildingsManager.getFarm_MaxLevel() && CFG.game.getCiv(n2).getTechnologyLevel() >= BuildingsManager.getFarm_TechLevel(CFG.game.getProvince(n).getLevelOfFarm() + 1)) {
            if (CFG.game.getCiv(n2).getMovePoints() >= BuildingsManager.getFarm_BuildMovementCost(CFG.game.getProvince(n).getLevelOfFarm() + 1) && CFG.game.getCiv(n2).getMoney() >= (long)BuildingsManager.getFarm_BuildCost(CFG.game.getProvince(n).getLevelOfFarm() + 1, n)) {
                CFG.game.getCiv(n2).setMovePoints(CFG.game.getCiv(n2).getMovePoints() - BuildingsManager.getFarm_BuildMovementCost(CFG.game.getProvince(n).getLevelOfFarm() + 1));
                CFG.game.getCiv(n2).setMoney(CFG.game.getCiv(n2).getMoney() - (long)BuildingsManager.getFarm_BuildCost(CFG.game.getProvince(n).getLevelOfFarm() + 1, n));
                CFG.game.getCiv(n2).addNewConstruction(new Construction_GameData_Farm(n, BuildingsManager.getFarm_Construction(CFG.game.getProvince(n).getLevelOfFarm() + 1)));
                return true;
            }
            return false;
        }
        return false;
    }

    protected static final boolean buildFarm(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfFarm() < BuildingsManager.getFarm_MaxLevel()) {
            CFG.game.getProvince(n).setLevelOfFarm(CFG.game.getProvince(n).getLevelOfFarm() + 1);
            ++CFG.game.getCiv((int)n2).civGameData.iNumOfBuildingsConstructed;
            CFG.game.getCiv((int)n2).getCivilization_Diplomacy_GameData().messageBox.addMessage(new Message_Bulit_Farm(n2, n));
            return true;
        }
        return false;
    }

    protected static final boolean canBuildFarm_Terrain(int n) {
        return CFG.terrainTypesManager.getPopulationGrowth(CFG.game.getProvince(n).getTerrainTypeID()) >= 0.0f;
    }

    protected static final boolean canBuildFarm(int n) {
        return CFG.game.getProvince(n).getLevelOfFarm() < BuildingsManager.getFarm_MaxLevel() && BuildingsManager.canBuildFarm_Terrain(n) && CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getTechnologyLevel() >= BuildingsManager.getFarm_TechLevel(CFG.game.getProvince(n).getLevelOfFarm() + 1) && CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getMovePoints() >= BuildingsManager.getFarm_BuildMovementCost(CFG.game.getProvince(n).getLevelOfFarm() + 1);
    }

    protected static final int getLibrary_MaxLevel() {
        return LIBRARY_NAMES.length - 1;
    }

    protected static final int getLibrary_MaxLevel_CanBuild(int n) {
        for (int i = 0; i < LIBRARY_TECH_LEVEL.length; ++i) {
            if (!(LIBRARY_TECH_LEVEL[i] > CFG.game.getCiv(n).getTechnologyLevel())) continue;
            return i - 1;
        }
        return BuildingsManager.getLibrary_MaxLevel();
    }

    protected static final String getLibrary_Name(int n) {
        try {
            return LIBRARY_NAMES[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return LIBRARY_NAMES[LIBRARY_NAMES.length - 1];
        }
    }

    protected static final int getLibrary_BuildCost(int n, int n2) {
        try {
            int n3 = 0;
            for (int i = 0; i < CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getNumOfProvinces(); ++i) {
                if (CFG.game.getProvince(CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getProvinceID(i)).getLevelOfLibrary() <= 0) continue;
                n3 += CFG.game.getProvince(CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getProvinceID(i)).getLevelOfLibrary();
            }
            return (int)(((float)CFG.game.getGameScenarios().getScenario_StartingPopulation() * (LIBRARY_BUILD_COST[n] + 0.00425f * (float)n3) + (float)CFG.game.getGameScenarios().getScenario_StartingPopulation() * (0.135f * (1.0f - CFG.game.getProvince(n2).getDevelopmentLevel()))) * (1.0f + CFG.terrainTypesManager.getBuildCost(CFG.game.getProvince(n2).getTerrainTypeID())));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final int getLibrary_BuildMovementCost(int n) {
        try {
            return LIBRARY_BUILD_MOVEMENT_COST[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final int getLibrary_ResearchPerPopulation(int n) {
        try {
            return LIBRARY_RESEARCH_PER_POPULATION[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final float getLibrary_TechLevel(int n) {
        try {
            return LIBRARY_TECH_LEVEL[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0.0f;
        }
    }

    protected static final int getLibrary_Construction(int n) {
        try {
            return LIBRARY_CONSTRUCTION[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final boolean constructLibrary(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfLibrary() < BuildingsManager.getLibrary_MaxLevel() && CFG.game.getCiv(n2).getTechnologyLevel() >= BuildingsManager.getLibrary_TechLevel(CFG.game.getProvince(n).getLevelOfLibrary() + 1)) {
            if (CFG.game.getCiv(n2).getMovePoints() >= BuildingsManager.getLibrary_BuildMovementCost(CFG.game.getProvince(n).getLevelOfLibrary() + 1) && CFG.game.getCiv(n2).getMoney() >= (long)BuildingsManager.getLibrary_BuildCost(CFG.game.getProvince(n).getLevelOfLibrary() + 1, n)) {
                CFG.game.getCiv(n2).setMovePoints(CFG.game.getCiv(n2).getMovePoints() - BuildingsManager.getLibrary_BuildMovementCost(CFG.game.getProvince(n).getLevelOfLibrary() + 1));
                CFG.game.getCiv(n2).setMoney(CFG.game.getCiv(n2).getMoney() - (long)BuildingsManager.getLibrary_BuildCost(CFG.game.getProvince(n).getLevelOfLibrary() + 1, n));
                CFG.game.getCiv(n2).addNewConstruction(new Construction_GameData_Library(n, BuildingsManager.getLibrary_Construction(CFG.game.getProvince(n).getLevelOfLibrary() + 1)));
                return true;
            }
            return false;
        }
        return false;
    }

    protected static final boolean buildLibrary(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfLibrary() < BuildingsManager.getLibrary_MaxLevel()) {
            CFG.game.getProvince(n).setLevelOfLibrary(CFG.game.getProvince(n).getLevelOfLibrary() + 1);
            ++CFG.game.getCiv((int)n2).civGameData.iNumOfBuildingsConstructed;
            CFG.game.getCiv((int)n2).getCivilization_Diplomacy_GameData().messageBox.addMessage(new Message_Bulit_Library(n2, n));
            return true;
        }
        return false;
    }

    protected static final boolean canBuildLibrary(int n) {
        return CFG.game.getProvince(n).getLevelOfLibrary() < BuildingsManager.getLibrary_MaxLevel() && CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getTechnologyLevel() >= BuildingsManager.getLibrary_TechLevel(CFG.game.getProvince(n).getLevelOfLibrary() + 1) && CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getMovePoints() >= BuildingsManager.getLibrary_BuildMovementCost(CFG.game.getProvince(n).getLevelOfLibrary() + 1);
    }

    protected static final int getArmoury_MaxLevel() {
        return ARMOURY_NAMES.length - 1;
    }

    protected static final String getArmoury_Name(int n) {
        try {
            return ARMOURY_NAMES[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return ARMOURY_NAMES[ARMOURY_NAMES.length - 1];
        }
    }

    protected static final int getArmoury_BuildCost(int n, int n2) {
        try {
            int n3 = 0;
            for (int i = 0; i < CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getNumOfProvinces(); ++i) {
                if (CFG.game.getProvince(CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getProvinceID(i)).getLevelOfArmoury() <= 0) continue;
                ++n3;
            }
            return (int)(((float)CFG.game.getGameScenarios().getScenario_StartingPopulation() * (ARMOURY_BUILD_COST[n] + 0.0235f * (float)n3) + (float)CFG.game.getGameScenarios().getScenario_StartingPopulation() * (0.3f * (1.0f - CFG.game.getProvince(n2).getDevelopmentLevel()))) * (1.0f + CFG.terrainTypesManager.getBuildCost(CFG.game.getProvince(n2).getTerrainTypeID())));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final int getArmoury_BuildMovementCost(int n) {
        try {
            return ARMOURY_BUILD_MOVEMENT_COST[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final float getArmoury_TechLevel(int n) {
        try {
            return ARMOURY_TECH_LEVEL[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0.0f;
        }
    }

    protected static final int getArmoury_Construction(int n) {
        try {
            return ARMOURY_CONSTRUCTION[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final boolean constructArmoury(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfArmoury() < BuildingsManager.getArmoury_MaxLevel() && CFG.game.getCiv(n2).getTechnologyLevel() >= BuildingsManager.getArmoury_TechLevel(CFG.game.getProvince(n).getLevelOfArmoury() + 1)) {
            if (CFG.game.getCiv(n2).getMovePoints() >= BuildingsManager.getArmoury_BuildMovementCost(CFG.game.getProvince(n).getLevelOfArmoury() + 1) && CFG.game.getCiv(n2).getMoney() >= (long)BuildingsManager.getArmoury_BuildCost(CFG.game.getProvince(n).getLevelOfArmoury() + 1, n)) {
                CFG.game.getCiv(n2).setMovePoints(CFG.game.getCiv(n2).getMovePoints() - BuildingsManager.getArmoury_BuildMovementCost(CFG.game.getProvince(n).getLevelOfArmoury() + 1));
                CFG.game.getCiv(n2).setMoney(CFG.game.getCiv(n2).getMoney() - (long)BuildingsManager.getArmoury_BuildCost(CFG.game.getProvince(n).getLevelOfArmoury() + 1, n));
                CFG.game.getCiv(n2).addNewConstruction(new Construction_GameData_Armoury(n, BuildingsManager.getArmoury_Construction(CFG.game.getProvince(n).getLevelOfArmoury() + 1)));
                return true;
            }
            return false;
        }
        return false;
    }

    protected static final boolean buildArmoury(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfArmoury() < BuildingsManager.getArmoury_MaxLevel()) {
            CFG.game.getProvince(n).setLevelOfArmoury(CFG.game.getProvince(n).getLevelOfArmoury() + 1);
            ++CFG.game.getCiv((int)n2).civGameData.iNumOfBuildingsConstructed;
            CFG.game.getCiv((int)n2).getCivilization_Diplomacy_GameData().messageBox.addMessage(new Message_Bulit_Armoury(n2, n));
            return true;
        }
        return false;
    }

    protected static final boolean canBuildArmoury(int n) {
        return CFG.game.getProvince(n).getLevelOfArmoury() < BuildingsManager.getArmoury_MaxLevel() && CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getTechnologyLevel() >= BuildingsManager.getArmoury_TechLevel(CFG.game.getProvince(n).getLevelOfArmoury() + 1) && CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getMovePoints() >= BuildingsManager.getArmoury_BuildMovementCost(CFG.game.getProvince(n).getLevelOfArmoury() + 1);
    }

    protected static final int getWorkshop_MaxLevel() {
        return WORKSHOP_NAMES.length - 1;
    }

    protected static final int getWorkshop_MaxLevel_CanBuild(int n) {
        for (int i = 0; i < WORKSHOP_TECHNOLOGY_LEVEL.length; ++i) {
            if (!(WORKSHOP_TECHNOLOGY_LEVEL[i] > CFG.game.getCiv(n).getTechnologyLevel())) continue;
            return i - 1;
        }
        return BuildingsManager.getWorkshop_MaxLevel();
    }

    protected static final String getWorkshop_Name(int n) {
        try {
            return WORKSHOP_NAMES[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return WORKSHOP_NAMES[WORKSHOP_NAMES.length - 1];
        }
    }

    protected static final int getWorkshop_BuildCost(int n, int n2) {
        try {
            int n3 = 0;
            for (int i = 0; i < CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getNumOfProvinces(); ++i) {
                if (CFG.game.getProvince(CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getProvinceID(i)).getLevelOfWorkshop() <= 0) continue;
                n3 += CFG.game.getProvince(CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getProvinceID(i)).getLevelOfWorkshop();
            }
            return (int)(((float)CFG.game.getGameScenarios().getScenario_StartingPopulation() * (WORKSHOP_BUILD_COST[n] + 0.002675f * (float)n3) + (float)CFG.game.getGameScenarios().getScenario_StartingPopulation() * (0.025f * (1.0f - CFG.game.getProvince(n2).getDevelopmentLevel()))) * (1.0f + CFG.terrainTypesManager.getBuildCost(CFG.game.getProvince(n2).getTerrainTypeID())));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final int getWorkshop_Construction(int n) {
        try {
            return WORKSHOP_CONSTRUCTION[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final int getWorkshop_BuildMovementCost(int n) {
        try {
            return WORKSHOP_BUILD_MOVEMENT_COST[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final float getWorkshop_TechLevel(int n) {
        try {
            return WORKSHOP_TECHNOLOGY_LEVEL[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0.0f;
        }
    }

    protected static final float getWorkshop_IncomeProduction(int n) {
        try {
            return WORKSHOP_INCOME_PRODUCTION[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return WORKSHOP_INCOME_PRODUCTION[WORKSHOP_INCOME_PRODUCTION.length - 1];
        }
    }

    protected static final int getWorkshop_MaitenanceCost(int n) {
        try {
            return WORKSHOP_MAINTENANCE_COST[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final boolean constructWorkshop(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfWorkshop() < BuildingsManager.getWorkshop_MaxLevel() && CFG.game.getCiv(n2).getTechnologyLevel() >= BuildingsManager.getWorkshop_TechLevel(CFG.game.getProvince(n).getLevelOfWorkshop() + 1)) {
            if (CFG.game.getCiv(n2).getMovePoints() >= BuildingsManager.getWorkshop_BuildMovementCost(CFG.game.getProvince(n).getLevelOfWorkshop() + 1) && CFG.game.getCiv(n2).getMoney() >= (long)BuildingsManager.getWorkshop_BuildCost(CFG.game.getProvince(n).getLevelOfWorkshop() + 1, n)) {
                CFG.game.getCiv(n2).setMovePoints(CFG.game.getCiv(n2).getMovePoints() - BuildingsManager.getWorkshop_BuildMovementCost(CFG.game.getProvince(n).getLevelOfWorkshop() + 1));
                CFG.game.getCiv(n2).setMoney(CFG.game.getCiv(n2).getMoney() - (long)BuildingsManager.getWorkshop_BuildCost(CFG.game.getProvince(n).getLevelOfWorkshop() + 1, n));
                CFG.game.getCiv(n2).addNewConstruction(new Construction_GameData_Workshop(n, BuildingsManager.getWorkshop_Construction(CFG.game.getProvince(n).getLevelOfWorkshop() + 1)));
                return true;
            }
            return false;
        }
        return false;
    }

    protected static final boolean buildWorkshop(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfWorkshop() < BuildingsManager.getWorkshop_MaxLevel()) {
            CFG.game.getProvince(n).setLevelOfWorkshop(CFG.game.getProvince(n).getLevelOfWorkshop() + 1);
            ++CFG.game.getCiv((int)n2).civGameData.iNumOfBuildingsConstructed;
            CFG.game.getCiv((int)n2).getCivilization_Diplomacy_GameData().messageBox.addMessage(new Message_Bulit_Workshop(n2, n));
            return true;
        }
        return false;
    }

    protected static final boolean canBuildWorkshop(int n) {
        return CFG.game.getProvince(n).getLevelOfWorkshop() < BuildingsManager.getWorkshop_MaxLevel() && CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getTechnologyLevel() >= BuildingsManager.getWorkshop_TechLevel(CFG.game.getProvince(n).getLevelOfWorkshop() + 1) && CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getMovePoints() >= BuildingsManager.getWorkshop_BuildMovementCost(CFG.game.getProvince(n).getLevelOfWorkshop() + 1);
    }

    protected static final int getSupply_MaxLevel() {
        return SUPPLY_NAMES.length - 1;
    }

    protected static final String getSupply_Name(int n) {
        try {
            return SUPPLY_NAMES[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return SUPPLY_NAMES[SUPPLY_NAMES.length - 1];
        }
    }

    protected static final int getSupply_BuildCost(int n, int n2) {
        try {
            int n3 = 0;
            for (int i = 0; i < CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getNumOfProvinces(); ++i) {
                if (CFG.game.getProvince(CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getProvinceID(i)).getLevelOfSupply() <= 0) continue;
                ++n3;
            }
            return (int)(((float)CFG.game.getGameScenarios().getScenario_StartingPopulation() * (SUPPLY_BUILD_COST[n] + 0.0115f * (float)n3) + (float)CFG.game.getGameScenarios().getScenario_StartingPopulation() * (0.3f * (1.0f - CFG.game.getProvince(n2).getDevelopmentLevel()))) * (1.0f + CFG.terrainTypesManager.getBuildCost(CFG.game.getProvince(n2).getTerrainTypeID())));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final float getSupply_Bonus(int n) {
        try {
            return SUPPLY_BONUS[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return SUPPLY_BONUS[SUPPLY_BONUS.length - 1];
        }
    }

    protected static final int getSupply_BuildMovementCost(int n) {
        try {
            return SUPPLY_BUILD_MOVEMENT_COST[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final float getSupply_TechLevel(int n) {
        try {
            return SUPPLY_TECH_LEVEL[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0.0f;
        }
    }

    protected static final int getSupply_Construction(int n) {
        try {
            return SUPPLY_CONSTRUCTION[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final boolean constructSupply(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfSupply() < BuildingsManager.getSupply_MaxLevel() && CFG.game.getCiv(n2).getTechnologyLevel() >= BuildingsManager.getSupply_TechLevel(CFG.game.getProvince(n).getLevelOfSupply() + 1)) {
            if (CFG.game.getCiv(n2).getMovePoints() >= BuildingsManager.getSupply_BuildMovementCost(CFG.game.getProvince(n).getLevelOfSupply() + 1) && CFG.game.getCiv(n2).getMoney() >= (long)BuildingsManager.getSupply_BuildCost(CFG.game.getProvince(n).getLevelOfSupply() + 1, n)) {
                CFG.game.getCiv(n2).setMovePoints(CFG.game.getCiv(n2).getMovePoints() - BuildingsManager.getSupply_BuildMovementCost(CFG.game.getProvince(n).getLevelOfSupply() + 1));
                CFG.game.getCiv(n2).setMoney(CFG.game.getCiv(n2).getMoney() - (long)BuildingsManager.getSupply_BuildCost(CFG.game.getProvince(n).getLevelOfSupply() + 1, n));
                CFG.game.getCiv(n2).addNewConstruction(new Construction_GameData_Supply(n, BuildingsManager.getSupply_Construction(CFG.game.getProvince(n).getLevelOfSupply() + 1)));
                return true;
            }
            return false;
        }
        return false;
    }

    protected static final boolean canBuildSupply(int n) {
        return CFG.game.getProvince(n).getLevelOfSupply() < BuildingsManager.getSupply_MaxLevel() && CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getTechnologyLevel() >= BuildingsManager.getSupply_TechLevel(CFG.game.getProvince(n).getLevelOfSupply() + 1) && CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getMovePoints() >= BuildingsManager.getSupply_BuildMovementCost(CFG.game.getProvince(n).getLevelOfSupply() + 1);
    }

    protected static final boolean buildSupply(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfSupply() < BuildingsManager.getSupply_MaxLevel()) {
            CFG.game.getProvince(n).setLevelOfSupply(CFG.game.getProvince(n).getLevelOfSupply() + 1);
            ++CFG.game.getCiv((int)n2).civGameData.iNumOfBuildingsConstructed;
            CFG.game.getCiv((int)n2).getCivilization_Diplomacy_GameData().messageBox.addMessage(new Message_Bulit_Supply(n2, n));
            return true;
        }
        return false;
    }
}

