/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.compression.lzma;

import com.badlogic.gdx.utils.compression.lz.OutWindow;
import com.badlogic.gdx.utils.compression.lzma.Base;
import com.badlogic.gdx.utils.compression.rangecoder.BitTreeDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Decoder {
    int m_DictionarySize = -1;
    int m_DictionarySizeCheck = -1;
    short[] m_IsMatchDecoders;
    short[] m_IsRep0LongDecoders;
    short[] m_IsRepDecoders;
    short[] m_IsRepG0Decoders;
    short[] m_IsRepG1Decoders;
    short[] m_IsRepG2Decoders;
    LenDecoder m_LenDecoder;
    LiteralDecoder m_LiteralDecoder;
    OutWindow m_OutWindow = new OutWindow();
    BitTreeDecoder m_PosAlignDecoder;
    short[] m_PosDecoders;
    BitTreeDecoder[] m_PosSlotDecoder;
    int m_PosStateMask;
    com.badlogic.gdx.utils.compression.rangecoder.Decoder m_RangeDecoder = new com.badlogic.gdx.utils.compression.rangecoder.Decoder();
    LenDecoder m_RepLenDecoder;

    public Decoder() {
        this.m_IsMatchDecoders = new short[192];
        this.m_IsRepDecoders = new short[12];
        this.m_IsRepG0Decoders = new short[12];
        this.m_IsRepG1Decoders = new short[12];
        this.m_IsRepG2Decoders = new short[12];
        this.m_IsRep0LongDecoders = new short[192];
        this.m_PosSlotDecoder = new BitTreeDecoder[4];
        this.m_PosDecoders = new short[114];
        this.m_PosAlignDecoder = new BitTreeDecoder(4);
        this.m_LenDecoder = new LenDecoder();
        this.m_RepLenDecoder = new LenDecoder();
        this.m_LiteralDecoder = new LiteralDecoder();
        for (int i = 0; i < 4; ++i) {
            this.m_PosSlotDecoder[i] = new BitTreeDecoder(6);
        }
    }

    public boolean Code(InputStream object, OutputStream object2, long l) throws IOException {
        this.m_RangeDecoder.SetStream((InputStream)object);
        this.m_OutWindow.SetStream((OutputStream)object2);
        this.Init();
        int n = Base.StateInit();
        long l2 = 0L;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = n2;
        while (true) {
            int n8;
            int n9;
            block15: {
                block17: {
                    block18: {
                        block20: {
                            block21: {
                                block13: {
                                    block19: {
                                        int n10;
                                        block16: {
                                            int n11;
                                            int n12;
                                            int n13;
                                            int n14;
                                            block14: {
                                                n2 = 1;
                                                if (l >= 0L && l2 >= l) break block13;
                                                object = this.m_RangeDecoder;
                                                object2 = this.m_IsMatchDecoders;
                                                n9 = (int)l2;
                                                n10 = this.m_PosStateMask & n9;
                                                n8 = (n << 4) + n10;
                                                if (((com.badlogic.gdx.utils.compression.rangecoder.Decoder)object).DecodeBit((short[])object2, n8) != 0) break block14;
                                                object = this.m_LiteralDecoder.GetDecoder(n9, (byte)n7);
                                                n7 = !Base.StateIsCharState(n) ? (n2 = ((LiteralDecoder.Decoder2)object).DecodeWithMatchByte(this.m_RangeDecoder, this.m_OutWindow.GetByte(n5))) : (n2 = ((LiteralDecoder.Decoder2)object).DecodeNormal(this.m_RangeDecoder));
                                                this.m_OutWindow.PutByte((byte)n7);
                                                n = Base.StateUpdateChar(n);
                                                ++l2;
                                                n9 = n6;
                                                n6 = n5;
                                                n5 = n4;
                                                n2 = n3;
                                                n8 = n7;
                                                break block15;
                                            }
                                            if (this.m_RangeDecoder.DecodeBit(this.m_IsRepDecoders, n) != 1) break block16;
                                            if (this.m_RangeDecoder.DecodeBit(this.m_IsRepG0Decoders, n) == 0) {
                                                if (this.m_RangeDecoder.DecodeBit(this.m_IsRep0LongDecoders, n8) == 0) {
                                                    n14 = Base.StateUpdateShortRep(n);
                                                    n13 = n3;
                                                    n12 = n4;
                                                    n8 = n5;
                                                    n11 = n6;
                                                } else {
                                                    n2 = 0;
                                                    n14 = n;
                                                    n13 = n3;
                                                    n12 = n4;
                                                    n8 = n5;
                                                    n11 = n6;
                                                }
                                            } else {
                                                if (this.m_RangeDecoder.DecodeBit(this.m_IsRepG1Decoders, n) == 0) {
                                                    n2 = n4;
                                                    n4 = n6;
                                                } else {
                                                    n9 = n3;
                                                    n2 = n6;
                                                    if (this.m_RangeDecoder.DecodeBit(this.m_IsRepG2Decoders, n) == 0) {
                                                        n2 = n3;
                                                        n9 = n6;
                                                    }
                                                    n3 = n4;
                                                    n4 = n9;
                                                }
                                                n8 = n2;
                                                n2 = 0;
                                                n11 = n4;
                                                n12 = n5;
                                                n13 = n3;
                                                n14 = n;
                                            }
                                            n = n14;
                                            n6 = n13;
                                            n5 = n12;
                                            n4 = n8;
                                            n3 = n11;
                                            n9 = n2;
                                            if (n2 == 0) {
                                                n9 = this.m_RepLenDecoder.Decode(this.m_RangeDecoder, n10) + 2;
                                                n = Base.StateUpdateRep(n14);
                                                n6 = n13;
                                                n5 = n12;
                                                n4 = n8;
                                                n3 = n11;
                                            }
                                            break block17;
                                        }
                                        n9 = this.m_LenDecoder.Decode(this.m_RangeDecoder, n10) + 2;
                                        n = Base.StateUpdateMatch(n);
                                        n2 = this.m_PosSlotDecoder[Base.GetLenToPosState(n9)].Decode(this.m_RangeDecoder);
                                        if (n2 < 4) break block18;
                                        n6 = (n2 >> 1) - 1;
                                        n8 = (n2 & 1 | 2) << n6;
                                        if (n2 >= 14) break block19;
                                        n6 = n8 + BitTreeDecoder.ReverseDecode(this.m_PosDecoders, n8 - n2 - 1, this.m_RangeDecoder, n6);
                                        break block20;
                                    }
                                    n6 = n2 = n8 + (this.m_RangeDecoder.DecodeDirectBits(n6 - 4) << 4) + this.m_PosAlignDecoder.ReverseDecode(this.m_RangeDecoder);
                                    if (n2 >= 0) break block20;
                                    if (n2 != -1) break block21;
                                }
                                this.m_OutWindow.Flush();
                                this.m_OutWindow.ReleaseStream();
                                this.m_RangeDecoder.ReleaseStream();
                                return true;
                            }
                            return false;
                        }
                        n2 = n6;
                        n6 = n4;
                        n4 = n2;
                        break block17;
                    }
                    n6 = n4;
                    n4 = n2;
                }
                if ((long)n4 >= l2 || n4 >= this.m_DictionarySizeCheck) break;
                this.m_OutWindow.CopyBlock(n4, n9);
                l2 += (long)n9;
                n8 = this.m_OutWindow.GetByte(0);
                n2 = n6;
                n6 = n4;
                n9 = n3;
            }
            n7 = n8;
            n3 = n2;
            n4 = n5;
            n5 = n6;
            n6 = n9;
        }
        return false;
    }

    void Init() throws IOException {
        OutWindow outWindow = this.m_OutWindow;
        outWindow.Init(false);
        com.badlogic.gdx.utils.compression.rangecoder.Decoder.InitBitModels(this.m_IsMatchDecoders);
        com.badlogic.gdx.utils.compression.rangecoder.Decoder.InitBitModels(this.m_IsRep0LongDecoders);
        com.badlogic.gdx.utils.compression.rangecoder.Decoder.InitBitModels(this.m_IsRepDecoders);
        com.badlogic.gdx.utils.compression.rangecoder.Decoder.InitBitModels(this.m_IsRepG0Decoders);
        com.badlogic.gdx.utils.compression.rangecoder.Decoder.InitBitModels(this.m_IsRepG1Decoders);
        com.badlogic.gdx.utils.compression.rangecoder.Decoder.InitBitModels(this.m_IsRepG2Decoders);
        com.badlogic.gdx.utils.compression.rangecoder.Decoder.InitBitModels(this.m_PosDecoders);
        this.m_LiteralDecoder.Init();
        for (int i = 0; i < 4; ++i) {
            this.m_PosSlotDecoder[i].Init();
        }
        this.m_LenDecoder.Init();
        this.m_RepLenDecoder.Init();
        this.m_PosAlignDecoder.Init();
        this.m_RangeDecoder.Init();
    }

    public boolean SetDecoderProperties(byte[] byArray) {
        if (byArray.length < 5) {
            return false;
        }
        int n = byArray[0] & 0xFF;
        int n2 = n / 9;
        int n3 = n2 / 5;
        int n4 = 0;
        int n5 = 0;
        while (n4 < 4) {
            int n6 = n4 + 1;
            n5 += (byArray[n6] & 0xFF) << n4 * 8;
            n4 = n6;
        }
        if (!this.SetLcLpPb(n % 9, n2 % 5, n3)) {
            return false;
        }
        return this.SetDictionarySize(n5);
    }

    boolean SetDictionarySize(int n) {
        if (n < 0) {
            return false;
        }
        if (this.m_DictionarySize != n) {
            this.m_DictionarySize = n;
            this.m_DictionarySizeCheck = Math.max(this.m_DictionarySize, 1);
            this.m_OutWindow.Create(Math.max(this.m_DictionarySizeCheck, 4096));
        }
        return true;
    }

    boolean SetLcLpPb(int n, int n2, int n3) {
        if (n <= 8 && n2 <= 4 && n3 <= 4) {
            this.m_LiteralDecoder.Create(n2, n);
            n = 1 << n3;
            this.m_LenDecoder.Create(n);
            this.m_RepLenDecoder.Create(n);
            this.m_PosStateMask = n - 1;
            return true;
        }
        return false;
    }

    class LenDecoder {
        short[] m_Choice = new short[2];
        BitTreeDecoder m_HighCoder;
        BitTreeDecoder[] m_LowCoder = new BitTreeDecoder[16];
        BitTreeDecoder[] m_MidCoder = new BitTreeDecoder[16];
        int m_NumPosStates = 0;

        LenDecoder() {
            this.m_HighCoder = new BitTreeDecoder(8);
        }

        public void Create(int n) {
            int n2;
            while ((n2 = ++this.m_NumPosStates) < n) {
                this.m_LowCoder[n2] = new BitTreeDecoder(3);
                this.m_MidCoder[this.m_NumPosStates] = new BitTreeDecoder(3);
            }
        }

        public int Decode(com.badlogic.gdx.utils.compression.rangecoder.Decoder decoder, int n) throws IOException {
            if (decoder.DecodeBit(this.m_Choice, 0) == 0) {
                return this.m_LowCoder[n].Decode(decoder);
            }
            n = decoder.DecodeBit(this.m_Choice, 1) == 0 ? this.m_MidCoder[n].Decode(decoder) : this.m_HighCoder.Decode(decoder) + 8;
            return n + 8;
        }

        public void Init() {
            com.badlogic.gdx.utils.compression.rangecoder.Decoder.InitBitModels(this.m_Choice);
            for (int i = 0; i < this.m_NumPosStates; ++i) {
                this.m_LowCoder[i].Init();
                this.m_MidCoder[i].Init();
            }
            this.m_HighCoder.Init();
        }
    }

    class LiteralDecoder {
        Decoder2[] m_Coders;
        int m_NumPosBits;
        int m_NumPrevBits;
        int m_PosMask;

        LiteralDecoder() {
        }

        public void Create(int n, int n2) {
            if (this.m_Coders != null && this.m_NumPrevBits == n2 && this.m_NumPosBits == n) {
                return;
            }
            this.m_NumPosBits = n;
            this.m_PosMask = (1 << n) - 1;
            this.m_NumPrevBits = n2;
            n2 = 1 << this.m_NumPrevBits + this.m_NumPosBits;
            this.m_Coders = new Decoder2[n2];
            for (n = 0; n < n2; ++n) {
                this.m_Coders[n] = new Decoder2();
            }
        }

        Decoder2 GetDecoder(int n, byte by) {
            Decoder2[] decoder2Array = this.m_Coders;
            int n2 = this.m_PosMask;
            int n3 = this.m_NumPrevBits;
            return decoder2Array[((n & n2) << n3) + ((by & 0xFF) >>> 8 - n3)];
        }

        public void Init() {
            int n = this.m_NumPrevBits;
            int n2 = this.m_NumPosBits;
            for (int i = 0; i < 1 << n + n2; ++i) {
                this.m_Coders[i].Init();
            }
        }

        class Decoder2 {
            short[] m_Decoders = new short[768];

            Decoder2() {
            }

            public byte DecodeNormal(com.badlogic.gdx.utils.compression.rangecoder.Decoder decoder) throws IOException {
                int n;
                int n2 = 1;
                do {
                    n2 = n = decoder.DecodeBit(this.m_Decoders, n2) | n2 << 1;
                } while (n < 256);
                return (byte)n;
            }

            public byte DecodeWithMatchByte(com.badlogic.gdx.utils.compression.rangecoder.Decoder decoder, byte by) throws IOException {
                int n;
                block4: {
                    n = 1;
                    byte by2 = by;
                    do {
                        int n2 = by2 >> 7 & 1;
                        by2 = (byte)(by2 << 1);
                        int n3 = decoder.DecodeBit(this.m_Decoders, (n2 + 1 << 8) + n);
                        by = (byte)(n << 1 | n3);
                        if (n2 != n3) {
                            while (true) {
                                n = by;
                                if (by < 256) {
                                    by = (byte)(by << 1 | decoder.DecodeBit(this.m_Decoders, by));
                                    continue;
                                }
                                break block4;
                                break;
                            }
                        }
                        n = by;
                    } while (by < 256);
                    n = by;
                }
                return (byte)n;
            }

            public void Init() {
                com.badlogic.gdx.utils.compression.rangecoder.Decoder.InitBitModels(this.m_Decoders);
            }
        }
    }
}

