/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Collections;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.util.Iterator;

public interface Predicate<T> {
    public boolean evaluate(T var1);

    public static class PredicateIterable<T>
    implements Iterable<T> {
        public Iterable<T> iterable;
        public PredicateIterator<T> iterator = null;
        public Predicate<T> predicate;

        public PredicateIterable(Iterable<T> iterable, Predicate<T> predicate) {
            this.set(iterable, predicate);
        }

        @Override
        public Iterator<T> iterator() {
            if (Collections.allocateIterators) {
                return new PredicateIterator<T>(this.iterable.iterator(), this.predicate);
            }
            PredicateIterator<T> predicateIterator = this.iterator;
            if (predicateIterator == null) {
                this.iterator = new PredicateIterator<T>(this.iterable.iterator(), this.predicate);
            } else {
                predicateIterator.set(this.iterable.iterator(), this.predicate);
            }
            return this.iterator;
        }

        public void set(Iterable<T> iterable, Predicate<T> predicate) {
            this.iterable = iterable;
            this.predicate = predicate;
        }
    }

    public static class PredicateIterator<T>
    implements Iterator<T> {
        public boolean end = false;
        public Iterator<T> iterator;
        public T next = null;
        public boolean peeked = false;
        public Predicate<T> predicate;

        public PredicateIterator(Iterable<T> iterable, Predicate<T> predicate) {
            this(iterable.iterator(), predicate);
        }

        public PredicateIterator(Iterator<T> iterator, Predicate<T> predicate) {
            this.set(iterator, predicate);
        }

        @Override
        public boolean hasNext() {
            if (this.end) {
                return false;
            }
            if (this.next != null) {
                return true;
            }
            this.peeked = true;
            while (this.iterator.hasNext()) {
                T t = this.iterator.next();
                if (!this.predicate.evaluate(t)) continue;
                this.next = t;
                return true;
            }
            this.end = true;
            return false;
        }

        @Override
        public T next() {
            if (this.next == null && !this.hasNext()) {
                return null;
            }
            T t = this.next;
            this.next = null;
            this.peeked = false;
            return t;
        }

        @Override
        public void remove() {
            if (!this.peeked) {
                this.iterator.remove();
                return;
            }
            throw new GdxRuntimeException("Cannot remove between a call to hasNext() and next().");
        }

        public void set(Iterable<T> iterable, Predicate<T> predicate) {
            this.set(iterable.iterator(), predicate);
        }

        public void set(Iterator<T> iterator, Predicate<T> predicate) {
            this.iterator = iterator;
            this.predicate = predicate;
            this.peeked = false;
            this.end = false;
            this.next = null;
        }
    }
}

