/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.JsonWriter;
import com.badlogic.gdx.utils.SerializationException;
import com.badlogic.gdx.utils.StringBuilder;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class JsonValue
implements Iterable<JsonValue> {
    public JsonValue child;
    private double doubleValue;
    private long longValue;
    public String name;
    public JsonValue next;
    public JsonValue parent;
    public JsonValue prev;
    public int size;
    private String stringValue;
    private ValueType type;

    public JsonValue(double d) {
        this.set(d, null);
    }

    public JsonValue(double d, String string2) {
        this.set(d, string2);
    }

    public JsonValue(long l) {
        this.set(l, (String)null);
    }

    public JsonValue(long l, String string2) {
        this.set(l, string2);
    }

    public JsonValue(ValueType valueType) {
        this.type = valueType;
    }

    public JsonValue(String string2) {
        this.set(string2);
    }

    public JsonValue(boolean bl) {
        this.set(bl);
    }

    private static void indent(int n, StringBuilder stringBuilder) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append('\t');
        }
    }

    private static void indent(int n, Writer writer) throws IOException {
        for (int i = 0; i < n; ++i) {
            writer.append('\t');
        }
    }

    private static boolean isFlat(JsonValue jsonValue) {
        jsonValue = jsonValue.child;
        while (jsonValue != null) {
            if (!jsonValue.isObject() && !jsonValue.isArray()) {
                jsonValue = jsonValue.next;
                continue;
            }
            return false;
        }
        return true;
    }

    private static boolean isNumeric(JsonValue jsonValue) {
        jsonValue = jsonValue.child;
        while (jsonValue != null) {
            if (!jsonValue.isNumber()) {
                return false;
            }
            jsonValue = jsonValue.next;
        }
        return true;
    }

    private void json(JsonValue object, StringBuilder appendable, JsonWriter.OutputType outputType) {
        block19: {
            block13: {
                block18: {
                    block17: {
                        block16: {
                            block15: {
                                block14: {
                                    block12: {
                                        if (!((JsonValue)object).isObject()) break block12;
                                        if (((JsonValue)object).child == null) {
                                            ((StringBuilder)appendable).append("{}");
                                        } else {
                                            ((StringBuilder)appendable).length();
                                            ((StringBuilder)appendable).append('{');
                                            object = ((JsonValue)object).child;
                                            while (object != null) {
                                                ((StringBuilder)appendable).append(outputType.quoteName(((JsonValue)object).name));
                                                ((StringBuilder)appendable).append(':');
                                                this.json((JsonValue)object, (StringBuilder)appendable, outputType);
                                                if (((JsonValue)object).next != null) {
                                                    ((StringBuilder)appendable).append(',');
                                                }
                                                object = ((JsonValue)object).next;
                                            }
                                            ((StringBuilder)appendable).append('}');
                                        }
                                        break block13;
                                    }
                                    if (!((JsonValue)object).isArray()) break block14;
                                    if (((JsonValue)object).child == null) {
                                        ((StringBuilder)appendable).append("[]");
                                    } else {
                                        ((StringBuilder)appendable).length();
                                        ((StringBuilder)appendable).append('[');
                                        object = ((JsonValue)object).child;
                                        while (object != null) {
                                            this.json((JsonValue)object, (StringBuilder)appendable, outputType);
                                            if (((JsonValue)object).next != null) {
                                                ((StringBuilder)appendable).append(',');
                                            }
                                            object = ((JsonValue)object).next;
                                        }
                                        ((StringBuilder)appendable).append(']');
                                    }
                                    break block13;
                                }
                                if (!((JsonValue)object).isString()) break block15;
                                ((StringBuilder)appendable).append(outputType.quoteValue(((JsonValue)object).asString()));
                                break block13;
                            }
                            if (!((JsonValue)object).isDouble()) break block16;
                            double d = ((JsonValue)object).asDouble();
                            double d2 = ((JsonValue)object).asLong();
                            double d3 = d;
                            if (d == d2) {
                                d3 = d2;
                            }
                            ((StringBuilder)appendable).append(d3);
                            break block13;
                        }
                        if (!((JsonValue)object).isLong()) break block17;
                        ((StringBuilder)appendable).append(((JsonValue)object).asLong());
                        break block13;
                    }
                    if (!((JsonValue)object).isBoolean()) break block18;
                    ((StringBuilder)appendable).append(((JsonValue)object).asBoolean());
                    break block13;
                }
                if (!((JsonValue)object).isNull()) break block19;
                ((StringBuilder)appendable).append("null");
            }
            return;
        }
        appendable = new java.lang.StringBuilder();
        ((java.lang.StringBuilder)appendable).append("Unknown object type: ");
        ((java.lang.StringBuilder)appendable).append(object);
        object = new SerializationException(((java.lang.StringBuilder)appendable).toString());
        throw object;
    }

    private void prettyPrint(JsonValue object, StringBuilder appendable, int n, PrettyPrintSettings prettyPrintSettings) {
        block27: {
            block21: {
                block26: {
                    block25: {
                        block24: {
                            block23: {
                                JsonWriter.OutputType outputType;
                                block22: {
                                    block20: {
                                        outputType = prettyPrintSettings.outputType;
                                        if (!((JsonValue)object).isObject()) break block20;
                                        if (((JsonValue)object).child == null) {
                                            ((StringBuilder)appendable).append("{}");
                                        } else {
                                            boolean bl = JsonValue.isFlat((JsonValue)object) ^ true;
                                            int n2 = ((StringBuilder)appendable).length();
                                            block0: while (true) {
                                                Object object2 = bl ? "{\n" : "{ ";
                                                ((StringBuilder)appendable).append((String)object2);
                                                object2 = ((JsonValue)object).child;
                                                while (object2 != null) {
                                                    char c;
                                                    if (bl) {
                                                        JsonValue.indent(n, (StringBuilder)appendable);
                                                    }
                                                    ((StringBuilder)appendable).append(outputType.quoteName(((JsonValue)object2).name));
                                                    ((StringBuilder)appendable).append(": ");
                                                    this.prettyPrint((JsonValue)object2, (StringBuilder)appendable, n + 1, prettyPrintSettings);
                                                    if (!(bl && outputType == JsonWriter.OutputType.minimal || ((JsonValue)object2).next == null)) {
                                                        ((StringBuilder)appendable).append(',');
                                                    }
                                                    char c2 = bl ? (c = '\n') : (c = ' ');
                                                    ((StringBuilder)appendable).append(c2);
                                                    if (!bl && ((StringBuilder)appendable).length() - n2 > prettyPrintSettings.singleLineColumns) {
                                                        ((StringBuilder)appendable).setLength(n2);
                                                        bl = true;
                                                        continue block0;
                                                    }
                                                    object2 = ((JsonValue)object2).next;
                                                }
                                                break;
                                            }
                                            if (bl) {
                                                JsonValue.indent(n - 1, (StringBuilder)appendable);
                                            }
                                            ((StringBuilder)appendable).append('}');
                                        }
                                        break block21;
                                    }
                                    if (!((JsonValue)object).isArray()) break block22;
                                    if (((JsonValue)object).child == null) {
                                        ((StringBuilder)appendable).append("[]");
                                    } else {
                                        boolean bl = JsonValue.isFlat((JsonValue)object) ^ true;
                                        boolean bl2 = prettyPrintSettings.wrapNumericArrays || !JsonValue.isNumeric((JsonValue)object);
                                        int n3 = ((StringBuilder)appendable).length();
                                        block2: while (true) {
                                            Object object3 = bl ? "[\n" : "[ ";
                                            ((StringBuilder)appendable).append((String)object3);
                                            object3 = ((JsonValue)object).child;
                                            while (object3 != null) {
                                                char c;
                                                if (bl) {
                                                    JsonValue.indent(n, (StringBuilder)appendable);
                                                }
                                                this.prettyPrint((JsonValue)object3, (StringBuilder)appendable, n + 1, prettyPrintSettings);
                                                if (!(bl && outputType == JsonWriter.OutputType.minimal || ((JsonValue)object3).next == null)) {
                                                    ((StringBuilder)appendable).append(',');
                                                }
                                                char c3 = bl ? (c = '\n') : (c = ' ');
                                                ((StringBuilder)appendable).append(c3);
                                                if (bl2 && !bl && ((StringBuilder)appendable).length() - n3 > prettyPrintSettings.singleLineColumns) {
                                                    ((StringBuilder)appendable).setLength(n3);
                                                    bl = true;
                                                    continue block2;
                                                }
                                                object3 = ((JsonValue)object3).next;
                                            }
                                            break;
                                        }
                                        if (bl) {
                                            JsonValue.indent(n - 1, (StringBuilder)appendable);
                                        }
                                        ((StringBuilder)appendable).append(']');
                                    }
                                    break block21;
                                }
                                if (!((JsonValue)object).isString()) break block23;
                                ((StringBuilder)appendable).append(outputType.quoteValue(((JsonValue)object).asString()));
                                break block21;
                            }
                            if (!((JsonValue)object).isDouble()) break block24;
                            double d = ((JsonValue)object).asDouble();
                            double d2 = ((JsonValue)object).asLong();
                            double d3 = d;
                            if (d == d2) {
                                d3 = d2;
                            }
                            ((StringBuilder)appendable).append(d3);
                            break block21;
                        }
                        if (!((JsonValue)object).isLong()) break block25;
                        ((StringBuilder)appendable).append(((JsonValue)object).asLong());
                        break block21;
                    }
                    if (!((JsonValue)object).isBoolean()) break block26;
                    ((StringBuilder)appendable).append(((JsonValue)object).asBoolean());
                    break block21;
                }
                if (!((JsonValue)object).isNull()) break block27;
                ((StringBuilder)appendable).append("null");
            }
            return;
        }
        appendable = new java.lang.StringBuilder();
        ((java.lang.StringBuilder)appendable).append("Unknown object type: ");
        ((java.lang.StringBuilder)appendable).append(object);
        object = new SerializationException(((java.lang.StringBuilder)appendable).toString());
        throw object;
    }

    private void prettyPrint(JsonValue object, Writer appendable, int n, PrettyPrintSettings prettyPrintSettings) throws IOException {
        block23: {
            block17: {
                block22: {
                    block21: {
                        block20: {
                            block19: {
                                JsonWriter.OutputType outputType;
                                block18: {
                                    block16: {
                                        outputType = prettyPrintSettings.outputType;
                                        if (!((JsonValue)object).isObject()) break block16;
                                        if (((JsonValue)object).child == null) {
                                            ((Writer)appendable).append("{}");
                                        } else {
                                            boolean bl = !JsonValue.isFlat((JsonValue)object) || ((JsonValue)object).size > 6;
                                            String string2 = bl ? "{\n" : "{ ";
                                            ((Writer)appendable).append(string2);
                                            object = ((JsonValue)object).child;
                                            while (object != null) {
                                                char c;
                                                if (bl) {
                                                    JsonValue.indent(n, (Writer)appendable);
                                                }
                                                ((Writer)appendable).append(outputType.quoteName(((JsonValue)object).name));
                                                ((Writer)appendable).append(": ");
                                                this.prettyPrint((JsonValue)object, (Writer)appendable, n + 1, prettyPrintSettings);
                                                if (!(bl && outputType == JsonWriter.OutputType.minimal || ((JsonValue)object).next == null)) {
                                                    ((Writer)appendable).append(',');
                                                }
                                                char c2 = bl ? (c = '\n') : (c = ' ');
                                                ((Writer)appendable).append(c2);
                                                object = ((JsonValue)object).next;
                                            }
                                            if (bl) {
                                                JsonValue.indent(n - 1, (Writer)appendable);
                                            }
                                            ((Writer)appendable).append('}');
                                        }
                                        break block17;
                                    }
                                    if (!((JsonValue)object).isArray()) break block18;
                                    if (((JsonValue)object).child == null) {
                                        ((Writer)appendable).append("[]");
                                    } else {
                                        boolean bl = JsonValue.isFlat((JsonValue)object) ^ true;
                                        String string3 = bl ? "[\n" : "[ ";
                                        ((Writer)appendable).append(string3);
                                        object = ((JsonValue)object).child;
                                        while (object != null) {
                                            char c;
                                            if (bl) {
                                                JsonValue.indent(n, (Writer)appendable);
                                            }
                                            this.prettyPrint((JsonValue)object, (Writer)appendable, n + 1, prettyPrintSettings);
                                            if (!(bl && outputType == JsonWriter.OutputType.minimal || ((JsonValue)object).next == null)) {
                                                ((Writer)appendable).append(',');
                                            }
                                            char c3 = bl ? (c = '\n') : (c = ' ');
                                            ((Writer)appendable).append(c3);
                                            object = ((JsonValue)object).next;
                                        }
                                        if (bl) {
                                            JsonValue.indent(n - 1, (Writer)appendable);
                                        }
                                        ((Writer)appendable).append(']');
                                    }
                                    break block17;
                                }
                                if (!((JsonValue)object).isString()) break block19;
                                ((Writer)appendable).append(outputType.quoteValue(((JsonValue)object).asString()));
                                break block17;
                            }
                            if (!((JsonValue)object).isDouble()) break block20;
                            double d = ((JsonValue)object).asDouble();
                            double d2 = ((JsonValue)object).asLong();
                            double d3 = d;
                            if (d == d2) {
                                d3 = d2;
                            }
                            ((Writer)appendable).append(Double.toString(d3));
                            break block17;
                        }
                        if (!((JsonValue)object).isLong()) break block21;
                        ((Writer)appendable).append(Long.toString(((JsonValue)object).asLong()));
                        break block17;
                    }
                    if (!((JsonValue)object).isBoolean()) break block22;
                    ((Writer)appendable).append(Boolean.toString(((JsonValue)object).asBoolean()));
                    break block17;
                }
                if (!((JsonValue)object).isNull()) break block23;
                ((Writer)appendable).append("null");
            }
            return;
        }
        appendable = new java.lang.StringBuilder();
        ((java.lang.StringBuilder)appendable).append("Unknown object type: ");
        ((java.lang.StringBuilder)appendable).append(object);
        object = new SerializationException(((java.lang.StringBuilder)appendable).toString());
        throw object;
    }

    public void addChild(JsonValue jsonValue) {
        JsonValue jsonValue2;
        jsonValue.parent = this;
        JsonValue jsonValue3 = jsonValue2 = this.child;
        if (jsonValue2 == null) {
            this.child = jsonValue;
            return;
        }
        while (true) {
            if ((jsonValue2 = jsonValue3.next) == null) {
                jsonValue3.next = jsonValue;
                return;
            }
            jsonValue3 = jsonValue2;
        }
    }

    public void addChild(String string2, JsonValue jsonValue) {
        if (string2 != null) {
            jsonValue.name = string2;
            this.addChild(jsonValue);
            return;
        }
        throw new IllegalArgumentException("name cannot be null.");
    }

    public boolean asBoolean() {
        int n = 1.$SwitchMap$com$badlogic$gdx$utils$JsonValue$ValueType[this.type.ordinal()];
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    if (n == 4) {
                        if (this.longValue == 0L) {
                            bl3 = false;
                        }
                        return bl3;
                    }
                    java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
                    stringBuilder.append("Value cannot be converted to boolean: ");
                    stringBuilder.append((Object)this.type);
                    throw new IllegalStateException(stringBuilder.toString());
                }
                bl3 = this.longValue != 0L ? bl : false;
                return bl3;
            }
            bl3 = this.doubleValue != 0.0 ? bl2 : false;
            return bl3;
        }
        return this.stringValue.equalsIgnoreCase("true");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public boolean[] asBooleanArray() {
        block7: {
            if (this.type != ValueType.array) break block7;
            var1_1 = new boolean[this.size];
            var2_2 = this.child;
            var3_4 = 0;
            while (var2_2 != null) {
                block6: {
                    block8: {
                        block9: {
                            var4_5 = 1.$SwitchMap$com$badlogic$gdx$utils$JsonValue$ValueType[var2_2.type.ordinal()];
                            if (var4_5 == 1) break block8;
                            if (var4_5 == 2) break block9;
                            if (var4_5 != 3) {
                                if (var4_5 == 4) {
                                    if (var2_2.longValue != 0L) lbl-1000:
                                    // 3 sources

                                    {
                                        while (true) {
                                            var5_6 = true;
                                            break block6;
                                            break;
                                        }
                                    }
lbl15:
                                    // 4 sources

                                    while (true) {
                                        var5_6 = false;
                                        break block6;
                                        break;
                                    }
                                }
                                var1_1 = new java.lang.StringBuilder();
                                var1_1.append("Value cannot be converted to boolean: ");
                                var1_1.append((Object)var2_2.type);
                                throw new IllegalStateException(var1_1.toString());
                            }
                            if (var2_2.longValue != 0L) ** GOTO lbl15
                            ** GOTO lbl-1000
                        }
                        if (var2_2.doubleValue == 0.0) ** break;
                        ** continue;
                        ** continue;
                    }
                    var5_6 = Boolean.parseBoolean(var2_2.stringValue);
                }
                var1_1[var3_4] = var5_6;
                var2_2 = var2_2.next;
                ++var3_4;
            }
            return var1_1;
        }
        var2_3 /* !! */  = new java.lang.StringBuilder();
        var2_3 /* !! */ .append("Value is not an array: ");
        var2_3 /* !! */ .append((Object)this.type);
        var2_3 /* !! */  = new IllegalStateException(var2_3 /* !! */ .toString());
        throw var2_3 /* !! */ ;
    }

    public byte asByte() {
        int n = 1.$SwitchMap$com$badlogic$gdx$utils$JsonValue$ValueType[this.type.ordinal()];
        byte by = 1;
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    if (n == 4) {
                        byte by2 = this.longValue != 0L ? by : (by = 0);
                        return by2;
                    }
                    java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
                    stringBuilder.append("Value cannot be converted to byte: ");
                    stringBuilder.append((Object)this.type);
                    throw new IllegalStateException(stringBuilder.toString());
                }
                return (byte)this.longValue;
            }
            return (byte)this.doubleValue;
        }
        return Byte.parseByte(this.stringValue);
    }

    public byte[] asByteArray() {
        block1: {
            if (this.type != ValueType.array) break block1;
            Object object = new byte[this.size];
            JsonValue jsonValue = this.child;
            int n = 0;
            while (jsonValue != null) {
                int n2;
                block6: {
                    block2: {
                        block7: {
                            block3: {
                                block4: {
                                    block5: {
                                        n2 = 1.$SwitchMap$com$badlogic$gdx$utils$JsonValue$ValueType[jsonValue.type.ordinal()];
                                        if (n2 == 1) break block2;
                                        if (n2 == 2) break block3;
                                        if (n2 == 3) break block4;
                                        if (n2 != 4) break block5;
                                        n2 = jsonValue.longValue != 0L ? 1 : 0;
                                        break block6;
                                    }
                                    object = new java.lang.StringBuilder();
                                    ((java.lang.StringBuilder)object).append("Value cannot be converted to byte: ");
                                    ((java.lang.StringBuilder)object).append((Object)jsonValue.type);
                                    throw new IllegalStateException(((java.lang.StringBuilder)object).toString());
                                }
                                n2 = (int)jsonValue.longValue;
                                break block7;
                            }
                            n2 = (int)jsonValue.doubleValue;
                        }
                        n2 = (byte)n2;
                        break block6;
                    }
                    n2 = Byte.parseByte(jsonValue.stringValue);
                }
                object[n] = (byte)n2;
                jsonValue = jsonValue.next;
                ++n;
            }
            return object;
        }
        Serializable serializable = new java.lang.StringBuilder();
        serializable.append("Value is not an array: ");
        serializable.append((Object)this.type);
        serializable = new IllegalStateException(serializable.toString());
        throw serializable;
    }

    public char asChar() {
        int n = 1.$SwitchMap$com$badlogic$gdx$utils$JsonValue$ValueType[this.type.ordinal()];
        char c = '\u0001';
        char c2 = '\u0000';
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    if (n == 4) {
                        char c3 = this.longValue != 0L ? c : (c2 = '\u0000');
                        return c3;
                    }
                    java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
                    stringBuilder.append("Value cannot be converted to char: ");
                    stringBuilder.append((Object)this.type);
                    throw new IllegalStateException(stringBuilder.toString());
                }
                return (char)this.longValue;
            }
            return (char)this.doubleValue;
        }
        char c4 = this.stringValue.length() == 0 ? c2 : (c2 = this.stringValue.charAt(0));
        return c4;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public char[] asCharArray() {
        block3: {
            if (this.type != ValueType.array) break block3;
            var1_1 = new char[this.size];
            var2_2 = this.child;
            var3_4 = 0;
            while (var2_2 != null) {
                block2: {
                    block4: {
                        block9: {
                            block5: {
                                block6: {
                                    block7: {
                                        block8: {
                                            var4_5 = 1.$SwitchMap$com$badlogic$gdx$utils$JsonValue$ValueType[var2_2.type.ordinal()];
                                            if (var4_5 == 1) break block4;
                                            if (var4_5 == 2) break block5;
                                            if (var4_5 == 3) break block6;
                                            if (var4_5 != 4) break block7;
                                            if (var2_2.longValue == 0L) break block8;
                                            var4_5 = 1;
                                            break block2;
                                        }
                                        while (true) {
                                            var4_5 = 0;
                                            break block2;
                                            break;
                                        }
                                    }
                                    var1_1 = new java.lang.StringBuilder();
                                    var1_1.append("Value cannot be converted to char: ");
                                    var1_1.append((Object)var2_2.type);
                                    throw new IllegalStateException(var1_1.toString());
                                }
                                var4_5 = (int)var2_2.longValue;
                                break block9;
                            }
                            var4_5 = (int)var2_2.doubleValue;
                        }
                        var4_5 = (char)var4_5;
                        break block2;
                    }
                    if (var2_2.stringValue.length() == 0) ** continue;
                    var4_5 = var2_2.stringValue.charAt(0);
                }
                var1_1[var3_4] = (char)var4_5;
                var2_2 = var2_2.next;
                ++var3_4;
            }
            return var1_1;
        }
        var2_3 /* !! */  = new java.lang.StringBuilder();
        var2_3 /* !! */ .append("Value is not an array: ");
        var2_3 /* !! */ .append((Object)this.type);
        var2_3 /* !! */  = new IllegalStateException(var2_3 /* !! */ .toString());
        throw var2_3 /* !! */ ;
    }

    public double asDouble() {
        int n = 1.$SwitchMap$com$badlogic$gdx$utils$JsonValue$ValueType[this.type.ordinal()];
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    if (n == 4) {
                        double d = this.longValue != 0L ? 1.0 : 0.0;
                        return d;
                    }
                    java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
                    stringBuilder.append("Value cannot be converted to double: ");
                    stringBuilder.append((Object)this.type);
                    throw new IllegalStateException(stringBuilder.toString());
                }
                return this.longValue;
            }
            return this.doubleValue;
        }
        return Double.parseDouble(this.stringValue);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public double[] asDoubleArray() {
        void var3_4;
        if (this.type != ValueType.array) {
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append("Value is not an array: ");
            stringBuilder.append((Object)this.type);
            IllegalStateException illegalStateException = new IllegalStateException(stringBuilder.toString());
            throw illegalStateException;
        }
        Object object = new double[this.size];
        int n = 0;
        JsonValue jsonValue = this.child;
        while (var3_4 != null) {
            double d;
            block7: {
                block8: {
                    int n2 = 1.$SwitchMap$com$badlogic$gdx$utils$JsonValue$ValueType[var3_4.type.ordinal()];
                    if (n2 == 1) break block8;
                    if (n2 != 2) {
                        if (n2 != 3) {
                            if (n2 != 4) {
                                object = new java.lang.StringBuilder();
                                ((java.lang.StringBuilder)object).append("Value cannot be converted to double: ");
                                ((java.lang.StringBuilder)object).append((Object)var3_4.type);
                                throw new IllegalStateException(((java.lang.StringBuilder)object).toString());
                            }
                            d = var3_4.longValue != 0L ? 1.0 : 0.0;
                            break block7;
                        } else {
                            d = var3_4.longValue;
                        }
                        break block7;
                    } else {
                        d = var3_4.doubleValue;
                    }
                    break block7;
                }
                d = Double.parseDouble(var3_4.stringValue);
            }
            object[n] = d;
            JsonValue jsonValue2 = var3_4.next;
            ++n;
        }
        return object;
    }

    public float asFloat() {
        int n = 1.$SwitchMap$com$badlogic$gdx$utils$JsonValue$ValueType[this.type.ordinal()];
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    if (n == 4) {
                        float f = this.longValue != 0L ? 1.0f : 0.0f;
                        return f;
                    }
                    java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
                    stringBuilder.append("Value cannot be converted to float: ");
                    stringBuilder.append((Object)this.type);
                    throw new IllegalStateException(stringBuilder.toString());
                }
                return this.longValue;
            }
            return (float)this.doubleValue;
        }
        return Float.parseFloat(this.stringValue);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public float[] asFloatArray() {
        void var3_4;
        if (this.type != ValueType.array) {
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append("Value is not an array: ");
            stringBuilder.append((Object)this.type);
            IllegalStateException illegalStateException = new IllegalStateException(stringBuilder.toString());
            throw illegalStateException;
        }
        Object object = new float[this.size];
        int n = 0;
        JsonValue jsonValue = this.child;
        while (var3_4 != null) {
            float f;
            block7: {
                block8: {
                    int n2 = 1.$SwitchMap$com$badlogic$gdx$utils$JsonValue$ValueType[var3_4.type.ordinal()];
                    if (n2 == 1) break block8;
                    if (n2 != 2) {
                        if (n2 != 3) {
                            if (n2 != 4) {
                                object = new java.lang.StringBuilder();
                                ((java.lang.StringBuilder)object).append("Value cannot be converted to float: ");
                                ((java.lang.StringBuilder)object).append((Object)var3_4.type);
                                throw new IllegalStateException(((java.lang.StringBuilder)object).toString());
                            }
                            f = var3_4.longValue != 0L ? 1.0f : 0.0f;
                            break block7;
                        } else {
                            f = var3_4.longValue;
                        }
                        break block7;
                    } else {
                        f = (float)var3_4.doubleValue;
                    }
                    break block7;
                }
                f = Float.parseFloat(var3_4.stringValue);
            }
            object[n] = f;
            JsonValue jsonValue2 = var3_4.next;
            ++n;
        }
        return object;
    }

    public int asInt() {
        int n = 1.$SwitchMap$com$badlogic$gdx$utils$JsonValue$ValueType[this.type.ordinal()];
        int n2 = 1;
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    if (n == 4) {
                        if (this.longValue == 0L) {
                            n2 = 0;
                        }
                        return n2;
                    }
                    java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
                    stringBuilder.append("Value cannot be converted to int: ");
                    stringBuilder.append((Object)this.type);
                    throw new IllegalStateException(stringBuilder.toString());
                }
                return (int)this.longValue;
            }
            return (int)this.doubleValue;
        }
        return Integer.parseInt(this.stringValue);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public int[] asIntArray() {
        void var2_3;
        if (this.type != ValueType.array) {
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append("Value is not an array: ");
            stringBuilder.append((Object)this.type);
            IllegalStateException illegalStateException = new IllegalStateException(stringBuilder.toString());
            throw illegalStateException;
        }
        Object object = new int[this.size];
        JsonValue jsonValue = this.child;
        int n = 0;
        while (var2_3 != null) {
            int n2;
            block7: {
                block8: {
                    n2 = 1.$SwitchMap$com$badlogic$gdx$utils$JsonValue$ValueType[var2_3.type.ordinal()];
                    if (n2 == 1) break block8;
                    if (n2 != 2) {
                        if (n2 != 3) {
                            if (n2 != 4) {
                                object = new java.lang.StringBuilder();
                                ((java.lang.StringBuilder)object).append("Value cannot be converted to int: ");
                                ((java.lang.StringBuilder)object).append((Object)var2_3.type);
                                throw new IllegalStateException(((java.lang.StringBuilder)object).toString());
                            }
                            n2 = var2_3.longValue != 0L ? 1 : 0;
                            break block7;
                        } else {
                            n2 = (int)var2_3.longValue;
                        }
                        break block7;
                    } else {
                        n2 = (int)var2_3.doubleValue;
                    }
                    break block7;
                }
                n2 = Integer.parseInt(var2_3.stringValue);
            }
            object[n] = n2;
            JsonValue jsonValue2 = var2_3.next;
            ++n;
        }
        return object;
    }

    public long asLong() {
        int n = 1.$SwitchMap$com$badlogic$gdx$utils$JsonValue$ValueType[this.type.ordinal()];
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    if (n == 4) {
                        long l = this.longValue;
                        long l2 = 0L;
                        if (l != 0L) {
                            l2 = 1L;
                        }
                        return l2;
                    }
                    java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
                    stringBuilder.append("Value cannot be converted to long: ");
                    stringBuilder.append((Object)this.type);
                    throw new IllegalStateException(stringBuilder.toString());
                }
                return this.longValue;
            }
            return (long)this.doubleValue;
        }
        return Long.parseLong(this.stringValue);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public long[] asLongArray() {
        void var3_4;
        if (this.type != ValueType.array) {
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append("Value is not an array: ");
            stringBuilder.append((Object)this.type);
            IllegalStateException illegalStateException = new IllegalStateException(stringBuilder.toString());
            throw illegalStateException;
        }
        Object object = new long[this.size];
        int n = 0;
        JsonValue jsonValue = this.child;
        while (var3_4 != null) {
            long l;
            block8: {
                block6: {
                    block7: {
                        int n2 = 1.$SwitchMap$com$badlogic$gdx$utils$JsonValue$ValueType[var3_4.type.ordinal()];
                        if (n2 == 1) break block6;
                        if (n2 == 2) break block7;
                        if (n2 != 3) {
                            if (n2 != 4) {
                                object = new java.lang.StringBuilder();
                                ((java.lang.StringBuilder)object).append("Value cannot be converted to long: ");
                                ((java.lang.StringBuilder)object).append((Object)var3_4.type);
                                throw new IllegalStateException(((java.lang.StringBuilder)object).toString());
                            }
                            long l2 = var3_4.longValue;
                            l = 0L;
                            if (l2 != 0L) {
                                l = 1L;
                            }
                            break block8;
                        } else {
                            l = var3_4.longValue;
                        }
                        break block8;
                    }
                    l = (long)var3_4.doubleValue;
                    break block8;
                }
                l = Long.parseLong(var3_4.stringValue);
            }
            object[n] = l;
            JsonValue jsonValue2 = var3_4.next;
            ++n;
        }
        return object;
    }

    public short asShort() {
        short s = 1.$SwitchMap$com$badlogic$gdx$utils$JsonValue$ValueType[this.type.ordinal()];
        short s2 = 1;
        if (s != 1) {
            if (s != 2) {
                if (s != 3) {
                    if (s == 4) {
                        short s3 = this.longValue != 0L ? s2 : (s = 0);
                        return s3;
                    }
                    java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
                    stringBuilder.append("Value cannot be converted to short: ");
                    stringBuilder.append((Object)this.type);
                    throw new IllegalStateException(stringBuilder.toString());
                }
                return (short)this.longValue;
            }
            return (short)this.doubleValue;
        }
        return Short.parseShort(this.stringValue);
    }

    public short[] asShortArray() {
        block1: {
            if (this.type != ValueType.array) break block1;
            Object object = new short[this.size];
            JsonValue jsonValue = this.child;
            int n = 0;
            while (jsonValue != null) {
                int n2;
                block6: {
                    block2: {
                        block7: {
                            block3: {
                                block4: {
                                    block5: {
                                        n2 = 1.$SwitchMap$com$badlogic$gdx$utils$JsonValue$ValueType[jsonValue.type.ordinal()];
                                        if (n2 == 1) break block2;
                                        if (n2 == 2) break block3;
                                        if (n2 == 3) break block4;
                                        if (n2 != 4) break block5;
                                        n2 = jsonValue.longValue != 0L ? 1 : 0;
                                        break block6;
                                    }
                                    object = new java.lang.StringBuilder();
                                    ((java.lang.StringBuilder)object).append("Value cannot be converted to short: ");
                                    ((java.lang.StringBuilder)object).append((Object)jsonValue.type);
                                    throw new IllegalStateException(((java.lang.StringBuilder)object).toString());
                                }
                                n2 = (int)jsonValue.longValue;
                                break block7;
                            }
                            n2 = (int)jsonValue.doubleValue;
                        }
                        n2 = (short)n2;
                        break block6;
                    }
                    n2 = Short.parseShort(jsonValue.stringValue);
                }
                object[n] = (short)n2;
                jsonValue = jsonValue.next;
                ++n;
            }
            return object;
        }
        Serializable serializable = new java.lang.StringBuilder();
        serializable.append("Value is not an array: ");
        serializable.append((Object)this.type);
        serializable = new IllegalStateException(serializable.toString());
        throw serializable;
    }

    public String asString() {
        int n = 1.$SwitchMap$com$badlogic$gdx$utils$JsonValue$ValueType[this.type.ordinal()];
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    if (n != 4) {
                        if (n == 5) {
                            return null;
                        }
                        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
                        stringBuilder.append("Value cannot be converted to string: ");
                        stringBuilder.append((Object)this.type);
                        throw new IllegalStateException(stringBuilder.toString());
                    }
                    String string2 = this.longValue != 0L ? "true" : "false";
                    return string2;
                }
                String string3 = this.stringValue;
                if (string3 == null) {
                    string3 = Long.toString(this.longValue);
                }
                return string3;
            }
            String string4 = this.stringValue;
            if (string4 == null) {
                string4 = Double.toString(this.doubleValue);
            }
            return string4;
        }
        return this.stringValue;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public String[] asStringArray() {
        if (this.type != ValueType.array) {
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append("Value is not an array: ");
            stringBuilder.append((Object)this.type);
            IllegalStateException illegalStateException = new IllegalStateException(stringBuilder.toString());
            throw illegalStateException;
        }
        String[] stringArray = new String[this.size];
        int n = 0;
        JsonValue jsonValue = this.child;
        while (jsonValue != null) {
            void var5_5;
            block9: {
                block10: {
                    block11: {
                        block12: {
                            int n2 = 1.$SwitchMap$com$badlogic$gdx$utils$JsonValue$ValueType[jsonValue.type.ordinal()];
                            if (n2 == 1) break block10;
                            if (n2 == 2) break block11;
                            if (n2 == 3) break block12;
                            if (n2 != 4) {
                                if (n2 != 5) {
                                    java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
                                    stringBuilder.append("Value cannot be converted to string: ");
                                    stringBuilder.append((Object)jsonValue.type);
                                    throw new IllegalStateException(stringBuilder.toString());
                                }
                                Object var5_6 = null;
                                break block9;
                            } else if (jsonValue.longValue != 0L) {
                                String string2 = "true";
                                break block9;
                            } else {
                                String string3 = "false";
                            }
                            break block9;
                        }
                        String string4 = this.stringValue;
                        if (string4 == null) {
                            String string5 = Long.toString(jsonValue.longValue);
                        }
                        break block9;
                    }
                    String string6 = this.stringValue;
                    if (string6 == null) {
                        String string7 = Double.toString(jsonValue.doubleValue);
                    }
                    break block9;
                }
                String string8 = jsonValue.stringValue;
            }
            stringArray[n] = var5_5;
            jsonValue = jsonValue.next;
            ++n;
        }
        return stringArray;
    }

    public JsonValue child() {
        return this.child;
    }

    public JsonValue get(int n) {
        JsonValue jsonValue = this.child;
        while (jsonValue != null && n > 0) {
            --n;
            jsonValue = jsonValue.next;
        }
        return jsonValue;
    }

    public JsonValue get(String string2) {
        String string3;
        JsonValue jsonValue = this.child;
        while (!(jsonValue == null || (string3 = jsonValue.name) != null && string3.equalsIgnoreCase(string2))) {
            jsonValue = jsonValue.next;
        }
        return jsonValue;
    }

    public boolean getBoolean(int n) {
        Object object = this.get(n);
        if (object != null) {
            return ((JsonValue)object).asBoolean();
        }
        object = new java.lang.StringBuilder();
        ((java.lang.StringBuilder)object).append("Indexed value not found: ");
        ((java.lang.StringBuilder)object).append(this.name);
        throw new IllegalArgumentException(((java.lang.StringBuilder)object).toString());
    }

    public boolean getBoolean(String string2) {
        Object object = this.get(string2);
        if (object != null) {
            return ((JsonValue)object).asBoolean();
        }
        object = new java.lang.StringBuilder();
        ((java.lang.StringBuilder)object).append("Named value not found: ");
        ((java.lang.StringBuilder)object).append(string2);
        throw new IllegalArgumentException(((java.lang.StringBuilder)object).toString());
    }

    public boolean getBoolean(String object, boolean bl) {
        object = this.get((String)object);
        boolean bl2 = bl;
        if (object != null) {
            bl2 = bl;
            if (((JsonValue)object).isValue()) {
                bl2 = ((JsonValue)object).isNull() ? bl : ((JsonValue)object).asBoolean();
            }
        }
        return bl2;
    }

    public byte getByte(int n) {
        Object object = this.get(n);
        if (object != null) {
            return ((JsonValue)object).asByte();
        }
        object = new java.lang.StringBuilder();
        ((java.lang.StringBuilder)object).append("Indexed value not found: ");
        ((java.lang.StringBuilder)object).append(this.name);
        throw new IllegalArgumentException(((java.lang.StringBuilder)object).toString());
    }

    public byte getByte(String string2) {
        Object object = this.get(string2);
        if (object != null) {
            return ((JsonValue)object).asByte();
        }
        object = new java.lang.StringBuilder();
        ((java.lang.StringBuilder)object).append("Named value not found: ");
        ((java.lang.StringBuilder)object).append(string2);
        throw new IllegalArgumentException(((java.lang.StringBuilder)object).toString());
    }

    public byte getByte(String object, byte by) {
        object = this.get((String)object);
        byte by2 = by;
        if (object != null) {
            by2 = by;
            if (((JsonValue)object).isValue()) {
                by2 = ((JsonValue)object).isNull() ? by : (by = ((JsonValue)object).asByte());
            }
        }
        return by2;
    }

    public char getChar(int n) {
        Object object = this.get(n);
        if (object != null) {
            return ((JsonValue)object).asChar();
        }
        object = new java.lang.StringBuilder();
        ((java.lang.StringBuilder)object).append("Indexed value not found: ");
        ((java.lang.StringBuilder)object).append(this.name);
        throw new IllegalArgumentException(((java.lang.StringBuilder)object).toString());
    }

    public char getChar(String string2) {
        Object object = this.get(string2);
        if (object != null) {
            return ((JsonValue)object).asChar();
        }
        object = new java.lang.StringBuilder();
        ((java.lang.StringBuilder)object).append("Named value not found: ");
        ((java.lang.StringBuilder)object).append(string2);
        throw new IllegalArgumentException(((java.lang.StringBuilder)object).toString());
    }

    public char getChar(String object, char c) {
        object = this.get((String)object);
        char c2 = c;
        if (object != null) {
            c2 = c;
            if (((JsonValue)object).isValue()) {
                c2 = ((JsonValue)object).isNull() ? c : (c = ((JsonValue)object).asChar());
            }
        }
        return c2;
    }

    public JsonValue getChild(String object) {
        object = (object = this.get((String)object)) == null ? null : ((JsonValue)object).child;
        return object;
    }

    public double getDouble(int n) {
        Object object = this.get(n);
        if (object != null) {
            return ((JsonValue)object).asDouble();
        }
        object = new java.lang.StringBuilder();
        ((java.lang.StringBuilder)object).append("Indexed value not found: ");
        ((java.lang.StringBuilder)object).append(this.name);
        throw new IllegalArgumentException(((java.lang.StringBuilder)object).toString());
    }

    public double getDouble(String string2) {
        Object object = this.get(string2);
        if (object != null) {
            return ((JsonValue)object).asDouble();
        }
        object = new java.lang.StringBuilder();
        ((java.lang.StringBuilder)object).append("Named value not found: ");
        ((java.lang.StringBuilder)object).append(string2);
        throw new IllegalArgumentException(((java.lang.StringBuilder)object).toString());
    }

    public double getDouble(String object, double d) {
        object = this.get((String)object);
        double d2 = d;
        if (object != null) {
            d2 = d;
            if (((JsonValue)object).isValue()) {
                d2 = ((JsonValue)object).isNull() ? d : ((JsonValue)object).asDouble();
            }
        }
        return d2;
    }

    public float getFloat(int n) {
        Object object = this.get(n);
        if (object != null) {
            return ((JsonValue)object).asFloat();
        }
        object = new java.lang.StringBuilder();
        ((java.lang.StringBuilder)object).append("Indexed value not found: ");
        ((java.lang.StringBuilder)object).append(this.name);
        throw new IllegalArgumentException(((java.lang.StringBuilder)object).toString());
    }

    public float getFloat(String string2) {
        Object object = this.get(string2);
        if (object != null) {
            return ((JsonValue)object).asFloat();
        }
        object = new java.lang.StringBuilder();
        ((java.lang.StringBuilder)object).append("Named value not found: ");
        ((java.lang.StringBuilder)object).append(string2);
        throw new IllegalArgumentException(((java.lang.StringBuilder)object).toString());
    }

    public float getFloat(String object, float f) {
        object = this.get((String)object);
        float f2 = f;
        if (object != null) {
            f2 = f;
            if (((JsonValue)object).isValue()) {
                f2 = ((JsonValue)object).isNull() ? f : ((JsonValue)object).asFloat();
            }
        }
        return f2;
    }

    public int getInt(int n) {
        Object object = this.get(n);
        if (object != null) {
            return ((JsonValue)object).asInt();
        }
        object = new java.lang.StringBuilder();
        ((java.lang.StringBuilder)object).append("Indexed value not found: ");
        ((java.lang.StringBuilder)object).append(this.name);
        throw new IllegalArgumentException(((java.lang.StringBuilder)object).toString());
    }

    public int getInt(String string2) {
        Object object = this.get(string2);
        if (object != null) {
            return ((JsonValue)object).asInt();
        }
        object = new java.lang.StringBuilder();
        ((java.lang.StringBuilder)object).append("Named value not found: ");
        ((java.lang.StringBuilder)object).append(string2);
        throw new IllegalArgumentException(((java.lang.StringBuilder)object).toString());
    }

    public int getInt(String object, int n) {
        object = this.get((String)object);
        int n2 = n;
        if (object != null) {
            n2 = n;
            if (((JsonValue)object).isValue()) {
                n2 = ((JsonValue)object).isNull() ? n : ((JsonValue)object).asInt();
            }
        }
        return n2;
    }

    public long getLong(int n) {
        Object object = this.get(n);
        if (object != null) {
            return ((JsonValue)object).asLong();
        }
        object = new java.lang.StringBuilder();
        ((java.lang.StringBuilder)object).append("Indexed value not found: ");
        ((java.lang.StringBuilder)object).append(this.name);
        throw new IllegalArgumentException(((java.lang.StringBuilder)object).toString());
    }

    public long getLong(String string2) {
        Object object = this.get(string2);
        if (object != null) {
            return ((JsonValue)object).asLong();
        }
        object = new java.lang.StringBuilder();
        ((java.lang.StringBuilder)object).append("Named value not found: ");
        ((java.lang.StringBuilder)object).append(string2);
        throw new IllegalArgumentException(((java.lang.StringBuilder)object).toString());
    }

    public long getLong(String object, long l) {
        object = this.get((String)object);
        long l2 = l;
        if (object != null) {
            l2 = l;
            if (((JsonValue)object).isValue()) {
                l2 = ((JsonValue)object).isNull() ? l : ((JsonValue)object).asLong();
            }
        }
        return l2;
    }

    public short getShort(int n) {
        Object object = this.get(n);
        if (object != null) {
            return ((JsonValue)object).asShort();
        }
        object = new java.lang.StringBuilder();
        ((java.lang.StringBuilder)object).append("Indexed value not found: ");
        ((java.lang.StringBuilder)object).append(this.name);
        throw new IllegalArgumentException(((java.lang.StringBuilder)object).toString());
    }

    public short getShort(String string2) {
        Object object = this.get(string2);
        if (object != null) {
            return ((JsonValue)object).asShort();
        }
        object = new java.lang.StringBuilder();
        ((java.lang.StringBuilder)object).append("Named value not found: ");
        ((java.lang.StringBuilder)object).append(string2);
        throw new IllegalArgumentException(((java.lang.StringBuilder)object).toString());
    }

    public short getShort(String object, short s) {
        object = this.get((String)object);
        short s2 = s;
        if (object != null) {
            s2 = s;
            if (((JsonValue)object).isValue()) {
                s2 = ((JsonValue)object).isNull() ? s : (s = ((JsonValue)object).asShort());
            }
        }
        return s2;
    }

    public String getString(int n) {
        Object object = this.get(n);
        if (object != null) {
            return ((JsonValue)object).asString();
        }
        object = new java.lang.StringBuilder();
        ((java.lang.StringBuilder)object).append("Indexed value not found: ");
        ((java.lang.StringBuilder)object).append(this.name);
        throw new IllegalArgumentException(((java.lang.StringBuilder)object).toString());
    }

    public String getString(String string2) {
        Object object = this.get(string2);
        if (object != null) {
            return ((JsonValue)object).asString();
        }
        object = new java.lang.StringBuilder();
        ((java.lang.StringBuilder)object).append("Named value not found: ");
        ((java.lang.StringBuilder)object).append(string2);
        throw new IllegalArgumentException(((java.lang.StringBuilder)object).toString());
    }

    public String getString(String string2, String string3) {
        JsonValue jsonValue = this.get(string2);
        string2 = string3;
        if (jsonValue != null) {
            string2 = string3;
            if (jsonValue.isValue()) {
                string2 = jsonValue.isNull() ? string3 : jsonValue.asString();
            }
        }
        return string2;
    }

    public boolean has(String string2) {
        boolean bl = this.get(string2) != null;
        return bl;
    }

    public boolean hasChild(String string2) {
        boolean bl = this.getChild(string2) != null;
        return bl;
    }

    public boolean isArray() {
        boolean bl = this.type == ValueType.array;
        return bl;
    }

    public boolean isBoolean() {
        boolean bl = this.type == ValueType.booleanValue;
        return bl;
    }

    public boolean isDouble() {
        boolean bl = this.type == ValueType.doubleValue;
        return bl;
    }

    public boolean isEmpty() {
        boolean bl = this.size == 0;
        return bl;
    }

    public boolean isLong() {
        boolean bl = this.type == ValueType.longValue;
        return bl;
    }

    public boolean isNull() {
        boolean bl = this.type == ValueType.nullValue;
        return bl;
    }

    public boolean isNumber() {
        boolean bl = this.type == ValueType.doubleValue || this.type == ValueType.longValue;
        return bl;
    }

    public boolean isObject() {
        boolean bl = this.type == ValueType.object;
        return bl;
    }

    public boolean isString() {
        boolean bl = this.type == ValueType.stringValue;
        return bl;
    }

    public boolean isValue() {
        int n = 1.$SwitchMap$com$badlogic$gdx$utils$JsonValue$ValueType[this.type.ordinal()];
        return n == 1 || n == 2 || n == 3 || n == 4 || n == 5;
    }

    public JsonIterator iterator() {
        return new JsonIterator();
    }

    public String name() {
        return this.name;
    }

    public JsonValue next() {
        return this.next;
    }

    public boolean notEmpty() {
        boolean bl = this.size > 0;
        return bl;
    }

    public JsonValue parent() {
        return this.parent;
    }

    public String prettyPrint(PrettyPrintSettings prettyPrintSettings) {
        StringBuilder stringBuilder = new StringBuilder(512);
        this.prettyPrint(this, stringBuilder, 0, prettyPrintSettings);
        return stringBuilder.toString();
    }

    public String prettyPrint(JsonWriter.OutputType outputType, int n) {
        PrettyPrintSettings prettyPrintSettings = new PrettyPrintSettings();
        prettyPrintSettings.outputType = outputType;
        prettyPrintSettings.singleLineColumns = n;
        return this.prettyPrint(prettyPrintSettings);
    }

    public void prettyPrint(JsonWriter.OutputType outputType, Writer writer) throws IOException {
        PrettyPrintSettings prettyPrintSettings = new PrettyPrintSettings();
        prettyPrintSettings.outputType = outputType;
        this.prettyPrint(this, writer, 0, prettyPrintSettings);
    }

    public JsonValue prev() {
        return this.prev;
    }

    public JsonValue remove(int n) {
        JsonValue jsonValue = this.get(n);
        if (jsonValue == null) {
            return null;
        }
        JsonValue jsonValue2 = jsonValue.prev;
        if (jsonValue2 == null) {
            this.child = jsonValue.next;
            jsonValue2 = this.child;
            if (jsonValue2 != null) {
                jsonValue2.prev = null;
            }
        } else {
            jsonValue2.next = jsonValue.next;
            JsonValue jsonValue3 = jsonValue.next;
            if (jsonValue3 != null) {
                jsonValue3.prev = jsonValue2;
            }
        }
        --this.size;
        return jsonValue;
    }

    public JsonValue remove(String object) {
        if ((object = this.get((String)object)) == null) {
            return null;
        }
        JsonValue jsonValue = ((JsonValue)object).prev;
        if (jsonValue == null) {
            this.child = ((JsonValue)object).next;
            jsonValue = this.child;
            if (jsonValue != null) {
                jsonValue.prev = null;
            }
        } else {
            jsonValue.next = ((JsonValue)object).next;
            JsonValue jsonValue2 = ((JsonValue)object).next;
            if (jsonValue2 != null) {
                jsonValue2.prev = jsonValue;
            }
        }
        --this.size;
        return object;
    }

    public JsonValue require(int n) {
        Object object = this.child;
        while (object != null && n > 0) {
            --n;
            object = ((JsonValue)object).next;
        }
        if (object != null) {
            return object;
        }
        object = new java.lang.StringBuilder();
        ((java.lang.StringBuilder)object).append("Child not found with index: ");
        ((java.lang.StringBuilder)object).append(n);
        object = new IllegalArgumentException(((java.lang.StringBuilder)object).toString());
        throw object;
    }

    public JsonValue require(String object) {
        String string2;
        Object object2 = this.child;
        while (!(object2 == null || (string2 = ((JsonValue)object2).name) != null && string2.equalsIgnoreCase((String)object))) {
            object2 = ((JsonValue)object2).next;
        }
        if (object2 != null) {
            return object2;
        }
        object2 = new java.lang.StringBuilder();
        ((java.lang.StringBuilder)object2).append("Child not found with name: ");
        ((java.lang.StringBuilder)object2).append((String)object);
        object = new IllegalArgumentException(((java.lang.StringBuilder)object2).toString());
        throw object;
    }

    public void set(double d, String string2) {
        this.doubleValue = d;
        this.longValue = (long)d;
        this.stringValue = string2;
        this.type = ValueType.doubleValue;
    }

    public void set(long l, String string2) {
        this.longValue = l;
        this.doubleValue = l;
        this.stringValue = string2;
        this.type = ValueType.longValue;
    }

    public void set(String object) {
        this.stringValue = object;
        object = object == null ? ValueType.nullValue : ValueType.stringValue;
        this.type = object;
    }

    public void set(boolean bl) {
        long l = bl ? 1L : 0L;
        this.longValue = l;
        this.type = ValueType.booleanValue;
    }

    public void setName(String string2) {
        this.name = string2;
    }

    public void setNext(JsonValue jsonValue) {
        this.next = jsonValue;
    }

    public void setPrev(JsonValue jsonValue) {
        this.prev = jsonValue;
    }

    public void setType(ValueType valueType) {
        if (valueType != null) {
            this.type = valueType;
            return;
        }
        throw new IllegalArgumentException("type cannot be null.");
    }

    @Deprecated
    public int size() {
        return this.size;
    }

    public String toJson(JsonWriter.OutputType outputType) {
        if (this.isValue()) {
            return this.asString();
        }
        StringBuilder stringBuilder = new StringBuilder(512);
        this.json(this, stringBuilder, outputType);
        return stringBuilder.toString();
    }

    public String toString() {
        CharSequence charSequence;
        if (this.isValue()) {
            CharSequence charSequence2;
            if (this.name == null) {
                charSequence2 = this.asString();
            } else {
                charSequence2 = new java.lang.StringBuilder();
                ((java.lang.StringBuilder)charSequence2).append(this.name);
                ((java.lang.StringBuilder)charSequence2).append(": ");
                ((java.lang.StringBuilder)charSequence2).append(this.asString());
                charSequence2 = ((java.lang.StringBuilder)charSequence2).toString();
            }
            return charSequence2;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        if (this.name == null) {
            charSequence = "";
        } else {
            charSequence = new java.lang.StringBuilder();
            ((java.lang.StringBuilder)charSequence).append(this.name);
            ((java.lang.StringBuilder)charSequence).append(": ");
            charSequence = ((java.lang.StringBuilder)charSequence).toString();
        }
        stringBuilder.append((String)charSequence);
        stringBuilder.append(this.prettyPrint(JsonWriter.OutputType.minimal, 0));
        return stringBuilder.toString();
    }

    public String trace() {
        Object object;
        Object object2;
        block8: {
            object2 = this.parent;
            String string2 = "[]";
            if (object2 == null) {
                if (this.type == ValueType.array) {
                    return "[]";
                }
                if (this.type == ValueType.object) {
                    return "{}";
                }
                return "";
            }
            if (((JsonValue)object2).type == ValueType.array) {
                int n = 0;
                object = this.parent.child;
                while (true) {
                    object2 = string2;
                    if (object == null) break block8;
                    if (object == this) {
                        object2 = new java.lang.StringBuilder();
                        ((java.lang.StringBuilder)object2).append("[");
                        ((java.lang.StringBuilder)object2).append(n);
                        ((java.lang.StringBuilder)object2).append("]");
                        object2 = ((java.lang.StringBuilder)object2).toString();
                        break block8;
                    }
                    object = ((JsonValue)object).next;
                    ++n;
                }
            }
            if (this.name.indexOf(46) != -1) {
                object2 = new java.lang.StringBuilder();
                ((java.lang.StringBuilder)object2).append(".\"");
                ((java.lang.StringBuilder)object2).append(this.name.replace("\"", "\\\""));
                ((java.lang.StringBuilder)object2).append("\"");
                object2 = ((java.lang.StringBuilder)object2).toString();
            } else {
                object2 = new java.lang.StringBuilder();
                ((java.lang.StringBuilder)object2).append('.');
                ((java.lang.StringBuilder)object2).append(this.name);
                object2 = ((java.lang.StringBuilder)object2).toString();
            }
        }
        object = new java.lang.StringBuilder();
        ((java.lang.StringBuilder)object).append(this.parent.trace());
        ((java.lang.StringBuilder)object).append((String)object2);
        return ((java.lang.StringBuilder)object).toString();
    }

    public ValueType type() {
        return this.type;
    }

    public class JsonIterator
    implements Iterator<JsonValue>,
    Iterable<JsonValue> {
        JsonValue current;
        JsonValue entry;

        public JsonIterator() {
            this.entry = JsonValue.this.child;
        }

        @Override
        public boolean hasNext() {
            boolean bl = this.entry != null;
            return bl;
        }

        @Override
        public Iterator<JsonValue> iterator() {
            return this;
        }

        @Override
        public JsonValue next() {
            this.current = this.entry;
            JsonValue jsonValue = this.current;
            if (jsonValue != null) {
                this.entry = jsonValue.next;
                return this.current;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.current.prev == null) {
                JsonValue.this.child = this.current.next;
                if (JsonValue.this.child != null) {
                    JsonValue.this.child.prev = null;
                }
            } else {
                this.current.prev.next = this.current.next;
                if (this.current.next != null) {
                    this.current.next.prev = this.current.prev;
                }
            }
            JsonValue jsonValue = JsonValue.this;
            --jsonValue.size;
        }
    }

    public static class PrettyPrintSettings {
        public JsonWriter.OutputType outputType;
        public int singleLineColumns;
        public boolean wrapNumericArrays;
    }

    public static enum ValueType {
        object,
        array,
        stringValue,
        doubleValue,
        longValue,
        booleanValue,
        nullValue;

    }
}

