/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Collections;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.StringBuilder;
import java.util.NoSuchElementException;

public class IntSet {
    private static final int EMPTY = 0;
    private static final int PRIME1 = -1105259343;
    private static final int PRIME2 = -1262997959;
    private static final int PRIME3 = -825114047;
    int capacity;
    boolean hasZeroValue;
    private int hashShift;
    private IntSetIterator iterator1;
    private IntSetIterator iterator2;
    int[] keyTable;
    private float loadFactor;
    private int mask;
    private int pushIterations;
    public int size;
    private int stashCapacity;
    int stashSize;
    private int threshold;

    public IntSet() {
        this(51, 0.8f);
    }

    public IntSet(int n) {
        this(n, 0.8f);
    }

    public IntSet(int n, float f) {
        if (n >= 0) {
            if ((n = MathUtils.nextPowerOfTwo((int)Math.ceil((float)n / f))) <= 0x40000000) {
                this.capacity = n;
                if (!(f <= 0.0f)) {
                    this.loadFactor = f;
                    n = this.capacity;
                    this.threshold = (int)((float)n * f);
                    this.mask = n - 1;
                    this.hashShift = 31 - Integer.numberOfTrailingZeros(n);
                    this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(this.capacity)) * 2);
                    this.pushIterations = Math.max(Math.min(this.capacity, 8), (int)Math.sqrt(this.capacity) / 8);
                    this.keyTable = new int[this.capacity + this.stashCapacity];
                    return;
                }
                java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
                stringBuilder.append("loadFactor must be > 0: ");
                stringBuilder.append(f);
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append("initialCapacity is too large: ");
            stringBuilder.append(n);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("initialCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public IntSet(IntSet intSet) {
        this((int)Math.floor((float)intSet.capacity * intSet.loadFactor), intSet.loadFactor);
        this.stashSize = intSet.stashSize;
        int[] nArray = intSet.keyTable;
        System.arraycopy(nArray, 0, this.keyTable, 0, nArray.length);
        this.size = intSet.size;
        this.hasZeroValue = intSet.hasZeroValue;
    }

    private void addResize(int n) {
        if (n == 0) {
            this.hasZeroValue = true;
            return;
        }
        int[] nArray = this.keyTable;
        int n2 = n & this.mask;
        int n3 = nArray[n2];
        if (n3 == 0) {
            nArray[n2] = n;
            n = this.size;
            this.size = n + 1;
            if (n >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        nArray = this.keyTable;
        int n4 = this.hash2(n);
        int n5 = nArray[n4];
        if (n5 == 0) {
            nArray[n4] = n;
            n = this.size;
            this.size = n + 1;
            if (n >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        nArray = this.keyTable;
        int n6 = this.hash3(n);
        int n7 = nArray[n6];
        if (n7 == 0) {
            nArray[n6] = n;
            n = this.size;
            this.size = n + 1;
            if (n >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(n, n2, n3, n4, n5, n6, n7);
    }

    private void addStash(int n) {
        int n2 = this.stashSize;
        if (n2 == this.stashCapacity) {
            this.resize(this.capacity << 1);
            this.addResize(n);
            return;
        }
        int n3 = this.capacity;
        this.keyTable[n3 + n2] = n;
        this.stashSize = n2 + 1;
        ++this.size;
    }

    private boolean containsKeyStash(int n) {
        int[] nArray = this.keyTable;
        int n2 = this.capacity;
        int n3 = this.stashSize;
        for (int i = n2; i < n3 + n2; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    private int hash2(int n) {
        return ((n *= -1262997959) ^ n >>> this.hashShift) & this.mask;
    }

    private int hash3(int n) {
        return ((n *= -825114047) ^ n >>> this.hashShift) & this.mask;
    }

    private void push(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int[] nArray = this.keyTable;
        int n8 = this.mask;
        int n9 = this.pushIterations;
        int n10 = 0;
        int n11 = n4;
        int n12 = n2;
        n4 = n;
        n2 = n10;
        do {
            if ((n = MathUtils.random(2)) != 0) {
                if (n != 1) {
                    nArray[n6] = n4;
                    n = n7;
                } else {
                    nArray[n11] = n4;
                    n = n5;
                }
            } else {
                nArray[n12] = n4;
                n = n3;
            }
            n12 = n & n8;
            n3 = nArray[n12];
            if (n3 == 0) {
                nArray[n12] = n;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n11 = this.hash2(n);
            n5 = nArray[n11];
            if (n5 == 0) {
                nArray[n11] = n;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n6 = this.hash3(n);
            n7 = nArray[n6];
            if (n7 == 0) {
                nArray[n6] = n;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n2 = n10 = n2 + 1;
            n4 = n;
        } while (n10 != n9);
        this.addStash(n);
    }

    private void resize(int n) {
        int n2 = this.capacity;
        int n3 = this.stashSize;
        this.capacity = n;
        this.threshold = (int)((float)n * this.loadFactor);
        this.mask = n - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(n);
        double d = n;
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(d)) * 2);
        this.pushIterations = Math.max(Math.min(n, 8), (int)Math.sqrt(d) / 8);
        int[] nArray = this.keyTable;
        this.keyTable = new int[n + this.stashCapacity];
        int n4 = this.size;
        this.size = this.hasZeroValue ? 1 : 0;
        this.stashSize = 0;
        if (n4 > 0) {
            for (n = 0; n < n2 + n3; ++n) {
                n4 = nArray[n];
                if (n4 == 0) continue;
                this.addResize(n4);
            }
        }
    }

    public static IntSet with(int ... nArray) {
        IntSet intSet = new IntSet();
        intSet.addAll(nArray);
        return intSet;
    }

    public boolean add(int n) {
        if (n == 0) {
            if (this.hasZeroValue) {
                return false;
            }
            this.hasZeroValue = true;
            ++this.size;
            return true;
        }
        int[] nArray = this.keyTable;
        int n2 = n & this.mask;
        int n3 = nArray[n2];
        if (n3 == n) {
            return false;
        }
        int n4 = this.hash2(n);
        int n5 = nArray[n4];
        if (n5 == n) {
            return false;
        }
        int n6 = this.hash3(n);
        int n7 = nArray[n6];
        if (n7 == n) {
            return false;
        }
        int n8 = this.capacity;
        int n9 = this.stashSize;
        for (int i = n8; i < n9 + n8; ++i) {
            if (nArray[i] != n) continue;
            return false;
        }
        if (n3 == 0) {
            nArray[n2] = n;
            n = this.size;
            this.size = n + 1;
            if (n >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return true;
        }
        if (n5 == 0) {
            nArray[n4] = n;
            n = this.size;
            this.size = n + 1;
            if (n >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return true;
        }
        if (n7 == 0) {
            nArray[n6] = n;
            n = this.size;
            this.size = n + 1;
            if (n >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return true;
        }
        this.push(n, n2, n3, n4, n5, n6, n7);
        return true;
    }

    public void addAll(IntArray intArray) {
        this.addAll(intArray.items, 0, intArray.size);
    }

    public void addAll(IntArray intArray, int n, int n2) {
        if (n + n2 <= intArray.size) {
            this.addAll(intArray.items, n, n2);
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("offset + length must be <= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" + ");
        stringBuilder.append(n2);
        stringBuilder.append(" <= ");
        stringBuilder.append(intArray.size);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public void addAll(IntSet object) {
        this.ensureCapacity(((IntSet)object).size);
        object = ((IntSet)object).iterator();
        while (((IntSetIterator)object).hasNext) {
            this.add(((IntSetIterator)object).next());
        }
    }

    public void addAll(int ... nArray) {
        this.addAll(nArray, 0, nArray.length);
    }

    public void addAll(int[] nArray, int n, int n2) {
        this.ensureCapacity(n2);
        for (int i = n; i < n2 + n; ++i) {
            this.add(nArray[i]);
        }
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        int[] nArray = this.keyTable;
        int n = this.capacity + this.stashSize;
        while (true) {
            int n2 = n - 1;
            if (n <= 0) break;
            nArray[n2] = 0;
            n = n2;
        }
        this.size = 0;
        this.stashSize = 0;
        this.hasZeroValue = false;
    }

    public void clear(int n) {
        if (this.capacity <= n) {
            this.clear();
            return;
        }
        this.hasZeroValue = false;
        this.size = 0;
        this.resize(n);
    }

    public boolean contains(int n) {
        if (n == 0) {
            return this.hasZeroValue;
        }
        int n2 = this.mask;
        if (this.keyTable[n2 & n] != n && this.keyTable[n2 = this.hash2(n)] != n && this.keyTable[n2 = this.hash3(n)] != n) {
            return this.containsKeyStash(n);
        }
        return true;
    }

    public void ensureCapacity(int n) {
        if (n >= 0) {
            if ((n = this.size + n) >= this.threshold) {
                this.resize(MathUtils.nextPowerOfTwo((int)Math.ceil((float)n / this.loadFactor)));
            }
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("additionalCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public boolean equals(Object object) {
        if (!(object instanceof IntSet)) {
            return false;
        }
        object = (IntSet)object;
        if (((IntSet)object).size != this.size) {
            return false;
        }
        if (((IntSet)object).hasZeroValue != this.hasZeroValue) {
            return false;
        }
        int[] nArray = this.keyTable;
        int n = this.capacity;
        int n2 = this.stashSize;
        for (int i = 0; i < n + n2; ++i) {
            if (nArray[i] == 0 || ((IntSet)object).contains(nArray[i])) continue;
            return false;
        }
        return true;
    }

    public int first() {
        boolean bl = this.hasZeroValue;
        if (bl) {
            return 0;
        }
        Object object = this.keyTable;
        int n = this.capacity;
        int n2 = this.stashSize;
        for (int i = 0; i < n + n2; ++i) {
            if (object[i] == 0) continue;
            return object[i];
        }
        object = new IllegalStateException("IntSet is empty.");
        throw object;
    }

    public int hashCode() {
        int n = this.capacity;
        int n2 = this.stashSize;
        int n3 = 0;
        for (int i = 0; i < n + n2; ++i) {
            int[] nArray = this.keyTable;
            int n4 = n3;
            if (nArray[i] != 0) {
                n4 = n3 + nArray[i];
            }
            n3 = n4;
        }
        return n3;
    }

    public boolean isEmpty() {
        boolean bl = this.size == 0;
        return bl;
    }

    public IntSetIterator iterator() {
        if (Collections.allocateIterators) {
            return new IntSetIterator(this);
        }
        if (this.iterator1 == null) {
            this.iterator1 = new IntSetIterator(this);
            this.iterator2 = new IntSetIterator(this);
        }
        if (!this.iterator1.valid) {
            this.iterator1.reset();
            IntSetIterator intSetIterator = this.iterator1;
            intSetIterator.valid = true;
            this.iterator2.valid = false;
            return intSetIterator;
        }
        this.iterator2.reset();
        IntSetIterator intSetIterator = this.iterator2;
        intSetIterator.valid = true;
        this.iterator1.valid = false;
        return intSetIterator;
    }

    public boolean notEmpty() {
        boolean bl = this.size > 0;
        return bl;
    }

    public boolean remove(int n) {
        if (n == 0) {
            if (!this.hasZeroValue) {
                return false;
            }
            this.hasZeroValue = false;
            --this.size;
            return true;
        }
        int[] nArray = this.keyTable;
        int n2 = this.mask & n;
        if (nArray[n2] == n) {
            nArray[n2] = 0;
            --this.size;
            return true;
        }
        nArray = this.keyTable;
        n2 = this.hash2(n);
        if (nArray[n2] == n) {
            nArray[n2] = 0;
            --this.size;
            return true;
        }
        nArray = this.keyTable;
        n2 = this.hash3(n);
        if (nArray[n2] == n) {
            nArray[n2] = 0;
            --this.size;
            return true;
        }
        return this.removeStash(n);
    }

    boolean removeStash(int n) {
        int[] nArray = this.keyTable;
        int n2 = this.capacity;
        int n3 = this.stashSize;
        for (int i = n2; i < n3 + n2; ++i) {
            if (nArray[i] != n) continue;
            this.removeStashIndex(i);
            --this.size;
            return true;
        }
        return false;
    }

    void removeStashIndex(int n) {
        --this.stashSize;
        int n2 = this.capacity + this.stashSize;
        if (n < n2) {
            int[] nArray = this.keyTable;
            nArray[n] = nArray[n2];
        }
    }

    public void shrink(int n) {
        if (n >= 0) {
            int n2 = this.size;
            int n3 = n;
            if (n2 > n) {
                n3 = n2;
            }
            if (this.capacity <= n3) {
                return;
            }
            this.resize(MathUtils.nextPowerOfTwo(n3));
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("maximumCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public String toString() {
        int n;
        int n2;
        int[] nArray;
        StringBuilder stringBuilder;
        block6: {
            if (this.size == 0) {
                return "[]";
            }
            stringBuilder = new StringBuilder(32);
            stringBuilder.append('[');
            nArray = this.keyTable;
            n = n2 = nArray.length;
            if (this.hasZeroValue) {
                stringBuilder.append("0");
            } else {
                int n3;
                while (true) {
                    n2 = n3 = n - 1;
                    if (n <= 0) break block6;
                    n2 = nArray[n3];
                    if (n2 != 0) break;
                    n = n3;
                }
                stringBuilder.append(n2);
                n2 = n3;
            }
        }
        while (true) {
            n = n2 - 1;
            if (n2 <= 0) break;
            n2 = nArray[n];
            if (n2 == 0) {
                n2 = n;
                continue;
            }
            stringBuilder.append(", ");
            stringBuilder.append(n2);
            n2 = n;
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static class IntSetIterator {
        static final int INDEX_ILLEGAL = -2;
        static final int INDEX_ZERO = -1;
        int currentIndex;
        public boolean hasNext;
        int nextIndex;
        final IntSet set;
        boolean valid = true;

        public IntSetIterator(IntSet intSet) {
            this.set = intSet;
            this.reset();
        }

        void findNextIndex() {
            block1: {
                this.hasNext = false;
                int[] nArray = this.set.keyTable;
                int n = this.set.capacity;
                int n2 = this.set.stashSize;
                do {
                    int n3;
                    this.nextIndex = n3 = this.nextIndex + 1;
                    if (n3 >= n + n2) break block1;
                } while (nArray[this.nextIndex] == 0);
                this.hasNext = true;
            }
        }

        public int next() {
            if (this.hasNext) {
                if (this.valid) {
                    int n = this.nextIndex == -1 ? 0 : this.set.keyTable[this.nextIndex];
                    this.currentIndex = this.nextIndex;
                    this.findNextIndex();
                    return n;
                }
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            block7: {
                block6: {
                    block5: {
                        if (this.currentIndex != -1 || !this.set.hasZeroValue) break block5;
                        this.set.hasZeroValue = false;
                        break block6;
                    }
                    int n = this.currentIndex;
                    if (n < 0) break block7;
                    if (n >= this.set.capacity) {
                        this.set.removeStashIndex(this.currentIndex);
                        this.nextIndex = this.currentIndex - 1;
                        this.findNextIndex();
                    } else {
                        this.set.keyTable[this.currentIndex] = 0;
                    }
                }
                this.currentIndex = -2;
                IntSet intSet = this.set;
                --intSet.size;
                return;
            }
            throw new IllegalStateException("next must be called before remove.");
        }

        public void reset() {
            this.currentIndex = -2;
            this.nextIndex = -1;
            if (this.set.hasZeroValue) {
                this.hasNext = true;
            } else {
                this.findNextIndex();
            }
        }

        public IntArray toArray() {
            IntArray intArray = new IntArray(true, this.set.size);
            while (this.hasNext) {
                intArray.add(this.next());
            }
            return intArray;
        }
    }
}

