/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IntArray;
import java.util.Comparator;

public class DelayedRemovalArray<T>
extends Array<T> {
    private int clear;
    private int iterating;
    private IntArray remove = new IntArray(0);

    public DelayedRemovalArray() {
    }

    public DelayedRemovalArray(int n) {
        super(n);
    }

    public DelayedRemovalArray(Array array) {
        super(array);
    }

    public DelayedRemovalArray(Class clazz) {
        super(clazz);
    }

    public DelayedRemovalArray(boolean bl, int n) {
        super(bl, n);
    }

    public DelayedRemovalArray(boolean bl, int n, Class clazz) {
        super(bl, n, clazz);
    }

    public DelayedRemovalArray(boolean bl, T[] TArray, int n, int n2) {
        super(bl, TArray, n, n2);
    }

    public DelayedRemovalArray(T[] TArray) {
        super(TArray);
    }

    private void remove(int n) {
        if (n < this.clear) {
            return;
        }
        int n2 = this.remove.size;
        for (int i = 0; i < n2; ++i) {
            int n3 = this.remove.get(i);
            if (n == n3) {
                return;
            }
            if (n >= n3) continue;
            this.remove.insert(i, n);
            return;
        }
        this.remove.add(n);
    }

    public static <T> DelayedRemovalArray<T> with(T ... TArray) {
        return new DelayedRemovalArray<T>(TArray);
    }

    public void begin() {
        ++this.iterating;
    }

    @Override
    public void clear() {
        if (this.iterating > 0) {
            this.clear = this.size;
            return;
        }
        super.clear();
    }

    public void end() {
        int n = this.iterating;
        if (n != 0) {
            this.iterating = n - 1;
            if (this.iterating == 0) {
                n = this.clear;
                if (n > 0 && n == this.size) {
                    this.remove.clear();
                    this.clear();
                } else {
                    int n2 = this.remove.size;
                    for (n = 0; n < n2; ++n) {
                        int n3 = this.remove.pop();
                        if (n3 < this.clear) continue;
                        this.removeIndex(n3);
                    }
                    for (n = this.clear - 1; n >= 0; --n) {
                        this.removeIndex(n);
                    }
                }
                this.clear = 0;
            }
            return;
        }
        IllegalStateException illegalStateException = new IllegalStateException("begin must be called before end.");
        throw illegalStateException;
    }

    @Override
    public void insert(int n, T t) {
        if (this.iterating <= 0) {
            super.insert(n, t);
            return;
        }
        throw new IllegalStateException("Invalid between begin/end.");
    }

    @Override
    public T pop() {
        if (this.iterating <= 0) {
            return super.pop();
        }
        throw new IllegalStateException("Invalid between begin/end.");
    }

    @Override
    public T removeIndex(int n) {
        if (this.iterating > 0) {
            this.remove(n);
            return this.get(n);
        }
        return super.removeIndex(n);
    }

    @Override
    public void removeRange(int n, int n2) {
        if (this.iterating > 0) {
            while (n2 >= n) {
                this.remove(n2);
                --n2;
            }
        } else {
            super.removeRange(n, n2);
        }
    }

    @Override
    public boolean removeValue(T t, boolean bl) {
        if (this.iterating > 0) {
            int n = this.indexOf(t, bl);
            if (n == -1) {
                return false;
            }
            this.remove(n);
            return true;
        }
        return super.removeValue(t, bl);
    }

    @Override
    public void reverse() {
        if (this.iterating <= 0) {
            super.reverse();
            return;
        }
        throw new IllegalStateException("Invalid between begin/end.");
    }

    @Override
    public void set(int n, T t) {
        if (this.iterating <= 0) {
            super.set(n, t);
            return;
        }
        throw new IllegalStateException("Invalid between begin/end.");
    }

    @Override
    public T[] setSize(int n) {
        if (this.iterating <= 0) {
            return super.setSize(n);
        }
        throw new IllegalStateException("Invalid between begin/end.");
    }

    @Override
    public void shuffle() {
        if (this.iterating <= 0) {
            super.shuffle();
            return;
        }
        throw new IllegalStateException("Invalid between begin/end.");
    }

    @Override
    public void sort() {
        if (this.iterating <= 0) {
            super.sort();
            return;
        }
        throw new IllegalStateException("Invalid between begin/end.");
    }

    @Override
    public void sort(Comparator<? super T> comparator) {
        if (this.iterating <= 0) {
            super.sort(comparator);
            return;
        }
        throw new IllegalStateException("Invalid between begin/end.");
    }

    @Override
    public void swap(int n, int n2) {
        if (this.iterating <= 0) {
            super.swap(n, n2);
            return;
        }
        throw new IllegalStateException("Invalid between begin/end.");
    }

    @Override
    public void truncate(int n) {
        if (this.iterating <= 0) {
            super.truncate(n);
            return;
        }
        throw new IllegalStateException("Invalid between begin/end.");
    }
}

