/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

public class Bits {
    long[] bits = new long[]{0L};

    public Bits() {
    }

    public Bits(int n) {
        this.checkCapacity(n >>> 6);
    }

    private void checkCapacity(int n) {
        long[] lArray = this.bits;
        if (n >= lArray.length) {
            long[] lArray2 = new long[n + 1];
            System.arraycopy(lArray, 0, lArray2, 0, lArray.length);
            this.bits = lArray2;
        }
    }

    public void and(Bits object) {
        int n;
        int n2 = Math.min(this.bits.length, ((Bits)object).bits.length);
        for (n = 0; n2 > n; ++n) {
            long[] lArray = this.bits;
            lArray[n] = lArray[n] & ((Bits)object).bits[n];
        }
        object = this.bits;
        if (((Object)object).length > n2) {
            int n3 = ((Object)object).length;
            for (n = n2; n3 > n; ++n) {
                this.bits[n] = 0L;
            }
        }
    }

    public void andNot(Bits bits) {
        int n = this.bits.length;
        int n2 = bits.bits.length;
        for (int i = 0; i < n && i < n2; ++i) {
            long[] lArray = this.bits;
            lArray[i] = lArray[i] & (bits.bits[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public void clear() {
        long[] lArray = this.bits;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            lArray[i] = 0L;
        }
    }

    public void clear(int n) {
        int n2 = n >>> 6;
        long[] lArray = this.bits;
        if (n2 >= lArray.length) {
            return;
        }
        lArray[n2] = lArray[n2] & (1L << (n & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public boolean containsAll(Bits object) {
        int n;
        int n2;
        long[] lArray = this.bits;
        object = ((Bits)object).bits;
        int n3 = ((Object)object).length;
        for (n2 = n = lArray.length; n2 < n3; ++n2) {
            if (object[n2] == 0L) continue;
            return false;
        }
        for (n2 = Math.min(n, n3) - 1; n2 >= 0; --n2) {
            if ((lArray[n2] & object[n2]) == object[n2]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (Bits)object;
        long[] lArray = ((Bits)object).bits;
        int n = Math.min(this.bits.length, lArray.length);
        for (int i = 0; n > i; ++i) {
            if (this.bits[i] == lArray[i]) continue;
            return false;
        }
        if (this.bits.length == lArray.length) {
            return true;
        }
        if (this.length() != ((Bits)object).length()) {
            bl = false;
        }
        return bl;
    }

    public void flip(int n) {
        int n2 = n >>> 6;
        this.checkCapacity(n2);
        long[] lArray = this.bits;
        lArray[n2] = lArray[n2] ^ 1L << (n & 0x3F);
    }

    public boolean get(int n) {
        int n2 = n >>> 6;
        long[] lArray = this.bits;
        int n3 = lArray.length;
        boolean bl = false;
        if (n2 >= n3) {
            return false;
        }
        if ((lArray[n2] & 1L << (n & 0x3F)) != 0L) {
            bl = true;
        }
        return bl;
    }

    public boolean getAndClear(int n) {
        int n2 = n >>> 6;
        long[] lArray = this.bits;
        int n3 = lArray.length;
        boolean bl = false;
        if (n2 >= n3) {
            return false;
        }
        long l = lArray[n2];
        lArray[n2] = lArray[n2] & (1L << (n & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
        if (lArray[n2] != l) {
            bl = true;
        }
        return bl;
    }

    public boolean getAndSet(int n) {
        int n2 = n >>> 6;
        this.checkCapacity(n2);
        long[] lArray = this.bits;
        long l = lArray[n2];
        lArray[n2] = lArray[n2] | 1L << (n & 0x3F);
        boolean bl = lArray[n2] == l;
        return bl;
    }

    public int hashCode() {
        int n = this.length();
        int n2 = 0;
        for (int i = 0; n >>> 6 >= i; ++i) {
            long[] lArray = this.bits;
            n2 = n2 * 127 + (int)(lArray[i] ^ lArray[i] >>> 32);
        }
        return n2;
    }

    public boolean intersects(Bits object) {
        long[] lArray = this.bits;
        object = ((Bits)object).bits;
        for (int i = Math.min(lArray.length, ((Object)object).length) - 1; i >= 0; --i) {
            if ((lArray[i] & object[i]) == 0L) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        long[] lArray = this.bits;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            if (lArray[i] == 0L) continue;
            return false;
        }
        return true;
    }

    public int length() {
        long[] lArray = this.bits;
        for (int i = lArray.length - 1; i >= 0; --i) {
            long l = lArray[i];
            if (l == 0L) continue;
            for (int j = 63; j >= 0; --j) {
                if ((1L << (j & 0x3F) & l) == 0L) continue;
                return (i << 6) + j + 1;
            }
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int nextClearBit(int n) {
        int n2;
        int n3 = n >>> 6;
        long[] lArray = this.bits;
        int n4 = lArray.length;
        if (n3 >= n4) {
            n = lArray.length;
            return n << 6;
        }
        long l = lArray[n3];
        n &= 0x3F;
        while (true) {
            n2 = n3;
            if (n >= 64) break;
            if ((1L << (n & 0x3F) & l) == 0L) {
                return (n3 << 6) + n;
            }
            ++n;
        }
        block1: while (true) {
            if ((n3 = n2 + 1) >= n4) {
                n = lArray.length;
                return n << 6;
            }
            if (n3 == 0) {
                return n3 << 6;
            }
            l = lArray[n3];
            n = 0;
            while (true) {
                n2 = n3;
                if (n >= 64) continue block1;
                if ((1L << (n & 0x3F) & l) == 0L) {
                    return (n3 << 6) + n;
                }
                ++n;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    public int nextSetBit(int var1_1) {
        var3_3 = var1_1 >>> 6;
        var2_2 = this.bits;
        var4_4 = var2_2.length;
        if (var3_3 >= var4_4) {
            return -1;
        }
        var5_5 = var2_2[var3_3];
        var7_6 = var3_3;
        if (var5_5 != 0L) {
            var1_1 &= 63;
            while (true) {
                var7_6 = var3_3;
                if (var1_1 >= 64) break;
                if ((1L << (var1_1 & 63) & var5_5) != 0L) {
                    return (var3_3 << 6) + var1_1;
                }
                ++var1_1;
            }
        }
        block2: while ((var3_3 = var7_6 + 1) < var4_4) {
            var7_6 = var3_3;
            if (var3_3 == 0) continue;
            var5_5 = var2_2[var3_3];
            var7_6 = var3_3;
            if (var5_5 == 0L) continue;
            var1_1 = 0;
            while (true) {
                var7_6 = var3_3;
                if (var1_1 >= 64) continue block2;
                if ((1L << (var1_1 & 63) & var5_5) != 0L) ** continue;
                ++var1_1;
            }
        }
        return -1;
    }

    public boolean notEmpty() {
        return this.isEmpty() ^ true;
    }

    public int numBits() {
        return this.bits.length << 6;
    }

    public void or(Bits bits) {
        long[] lArray;
        int n;
        int n2 = Math.min(this.bits.length, bits.bits.length);
        for (n = 0; n2 > n; ++n) {
            lArray = this.bits;
            lArray[n] = lArray[n] | bits.bits[n];
        }
        lArray = bits.bits;
        if (n2 < lArray.length) {
            this.checkCapacity(lArray.length);
            int n3 = bits.bits.length;
            for (n = n2; n3 > n; ++n) {
                this.bits[n] = bits.bits[n];
            }
        }
    }

    public void set(int n) {
        int n2 = n >>> 6;
        this.checkCapacity(n2);
        long[] lArray = this.bits;
        lArray[n2] = lArray[n2] | 1L << (n & 0x3F);
    }

    public void xor(Bits bits) {
        long[] lArray;
        int n;
        int n2 = Math.min(this.bits.length, bits.bits.length);
        for (n = 0; n2 > n; ++n) {
            lArray = this.bits;
            lArray[n] = lArray[n] ^ bits.bits[n];
        }
        lArray = bits.bits;
        if (n2 < lArray.length) {
            this.checkCapacity(lArray.length);
            int n3 = bits.bits.length;
            for (n = n2; n3 > n; ++n) {
                this.bits[n] = bits.bits[n];
            }
        }
    }
}

