/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.utils;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.utils.DragListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;

public class DragAndDrop {
    static final Vector2 tmpVector = new Vector2();
    int activePointer = -1;
    private int button;
    boolean cancelTouchFocus = true;
    Actor dragActor;
    float dragActorX = 0.0f;
    float dragActorY = 0.0f;
    Source dragSource;
    int dragTime = 250;
    long dragValidTime;
    boolean isValidTarget;
    boolean keepWithinStage = true;
    Payload payload;
    final ObjectMap<Source, DragListener> sourceListeners;
    private float tapSquareSize = 8.0f;
    Target target;
    final Array<Target> targets = new Array();
    float touchOffsetX;
    float touchOffsetY;

    public DragAndDrop() {
        this.sourceListeners = new ObjectMap();
    }

    public void addSource(final Source source) {
        DragListener dragListener = new DragListener(){

            @Override
            public void drag(InputEvent inputEvent, float f, float f2, int n) {
                Object object;
                if (DragAndDrop.this.payload == null) {
                    return;
                }
                if (n != DragAndDrop.this.activePointer) {
                    return;
                }
                source.drag(inputEvent, f, f2, n);
                Stage stage = inputEvent.getStage();
                Object object2 = DragAndDrop.this.dragActor;
                Object object3 = null;
                if (object2 != null) {
                    DragAndDrop.this.dragActor.remove();
                    DragAndDrop.this.dragActor = null;
                }
                object2 = DragAndDrop.this;
                int n2 = 0;
                ((DragAndDrop)object2).isValidTarget = false;
                f2 = inputEvent.getStageX() + DragAndDrop.this.touchOffsetX;
                f = inputEvent.getStageY() + DragAndDrop.this.touchOffsetY;
                object2 = object = inputEvent.getStage().hit(f2, f, true);
                if (object == null) {
                    object2 = inputEvent.getStage().hit(f2, f, false);
                }
                if (object2 != null) {
                    int n3 = DragAndDrop.this.targets.size;
                    while (n2 < n3) {
                        object = DragAndDrop.this.targets.get(n2);
                        if (!((Target)object).actor.isAscendantOf((Actor)object2)) {
                            ++n2;
                            continue;
                        }
                        ((Target)object).actor.stageToLocalCoordinates(tmpVector.set(f2, f));
                        object2 = object;
                        break;
                    }
                } else {
                    object2 = null;
                }
                if (object2 != DragAndDrop.this.target) {
                    if (DragAndDrop.this.target != null) {
                        DragAndDrop.this.target.reset(source, DragAndDrop.this.payload);
                    }
                    DragAndDrop.this.target = object2;
                }
                if (object2 != null) {
                    object = DragAndDrop.this;
                    ((DragAndDrop)object).isValidTarget = ((Target)object2).drag(source, ((DragAndDrop)object).payload, DragAndDrop.tmpVector.x, DragAndDrop.tmpVector.y, n);
                }
                object2 = object3;
                if (DragAndDrop.this.target != null) {
                    object2 = DragAndDrop.this.isValidTarget ? DragAndDrop.this.payload.validDragActor : DragAndDrop.this.payload.invalidDragActor;
                }
                object3 = object2;
                if (object2 == null) {
                    object3 = DragAndDrop.this.payload.dragActor;
                }
                DragAndDrop.this.dragActor = object3;
                if (object3 == null) {
                    return;
                }
                stage.addActor((Actor)object3);
                f = inputEvent.getStageX() - ((Actor)object3).getWidth() + DragAndDrop.this.dragActorX;
                float f3 = inputEvent.getStageY() + DragAndDrop.this.dragActorY;
                float f4 = f;
                f2 = f3;
                if (DragAndDrop.this.keepWithinStage) {
                    f2 = f;
                    if (f < 0.0f) {
                        f2 = 0.0f;
                    }
                    f = f3;
                    if (f3 < 0.0f) {
                        f = 0.0f;
                    }
                    f3 = f2;
                    if (((Actor)object3).getWidth() + f2 > stage.getWidth()) {
                        f3 = stage.getWidth() - ((Actor)object3).getWidth();
                    }
                    f4 = f3;
                    f2 = f;
                    if (((Actor)object3).getHeight() + f > stage.getHeight()) {
                        f2 = stage.getHeight() - ((Actor)object3).getHeight();
                        f4 = f3;
                    }
                }
                ((Actor)object3).setPosition(f4, f2);
            }

            @Override
            public void dragStart(InputEvent object, float f, float f2, int n) {
                Source source2;
                if (DragAndDrop.this.activePointer != -1) {
                    ((Event)object).stop();
                    return;
                }
                DragAndDrop dragAndDrop = DragAndDrop.this;
                dragAndDrop.activePointer = n;
                dragAndDrop.dragValidTime = System.currentTimeMillis() + (long)DragAndDrop.this.dragTime;
                dragAndDrop = DragAndDrop.this;
                dragAndDrop.dragSource = source2 = source;
                dragAndDrop.payload = source2.dragStart((InputEvent)object, this.getTouchDownX(), this.getTouchDownY(), n);
                ((Event)object).stop();
                if (DragAndDrop.this.cancelTouchFocus && DragAndDrop.this.payload != null && (object = source.getActor().getStage()) != null) {
                    ((Stage)object).cancelTouchFocusExcept(this, source.getActor());
                }
            }

            @Override
            public void dragStop(InputEvent object, float f, float f2, int n) {
                if (n != DragAndDrop.this.activePointer) {
                    return;
                }
                Object object2 = DragAndDrop.this;
                ((DragAndDrop)object2).activePointer = -1;
                if (((DragAndDrop)object2).payload == null) {
                    return;
                }
                if (System.currentTimeMillis() < DragAndDrop.this.dragValidTime) {
                    DragAndDrop.this.isValidTarget = false;
                }
                if (DragAndDrop.this.dragActor != null) {
                    DragAndDrop.this.dragActor.remove();
                }
                if (DragAndDrop.this.isValidTarget) {
                    float f3 = ((InputEvent)object).getStageX();
                    float f4 = DragAndDrop.this.touchOffsetX;
                    float f5 = ((InputEvent)object).getStageY();
                    float f6 = DragAndDrop.this.touchOffsetY;
                    DragAndDrop.this.target.actor.stageToLocalCoordinates(tmpVector.set(f3 + f4, f5 + f6));
                    DragAndDrop.this.target.drop(source, DragAndDrop.this.payload, DragAndDrop.tmpVector.x, DragAndDrop.tmpVector.y, n);
                }
                Source source2 = source;
                Payload payload = DragAndDrop.this.payload;
                object2 = DragAndDrop.this.isValidTarget ? DragAndDrop.this.target : null;
                source2.dragStop((InputEvent)object, f, f2, n, payload, (Target)object2);
                if (DragAndDrop.this.target != null) {
                    DragAndDrop.this.target.reset(source, DragAndDrop.this.payload);
                }
                object = DragAndDrop.this;
                ((DragAndDrop)object).dragSource = null;
                ((DragAndDrop)object).payload = null;
                ((DragAndDrop)object).target = null;
                ((DragAndDrop)object).isValidTarget = false;
                ((DragAndDrop)object).dragActor = null;
            }
        };
        dragListener.setTapSquareSize(this.tapSquareSize);
        dragListener.setButton(this.button);
        source.actor.addCaptureListener(dragListener);
        this.sourceListeners.put(source, dragListener);
    }

    public void addTarget(Target target) {
        this.targets.add(target);
    }

    public void cancelTouchFocusExcept(Source source) {
        DragListener dragListener = this.sourceListeners.get(source);
        if (dragListener == null) {
            return;
        }
        Stage stage = source.getActor().getStage();
        if (stage != null) {
            stage.cancelTouchFocusExcept(dragListener, source.getActor());
        }
    }

    public void clear() {
        this.targets.clear();
        for (ObjectMap.Entry entry : this.sourceListeners.entries()) {
            ((Source)entry.key).actor.removeCaptureListener((EventListener)entry.value);
        }
        this.sourceListeners.clear();
    }

    public Actor getDragActor() {
        return this.dragActor;
    }

    public Payload getDragPayload() {
        return this.payload;
    }

    public Source getDragSource() {
        return this.dragSource;
    }

    public int getDragTime() {
        return this.dragTime;
    }

    public boolean isDragValid() {
        boolean bl = this.payload != null && System.currentTimeMillis() >= this.dragValidTime;
        return bl;
    }

    public boolean isDragging() {
        boolean bl = this.payload != null;
        return bl;
    }

    public void removeSource(Source source) {
        DragListener dragListener = this.sourceListeners.remove(source);
        source.actor.removeCaptureListener(dragListener);
    }

    public void removeTarget(Target target) {
        this.targets.removeValue(target, true);
    }

    public void setButton(int n) {
        this.button = n;
    }

    public void setCancelTouchFocus(boolean bl) {
        this.cancelTouchFocus = bl;
    }

    public void setDragActorPosition(float f, float f2) {
        this.dragActorX = f;
        this.dragActorY = f2;
    }

    public void setDragTime(int n) {
        this.dragTime = n;
    }

    public void setKeepWithinStage(boolean bl) {
        this.keepWithinStage = bl;
    }

    public void setTapSquareSize(float f) {
        this.tapSquareSize = f;
    }

    public void setTouchOffset(float f, float f2) {
        this.touchOffsetX = f;
        this.touchOffsetY = f2;
    }

    public static class Payload {
        Actor dragActor;
        Actor invalidDragActor;
        Object object;
        Actor validDragActor;

        public Actor getDragActor() {
            return this.dragActor;
        }

        public Actor getInvalidDragActor() {
            return this.invalidDragActor;
        }

        public Object getObject() {
            return this.object;
        }

        public Actor getValidDragActor() {
            return this.validDragActor;
        }

        public void setDragActor(Actor actor) {
            this.dragActor = actor;
        }

        public void setInvalidDragActor(Actor actor) {
            this.invalidDragActor = actor;
        }

        public void setObject(Object object) {
            this.object = object;
        }

        public void setValidDragActor(Actor actor) {
            this.validDragActor = actor;
        }
    }

    public static abstract class Source {
        final Actor actor;

        public Source(Actor actor) {
            if (actor != null) {
                this.actor = actor;
                return;
            }
            throw new IllegalArgumentException("actor cannot be null.");
        }

        public void drag(InputEvent inputEvent, float f, float f2, int n) {
        }

        public abstract Payload dragStart(InputEvent var1, float var2, float var3, int var4);

        public void dragStop(InputEvent inputEvent, float f, float f2, int n, Payload payload, Target target) {
        }

        public Actor getActor() {
            return this.actor;
        }
    }

    public static abstract class Target {
        final Actor actor;

        public Target(Actor actor) {
            if (actor != null) {
                this.actor = actor;
                Stage stage = actor.getStage();
                if (stage != null && actor == stage.getRoot()) {
                    throw new IllegalArgumentException("The stage root cannot be a drag and drop target.");
                }
                return;
            }
            throw new IllegalArgumentException("actor cannot be null.");
        }

        public abstract boolean drag(Source var1, Payload var2, float var3, float var4, int var5);

        public abstract void drop(Source var1, Payload var2, float var3, float var4, int var5);

        public Actor getActor() {
            return this.actor;
        }

        public void reset(Source source, Payload payload) {
        }
    }
}

