/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.FocusListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.Pools;
import com.badlogic.gdx.utils.Scaling;
import com.badlogic.gdx.utils.SnapshotArray;
import com.badlogic.gdx.utils.viewport.ScalingViewport;
import com.badlogic.gdx.utils.viewport.Viewport;

public class Stage
extends InputAdapter
implements Disposable {
    static boolean debug;
    private boolean actionsRequestRendering = true;
    private final Batch batch;
    private boolean debugAll;
    private final Color debugColor;
    private boolean debugInvisible;
    private boolean debugParentUnderMouse;
    private ShapeRenderer debugShapes;
    private Table.Debug debugTableUnderMouse;
    private boolean debugUnderMouse;
    private Actor keyboardFocus;
    private Actor mouseOverActor;
    private int mouseScreenX;
    private int mouseScreenY;
    private boolean ownsBatch;
    private final Actor[] pointerOverActors;
    private final int[] pointerScreenX;
    private final int[] pointerScreenY;
    private final boolean[] pointerTouched;
    private Group root;
    private Actor scrollFocus;
    private final Vector2 tempCoords = new Vector2();
    final SnapshotArray<TouchFocus> touchFocuses;
    private Viewport viewport;

    public Stage() {
        this(new ScalingViewport(Scaling.stretch, Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), new OrthographicCamera()), new SpriteBatch());
        this.ownsBatch = true;
    }

    public Stage(Viewport viewport) {
        this(viewport, new SpriteBatch());
        this.ownsBatch = true;
    }

    public Stage(Viewport viewport, Batch batch) {
        this.pointerOverActors = new Actor[20];
        this.pointerTouched = new boolean[20];
        this.pointerScreenX = new int[20];
        this.pointerScreenY = new int[20];
        this.touchFocuses = new SnapshotArray(true, 4, TouchFocus.class);
        this.debugTableUnderMouse = Table.Debug.none;
        this.debugColor = new Color(0.0f, 1.0f, 0.0f, 0.85f);
        if (viewport != null) {
            if (batch != null) {
                this.viewport = viewport;
                this.batch = batch;
                this.root = new Group();
                this.root.setStage(this);
                viewport.update(Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), true);
                return;
            }
            throw new IllegalArgumentException("batch cannot be null.");
        }
        throw new IllegalArgumentException("viewport cannot be null.");
    }

    private void disableDebug(Actor object, Actor actor) {
        if (object == actor) {
            return;
        }
        ((Actor)object).setDebug(false);
        if (object instanceof Group) {
            object = ((Group)object).children;
            int n = ((SnapshotArray)object).size;
            for (int i = 0; i < n; ++i) {
                this.disableDebug((Actor)((Array)object).get(i), actor);
            }
        }
    }

    private void drawDebug() {
        if (this.debugShapes == null) {
            this.debugShapes = new ShapeRenderer();
            this.debugShapes.setAutoShapeType(true);
        }
        if (!this.debugUnderMouse && !this.debugParentUnderMouse && this.debugTableUnderMouse == Table.Debug.none) {
            if (this.debugAll) {
                this.root.debugAll();
            }
        } else {
            this.screenToStageCoordinates(this.tempCoords.set(Gdx.input.getX(), Gdx.input.getY()));
            Actor actor = this.hit(this.tempCoords.x, this.tempCoords.y, true);
            if (actor == null) {
                return;
            }
            Actor actor2 = actor;
            if (this.debugParentUnderMouse) {
                actor2 = actor;
                if (actor.parent != null) {
                    actor2 = actor.parent;
                }
            }
            actor = actor2;
            if (this.debugTableUnderMouse == Table.Debug.none) {
                actor2.setDebug(true);
            } else {
                while (actor != null && !(actor instanceof Table)) {
                    actor = actor.parent;
                }
                if (actor == null) {
                    return;
                }
                ((Table)actor).debug(this.debugTableUnderMouse);
                actor2 = actor;
            }
            if (this.debugAll && actor2 instanceof Group) {
                ((Group)actor2).debugAll();
            }
            this.disableDebug(this.root, actor2);
        }
        Gdx.gl.glEnable(3042);
        this.debugShapes.setProjectionMatrix(this.viewport.getCamera().combined);
        this.debugShapes.begin();
        this.root.drawDebug(this.debugShapes);
        this.debugShapes.end();
        Gdx.gl.glDisable(3042);
    }

    private Actor fireEnterAndExit(Actor actor, int n, int n2, int n3) {
        InputEvent inputEvent;
        this.screenToStageCoordinates(this.tempCoords.set(n, n2));
        Actor actor2 = this.hit(this.tempCoords.x, this.tempCoords.y, true);
        if (actor2 == actor) {
            return actor;
        }
        if (actor != null) {
            inputEvent = Pools.obtain(InputEvent.class);
            inputEvent.setStage(this);
            inputEvent.setStageX(this.tempCoords.x);
            inputEvent.setStageY(this.tempCoords.y);
            inputEvent.setPointer(n3);
            inputEvent.setType(InputEvent.Type.exit);
            inputEvent.setRelatedActor(actor2);
            actor.fire(inputEvent);
            Pools.free(inputEvent);
        }
        if (actor2 != null) {
            inputEvent = Pools.obtain(InputEvent.class);
            inputEvent.setStage(this);
            inputEvent.setStageX(this.tempCoords.x);
            inputEvent.setStageY(this.tempCoords.y);
            inputEvent.setPointer(n3);
            inputEvent.setType(InputEvent.Type.enter);
            inputEvent.setRelatedActor(actor);
            actor2.fire(inputEvent);
            Pools.free(inputEvent);
        }
        return actor2;
    }

    public void act() {
        this.act(Math.min(Gdx.graphics.getDeltaTime(), 0.033333335f));
    }

    public void act(float f) {
        Object object;
        int n = this.pointerOverActors.length;
        for (int i = 0; i < n; ++i) {
            Object object2 = this.pointerOverActors;
            object = object2[i];
            if (!this.pointerTouched[i]) {
                if (object == null) continue;
                object2[i] = null;
                this.screenToStageCoordinates(this.tempCoords.set(this.pointerScreenX[i], this.pointerScreenY[i]));
                object2 = Pools.obtain(InputEvent.class);
                ((InputEvent)object2).setType(InputEvent.Type.exit);
                ((Event)object2).setStage(this);
                ((InputEvent)object2).setStageX(this.tempCoords.x);
                ((InputEvent)object2).setStageY(this.tempCoords.y);
                ((InputEvent)object2).setRelatedActor((Actor)object);
                ((InputEvent)object2).setPointer(i);
                ((Actor)object).fire((Event)object2);
                Pools.free(object2);
                continue;
            }
            object2[i] = this.fireEnterAndExit((Actor)object, this.pointerScreenX[i], this.pointerScreenY[i], i);
        }
        object = Gdx.app.getType();
        if (object == Application.ApplicationType.Desktop || object == Application.ApplicationType.Applet || object == Application.ApplicationType.WebGL) {
            this.mouseOverActor = this.fireEnterAndExit(this.mouseOverActor, this.mouseScreenX, this.mouseScreenY, -1);
        }
        this.root.act(f);
    }

    public void addAction(Action action) {
        this.root.addAction(action);
    }

    public void addActor(Actor actor) {
        this.root.addActor(actor);
    }

    public boolean addCaptureListener(EventListener eventListener) {
        return this.root.addCaptureListener(eventListener);
    }

    public boolean addListener(EventListener eventListener) {
        return this.root.addListener(eventListener);
    }

    public void addTouchFocus(EventListener eventListener, Actor actor, Actor actor2, int n, int n2) {
        TouchFocus touchFocus = Pools.obtain(TouchFocus.class);
        touchFocus.listenerActor = actor;
        touchFocus.target = actor2;
        touchFocus.listener = eventListener;
        touchFocus.pointer = n;
        touchFocus.button = n2;
        this.touchFocuses.add(touchFocus);
    }

    public void calculateScissors(Rectangle rectangle, Rectangle rectangle2) {
        Object object = this.debugShapes;
        object = object != null && ((ShapeRenderer)object).isDrawing() ? this.debugShapes.getTransformMatrix() : this.batch.getTransformMatrix();
        this.viewport.calculateScissors((Matrix4)object, rectangle, rectangle2);
    }

    public void cancelTouchFocus() {
        this.cancelTouchFocusExcept(null, null);
    }

    public void cancelTouchFocus(Actor actor) {
        InputEvent inputEvent = Pools.obtain(InputEvent.class);
        inputEvent.setStage(this);
        inputEvent.setType(InputEvent.Type.touchUp);
        inputEvent.setStageX(-2.1474836E9f);
        inputEvent.setStageY(-2.1474836E9f);
        SnapshotArray<TouchFocus> snapshotArray = this.touchFocuses;
        TouchFocus[] touchFocusArray = snapshotArray.begin();
        int n = snapshotArray.size;
        for (int i = 0; i < n; ++i) {
            TouchFocus touchFocus = touchFocusArray[i];
            if (touchFocus.listenerActor != actor || !snapshotArray.removeValue(touchFocus, true)) continue;
            inputEvent.setTarget(touchFocus.target);
            inputEvent.setListenerActor(touchFocus.listenerActor);
            inputEvent.setPointer(touchFocus.pointer);
            inputEvent.setButton(touchFocus.button);
            touchFocus.listener.handle(inputEvent);
        }
        snapshotArray.end();
        Pools.free(inputEvent);
    }

    public void cancelTouchFocusExcept(EventListener eventListener, Actor actor) {
        InputEvent inputEvent = Pools.obtain(InputEvent.class);
        inputEvent.setStage(this);
        inputEvent.setType(InputEvent.Type.touchUp);
        inputEvent.setStageX(-2.1474836E9f);
        inputEvent.setStageY(-2.1474836E9f);
        SnapshotArray<TouchFocus> snapshotArray = this.touchFocuses;
        TouchFocus[] touchFocusArray = snapshotArray.begin();
        int n = snapshotArray.size;
        for (int i = 0; i < n; ++i) {
            TouchFocus touchFocus = touchFocusArray[i];
            if (touchFocus.listener == eventListener && touchFocus.listenerActor == actor || !snapshotArray.removeValue(touchFocus, true)) continue;
            inputEvent.setTarget(touchFocus.target);
            inputEvent.setListenerActor(touchFocus.listenerActor);
            inputEvent.setPointer(touchFocus.pointer);
            inputEvent.setButton(touchFocus.button);
            touchFocus.listener.handle(inputEvent);
        }
        snapshotArray.end();
        Pools.free(inputEvent);
    }

    public void clear() {
        this.unfocusAll();
        this.root.clear();
    }

    @Override
    public void dispose() {
        this.clear();
        if (this.ownsBatch) {
            this.batch.dispose();
        }
    }

    public void draw() {
        Camera camera = this.viewport.getCamera();
        camera.update();
        if (!this.root.isVisible()) {
            return;
        }
        Batch batch = this.batch;
        batch.setProjectionMatrix(camera.combined);
        batch.begin();
        this.root.draw(batch, 1.0f);
        batch.end();
        if (debug) {
            this.drawDebug();
        }
    }

    public boolean getActionsRequestRendering() {
        return this.actionsRequestRendering;
    }

    public Array<Actor> getActors() {
        return this.root.children;
    }

    public Batch getBatch() {
        return this.batch;
    }

    public Camera getCamera() {
        return this.viewport.getCamera();
    }

    public Color getDebugColor() {
        return this.debugColor;
    }

    public float getHeight() {
        return this.viewport.getWorldHeight();
    }

    public Actor getKeyboardFocus() {
        return this.keyboardFocus;
    }

    public Group getRoot() {
        return this.root;
    }

    public Actor getScrollFocus() {
        return this.scrollFocus;
    }

    public Viewport getViewport() {
        return this.viewport;
    }

    public float getWidth() {
        return this.viewport.getWorldWidth();
    }

    public Actor hit(float f, float f2, boolean bl) {
        this.root.parentToLocalCoordinates(this.tempCoords.set(f, f2));
        return this.root.hit(this.tempCoords.x, this.tempCoords.y, bl);
    }

    public boolean isDebugAll() {
        return this.debugAll;
    }

    protected boolean isInsideViewport(int n, int n2) {
        int n3 = this.viewport.getScreenX();
        int n4 = this.viewport.getScreenWidth();
        int n5 = this.viewport.getScreenY();
        int n6 = this.viewport.getScreenHeight();
        int n7 = Gdx.graphics.getHeight();
        boolean bl = true;
        n2 = n7 - 1 - n2;
        if (n < n3 || n >= n4 + n3 || n2 < n5 || n2 >= n6 + n5) {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean keyDown(int n) {
        Object object = this.keyboardFocus;
        Actor actor = object;
        if (object == null) {
            actor = this.root;
        }
        object = Pools.obtain(InputEvent.class);
        ((Event)object).setStage(this);
        ((InputEvent)object).setType(InputEvent.Type.keyDown);
        ((InputEvent)object).setKeyCode(n);
        actor.fire((Event)object);
        boolean bl = ((Event)object).isHandled();
        Pools.free(object);
        return bl;
    }

    @Override
    public boolean keyTyped(char c) {
        Object object = this.keyboardFocus;
        Actor actor = object;
        if (object == null) {
            actor = this.root;
        }
        object = Pools.obtain(InputEvent.class);
        ((Event)object).setStage(this);
        ((InputEvent)object).setType(InputEvent.Type.keyTyped);
        ((InputEvent)object).setCharacter(c);
        actor.fire((Event)object);
        boolean bl = ((Event)object).isHandled();
        Pools.free(object);
        return bl;
    }

    @Override
    public boolean keyUp(int n) {
        Object object = this.keyboardFocus;
        Actor actor = object;
        if (object == null) {
            actor = this.root;
        }
        object = Pools.obtain(InputEvent.class);
        ((Event)object).setStage(this);
        ((InputEvent)object).setType(InputEvent.Type.keyUp);
        ((InputEvent)object).setKeyCode(n);
        actor.fire((Event)object);
        boolean bl = ((Event)object).isHandled();
        Pools.free(object);
        return bl;
    }

    @Override
    public boolean mouseMoved(int n, int n2) {
        Actor actor;
        this.mouseScreenX = n;
        this.mouseScreenY = n2;
        if (!this.isInsideViewport(n, n2)) {
            return false;
        }
        this.screenToStageCoordinates(this.tempCoords.set(n, n2));
        InputEvent inputEvent = Pools.obtain(InputEvent.class);
        inputEvent.setStage(this);
        inputEvent.setType(InputEvent.Type.mouseMoved);
        inputEvent.setStageX(this.tempCoords.x);
        inputEvent.setStageY(this.tempCoords.y);
        Actor actor2 = actor = this.hit(this.tempCoords.x, this.tempCoords.y, true);
        if (actor == null) {
            actor2 = this.root;
        }
        actor2.fire(inputEvent);
        boolean bl = inputEvent.isHandled();
        Pools.free(inputEvent);
        return bl;
    }

    public boolean removeCaptureListener(EventListener eventListener) {
        return this.root.removeCaptureListener(eventListener);
    }

    public boolean removeListener(EventListener eventListener) {
        return this.root.removeListener(eventListener);
    }

    public void removeTouchFocus(EventListener eventListener, Actor actor, Actor actor2, int n, int n2) {
        SnapshotArray<TouchFocus> snapshotArray = this.touchFocuses;
        for (int i = snapshotArray.size - 1; i >= 0; --i) {
            TouchFocus touchFocus = (TouchFocus)snapshotArray.get(i);
            if (touchFocus.listener != eventListener || touchFocus.listenerActor != actor || touchFocus.target != actor2 || touchFocus.pointer != n || touchFocus.button != n2) continue;
            snapshotArray.removeIndex(i);
            Pools.free(touchFocus);
        }
    }

    public Vector2 screenToStageCoordinates(Vector2 vector2) {
        this.viewport.unproject(vector2);
        return vector2;
    }

    @Override
    public boolean scrolled(int n) {
        Object object = this.scrollFocus;
        Actor actor = object;
        if (object == null) {
            actor = this.root;
        }
        this.screenToStageCoordinates(this.tempCoords.set(this.mouseScreenX, this.mouseScreenY));
        object = Pools.obtain(InputEvent.class);
        ((Event)object).setStage(this);
        ((InputEvent)object).setType(InputEvent.Type.scrolled);
        ((InputEvent)object).setScrollAmount(n);
        ((InputEvent)object).setStageX(this.tempCoords.x);
        ((InputEvent)object).setStageY(this.tempCoords.y);
        actor.fire((Event)object);
        boolean bl = ((Event)object).isHandled();
        Pools.free(object);
        return bl;
    }

    public void setActionsRequestRendering(boolean bl) {
        this.actionsRequestRendering = bl;
    }

    public void setDebugAll(boolean bl) {
        if (this.debugAll == bl) {
            return;
        }
        this.debugAll = bl;
        if (bl) {
            debug = true;
        } else {
            this.root.setDebug(false, true);
        }
    }

    public void setDebugInvisible(boolean bl) {
        this.debugInvisible = bl;
    }

    public void setDebugParentUnderMouse(boolean bl) {
        if (this.debugParentUnderMouse == bl) {
            return;
        }
        this.debugParentUnderMouse = bl;
        if (bl) {
            debug = true;
        } else {
            this.root.setDebug(false, true);
        }
    }

    public void setDebugTableUnderMouse(Table.Debug debug) {
        Table.Debug debug2 = debug;
        if (debug == null) {
            debug2 = Table.Debug.none;
        }
        if (this.debugTableUnderMouse == debug2) {
            return;
        }
        this.debugTableUnderMouse = debug2;
        if (debug2 != Table.Debug.none) {
            Stage.debug = true;
        } else {
            this.root.setDebug(false, true);
        }
    }

    public void setDebugTableUnderMouse(boolean bl) {
        Table.Debug debug = bl ? Table.Debug.all : Table.Debug.none;
        this.setDebugTableUnderMouse(debug);
    }

    public void setDebugUnderMouse(boolean bl) {
        if (this.debugUnderMouse == bl) {
            return;
        }
        this.debugUnderMouse = bl;
        if (bl) {
            debug = true;
        } else {
            this.root.setDebug(false, true);
        }
    }

    public boolean setKeyboardFocus(Actor actor) {
        boolean bl;
        if (this.keyboardFocus == actor) {
            return true;
        }
        FocusListener.FocusEvent focusEvent = Pools.obtain(FocusListener.FocusEvent.class);
        focusEvent.setStage(this);
        focusEvent.setType(FocusListener.FocusEvent.Type.keyboard);
        Actor actor2 = this.keyboardFocus;
        if (actor2 != null) {
            focusEvent.setFocused(false);
            focusEvent.setRelatedActor(actor);
            actor2.fire(focusEvent);
        }
        boolean bl2 = bl = focusEvent.isCancelled() ^ true;
        if (bl) {
            this.keyboardFocus = actor;
            bl2 = bl;
            if (actor != null) {
                focusEvent.setFocused(true);
                focusEvent.setRelatedActor(actor2);
                actor.fire(focusEvent);
                bl2 = bl = focusEvent.isCancelled() ^ true;
                if (!bl) {
                    this.keyboardFocus = actor2;
                    bl2 = bl;
                }
            }
        }
        Pools.free(focusEvent);
        return bl2;
    }

    public void setRoot(Group group) {
        if (group.parent != null) {
            group.parent.removeActor(group, false);
        }
        this.root = group;
        group.setParent(null);
        group.setStage(this);
    }

    public boolean setScrollFocus(Actor actor) {
        boolean bl;
        if (this.scrollFocus == actor) {
            return true;
        }
        FocusListener.FocusEvent focusEvent = Pools.obtain(FocusListener.FocusEvent.class);
        focusEvent.setStage(this);
        focusEvent.setType(FocusListener.FocusEvent.Type.scroll);
        Actor actor2 = this.scrollFocus;
        if (actor2 != null) {
            focusEvent.setFocused(false);
            focusEvent.setRelatedActor(actor);
            actor2.fire(focusEvent);
        }
        boolean bl2 = bl = focusEvent.isCancelled() ^ true;
        if (bl) {
            this.scrollFocus = actor;
            bl2 = bl;
            if (actor != null) {
                focusEvent.setFocused(true);
                focusEvent.setRelatedActor(actor2);
                actor.fire(focusEvent);
                bl2 = bl = focusEvent.isCancelled() ^ true;
                if (!bl) {
                    this.scrollFocus = actor2;
                    bl2 = bl;
                }
            }
        }
        Pools.free(focusEvent);
        return bl2;
    }

    public void setViewport(Viewport viewport) {
        this.viewport = viewport;
    }

    public Vector2 stageToScreenCoordinates(Vector2 vector2) {
        this.viewport.project(vector2);
        vector2.y = (float)this.viewport.getScreenHeight() - vector2.y;
        return vector2;
    }

    public Vector2 toScreenCoordinates(Vector2 vector2, Matrix4 matrix4) {
        return this.viewport.toScreenCoordinates(vector2, matrix4);
    }

    @Override
    public boolean touchDown(int n, int n2, int n3, int n4) {
        if (!this.isInsideViewport(n, n2)) {
            return false;
        }
        this.pointerTouched[n3] = true;
        this.pointerScreenX[n3] = n;
        this.pointerScreenY[n3] = n2;
        this.screenToStageCoordinates(this.tempCoords.set(n, n2));
        InputEvent inputEvent = Pools.obtain(InputEvent.class);
        inputEvent.setType(InputEvent.Type.touchDown);
        inputEvent.setStage(this);
        inputEvent.setStageX(this.tempCoords.x);
        inputEvent.setStageY(this.tempCoords.y);
        inputEvent.setPointer(n3);
        inputEvent.setButton(n4);
        Actor actor = this.hit(this.tempCoords.x, this.tempCoords.y, true);
        if (actor == null) {
            if (this.root.getTouchable() == Touchable.enabled) {
                this.root.fire(inputEvent);
            }
        } else {
            actor.fire(inputEvent);
        }
        boolean bl = inputEvent.isHandled();
        Pools.free(inputEvent);
        return bl;
    }

    @Override
    public boolean touchDragged(int n, int n2, int n3) {
        this.pointerScreenX[n3] = n;
        this.pointerScreenY[n3] = n2;
        this.mouseScreenX = n;
        this.mouseScreenY = n2;
        int n4 = this.touchFocuses.size;
        int n5 = 0;
        if (n4 == 0) {
            return false;
        }
        this.screenToStageCoordinates(this.tempCoords.set(n, n2));
        InputEvent inputEvent = Pools.obtain(InputEvent.class);
        inputEvent.setType(InputEvent.Type.touchDragged);
        inputEvent.setStage(this);
        inputEvent.setStageX(this.tempCoords.x);
        inputEvent.setStageY(this.tempCoords.y);
        inputEvent.setPointer(n3);
        SnapshotArray<TouchFocus> snapshotArray = this.touchFocuses;
        TouchFocus[] touchFocusArray = snapshotArray.begin();
        n2 = snapshotArray.size;
        for (n = n5; n < n2; ++n) {
            TouchFocus touchFocus = touchFocusArray[n];
            if (touchFocus.pointer != n3 || !snapshotArray.contains(touchFocus, true)) continue;
            inputEvent.setTarget(touchFocus.target);
            inputEvent.setListenerActor(touchFocus.listenerActor);
            if (!touchFocus.listener.handle(inputEvent)) continue;
            inputEvent.handle();
        }
        snapshotArray.end();
        boolean bl = inputEvent.isHandled();
        Pools.free(inputEvent);
        return bl;
    }

    @Override
    public boolean touchUp(int n, int n2, int n3, int n4) {
        Object object = this.pointerTouched;
        int n5 = 0;
        object[n3] = false;
        this.pointerScreenX[n3] = n;
        this.pointerScreenY[n3] = n2;
        if (this.touchFocuses.size == 0) {
            return false;
        }
        this.screenToStageCoordinates(this.tempCoords.set(n, n2));
        InputEvent inputEvent = Pools.obtain(InputEvent.class);
        inputEvent.setType(InputEvent.Type.touchUp);
        inputEvent.setStage(this);
        inputEvent.setStageX(this.tempCoords.x);
        inputEvent.setStageY(this.tempCoords.y);
        inputEvent.setPointer(n3);
        inputEvent.setButton(n4);
        SnapshotArray<TouchFocus> snapshotArray = this.touchFocuses;
        TouchFocus[] touchFocusArray = snapshotArray.begin();
        n2 = snapshotArray.size;
        for (n = n5; n < n2; ++n) {
            object = touchFocusArray[n];
            if (object.pointer != n3 || object.button != n4 || !snapshotArray.removeValue((TouchFocus)object, true)) continue;
            inputEvent.setTarget(object.target);
            inputEvent.setListenerActor(object.listenerActor);
            if (object.listener.handle(inputEvent)) {
                inputEvent.handle();
            }
            Pools.free(object);
        }
        snapshotArray.end();
        boolean bl = inputEvent.isHandled();
        Pools.free(inputEvent);
        return bl;
    }

    public void unfocus(Actor actor) {
        this.cancelTouchFocus(actor);
        Actor actor2 = this.scrollFocus;
        if (actor2 != null && actor2.isDescendantOf(actor)) {
            this.setScrollFocus(null);
        }
        if ((actor2 = this.keyboardFocus) != null && actor2.isDescendantOf(actor)) {
            this.setKeyboardFocus(null);
        }
    }

    public void unfocusAll() {
        this.setScrollFocus(null);
        this.setKeyboardFocus(null);
        this.cancelTouchFocus();
    }

    public static final class TouchFocus
    implements Pool.Poolable {
        int button;
        EventListener listener;
        Actor listenerActor;
        int pointer;
        Actor target;

        @Override
        public void reset() {
            this.listenerActor = null;
            this.listener = null;
            this.target = null;
        }
    }
}

