/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.utils.Cullable;
import com.badlogic.gdx.utils.SnapshotArray;

public class Group
extends Actor
implements Cullable {
    private static final Vector2 tmp = new Vector2();
    final SnapshotArray<Actor> children = new SnapshotArray(true, 4, Actor.class);
    private final Matrix4 computedTransform;
    private Rectangle cullingArea;
    private final Matrix4 oldTransform;
    boolean transform = true;
    private final Affine2 worldTransform = new Affine2();

    public Group() {
        this.computedTransform = new Matrix4();
        this.oldTransform = new Matrix4();
    }

    @Override
    public void act(float f) {
        super.act(f);
        Actor[] actorArray = this.children.begin();
        int n = this.children.size;
        for (int i = 0; i < n; ++i) {
            actorArray[i].act(f);
        }
        this.children.end();
    }

    public void addActor(Actor actor) {
        if (actor.parent != null) {
            if (actor.parent == this) {
                return;
            }
            actor.parent.removeActor(actor, false);
        }
        this.children.add(actor);
        actor.setParent(this);
        actor.setStage(this.getStage());
        this.childrenChanged();
    }

    public void addActorAfter(Actor actor, Actor actor2) {
        int n;
        if (actor2.parent != null) {
            if (actor2.parent == this) {
                return;
            }
            actor2.parent.removeActor(actor2, false);
        }
        if ((n = this.children.indexOf(actor, true)) == this.children.size) {
            this.children.add(actor2);
        } else {
            this.children.insert(n + 1, actor2);
        }
        actor2.setParent(this);
        actor2.setStage(this.getStage());
        this.childrenChanged();
    }

    public void addActorAt(int n, Actor actor) {
        if (actor.parent != null) {
            if (actor.parent == this) {
                return;
            }
            actor.parent.removeActor(actor, false);
        }
        if (n >= this.children.size) {
            this.children.add(actor);
        } else {
            this.children.insert(n, actor);
        }
        actor.setParent(this);
        actor.setStage(this.getStage());
        this.childrenChanged();
    }

    public void addActorBefore(Actor actor, Actor actor2) {
        if (actor2.parent != null) {
            if (actor2.parent == this) {
                return;
            }
            actor2.parent.removeActor(actor2, false);
        }
        int n = this.children.indexOf(actor, true);
        this.children.insert(n, actor2);
        actor2.setParent(this);
        actor2.setStage(this.getStage());
        this.childrenChanged();
    }

    protected void applyTransform(Batch batch, Matrix4 matrix4) {
        this.oldTransform.set(batch.getTransformMatrix());
        batch.setTransformMatrix(matrix4);
    }

    protected void applyTransform(ShapeRenderer shapeRenderer, Matrix4 matrix4) {
        this.oldTransform.set(shapeRenderer.getTransformMatrix());
        shapeRenderer.setTransformMatrix(matrix4);
        shapeRenderer.flush();
    }

    protected void childrenChanged() {
    }

    @Override
    public void clear() {
        super.clear();
        this.clearChildren();
    }

    public void clearChildren() {
        Actor[] actorArray = this.children.begin();
        int n = this.children.size;
        for (int i = 0; i < n; ++i) {
            Actor actor = actorArray[i];
            actor.setStage(null);
            actor.setParent(null);
        }
        this.children.end();
        this.children.clear();
        this.childrenChanged();
    }

    protected Matrix4 computeTransform() {
        Affine2 affine2 = this.worldTransform;
        float f = this.originX;
        float f2 = this.originY;
        affine2.setToTrnRotScl(this.x + f, this.y + f2, this.rotation, this.scaleX, this.scaleY);
        if (f != 0.0f || f2 != 0.0f) {
            affine2.translate(-f, -f2);
        }
        Group group = this.parent;
        while (group != null && !group.transform) {
            group = group.parent;
        }
        if (group != null) {
            affine2.preMul(group.worldTransform);
        }
        this.computedTransform.set(affine2);
        return this.computedTransform;
    }

    public Group debugAll() {
        this.setDebug(true, true);
        return this;
    }

    @Override
    public void draw(Batch batch, float f) {
        if (this.transform) {
            this.applyTransform(batch, this.computeTransform());
        }
        this.drawChildren(batch, f);
        if (this.transform) {
            this.resetTransform(batch);
        }
    }

    protected void drawChildren(Batch batch, float f) {
        int n;
        float f2 = this.color.a * f;
        SnapshotArray<Actor> snapshotArray = this.children;
        Actor[] actorArray = snapshotArray.begin();
        Object object = this.cullingArea;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (object != null) {
            float f3 = ((Rectangle)object).x;
            float f4 = ((Rectangle)object).width + f3;
            float f5 = ((Rectangle)object).y;
            f = ((Rectangle)object).height + f5;
            if (this.transform) {
                n2 = snapshotArray.size;
                for (n = 0; n < n2; ++n) {
                    object = actorArray[n];
                    if (!((Actor)object).isVisible()) continue;
                    float f6 = ((Actor)object).x;
                    float f7 = ((Actor)object).y;
                    if (!(f6 <= f4) || !(f7 <= f) || !(f6 + ((Actor)object).width >= f3) || !(f7 + ((Actor)object).height >= f5)) continue;
                    ((Actor)object).draw(batch, f2);
                }
            } else {
                float f8 = this.x;
                float f9 = this.y;
                this.x = 0.0f;
                this.y = 0.0f;
                n3 = snapshotArray.size;
                for (n = n2; n < n3; ++n) {
                    object = actorArray[n];
                    if (!((Actor)object).isVisible()) continue;
                    float f10 = ((Actor)object).x;
                    float f11 = ((Actor)object).y;
                    if (!(f10 <= f4) || !(f11 <= f) || !(((Actor)object).width + f10 >= f3) || !(((Actor)object).height + f11 >= f5)) continue;
                    ((Actor)object).x = f10 + f8;
                    ((Actor)object).y = f11 + f9;
                    ((Actor)object).draw(batch, f2);
                    ((Actor)object).x = f10;
                    ((Actor)object).y = f11;
                }
                this.x = f8;
                this.y = f9;
            }
        } else if (this.transform) {
            n2 = snapshotArray.size;
            for (n = n3; n < n2; ++n) {
                object = actorArray[n];
                if (!((Actor)object).isVisible()) continue;
                ((Actor)object).draw(batch, f2);
            }
        } else {
            float f12 = this.x;
            float f13 = this.y;
            this.x = 0.0f;
            this.y = 0.0f;
            n2 = snapshotArray.size;
            for (n = n4; n < n2; ++n) {
                object = actorArray[n];
                if (!((Actor)object).isVisible()) continue;
                float f14 = ((Actor)object).x;
                f = ((Actor)object).y;
                ((Actor)object).x = f14 + f12;
                ((Actor)object).y = f + f13;
                ((Actor)object).draw(batch, f2);
                ((Actor)object).x = f14;
                ((Actor)object).y = f;
            }
            this.x = f12;
            this.y = f13;
        }
        snapshotArray.end();
    }

    @Override
    public void drawDebug(ShapeRenderer shapeRenderer) {
        this.drawDebugBounds(shapeRenderer);
        if (this.transform) {
            this.applyTransform(shapeRenderer, this.computeTransform());
        }
        this.drawDebugChildren(shapeRenderer);
        if (this.transform) {
            this.resetTransform(shapeRenderer);
        }
    }

    protected void drawDebugChildren(ShapeRenderer shapeRenderer) {
        int n;
        SnapshotArray<Actor> snapshotArray = this.children;
        Actor[] actorArray = snapshotArray.begin();
        boolean bl = this.transform;
        int n2 = 0;
        if (bl) {
            n2 = snapshotArray.size;
            for (n = 0; n < n2; ++n) {
                Actor actor = actorArray[n];
                if (!actor.isVisible() || !actor.getDebug() && !(actor instanceof Group)) continue;
                actor.drawDebug(shapeRenderer);
            }
            shapeRenderer.flush();
        } else {
            float f = this.x;
            float f2 = this.y;
            this.x = 0.0f;
            this.y = 0.0f;
            int n3 = snapshotArray.size;
            for (n = n2; n < n3; ++n) {
                Actor actor = actorArray[n];
                if (!actor.isVisible() || !actor.getDebug() && !(actor instanceof Group)) continue;
                float f3 = actor.x;
                float f4 = actor.y;
                actor.x = f3 + f;
                actor.y = f4 + f2;
                actor.drawDebug(shapeRenderer);
                actor.x = f3;
                actor.y = f4;
            }
            this.x = f;
            this.y = f2;
        }
        snapshotArray.end();
    }

    public <T extends Actor> T findActor(String string2) {
        int n;
        SnapshotArray<Actor> snapshotArray = this.children;
        int n2 = snapshotArray.size;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            if (!string2.equals(((Actor)snapshotArray.get(n)).getName())) continue;
            return (T)((Actor)snapshotArray.get(n));
        }
        n2 = snapshotArray.size;
        for (n = n3; n < n2; ++n) {
            Actor actor = (Actor)snapshotArray.get(n);
            if (!(actor instanceof Group) || (actor = ((Group)actor).findActor(string2)) == null) continue;
            return (T)actor;
        }
        return null;
    }

    public Actor getChild(int n) {
        return (Actor)this.children.get(n);
    }

    public SnapshotArray<Actor> getChildren() {
        return this.children;
    }

    public Rectangle getCullingArea() {
        return this.cullingArea;
    }

    public boolean hasChildren() {
        boolean bl = this.children.size > 0;
        return bl;
    }

    @Override
    public Actor hit(float f, float f2, boolean bl) {
        if (bl && this.getTouchable() == Touchable.disabled) {
            return null;
        }
        if (!this.isVisible()) {
            return null;
        }
        Vector2 vector2 = tmp;
        Actor[] actorArray = (Actor[])this.children.items;
        for (int i = this.children.size - 1; i >= 0; --i) {
            Actor actor = actorArray[i];
            actor.parentToLocalCoordinates(vector2.set(f, f2));
            actor = actor.hit(vector2.x, vector2.y, bl);
            if (actor == null) continue;
            return actor;
        }
        return super.hit(f, f2, bl);
    }

    public boolean isTransform() {
        return this.transform;
    }

    public Vector2 localToDescendantCoordinates(Actor actor, Vector2 serializable) {
        Group group = actor.parent;
        if (group != null) {
            if (group != this) {
                this.localToDescendantCoordinates(group, (Vector2)serializable);
            }
            actor.parentToLocalCoordinates((Vector2)serializable);
            return serializable;
        }
        serializable = new StringBuilder();
        ((StringBuilder)serializable).append("Child is not a descendant: ");
        ((StringBuilder)serializable).append(actor);
        throw new IllegalArgumentException(((StringBuilder)serializable).toString());
    }

    public boolean removeActor(Actor actor) {
        return this.removeActor(actor, true);
    }

    public boolean removeActor(Actor actor, boolean bl) {
        Stage stage;
        if (!this.children.removeValue(actor, true)) {
            return false;
        }
        if (bl && (stage = this.getStage()) != null) {
            stage.unfocus(actor);
        }
        actor.setParent(null);
        actor.setStage(null);
        this.childrenChanged();
        return true;
    }

    protected void resetTransform(Batch batch) {
        batch.setTransformMatrix(this.oldTransform);
    }

    protected void resetTransform(ShapeRenderer shapeRenderer) {
        shapeRenderer.setTransformMatrix(this.oldTransform);
    }

    @Override
    public void setCullingArea(Rectangle rectangle) {
        this.cullingArea = rectangle;
    }

    public void setDebug(boolean bl, boolean bl2) {
        this.setDebug(bl);
        if (bl2) {
            for (Actor actor : this.children) {
                if (actor instanceof Group) {
                    ((Group)actor).setDebug(bl, bl2);
                    continue;
                }
                actor.setDebug(bl);
            }
        }
    }

    @Override
    protected void setStage(Stage stage) {
        super.setStage(stage);
        Actor[] actorArray = (Actor[])this.children.items;
        int n = this.children.size;
        for (int i = 0; i < n; ++i) {
            actorArray[i].setStage(stage);
        }
    }

    public void setTransform(boolean bl) {
        this.transform = bl;
    }

    public boolean swapActor(int n, int n2) {
        int n3 = this.children.size;
        if (n >= 0 && n < n3 && n2 >= 0 && n2 < n3) {
            this.children.swap(n, n2);
            return true;
        }
        return false;
    }

    public boolean swapActor(Actor actor, Actor actor2) {
        int n = this.children.indexOf(actor, true);
        int n2 = this.children.indexOf(actor2, true);
        if (n != -1 && n2 != -1) {
            this.children.swap(n, n2);
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        this.toString(stringBuilder, 1);
        stringBuilder.setLength(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    void toString(StringBuilder stringBuilder, int n) {
        stringBuilder.append(super.toString());
        stringBuilder.append('\n');
        Actor[] actorArray = this.children.begin();
        int n2 = this.children.size;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                stringBuilder.append("|  ");
            }
            Actor actor = actorArray[i];
            if (actor instanceof Group) {
                ((Group)actor).toString(stringBuilder, n + 1);
                continue;
            }
            stringBuilder.append(actor);
            stringBuilder.append('\n');
        }
        this.children.end();
    }
}

