/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.GeometryUtils;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Shape2D;
import com.badlogic.gdx.math.Vector2;

public class Polygon
implements Shape2D {
    private Rectangle bounds;
    private boolean dirty = true;
    private float[] localVertices;
    private float originX;
    private float originY;
    private float rotation;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float[] worldVertices;
    private float x;
    private float y;

    public Polygon() {
        this.localVertices = new float[0];
    }

    public Polygon(float[] fArray) {
        if (fArray.length >= 6) {
            this.localVertices = fArray;
            return;
        }
        throw new IllegalArgumentException("polygons must contain at least 3 points.");
    }

    public float area() {
        float[] fArray = this.getTransformedVertices();
        return GeometryUtils.polygonArea(fArray, 0, fArray.length);
    }

    @Override
    public boolean contains(float f, float f2) {
        float[] fArray = this.getTransformedVertices();
        int n = fArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4;
            int n5;
            block7: {
                float f3;
                float f4;
                float f5;
                float f6;
                block6: {
                    f6 = fArray[n2];
                    f5 = fArray[n2 + 1];
                    n5 = n2 + 2;
                    f4 = fArray[n5 % n];
                    f3 = fArray[(n2 + 3) % n];
                    if (f5 <= f2 && f2 < f3) break block6;
                    n4 = n3;
                    if (!(f3 <= f2)) break block7;
                    n4 = n3;
                    if (!(f2 < f5)) break block7;
                }
                n4 = n3;
                if (f < (f4 - f6) / (f3 - f5) * (f2 - f5) + f6) {
                    n4 = n3 + 1;
                }
            }
            n2 = n5;
            n3 = n4;
        }
        boolean bl = true;
        if (!(n3 & true)) {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean contains(Vector2 vector2) {
        return this.contains(vector2.x, vector2.y);
    }

    public void dirty() {
        this.dirty = true;
    }

    public Rectangle getBoundingRectangle() {
        Object object = this.getTransformedVertices();
        float f = object[0];
        float f2 = object[1];
        float f3 = object[0];
        float f4 = object[1];
        int n = ((float[])object).length;
        for (int i = 2; i < n; i += 2) {
            float f5 = f;
            if (f > object[i]) {
                f5 = object[i];
            }
            int n2 = i + 1;
            float f6 = f2;
            if (f2 > object[n2]) {
                f6 = object[n2];
            }
            f = f3;
            if (f3 < object[i]) {
                f = object[i];
            }
            f2 = f4;
            if (f4 < object[n2]) {
                f2 = object[n2];
            }
            f3 = f;
            f = f5;
            f4 = f2;
            f2 = f6;
        }
        if (this.bounds == null) {
            this.bounds = new Rectangle();
        }
        object = this.bounds;
        object.x = f;
        object.y = f2;
        object.width = f3 - f;
        object.height = f4 - f2;
        return object;
    }

    public float getOriginX() {
        return this.originX;
    }

    public float getOriginY() {
        return this.originY;
    }

    public float getRotation() {
        return this.rotation;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public float[] getTransformedVertices() {
        if (!this.dirty) {
            return this.worldVertices;
        }
        int n = 0;
        this.dirty = false;
        float[] fArray = this.localVertices;
        float[] fArray2 = this.worldVertices;
        if (fArray2 == null || fArray2.length != fArray.length) {
            this.worldVertices = new float[fArray.length];
        }
        fArray2 = this.worldVertices;
        float f = this.x;
        float f2 = this.y;
        float f3 = this.originX;
        float f4 = this.originY;
        float f5 = this.scaleX;
        float f6 = this.scaleY;
        boolean bl = f5 != 1.0f || f6 != 1.0f;
        float f7 = this.rotation;
        float f8 = MathUtils.cosDeg(f7);
        float f9 = MathUtils.sinDeg(f7);
        int n2 = fArray.length;
        while (n < n2) {
            float f10 = fArray[n] - f3;
            int n3 = n + 1;
            float f11 = fArray[n3] - f4;
            float f12 = f10;
            float f13 = f11;
            if (bl) {
                f12 = f10 * f5;
                f13 = f11 * f6;
            }
            f10 = f12;
            f11 = f13;
            if (f7 != 0.0f) {
                f11 = f12 * f9 + f13 * f8;
                f10 = f8 * f12 - f9 * f13;
            }
            fArray2[n] = f10 + f + f3;
            fArray2[n3] = f2 + f11 + f4;
            n += 2;
        }
        return fArray2;
    }

    public float[] getVertices() {
        return this.localVertices;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public void rotate(float f) {
        this.rotation += f;
        this.dirty = true;
    }

    public void scale(float f) {
        this.scaleX += f;
        this.scaleY += f;
        this.dirty = true;
    }

    public void setOrigin(float f, float f2) {
        this.originX = f;
        this.originY = f2;
        this.dirty = true;
    }

    public void setPosition(float f, float f2) {
        this.x = f;
        this.y = f2;
        this.dirty = true;
    }

    public void setRotation(float f) {
        this.rotation = f;
        this.dirty = true;
    }

    public void setScale(float f, float f2) {
        this.scaleX = f;
        this.scaleY = f2;
        this.dirty = true;
    }

    public void setVertices(float[] fArray) {
        if (fArray.length >= 6) {
            this.localVertices = fArray;
            this.dirty = true;
            return;
        }
        throw new IllegalArgumentException("polygons must contain at least 3 points.");
    }

    public void translate(float f, float f2) {
        this.x += f;
        this.y += f2;
        this.dirty = true;
    }
}

