/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import java.io.Serializable;

public class Matrix4
implements Serializable {
    public static final int M00 = 0;
    public static final int M01 = 4;
    public static final int M02 = 8;
    public static final int M03 = 12;
    public static final int M10 = 1;
    public static final int M11 = 5;
    public static final int M12 = 9;
    public static final int M13 = 13;
    public static final int M20 = 2;
    public static final int M21 = 6;
    public static final int M22 = 10;
    public static final int M23 = 14;
    public static final int M30 = 3;
    public static final int M31 = 7;
    public static final int M32 = 11;
    public static final int M33 = 15;
    static final Vector3 l_vex;
    static final Vector3 l_vey;
    static final Vector3 l_vez;
    static Quaternion quat;
    static Quaternion quat2;
    static final Vector3 right;
    private static final long serialVersionUID = -2717655254359579617L;
    private static final float[] tmp;
    static final Vector3 tmpForward;
    static final Matrix4 tmpMat;
    static final Vector3 tmpUp;
    static final Vector3 tmpVec;
    public final float[] val;

    static {
        tmp = new float[16];
        quat = new Quaternion();
        quat2 = new Quaternion();
        l_vez = new Vector3();
        l_vex = new Vector3();
        l_vey = new Vector3();
        tmpVec = new Vector3();
        tmpMat = new Matrix4();
        right = new Vector3();
        tmpForward = new Vector3();
        tmpUp = new Vector3();
    }

    public Matrix4() {
        float[] fArray = this.val = new float[16];
        fArray[0] = 1.0f;
        fArray[5] = 1.0f;
        fArray[10] = 1.0f;
        fArray[15] = 1.0f;
    }

    public Matrix4(Matrix4 matrix4) {
        this.val = new float[16];
        this.set(matrix4);
    }

    public Matrix4(Quaternion quaternion) {
        this.val = new float[16];
        this.set(quaternion);
    }

    public Matrix4(Vector3 vector3, Quaternion quaternion, Vector3 vector32) {
        this.val = new float[16];
        this.set(vector3, quaternion, vector32);
    }

    public Matrix4(float[] fArray) {
        this.val = new float[16];
        this.set(fArray);
    }

    public static native float det(float[] var0);

    public static native boolean inv(float[] var0);

    public static native void mul(float[] var0, float[] var1);

    public static native void mulVec(float[] var0, float[] var1);

    public static native void mulVec(float[] var0, float[] var1, int var2, int var3, int var4);

    public static native void prj(float[] var0, float[] var1);

    public static native void prj(float[] var0, float[] var1, int var2, int var3, int var4);

    public static native void rot(float[] var0, float[] var1);

    public static native void rot(float[] var0, float[] var1, int var2, int var3, int var4);

    public Matrix4 avg(Matrix4 serializable, float f) {
        this.getScale(tmpVec);
        ((Matrix4)serializable).getScale(tmpForward);
        this.getRotation(quat);
        ((Matrix4)serializable).getRotation(quat2);
        this.getTranslation(tmpUp);
        ((Matrix4)serializable).getTranslation(right);
        serializable = tmpVec.scl(f);
        Vector3 vector3 = tmpForward;
        float f2 = 1.0f - f;
        this.setToScaling(((Vector3)serializable).add(vector3.scl(f2)));
        this.rotate(quat.slerp(quat2, f2));
        this.setTranslation(tmpUp.scl(f).add(right.scl(f2)));
        return this;
    }

    public Matrix4 avg(Matrix4[] matrix4Array) {
        float f = 1.0f / (float)matrix4Array.length;
        tmpVec.set(matrix4Array[0].getScale(tmpUp).scl(f));
        quat.set(matrix4Array[0].getRotation(quat2).exp(f));
        tmpForward.set(matrix4Array[0].getTranslation(tmpUp).scl(f));
        for (int i = 1; i < matrix4Array.length; ++i) {
            tmpVec.add(matrix4Array[i].getScale(tmpUp).scl(f));
            quat.mul(matrix4Array[i].getRotation(quat2).exp(f));
            tmpForward.add(matrix4Array[i].getTranslation(tmpUp).scl(f));
        }
        quat.nor();
        this.setToScaling(tmpVec);
        this.rotate(quat);
        this.setTranslation(tmpForward);
        return this;
    }

    public Matrix4 avg(Matrix4[] matrix4Array, float[] fArray) {
        tmpVec.set(matrix4Array[0].getScale(tmpUp).scl(fArray[0]));
        quat.set(matrix4Array[0].getRotation(quat2).exp(fArray[0]));
        tmpForward.set(matrix4Array[0].getTranslation(tmpUp).scl(fArray[0]));
        for (int i = 1; i < matrix4Array.length; ++i) {
            tmpVec.add(matrix4Array[i].getScale(tmpUp).scl(fArray[i]));
            quat.mul(matrix4Array[i].getRotation(quat2).exp(fArray[i]));
            tmpForward.add(matrix4Array[i].getTranslation(tmpUp).scl(fArray[i]));
        }
        quat.nor();
        this.setToScaling(tmpVec);
        this.rotate(quat);
        this.setTranslation(tmpForward);
        return this;
    }

    public Matrix4 cpy() {
        return new Matrix4(this);
    }

    public float det() {
        float[] fArray = this.val;
        return fArray[3] * fArray[6] * fArray[9] * fArray[12] - fArray[2] * fArray[7] * fArray[9] * fArray[12] - fArray[3] * fArray[5] * fArray[10] * fArray[12] + fArray[1] * fArray[7] * fArray[10] * fArray[12] + fArray[2] * fArray[5] * fArray[11] * fArray[12] - fArray[1] * fArray[6] * fArray[11] * fArray[12] - fArray[3] * fArray[6] * fArray[8] * fArray[13] + fArray[2] * fArray[7] * fArray[8] * fArray[13] + fArray[3] * fArray[4] * fArray[10] * fArray[13] - fArray[0] * fArray[7] * fArray[10] * fArray[13] - fArray[2] * fArray[4] * fArray[11] * fArray[13] + fArray[0] * fArray[6] * fArray[11] * fArray[13] + fArray[3] * fArray[5] * fArray[8] * fArray[14] - fArray[1] * fArray[7] * fArray[8] * fArray[14] - fArray[3] * fArray[4] * fArray[9] * fArray[14] + fArray[0] * fArray[7] * fArray[9] * fArray[14] + fArray[1] * fArray[4] * fArray[11] * fArray[14] - fArray[0] * fArray[5] * fArray[11] * fArray[14] - fArray[2] * fArray[5] * fArray[8] * fArray[15] + fArray[1] * fArray[6] * fArray[8] * fArray[15] + fArray[2] * fArray[4] * fArray[9] * fArray[15] - fArray[0] * fArray[6] * fArray[9] * fArray[15] - fArray[1] * fArray[4] * fArray[10] * fArray[15] + fArray[0] * fArray[5] * fArray[10] * fArray[15];
    }

    public float det3x3() {
        float[] fArray = this.val;
        return fArray[0] * fArray[5] * fArray[10] + fArray[4] * fArray[9] * fArray[2] + fArray[8] * fArray[1] * fArray[6] - fArray[0] * fArray[9] * fArray[6] - fArray[4] * fArray[1] * fArray[10] - fArray[8] * fArray[5] * fArray[2];
    }

    public void extract4x3Matrix(float[] fArray) {
        float[] fArray2 = this.val;
        fArray[0] = fArray2[0];
        fArray[1] = fArray2[1];
        fArray[2] = fArray2[2];
        fArray[3] = fArray2[4];
        fArray[4] = fArray2[5];
        fArray[5] = fArray2[6];
        fArray[6] = fArray2[8];
        fArray[7] = fArray2[9];
        fArray[8] = fArray2[10];
        fArray[9] = fArray2[12];
        fArray[10] = fArray2[13];
        fArray[11] = fArray2[14];
    }

    public Quaternion getRotation(Quaternion quaternion) {
        return quaternion.setFromMatrix(this);
    }

    public Quaternion getRotation(Quaternion quaternion, boolean bl) {
        return quaternion.setFromMatrix(bl, this);
    }

    public Vector3 getScale(Vector3 vector3) {
        return vector3.set(this.getScaleX(), this.getScaleY(), this.getScaleZ());
    }

    public float getScaleX() {
        float f = MathUtils.isZero(this.val[4]) && MathUtils.isZero(this.val[8]) ? Math.abs(this.val[0]) : (float)Math.sqrt(this.getScaleXSquared());
        return f;
    }

    public float getScaleXSquared() {
        float[] fArray = this.val;
        return fArray[0] * fArray[0] + fArray[4] * fArray[4] + fArray[8] * fArray[8];
    }

    public float getScaleY() {
        float f = MathUtils.isZero(this.val[1]) && MathUtils.isZero(this.val[9]) ? Math.abs(this.val[5]) : (float)Math.sqrt(this.getScaleYSquared());
        return f;
    }

    public float getScaleYSquared() {
        float[] fArray = this.val;
        return fArray[1] * fArray[1] + fArray[5] * fArray[5] + fArray[9] * fArray[9];
    }

    public float getScaleZ() {
        float f = MathUtils.isZero(this.val[2]) && MathUtils.isZero(this.val[6]) ? Math.abs(this.val[10]) : (float)Math.sqrt(this.getScaleZSquared());
        return f;
    }

    public float getScaleZSquared() {
        float[] fArray = this.val;
        return fArray[2] * fArray[2] + fArray[6] * fArray[6] + fArray[10] * fArray[10];
    }

    public Vector3 getTranslation(Vector3 vector3) {
        float[] fArray = this.val;
        vector3.x = fArray[12];
        vector3.y = fArray[13];
        vector3.z = fArray[14];
        return vector3;
    }

    public float[] getValues() {
        return this.val;
    }

    public boolean hasRotationOrScaling() {
        float[] fArray = this.val;
        boolean bl = false;
        if (!(MathUtils.isEqual(fArray[0], 1.0f) && MathUtils.isEqual(this.val[5], 1.0f) && MathUtils.isEqual(this.val[10], 1.0f) && MathUtils.isZero(this.val[4]) && MathUtils.isZero(this.val[8]) && MathUtils.isZero(this.val[1]) && MathUtils.isZero(this.val[9]) && MathUtils.isZero(this.val[2]) && MathUtils.isZero(this.val[6]))) {
            bl = true;
        }
        return bl;
    }

    public Matrix4 idt() {
        float[] fArray = this.val;
        fArray[0] = 1.0f;
        fArray[4] = 0.0f;
        fArray[8] = 0.0f;
        fArray[12] = 0.0f;
        fArray[1] = 0.0f;
        fArray[5] = 1.0f;
        fArray[9] = 0.0f;
        fArray[13] = 0.0f;
        fArray[2] = 0.0f;
        fArray[6] = 0.0f;
        fArray[10] = 1.0f;
        fArray[14] = 0.0f;
        fArray[3] = 0.0f;
        fArray[7] = 0.0f;
        fArray[11] = 0.0f;
        fArray[15] = 1.0f;
        return this;
    }

    public Matrix4 inv() {
        float[] fArray = this.val;
        float f = fArray[3] * fArray[6] * fArray[9] * fArray[12] - fArray[2] * fArray[7] * fArray[9] * fArray[12] - fArray[3] * fArray[5] * fArray[10] * fArray[12] + fArray[1] * fArray[7] * fArray[10] * fArray[12] + fArray[2] * fArray[5] * fArray[11] * fArray[12] - fArray[1] * fArray[6] * fArray[11] * fArray[12] - fArray[3] * fArray[6] * fArray[8] * fArray[13] + fArray[2] * fArray[7] * fArray[8] * fArray[13] + fArray[3] * fArray[4] * fArray[10] * fArray[13] - fArray[0] * fArray[7] * fArray[10] * fArray[13] - fArray[2] * fArray[4] * fArray[11] * fArray[13] + fArray[0] * fArray[6] * fArray[11] * fArray[13] + fArray[3] * fArray[5] * fArray[8] * fArray[14] - fArray[1] * fArray[7] * fArray[8] * fArray[14] - fArray[3] * fArray[4] * fArray[9] * fArray[14] + fArray[0] * fArray[7] * fArray[9] * fArray[14] + fArray[1] * fArray[4] * fArray[11] * fArray[14] - fArray[0] * fArray[5] * fArray[11] * fArray[14] - fArray[2] * fArray[5] * fArray[8] * fArray[15] + fArray[1] * fArray[6] * fArray[8] * fArray[15] + fArray[2] * fArray[4] * fArray[9] * fArray[15] - fArray[0] * fArray[6] * fArray[9] * fArray[15] - fArray[1] * fArray[4] * fArray[10] * fArray[15] + fArray[0] * fArray[5] * fArray[10] * fArray[15];
        if (f != 0.0f) {
            f = 1.0f / f;
            float[] fArray2 = tmp;
            fArray2[0] = fArray[9] * fArray[14] * fArray[7] - fArray[13] * fArray[10] * fArray[7] + fArray[13] * fArray[6] * fArray[11] - fArray[5] * fArray[14] * fArray[11] - fArray[9] * fArray[6] * fArray[15] + fArray[5] * fArray[10] * fArray[15];
            fArray2[4] = fArray[12] * fArray[10] * fArray[7] - fArray[8] * fArray[14] * fArray[7] - fArray[12] * fArray[6] * fArray[11] + fArray[4] * fArray[14] * fArray[11] + fArray[8] * fArray[6] * fArray[15] - fArray[4] * fArray[10] * fArray[15];
            fArray2[8] = fArray[8] * fArray[13] * fArray[7] - fArray[12] * fArray[9] * fArray[7] + fArray[12] * fArray[5] * fArray[11] - fArray[4] * fArray[13] * fArray[11] - fArray[8] * fArray[5] * fArray[15] + fArray[4] * fArray[9] * fArray[15];
            fArray2[12] = fArray[12] * fArray[9] * fArray[6] - fArray[8] * fArray[13] * fArray[6] - fArray[12] * fArray[5] * fArray[10] + fArray[4] * fArray[13] * fArray[10] + fArray[8] * fArray[5] * fArray[14] - fArray[4] * fArray[9] * fArray[14];
            fArray2[1] = fArray[13] * fArray[10] * fArray[3] - fArray[9] * fArray[14] * fArray[3] - fArray[13] * fArray[2] * fArray[11] + fArray[1] * fArray[14] * fArray[11] + fArray[9] * fArray[2] * fArray[15] - fArray[1] * fArray[10] * fArray[15];
            fArray2[5] = fArray[8] * fArray[14] * fArray[3] - fArray[12] * fArray[10] * fArray[3] + fArray[12] * fArray[2] * fArray[11] - fArray[0] * fArray[14] * fArray[11] - fArray[8] * fArray[2] * fArray[15] + fArray[0] * fArray[10] * fArray[15];
            fArray2[9] = fArray[12] * fArray[9] * fArray[3] - fArray[8] * fArray[13] * fArray[3] - fArray[12] * fArray[1] * fArray[11] + fArray[0] * fArray[13] * fArray[11] + fArray[8] * fArray[1] * fArray[15] - fArray[0] * fArray[9] * fArray[15];
            fArray2[13] = fArray[8] * fArray[13] * fArray[2] - fArray[12] * fArray[9] * fArray[2] + fArray[12] * fArray[1] * fArray[10] - fArray[0] * fArray[13] * fArray[10] - fArray[8] * fArray[1] * fArray[14] + fArray[0] * fArray[9] * fArray[14];
            fArray2[2] = fArray[5] * fArray[14] * fArray[3] - fArray[13] * fArray[6] * fArray[3] + fArray[13] * fArray[2] * fArray[7] - fArray[1] * fArray[14] * fArray[7] - fArray[5] * fArray[2] * fArray[15] + fArray[1] * fArray[6] * fArray[15];
            fArray2[6] = fArray[12] * fArray[6] * fArray[3] - fArray[4] * fArray[14] * fArray[3] - fArray[12] * fArray[2] * fArray[7] + fArray[0] * fArray[14] * fArray[7] + fArray[4] * fArray[2] * fArray[15] - fArray[0] * fArray[6] * fArray[15];
            fArray2[10] = fArray[4] * fArray[13] * fArray[3] - fArray[12] * fArray[5] * fArray[3] + fArray[12] * fArray[1] * fArray[7] - fArray[0] * fArray[13] * fArray[7] - fArray[4] * fArray[1] * fArray[15] + fArray[0] * fArray[5] * fArray[15];
            fArray2[14] = fArray[12] * fArray[5] * fArray[2] - fArray[4] * fArray[13] * fArray[2] - fArray[12] * fArray[1] * fArray[6] + fArray[0] * fArray[13] * fArray[6] + fArray[4] * fArray[1] * fArray[14] - fArray[0] * fArray[5] * fArray[14];
            fArray2[3] = fArray[9] * fArray[6] * fArray[3] - fArray[5] * fArray[10] * fArray[3] - fArray[9] * fArray[2] * fArray[7] + fArray[1] * fArray[10] * fArray[7] + fArray[5] * fArray[2] * fArray[11] - fArray[1] * fArray[6] * fArray[11];
            fArray2[7] = fArray[4] * fArray[10] * fArray[3] - fArray[8] * fArray[6] * fArray[3] + fArray[8] * fArray[2] * fArray[7] - fArray[0] * fArray[10] * fArray[7] - fArray[4] * fArray[2] * fArray[11] + fArray[0] * fArray[6] * fArray[11];
            fArray2[11] = fArray[8] * fArray[5] * fArray[3] - fArray[4] * fArray[9] * fArray[3] - fArray[8] * fArray[1] * fArray[7] + fArray[0] * fArray[9] * fArray[7] + fArray[4] * fArray[1] * fArray[11] - fArray[0] * fArray[5] * fArray[11];
            fArray2[15] = fArray[4] * fArray[9] * fArray[2] - fArray[8] * fArray[5] * fArray[2] + fArray[8] * fArray[1] * fArray[6] - fArray[0] * fArray[9] * fArray[6] - fArray[4] * fArray[1] * fArray[10] + fArray[0] * fArray[5] * fArray[10];
            fArray[0] = fArray2[0] * f;
            fArray[4] = fArray2[4] * f;
            fArray[8] = fArray2[8] * f;
            fArray[12] = fArray2[12] * f;
            fArray[1] = fArray2[1] * f;
            fArray[5] = fArray2[5] * f;
            fArray[9] = fArray2[9] * f;
            fArray[13] = fArray2[13] * f;
            fArray[2] = fArray2[2] * f;
            fArray[6] = fArray2[6] * f;
            fArray[10] = fArray2[10] * f;
            fArray[14] = fArray2[14] * f;
            fArray[3] = fArray2[3] * f;
            fArray[7] = fArray2[7] * f;
            fArray[11] = fArray2[11] * f;
            fArray[15] = fArray2[15] * f;
            return this;
        }
        throw new RuntimeException("non-invertible matrix");
    }

    public Matrix4 lerp(Matrix4 matrix4, float f) {
        for (int i = 0; i < 16; ++i) {
            float[] fArray = this.val;
            fArray[i] = fArray[i] * (1.0f - f) + matrix4.val[i] * f;
        }
        return this;
    }

    public Matrix4 mul(Matrix4 matrix4) {
        Matrix4.mul(this.val, matrix4.val);
        return this;
    }

    public Matrix4 mulLeft(Matrix4 matrix4) {
        tmpMat.set(matrix4);
        Matrix4.mul(Matrix4.tmpMat.val, this.val);
        return this.set(tmpMat);
    }

    public Matrix4 rotate(float f, float f2, float f3, float f4) {
        if (f4 == 0.0f) {
            return this;
        }
        quat.setFromAxis(f, f2, f3, f4);
        return this.rotate(quat);
    }

    public Matrix4 rotate(Quaternion quaternion) {
        quaternion.toMatrix(tmp);
        Matrix4.mul(this.val, tmp);
        return this;
    }

    public Matrix4 rotate(Vector3 vector3, float f) {
        if (f == 0.0f) {
            return this;
        }
        quat.set(vector3, f);
        return this.rotate(quat);
    }

    public Matrix4 rotate(Vector3 vector3, Vector3 vector32) {
        return this.rotate(quat.setFromCross(vector3, vector32));
    }

    public Matrix4 rotateRad(float f, float f2, float f3, float f4) {
        if (f4 == 0.0f) {
            return this;
        }
        quat.setFromAxisRad(f, f2, f3, f4);
        return this.rotate(quat);
    }

    public Matrix4 rotateRad(Vector3 vector3, float f) {
        if (f == 0.0f) {
            return this;
        }
        quat.setFromAxisRad(vector3, f);
        return this.rotate(quat);
    }

    public Matrix4 scale(float f, float f2, float f3) {
        float[] fArray = tmp;
        fArray[0] = f;
        fArray[4] = 0.0f;
        fArray[8] = 0.0f;
        fArray[12] = 0.0f;
        fArray[1] = 0.0f;
        fArray[5] = f2;
        fArray[9] = 0.0f;
        fArray[13] = 0.0f;
        fArray[2] = 0.0f;
        fArray[6] = 0.0f;
        fArray[10] = f3;
        fArray[14] = 0.0f;
        fArray[3] = 0.0f;
        fArray[7] = 0.0f;
        fArray[11] = 0.0f;
        fArray[15] = 1.0f;
        Matrix4.mul(this.val, fArray);
        return this;
    }

    public Matrix4 scl(float f) {
        float[] fArray = this.val;
        fArray[0] = fArray[0] * f;
        fArray[5] = fArray[5] * f;
        fArray[10] = fArray[10] * f;
        return this;
    }

    public Matrix4 scl(float f, float f2, float f3) {
        float[] fArray = this.val;
        fArray[0] = fArray[0] * f;
        fArray[5] = fArray[5] * f2;
        fArray[10] = fArray[10] * f3;
        return this;
    }

    public Matrix4 scl(Vector3 vector3) {
        float[] fArray = this.val;
        fArray[0] = fArray[0] * vector3.x;
        fArray = this.val;
        fArray[5] = fArray[5] * vector3.y;
        fArray = this.val;
        fArray[10] = fArray[10] * vector3.z;
        return this;
    }

    public Matrix4 set(float f, float f2, float f3, float f4) {
        return this.set(0.0f, 0.0f, 0.0f, f, f2, f3, f4);
    }

    public Matrix4 set(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = f4 * 2.0f;
        float f9 = f5 * 2.0f;
        float f10 = 2.0f * f6;
        float f11 = f7 * f8;
        float f12 = f7 * f9;
        f7 *= f10;
        f8 *= f4;
        float f13 = f4 * f9;
        f4 *= f10;
        f9 *= f5;
        f5 *= f10;
        f6 = f10 * f6;
        float[] fArray = this.val;
        fArray[0] = 1.0f - (f9 + f6);
        fArray[4] = f13 - f7;
        fArray[8] = f4 + f12;
        fArray[12] = f;
        fArray[1] = f13 + f7;
        fArray[5] = 1.0f - (f6 + f8);
        fArray[9] = f5 - f11;
        fArray[13] = f2;
        fArray[2] = f4 - f12;
        fArray[6] = f5 + f11;
        fArray[10] = 1.0f - (f8 + f9);
        fArray[14] = f3;
        fArray[3] = 0.0f;
        fArray[7] = 0.0f;
        fArray[11] = 0.0f;
        fArray[15] = 1.0f;
        return this;
    }

    public Matrix4 set(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        float f11 = f4 * 2.0f;
        float f12 = f5 * 2.0f;
        float f13 = 2.0f * f6;
        float f14 = f7 * f11;
        float f15 = f7 * f12;
        f7 *= f13;
        f11 *= f4;
        float f16 = f4 * f12;
        f4 *= f13;
        f12 *= f5;
        f5 *= f13;
        f6 = f13 * f6;
        float[] fArray = this.val;
        fArray[0] = (1.0f - (f12 + f6)) * f8;
        fArray[4] = (f16 - f7) * f9;
        fArray[8] = (f4 + f15) * f10;
        fArray[12] = f;
        fArray[1] = f8 * (f16 + f7);
        fArray[5] = (1.0f - (f6 + f11)) * f9;
        fArray[9] = (f5 - f14) * f10;
        fArray[13] = f2;
        fArray[2] = f8 * (f4 - f15);
        fArray[6] = f9 * (f5 + f14);
        fArray[10] = (1.0f - (f11 + f12)) * f10;
        fArray[14] = f3;
        fArray[3] = 0.0f;
        fArray[7] = 0.0f;
        fArray[11] = 0.0f;
        fArray[15] = 1.0f;
        return this;
    }

    public Matrix4 set(Affine2 object) {
        this.val[0] = ((Affine2)object).m00;
        this.val[1] = ((Affine2)object).m10;
        float[] fArray = this.val;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = ((Affine2)object).m01;
        this.val[5] = ((Affine2)object).m11;
        fArray = this.val;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 0.0f;
        fArray[9] = 0.0f;
        fArray[10] = 1.0f;
        fArray[11] = 0.0f;
        fArray[12] = ((Affine2)object).m02;
        this.val[13] = ((Affine2)object).m12;
        object = this.val;
        object[14] = 0.0f;
        object[15] = 1.0f;
        return this;
    }

    public Matrix4 set(Matrix3 matrix3) {
        this.val[0] = matrix3.val[0];
        this.val[1] = matrix3.val[1];
        this.val[2] = matrix3.val[2];
        float[] fArray = this.val;
        fArray[3] = 0.0f;
        fArray[4] = matrix3.val[3];
        this.val[5] = matrix3.val[4];
        this.val[6] = matrix3.val[5];
        fArray = this.val;
        fArray[7] = 0.0f;
        fArray[8] = 0.0f;
        fArray[9] = 0.0f;
        fArray[10] = 1.0f;
        fArray[11] = 0.0f;
        fArray[12] = matrix3.val[6];
        this.val[13] = matrix3.val[7];
        fArray = this.val;
        fArray[14] = 0.0f;
        fArray[15] = matrix3.val[8];
        return this;
    }

    public Matrix4 set(Matrix4 matrix4) {
        return this.set(matrix4.val);
    }

    public Matrix4 set(Quaternion quaternion) {
        return this.set(quaternion.x, quaternion.y, quaternion.z, quaternion.w);
    }

    public Matrix4 set(Vector3 vector3, Quaternion quaternion) {
        return this.set(vector3.x, vector3.y, vector3.z, quaternion.x, quaternion.y, quaternion.z, quaternion.w);
    }

    public Matrix4 set(Vector3 vector3, Quaternion quaternion, Vector3 vector32) {
        return this.set(vector3.x, vector3.y, vector3.z, quaternion.x, quaternion.y, quaternion.z, quaternion.w, vector32.x, vector32.y, vector32.z);
    }

    public Matrix4 set(Vector3 object, Vector3 vector3, Vector3 vector32, Vector3 vector33) {
        this.val[0] = ((Vector3)object).x;
        this.val[4] = ((Vector3)object).y;
        this.val[8] = ((Vector3)object).z;
        this.val[1] = vector3.x;
        this.val[5] = vector3.y;
        this.val[9] = vector3.z;
        this.val[2] = vector32.x;
        this.val[6] = vector32.y;
        this.val[10] = vector32.z;
        this.val[12] = vector33.x;
        this.val[13] = vector33.y;
        this.val[14] = vector33.z;
        object = this.val;
        object[3] = 0.0f;
        object[7] = 0.0f;
        object[11] = 0.0f;
        object[15] = 1.0f;
        return this;
    }

    public Matrix4 set(float[] fArray) {
        float[] fArray2 = this.val;
        System.arraycopy(fArray, 0, fArray2, 0, fArray2.length);
        return this;
    }

    public Matrix4 setAsAffine(Affine2 affine2) {
        this.val[0] = affine2.m00;
        this.val[1] = affine2.m10;
        this.val[4] = affine2.m01;
        this.val[5] = affine2.m11;
        this.val[12] = affine2.m02;
        this.val[13] = affine2.m12;
        return this;
    }

    public Matrix4 setAsAffine(Matrix4 object) {
        float[] fArray = this.val;
        object = ((Matrix4)object).val;
        fArray[0] = (float)object[0];
        fArray[1] = (float)object[1];
        fArray[4] = (float)object[4];
        fArray[5] = (float)object[5];
        fArray[12] = (float)object[12];
        fArray[13] = (float)object[13];
        return this;
    }

    public Matrix4 setFromEulerAngles(float f, float f2, float f3) {
        quat.setEulerAngles(f, f2, f3);
        return this.set(quat);
    }

    public Matrix4 setFromEulerAnglesRad(float f, float f2, float f3) {
        quat.setEulerAnglesRad(f, f2, f3);
        return this.set(quat);
    }

    public Matrix4 setToLookAt(Vector3 vector3, Vector3 vector32) {
        l_vez.set(vector3).nor();
        l_vex.set(vector3).nor();
        l_vex.crs(vector32).nor();
        l_vey.set(l_vex).crs(l_vez).nor();
        this.idt();
        this.val[0] = Matrix4.l_vex.x;
        this.val[4] = Matrix4.l_vex.y;
        this.val[8] = Matrix4.l_vex.z;
        this.val[1] = Matrix4.l_vey.x;
        this.val[5] = Matrix4.l_vey.y;
        this.val[9] = Matrix4.l_vey.z;
        this.val[2] = -Matrix4.l_vez.x;
        this.val[6] = -Matrix4.l_vez.y;
        this.val[10] = -Matrix4.l_vez.z;
        return this;
    }

    public Matrix4 setToLookAt(Vector3 vector3, Vector3 vector32, Vector3 vector33) {
        tmpVec.set(vector32).sub(vector3);
        this.setToLookAt(tmpVec, vector33);
        this.mul(tmpMat.setToTranslation(-vector3.x, -vector3.y, -vector3.z));
        return this;
    }

    public Matrix4 setToOrtho(float f, float f2, float f3, float f4, float f5, float f6) {
        this.idt();
        float f7 = f2 - f;
        float f8 = 2.0f / f7;
        float f9 = f4 - f3;
        float f10 = 2.0f / f9;
        float f11 = f6 - f5;
        float f12 = -2.0f / f11;
        f = -(f2 + f) / f7;
        f2 = -(f4 + f3) / f9;
        f3 = -(f6 + f5) / f11;
        float[] fArray = this.val;
        fArray[0] = f8;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = 0.0f;
        fArray[5] = f10;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 0.0f;
        fArray[9] = 0.0f;
        fArray[10] = f12;
        fArray[11] = 0.0f;
        fArray[12] = f;
        fArray[13] = f2;
        fArray[14] = f3;
        fArray[15] = 1.0f;
        return this;
    }

    public Matrix4 setToOrtho2D(float f, float f2, float f3, float f4) {
        this.setToOrtho(f, f + f3, f2, f2 + f4, 0.0f, 1.0f);
        return this;
    }

    public Matrix4 setToOrtho2D(float f, float f2, float f3, float f4, float f5, float f6) {
        this.setToOrtho(f, f + f3, f2, f2 + f4, f5, f6);
        return this;
    }

    public Matrix4 setToProjection(float f, float f2, float f3, float f4) {
        this.idt();
        double d = f3;
        Double.isNaN(d);
        float f5 = (float)(1.0 / Math.tan(d * (Math.PI / 180) / 2.0));
        float f6 = f - f2;
        f3 = (f2 + f) / f6;
        f = f2 * 2.0f * f / f6;
        float[] fArray = this.val;
        fArray[0] = f5 / f4;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = 0.0f;
        fArray[5] = f5;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 0.0f;
        fArray[9] = 0.0f;
        fArray[10] = f3;
        fArray[11] = -1.0f;
        fArray[12] = 0.0f;
        fArray[13] = 0.0f;
        fArray[14] = f;
        fArray[15] = 0.0f;
        return this;
    }

    public Matrix4 setToProjection(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = f5 * 2.0f;
        float f8 = f2 - f;
        float f9 = f7 / f8;
        float f10 = f4 - f3;
        f7 /= f10;
        f = (f2 + f) / f8;
        f2 = (f4 + f3) / f10;
        f4 = f5 - f6;
        f3 = (f6 + f5) / f4;
        f4 = f6 * 2.0f * f5 / f4;
        float[] fArray = this.val;
        fArray[0] = f9;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = 0.0f;
        fArray[5] = f7;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = f;
        fArray[9] = f2;
        fArray[10] = f3;
        fArray[11] = -1.0f;
        fArray[12] = 0.0f;
        fArray[13] = 0.0f;
        fArray[14] = f4;
        fArray[15] = 0.0f;
        return this;
    }

    public Matrix4 setToRotation(float f, float f2, float f3, float f4) {
        if (f4 == 0.0f) {
            this.idt();
            return this;
        }
        return this.set(quat.setFromAxis(f, f2, f3, f4));
    }

    public Matrix4 setToRotation(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.set(quat.setFromCross(f, f2, f3, f4, f5, f6));
    }

    public Matrix4 setToRotation(Vector3 vector3, float f) {
        if (f == 0.0f) {
            this.idt();
            return this;
        }
        return this.set(quat.set(vector3, f));
    }

    public Matrix4 setToRotation(Vector3 vector3, Vector3 vector32) {
        return this.set(quat.setFromCross(vector3, vector32));
    }

    public Matrix4 setToRotationRad(float f, float f2, float f3, float f4) {
        if (f4 == 0.0f) {
            this.idt();
            return this;
        }
        return this.set(quat.setFromAxisRad(f, f2, f3, f4));
    }

    public Matrix4 setToRotationRad(Vector3 vector3, float f) {
        if (f == 0.0f) {
            this.idt();
            return this;
        }
        return this.set(quat.setFromAxisRad(vector3, f));
    }

    public Matrix4 setToScaling(float f, float f2, float f3) {
        this.idt();
        float[] fArray = this.val;
        fArray[0] = f;
        fArray[5] = f2;
        fArray[10] = f3;
        return this;
    }

    public Matrix4 setToScaling(Vector3 vector3) {
        this.idt();
        this.val[0] = vector3.x;
        this.val[5] = vector3.y;
        this.val[10] = vector3.z;
        return this;
    }

    public Matrix4 setToTranslation(float f, float f2, float f3) {
        this.idt();
        float[] fArray = this.val;
        fArray[12] = f;
        fArray[13] = f2;
        fArray[14] = f3;
        return this;
    }

    public Matrix4 setToTranslation(Vector3 vector3) {
        this.idt();
        this.val[12] = vector3.x;
        this.val[13] = vector3.y;
        this.val[14] = vector3.z;
        return this;
    }

    public Matrix4 setToTranslationAndScaling(float f, float f2, float f3, float f4, float f5, float f6) {
        this.idt();
        float[] fArray = this.val;
        fArray[12] = f;
        fArray[13] = f2;
        fArray[14] = f3;
        fArray[0] = f4;
        fArray[5] = f5;
        fArray[10] = f6;
        return this;
    }

    public Matrix4 setToTranslationAndScaling(Vector3 vector3, Vector3 vector32) {
        this.idt();
        this.val[12] = vector3.x;
        this.val[13] = vector3.y;
        this.val[14] = vector3.z;
        this.val[0] = vector32.x;
        this.val[5] = vector32.y;
        this.val[10] = vector32.z;
        return this;
    }

    public Matrix4 setToWorld(Vector3 vector3, Vector3 vector32, Vector3 vector33) {
        tmpForward.set(vector32).nor();
        right.set(tmpForward).crs(vector33).nor();
        tmpUp.set(right).crs(tmpForward).nor();
        this.set(right, tmpUp, tmpForward.scl(-1.0f), vector3);
        return this;
    }

    public Matrix4 setTranslation(float f, float f2, float f3) {
        float[] fArray = this.val;
        fArray[12] = f;
        fArray[13] = f2;
        fArray[14] = f3;
        return this;
    }

    public Matrix4 setTranslation(Vector3 vector3) {
        this.val[12] = vector3.x;
        this.val[13] = vector3.y;
        this.val[14] = vector3.z;
        return this;
    }

    public Matrix4 toNormalMatrix() {
        float[] fArray = this.val;
        fArray[12] = 0.0f;
        fArray[13] = 0.0f;
        fArray[14] = 0.0f;
        return this.inv().tra();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append(this.val[0]);
        stringBuilder.append("|");
        stringBuilder.append(this.val[4]);
        stringBuilder.append("|");
        stringBuilder.append(this.val[8]);
        stringBuilder.append("|");
        stringBuilder.append(this.val[12]);
        stringBuilder.append("]\n[");
        stringBuilder.append(this.val[1]);
        stringBuilder.append("|");
        stringBuilder.append(this.val[5]);
        stringBuilder.append("|");
        stringBuilder.append(this.val[9]);
        stringBuilder.append("|");
        stringBuilder.append(this.val[13]);
        stringBuilder.append("]\n[");
        stringBuilder.append(this.val[2]);
        stringBuilder.append("|");
        stringBuilder.append(this.val[6]);
        stringBuilder.append("|");
        stringBuilder.append(this.val[10]);
        stringBuilder.append("|");
        stringBuilder.append(this.val[14]);
        stringBuilder.append("]\n[");
        stringBuilder.append(this.val[3]);
        stringBuilder.append("|");
        stringBuilder.append(this.val[7]);
        stringBuilder.append("|");
        stringBuilder.append(this.val[11]);
        stringBuilder.append("|");
        stringBuilder.append(this.val[15]);
        stringBuilder.append("]\n");
        return stringBuilder.toString();
    }

    public Matrix4 tra() {
        float[] fArray = tmp;
        float[] fArray2 = this.val;
        fArray[0] = fArray2[0];
        fArray[4] = fArray2[1];
        fArray[8] = fArray2[2];
        fArray[12] = fArray2[3];
        fArray[1] = fArray2[4];
        fArray[5] = fArray2[5];
        fArray[9] = fArray2[6];
        fArray[13] = fArray2[7];
        fArray[2] = fArray2[8];
        fArray[6] = fArray2[9];
        fArray[10] = fArray2[10];
        fArray[14] = fArray2[11];
        fArray[3] = fArray2[12];
        fArray[7] = fArray2[13];
        fArray[11] = fArray2[14];
        fArray[15] = fArray2[15];
        return this.set(fArray);
    }

    public Matrix4 translate(float f, float f2, float f3) {
        float[] fArray = tmp;
        fArray[0] = 1.0f;
        fArray[4] = 0.0f;
        fArray[8] = 0.0f;
        fArray[12] = f;
        fArray[1] = 0.0f;
        fArray[5] = 1.0f;
        fArray[9] = 0.0f;
        fArray[13] = f2;
        fArray[2] = 0.0f;
        fArray[6] = 0.0f;
        fArray[10] = 1.0f;
        fArray[14] = f3;
        fArray[3] = 0.0f;
        fArray[7] = 0.0f;
        fArray[11] = 0.0f;
        fArray[15] = 1.0f;
        Matrix4.mul(this.val, fArray);
        return this;
    }

    public Matrix4 translate(Vector3 vector3) {
        return this.translate(vector3.x, vector3.y, vector3.z);
    }

    public Matrix4 trn(float f, float f2, float f3) {
        float[] fArray = this.val;
        fArray[12] = fArray[12] + f;
        fArray[13] = fArray[13] + f2;
        fArray[14] = fArray[14] + f3;
        return this;
    }

    public Matrix4 trn(Vector3 vector3) {
        float[] fArray = this.val;
        fArray[12] = fArray[12] + vector3.x;
        fArray = this.val;
        fArray[13] = fArray[13] + vector3.y;
        fArray = this.val;
        fArray[14] = fArray[14] + vector3.z;
        return this;
    }
}

