/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.Serializable;

public class Matrix3
implements Serializable {
    public static final int M00 = 0;
    public static final int M01 = 3;
    public static final int M02 = 6;
    public static final int M10 = 1;
    public static final int M11 = 4;
    public static final int M12 = 7;
    public static final int M20 = 2;
    public static final int M21 = 5;
    public static final int M22 = 8;
    private static final long serialVersionUID = 7907569533774959788L;
    private float[] tmp;
    public float[] val = new float[9];

    public Matrix3() {
        this.tmp = new float[9];
        this.idt();
    }

    public Matrix3(Matrix3 matrix3) {
        this.tmp = new float[9];
        this.set(matrix3);
    }

    public Matrix3(float[] fArray) {
        this.tmp = new float[9];
        this.set(fArray);
    }

    private static void mul(float[] fArray, float[] fArray2) {
        float f = fArray[0];
        float f2 = fArray2[0];
        float f3 = fArray[3];
        float f4 = fArray2[1];
        float f5 = fArray[6];
        float f6 = fArray2[2];
        float f7 = fArray[0];
        float f8 = fArray2[3];
        float f9 = fArray[3];
        float f10 = fArray2[4];
        float f11 = fArray[6];
        float f12 = fArray2[5];
        float f13 = fArray[0];
        float f14 = fArray2[6];
        float f15 = fArray[3];
        float f16 = fArray2[7];
        float f17 = fArray[6];
        float f18 = fArray2[8];
        float f19 = fArray[1];
        float f20 = fArray2[0];
        float f21 = fArray[4];
        float f22 = fArray2[1];
        float f23 = fArray[7];
        float f24 = fArray2[2];
        float f25 = fArray[1];
        float f26 = fArray2[3];
        float f27 = fArray[4];
        float f28 = fArray2[4];
        float f29 = fArray[7];
        float f30 = fArray2[5];
        float f31 = fArray[1];
        float f32 = fArray2[6];
        float f33 = fArray[4];
        float f34 = fArray2[7];
        float f35 = fArray[7];
        float f36 = fArray2[8];
        float f37 = fArray[2];
        float f38 = fArray2[0];
        float f39 = fArray[5];
        float f40 = fArray2[1];
        float f41 = fArray[8];
        float f42 = fArray2[2];
        float f43 = fArray[2];
        float f44 = fArray2[3];
        float f45 = fArray[5];
        float f46 = fArray2[4];
        float f47 = fArray[8];
        float f48 = fArray2[5];
        float f49 = fArray[2];
        float f50 = fArray2[6];
        float f51 = fArray[5];
        float f52 = fArray2[7];
        float f53 = fArray[8];
        float f54 = fArray2[8];
        fArray[0] = f * f2 + f3 * f4 + f5 * f6;
        fArray[1] = f19 * f20 + f21 * f22 + f23 * f24;
        fArray[2] = f37 * f38 + f39 * f40 + f41 * f42;
        fArray[3] = f7 * f8 + f9 * f10 + f11 * f12;
        fArray[4] = f25 * f26 + f27 * f28 + f29 * f30;
        fArray[5] = f43 * f44 + f45 * f46 + f47 * f48;
        fArray[6] = f13 * f14 + f15 * f16 + f17 * f18;
        fArray[7] = f31 * f32 + f33 * f34 + f35 * f36;
        fArray[8] = f49 * f50 + f51 * f52 + f53 * f54;
    }

    public float det() {
        float[] fArray = this.val;
        return fArray[0] * fArray[4] * fArray[8] + fArray[3] * fArray[7] * fArray[2] + fArray[6] * fArray[1] * fArray[5] - fArray[0] * fArray[7] * fArray[5] - fArray[3] * fArray[1] * fArray[8] - fArray[6] * fArray[4] * fArray[2];
    }

    public float getRotation() {
        float[] fArray = this.val;
        return (float)Math.atan2(fArray[1], fArray[0]) * 57.295776f;
    }

    public float getRotationRad() {
        float[] fArray = this.val;
        return (float)Math.atan2(fArray[1], fArray[0]);
    }

    public Vector2 getScale(Vector2 vector2) {
        float[] fArray = this.val;
        vector2.x = (float)Math.sqrt(fArray[0] * fArray[0] + fArray[3] * fArray[3]);
        vector2.y = (float)Math.sqrt(fArray[1] * fArray[1] + fArray[4] * fArray[4]);
        return vector2;
    }

    public Vector2 getTranslation(Vector2 vector2) {
        float[] fArray = this.val;
        vector2.x = fArray[6];
        vector2.y = fArray[7];
        return vector2;
    }

    public float[] getValues() {
        return this.val;
    }

    public Matrix3 idt() {
        float[] fArray = this.val;
        fArray[0] = 1.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = 1.0f;
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
        return this;
    }

    public Matrix3 inv() {
        float f = this.det();
        if (f != 0.0f) {
            f = 1.0f / f;
            float[] fArray = this.tmp;
            float[] fArray2 = this.val;
            fArray[0] = fArray2[4] * fArray2[8] - fArray2[5] * fArray2[7];
            fArray[1] = fArray2[2] * fArray2[7] - fArray2[1] * fArray2[8];
            fArray[2] = fArray2[1] * fArray2[5] - fArray2[2] * fArray2[4];
            fArray[3] = fArray2[5] * fArray2[6] - fArray2[3] * fArray2[8];
            fArray[4] = fArray2[0] * fArray2[8] - fArray2[2] * fArray2[6];
            fArray[5] = fArray2[2] * fArray2[3] - fArray2[0] * fArray2[5];
            fArray[6] = fArray2[3] * fArray2[7] - fArray2[4] * fArray2[6];
            fArray[7] = fArray2[1] * fArray2[6] - fArray2[0] * fArray2[7];
            fArray[8] = fArray2[0] * fArray2[4] - fArray2[1] * fArray2[3];
            fArray2[0] = fArray[0] * f;
            fArray2[1] = fArray[1] * f;
            fArray2[2] = fArray[2] * f;
            fArray2[3] = fArray[3] * f;
            fArray2[4] = fArray[4] * f;
            fArray2[5] = fArray[5] * f;
            fArray2[6] = fArray[6] * f;
            fArray2[7] = fArray[7] * f;
            fArray2[8] = f * fArray[8];
            return this;
        }
        throw new GdxRuntimeException("Can't invert a singular matrix");
    }

    public Matrix3 mul(Matrix3 object) {
        float[] fArray = this.val;
        float f = fArray[0];
        object = ((Matrix3)object).val;
        Object object2 = object[0];
        float f2 = fArray[3];
        Object object3 = object[1];
        float f3 = fArray[6];
        Object object4 = object[2];
        float f4 = fArray[0];
        Object object5 = object[3];
        float f5 = fArray[3];
        Object object6 = object[4];
        float f6 = fArray[6];
        Object object7 = object[5];
        float f7 = fArray[0];
        Object object8 = object[6];
        float f8 = fArray[3];
        Object object9 = object[7];
        float f9 = fArray[6];
        Object object10 = object[8];
        float f10 = fArray[1];
        Object object11 = object[0];
        float f11 = fArray[4];
        Object object12 = object[1];
        float f12 = fArray[7];
        Object object13 = object[2];
        float f13 = fArray[1];
        Object object14 = object[3];
        float f14 = fArray[4];
        Object object15 = object[4];
        float f15 = fArray[7];
        Object object16 = object[5];
        float f16 = fArray[1];
        Object object17 = object[6];
        float f17 = fArray[4];
        Object object18 = object[7];
        float f18 = fArray[7];
        Object object19 = object[8];
        float f19 = fArray[2];
        Object object20 = object[0];
        float f20 = fArray[5];
        Object object21 = object[1];
        float f21 = fArray[8];
        Object object22 = object[2];
        float f22 = fArray[2];
        Object object23 = object[3];
        float f23 = fArray[5];
        Object object24 = object[4];
        float f24 = fArray[8];
        Object object25 = object[5];
        float f25 = fArray[2];
        Object object26 = object[6];
        float f26 = fArray[5];
        Object object27 = object[7];
        float f27 = fArray[8];
        Object object28 = object[8];
        fArray[0] = f * object2 + f2 * object3 + f3 * object4;
        fArray[1] = f10 * object11 + f11 * object12 + f12 * object13;
        fArray[2] = f19 * object20 + f20 * object21 + f21 * object22;
        fArray[3] = f4 * object5 + f5 * object6 + f6 * object7;
        fArray[4] = f13 * object14 + f14 * object15 + f15 * object16;
        fArray[5] = f22 * object23 + f23 * object24 + f24 * object25;
        fArray[6] = f7 * object8 + f8 * object9 + f9 * object10;
        fArray[7] = f16 * object17 + f17 * object18 + f18 * object19;
        fArray[8] = f25 * object26 + f26 * object27 + f27 * object28;
        return this;
    }

    public Matrix3 mulLeft(Matrix3 object) {
        float[] fArray = this.val;
        object = ((Matrix3)object).val;
        Object object2 = object[0];
        float f = fArray[0];
        Object object3 = object[3];
        float f2 = fArray[1];
        Object object4 = object[6];
        float f3 = fArray[2];
        Object object5 = object[0];
        float f4 = fArray[3];
        Object object6 = object[3];
        float f5 = fArray[4];
        Object object7 = object[6];
        float f6 = fArray[5];
        Object object8 = object[0];
        float f7 = fArray[6];
        Object object9 = object[3];
        float f8 = fArray[7];
        Object object10 = object[6];
        float f9 = fArray[8];
        Object object11 = object[1];
        float f10 = fArray[0];
        Object object12 = object[4];
        float f11 = fArray[1];
        Object object13 = object[7];
        float f12 = fArray[2];
        Object object14 = object[1];
        float f13 = fArray[3];
        Object object15 = object[4];
        float f14 = fArray[4];
        Object object16 = object[7];
        float f15 = fArray[5];
        Object object17 = object[1];
        float f16 = fArray[6];
        Object object18 = object[4];
        float f17 = fArray[7];
        Object object19 = object[7];
        float f18 = fArray[8];
        Object object20 = object[2];
        float f19 = fArray[0];
        Object object21 = object[5];
        float f20 = fArray[1];
        Object object22 = object[8];
        float f21 = fArray[2];
        Object object23 = object[2];
        float f22 = fArray[3];
        Object object24 = object[5];
        float f23 = fArray[4];
        Object object25 = object[8];
        float f24 = fArray[5];
        Object object26 = object[2];
        float f25 = fArray[6];
        Object object27 = object[5];
        float f26 = fArray[7];
        Object object28 = object[8];
        float f27 = fArray[8];
        fArray[0] = (float)(object2 * f + object3 * f2 + object4 * f3);
        fArray[1] = (float)(object11 * f10 + object12 * f11 + object13 * f12);
        fArray[2] = (float)(object20 * f19 + object21 * f20 + object22 * f21);
        fArray[3] = (float)(object5 * f4 + object6 * f5 + object7 * f6);
        fArray[4] = (float)(object14 * f13 + object15 * f14 + object16 * f15);
        fArray[5] = (float)(object23 * f22 + object24 * f23 + object25 * f24);
        fArray[6] = (float)(object8 * f7 + object9 * f8 + object10 * f9);
        fArray[7] = (float)(object17 * f16 + object18 * f17 + object19 * f18);
        fArray[8] = (float)(object26 * f25 + object27 * f26 + object28 * f27);
        return this;
    }

    public Matrix3 rotate(float f) {
        return this.rotateRad(f * ((float)Math.PI / 180));
    }

    public Matrix3 rotateRad(float f) {
        if (f == 0.0f) {
            return this;
        }
        double d = f;
        float f2 = (float)Math.cos(d);
        f = (float)Math.sin(d);
        float[] fArray = this.tmp;
        fArray[0] = f2;
        fArray[1] = f;
        fArray[2] = 0.0f;
        fArray[3] = -f;
        fArray[4] = f2;
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
        Matrix3.mul(this.val, fArray);
        return this;
    }

    public Matrix3 scale(float f, float f2) {
        float[] fArray = this.tmp;
        fArray[0] = f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = f2;
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
        Matrix3.mul(this.val, fArray);
        return this;
    }

    public Matrix3 scale(Vector2 vector2) {
        float[] fArray = this.tmp;
        fArray[0] = vector2.x;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = vector2.y;
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
        Matrix3.mul(this.val, fArray);
        return this;
    }

    public Matrix3 scl(float f) {
        float[] fArray = this.val;
        fArray[0] = fArray[0] * f;
        fArray[4] = fArray[4] * f;
        return this;
    }

    public Matrix3 scl(Vector2 vector2) {
        float[] fArray = this.val;
        fArray[0] = fArray[0] * vector2.x;
        fArray = this.val;
        fArray[4] = fArray[4] * vector2.y;
        return this;
    }

    public Matrix3 scl(Vector3 vector3) {
        float[] fArray = this.val;
        fArray[0] = fArray[0] * vector3.x;
        fArray = this.val;
        fArray[4] = fArray[4] * vector3.y;
        return this;
    }

    public Matrix3 set(Affine2 affine2) {
        float[] fArray = this.val;
        fArray[0] = affine2.m00;
        fArray[1] = affine2.m10;
        fArray[2] = 0.0f;
        fArray[3] = affine2.m01;
        fArray[4] = affine2.m11;
        fArray[5] = 0.0f;
        fArray[6] = affine2.m02;
        fArray[7] = affine2.m12;
        fArray[8] = 1.0f;
        return this;
    }

    public Matrix3 set(Matrix3 object) {
        object = ((Matrix3)object).val;
        float[] fArray = this.val;
        System.arraycopy(object, 0, fArray, 0, fArray.length);
        return this;
    }

    public Matrix3 set(Matrix4 matrix4) {
        float[] fArray = this.val;
        fArray[0] = matrix4.val[0];
        fArray[1] = matrix4.val[1];
        fArray[2] = matrix4.val[2];
        fArray[3] = matrix4.val[4];
        fArray[4] = matrix4.val[5];
        fArray[5] = matrix4.val[6];
        fArray[6] = matrix4.val[8];
        fArray[7] = matrix4.val[9];
        fArray[8] = matrix4.val[10];
        return this;
    }

    public Matrix3 set(float[] fArray) {
        float[] fArray2 = this.val;
        System.arraycopy(fArray, 0, fArray2, 0, fArray2.length);
        return this;
    }

    public Matrix3 setToRotation(float f) {
        return this.setToRotationRad(f * ((float)Math.PI / 180));
    }

    public Matrix3 setToRotation(Vector3 vector3, float f) {
        return this.setToRotation(vector3, MathUtils.cosDeg(f), MathUtils.sinDeg(f));
    }

    public Matrix3 setToRotation(Vector3 vector3, float f, float f2) {
        float[] fArray = this.val;
        float f3 = 1.0f - f;
        fArray[0] = vector3.x * f3 * vector3.x + f;
        fArray[1] = vector3.x * f3 * vector3.y - vector3.z * f2;
        fArray[2] = vector3.z * f3 * vector3.x + vector3.y * f2;
        fArray[3] = vector3.x * f3 * vector3.y + vector3.z * f2;
        fArray[4] = vector3.y * f3 * vector3.y + f;
        fArray[5] = vector3.y * f3 * vector3.z - vector3.x * f2;
        fArray[6] = vector3.z * f3 * vector3.x - vector3.y * f2;
        fArray[7] = vector3.y * f3 * vector3.z + vector3.x * f2;
        fArray[8] = f3 * vector3.z * vector3.z + f;
        return this;
    }

    public Matrix3 setToRotationRad(float f) {
        double d = f;
        f = (float)Math.cos(d);
        float f2 = (float)Math.sin(d);
        float[] fArray = this.val;
        fArray[0] = f;
        fArray[1] = f2;
        fArray[2] = 0.0f;
        fArray[3] = -f2;
        fArray[4] = f;
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
        return this;
    }

    public Matrix3 setToScaling(float f, float f2) {
        float[] fArray = this.val;
        fArray[0] = f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = f2;
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
        return this;
    }

    public Matrix3 setToScaling(Vector2 vector2) {
        float[] fArray = this.val;
        fArray[0] = vector2.x;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = vector2.y;
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
        return this;
    }

    public Matrix3 setToTranslation(float f, float f2) {
        float[] fArray = this.val;
        fArray[0] = 1.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = 1.0f;
        fArray[5] = 0.0f;
        fArray[6] = f;
        fArray[7] = f2;
        fArray[8] = 1.0f;
        return this;
    }

    public Matrix3 setToTranslation(Vector2 vector2) {
        float[] fArray = this.val;
        fArray[0] = 1.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = 1.0f;
        fArray[5] = 0.0f;
        fArray[6] = vector2.x;
        fArray[7] = vector2.y;
        fArray[8] = 1.0f;
        return this;
    }

    public String toString() {
        float[] fArray = this.val;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append(fArray[0]);
        stringBuilder.append("|");
        stringBuilder.append(fArray[3]);
        stringBuilder.append("|");
        stringBuilder.append(fArray[6]);
        stringBuilder.append("]\n[");
        stringBuilder.append(fArray[1]);
        stringBuilder.append("|");
        stringBuilder.append(fArray[4]);
        stringBuilder.append("|");
        stringBuilder.append(fArray[7]);
        stringBuilder.append("]\n[");
        stringBuilder.append(fArray[2]);
        stringBuilder.append("|");
        stringBuilder.append(fArray[5]);
        stringBuilder.append("|");
        stringBuilder.append(fArray[8]);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public Matrix3 translate(float f, float f2) {
        float[] fArray = this.val;
        float[] fArray2 = this.tmp;
        fArray2[0] = 1.0f;
        fArray2[1] = 0.0f;
        fArray2[2] = 0.0f;
        fArray2[3] = 0.0f;
        fArray2[4] = 1.0f;
        fArray2[5] = 0.0f;
        fArray2[6] = f;
        fArray2[7] = f2;
        fArray2[8] = 1.0f;
        Matrix3.mul(fArray, fArray2);
        return this;
    }

    public Matrix3 translate(Vector2 object) {
        float[] fArray = this.val;
        float[] fArray2 = this.tmp;
        fArray2[0] = 1.0f;
        fArray2[1] = 0.0f;
        fArray2[2] = 0.0f;
        fArray2[3] = 0.0f;
        fArray2[4] = 1.0f;
        fArray2[5] = 0.0f;
        fArray2[6] = ((Vector2)object).x;
        this.tmp[7] = ((Vector2)object).y;
        object = this.tmp;
        object[8] = 1.0f;
        Matrix3.mul(fArray, (float[])object);
        return this;
    }

    public Matrix3 transpose() {
        float[] fArray = this.val;
        float f = fArray[1];
        float f2 = fArray[2];
        float f3 = fArray[3];
        float f4 = fArray[5];
        float f5 = fArray[6];
        float f6 = fArray[7];
        fArray[3] = f;
        fArray[6] = f2;
        fArray[1] = f3;
        fArray[7] = f4;
        fArray[2] = f5;
        fArray[5] = f6;
        return this;
    }

    public Matrix3 trn(float f, float f2) {
        float[] fArray = this.val;
        fArray[6] = fArray[6] + f;
        fArray[7] = fArray[7] + f2;
        return this;
    }

    public Matrix3 trn(Vector2 vector2) {
        float[] fArray = this.val;
        fArray[6] = fArray[6] + vector2.x;
        fArray = this.val;
        fArray[7] = fArray[7] + vector2.y;
        return this;
    }

    public Matrix3 trn(Vector3 vector3) {
        float[] fArray = this.val;
        fArray[6] = fArray[6] + vector3.x;
        fArray = this.val;
        fArray[7] = fArray[7] + vector3.y;
        return this;
    }
}

