/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.ShortArray;

public class ConvexHull {
    private final FloatArray hull;
    private final IntArray indices;
    private final ShortArray originalIndices;
    private final IntArray quicksortStack = new IntArray();
    private float[] sortedPoints;

    public ConvexHull() {
        this.hull = new FloatArray();
        this.indices = new IntArray();
        this.originalIndices = new ShortArray(false, 0);
    }

    private float ccw(float f, float f2) {
        FloatArray floatArray = this.hull;
        int n = floatArray.size;
        float f3 = floatArray.get(n - 4);
        float f4 = floatArray.get(n - 3);
        return (floatArray.get(n - 2) - f3) * (f2 - f4) - (floatArray.peek() - f4) * (f - f3);
    }

    private int quicksortPartition(float[] fArray, int n, int n2) {
        float f = fArray[n];
        int n3 = n + 1;
        float f2 = fArray[n3];
        int n4 = n;
        int n5 = n2;
        block0: while (n4 < n5) {
            int n6;
            n2 = n4;
            while (true) {
                n6 = n5;
                if (n2 >= n5) break;
                n6 = n5;
                if (!(fArray[n2] <= f)) break;
                n2 += 2;
            }
            while (true) {
                if (!(fArray[n6] > f || fArray[n6] == f && fArray[n6 + 1] < f2)) {
                    n5 = n6;
                    n4 = n2;
                    if (n2 >= n6) continue block0;
                    float f3 = fArray[n2];
                    fArray[n2] = fArray[n6];
                    fArray[n6] = f3;
                    n4 = n2 + 1;
                    f3 = fArray[n4];
                    n5 = n6 + 1;
                    fArray[n4] = fArray[n5];
                    fArray[n5] = f3;
                    n5 = n6;
                    n4 = n2;
                    continue block0;
                }
                n6 -= 2;
            }
        }
        fArray[n] = fArray[n5];
        fArray[n5] = f;
        n = n5 + 1;
        fArray[n3] = fArray[n];
        fArray[n] = f2;
        return n5;
    }

    /*
     * Unable to fully structure code
     */
    private int quicksortPartitionWithIndices(float[] var1_1, int var2_2, int var3_3, boolean var4_4, short[] var5_5) {
        var6_6 = var1_1[var2_2];
        var7_7 = var2_2 + 1;
        var8_8 = var1_1[var7_7];
        var9_9 = var2_2;
        block0: while (var9_9 < var3_3) {
            block10: {
                for (var10_10 = var9_9; var10_10 < var3_3 && var1_1[var10_10] <= var6_6; var10_10 += 2) {
                }
                var9_9 = var3_3;
                if (!var4_4) break block10;
                while (true) lbl-1000:
                // 2 sources

                {
                    block11: {
                        if (var1_1[var3_3] > var6_6) break block11;
                        var11_11 = var3_3;
                        if (var1_1[var3_3] != var6_6) ** GOTO lbl27
                        var11_11 = var3_3;
                        if (!(var1_1[var3_3 + 1] < var8_8)) ** GOTO lbl27
                    }
                    var3_3 -= 2;
                    ** while (true)
                    break;
                }
            }
            while (true) {
                block12: {
                    block13: {
                        if (var1_1[var9_9] > var6_6) break block12;
                        var11_11 = var9_9;
                        if (var1_1[var9_9] != var6_6) break block13;
                        var11_11 = var9_9;
                        if (var1_1[var9_9 + 1] > var8_8) break block12;
                    }
                    var3_3 = var11_11;
                    var9_9 = var10_10;
                    if (var10_10 >= var11_11) continue block0;
                    var12_12 = var1_1[var10_10];
                    var1_1[var10_10] = var1_1[var11_11];
                    var1_1[var11_11] = var12_12;
                    var3_3 = var10_10 + 1;
                    var12_12 = var1_1[var3_3];
                    var9_9 = var11_11 + 1;
                    var1_1[var3_3] = var1_1[var9_9];
                    var1_1[var9_9] = var12_12;
                    var13_13 = var10_10 / 2;
                    var9_9 = var5_5[var13_13];
                    var3_3 = var11_11 / 2;
                    var5_5[var13_13] = var5_5[var3_3];
                    var5_5[var3_3] = (short)var9_9;
                    var3_3 = var11_11;
                    var9_9 = var10_10;
                    continue block0;
                }
                var9_9 -= 2;
            }
        }
        var1_1[var2_2] = var1_1[var3_3];
        var1_1[var3_3] = var6_6;
        var11_11 = var3_3 + 1;
        var1_1[var7_7] = var1_1[var11_11];
        var1_1[var11_11] = var8_8;
        var11_11 = var2_2 / 2;
        var2_2 = var5_5[var11_11];
        var9_9 = var3_3 / 2;
        var5_5[var11_11] = var5_5[var9_9];
        var5_5[var9_9] = (short)var2_2;
        return var3_3;
    }

    private void sort(float[] fArray, int n) {
        IntArray intArray = this.quicksortStack;
        intArray.add(0);
        intArray.add(n - 1 - 1);
        while (intArray.size > 0) {
            int n2;
            int n3;
            int n4 = intArray.pop();
            if (n4 <= (n3 = intArray.pop())) continue;
            n = this.quicksortPartition(fArray, n3, n4);
            int n5 = n - n3;
            if (n5 > (n2 = n4 - n)) {
                intArray.add(n3);
                intArray.add(n - 2);
            }
            intArray.add(n + 2);
            intArray.add(n4);
            if (n2 < n5) continue;
            intArray.add(n3);
            intArray.add(n - 2);
        }
    }

    private void sortWithIndices(float[] fArray, int n, boolean bl) {
        int n2;
        int n3 = n / 2;
        this.originalIndices.clear();
        this.originalIndices.ensureCapacity(n3);
        short[] sArray = this.originalIndices.items;
        for (n2 = 0; n2 < n3; n2 = (int)((short)(n2 + 1))) {
            sArray[n2] = (short)n2;
        }
        IntArray intArray = this.quicksortStack;
        intArray.add(0);
        intArray.add(n - 1 - 1);
        while (intArray.size > 0) {
            n3 = intArray.pop();
            if (n3 <= (n = intArray.pop())) continue;
            int n4 = this.quicksortPartitionWithIndices(fArray, n, n3, bl, sArray);
            int n5 = n4 - n;
            if (n5 > (n2 = n3 - n4)) {
                intArray.add(n);
                intArray.add(n4 - 2);
            }
            intArray.add(n4 + 2);
            intArray.add(n3);
            if (n2 < n5) continue;
            intArray.add(n);
            intArray.add(n4 - 2);
        }
    }

    public IntArray computeIndices(FloatArray floatArray, boolean bl, boolean bl2) {
        return this.computeIndices(floatArray.items, 0, floatArray.size, bl, bl2);
    }

    public IntArray computeIndices(float[] object, int n, int n2, boolean bl, boolean bl2) {
        if (n2 <= Short.MAX_VALUE) {
            float f;
            float f2;
            int n3 = n + n2;
            int n4 = 0;
            Object object2 = object;
            int n5 = n;
            if (!bl) {
                object2 = this.sortedPoints;
                if (object2 == null || ((float[])object2).length < n2) {
                    this.sortedPoints = new float[n2];
                }
                System.arraycopy(object, n, this.sortedPoints, 0, n2);
                object2 = this.sortedPoints;
                this.sortWithIndices((float[])object2, n2, bl2);
                n5 = 0;
            }
            object = this.indices;
            ((IntArray)object).clear();
            Object object3 = this.hull;
            ((FloatArray)object3).clear();
            n = n5 / 2;
            n2 = n5;
            while (n2 < n3) {
                f2 = object2[n2];
                f = object2[n2 + 1];
                while (((FloatArray)object3).size >= 4 && this.ccw(f2, f) <= 0.0f) {
                    ((FloatArray)object3).size -= 2;
                    --((IntArray)object).size;
                }
                ((FloatArray)object3).add(f2);
                ((FloatArray)object3).add(f);
                ((IntArray)object).add(n);
                n2 += 2;
                ++n;
            }
            n2 = n3 - 4;
            n = n2 / 2;
            n3 = ((FloatArray)object3).size;
            while (n2 >= n5) {
                f2 = object2[n2];
                f = object2[n2 + 1];
                while (((FloatArray)object3).size >= n3 + 2 && this.ccw(f2, f) <= 0.0f) {
                    ((FloatArray)object3).size -= 2;
                    --((IntArray)object).size;
                }
                ((FloatArray)object3).add(f2);
                ((FloatArray)object3).add(f);
                ((IntArray)object).add(n);
                n2 -= 2;
                --n;
            }
            if (!bl) {
                object2 = this.originalIndices.items;
                object3 = ((IntArray)object).items;
                n2 = ((IntArray)object).size;
                for (n = n4; n < n2; ++n) {
                    object3[n] = object2[object3[n]];
                }
            }
            return object;
        }
        object = new IllegalArgumentException("count must be <= 32767");
        throw object;
    }

    public IntArray computeIndices(float[] fArray, boolean bl, boolean bl2) {
        return this.computeIndices(fArray, 0, fArray.length, bl, bl2);
    }

    public FloatArray computePolygon(FloatArray floatArray, boolean bl) {
        return this.computePolygon(floatArray.items, 0, floatArray.size, bl);
    }

    public FloatArray computePolygon(float[] object, int n, int n2, boolean bl) {
        float f;
        float f2;
        int n3 = n + n2;
        float[] fArray = object;
        int n4 = n;
        if (!bl) {
            fArray = this.sortedPoints;
            if (fArray == null || fArray.length < n2) {
                this.sortedPoints = new float[n2];
            }
            System.arraycopy(object, n, this.sortedPoints, 0, n2);
            fArray = this.sortedPoints;
            this.sort(fArray, n2);
            n4 = 0;
        }
        object = this.hull;
        ((FloatArray)object).clear();
        for (n = n4; n < n3; n += 2) {
            f2 = fArray[n];
            f = fArray[n + 1];
            while (((FloatArray)object).size >= 4 && this.ccw(f2, f) <= 0.0f) {
                ((FloatArray)object).size -= 2;
            }
            ((FloatArray)object).add(f2);
            ((FloatArray)object).add(f);
        }
        n2 = ((FloatArray)object).size;
        for (n = n3 - 4; n >= n4; n -= 2) {
            f2 = fArray[n];
            f = fArray[n + 1];
            while (((FloatArray)object).size >= n2 + 2 && this.ccw(f2, f) <= 0.0f) {
                ((FloatArray)object).size -= 2;
            }
            ((FloatArray)object).add(f2);
            ((FloatArray)object).add(f);
        }
        return object;
    }

    public FloatArray computePolygon(float[] fArray, boolean bl) {
        return this.computePolygon(fArray, 0, fArray.length, bl);
    }
}

