/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps.tiled.tiles;

import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.maps.MapObjects;
import com.badlogic.gdx.maps.MapProperties;
import com.badlogic.gdx.maps.tiled.TiledMapTile;
import com.badlogic.gdx.maps.tiled.tiles.StaticTiledMapTile;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.TimeUtils;

public class AnimatedTiledMapTile
implements TiledMapTile {
    private static final long initialTimeOffset = TimeUtils.millis();
    private static long lastTiledMapRenderTime;
    private int[] animationIntervals;
    private TiledMapTile.BlendMode blendMode = TiledMapTile.BlendMode.ALPHA;
    private int frameCount = 0;
    private StaticTiledMapTile[] frameTiles;
    private int id;
    private int loopDuration;
    private MapObjects objects;
    private MapProperties properties;

    public AnimatedTiledMapTile(float f, Array<StaticTiledMapTile> array) {
        this.frameTiles = new StaticTiledMapTile[array.size];
        this.frameCount = array.size;
        int n = array.size;
        int n2 = (int)(f * 1000.0f);
        this.loopDuration = n * n2;
        this.animationIntervals = new int[array.size];
        for (int i = 0; i < array.size; ++i) {
            this.frameTiles[i] = array.get(i);
            this.animationIntervals[i] = n2;
        }
    }

    public AnimatedTiledMapTile(IntArray intArray, Array<StaticTiledMapTile> array) {
        this.frameTiles = new StaticTiledMapTile[array.size];
        this.frameCount = array.size;
        this.animationIntervals = intArray.toArray();
        this.loopDuration = 0;
        for (int i = 0; i < intArray.size; ++i) {
            this.frameTiles[i] = array.get(i);
            this.loopDuration += intArray.get(i);
        }
    }

    public static void updateAnimationBaseTime() {
        lastTiledMapRenderTime = TimeUtils.millis() - initialTimeOffset;
    }

    public int[] getAnimationIntervals() {
        return this.animationIntervals;
    }

    @Override
    public TiledMapTile.BlendMode getBlendMode() {
        return this.blendMode;
    }

    public TiledMapTile getCurrentFrame() {
        return this.frameTiles[this.getCurrentFrameIndex()];
    }

    public int getCurrentFrameIndex() {
        Object object;
        int n = (int)(lastTiledMapRenderTime % (long)this.loopDuration);
        for (int i = 0; i < ((int[])(object = this.animationIntervals)).length; ++i) {
            int n2 = object[i];
            if (n <= n2) {
                return i;
            }
            n -= n2;
        }
        object = new GdxRuntimeException("Could not determine current animation frame in AnimatedTiledMapTile.  This should never happen.");
        throw object;
    }

    public StaticTiledMapTile[] getFrameTiles() {
        return this.frameTiles;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public MapObjects getObjects() {
        if (this.objects == null) {
            this.objects = new MapObjects();
        }
        return this.objects;
    }

    @Override
    public float getOffsetX() {
        return this.getCurrentFrame().getOffsetX();
    }

    @Override
    public float getOffsetY() {
        return this.getCurrentFrame().getOffsetY();
    }

    @Override
    public MapProperties getProperties() {
        if (this.properties == null) {
            this.properties = new MapProperties();
        }
        return this.properties;
    }

    @Override
    public TextureRegion getTextureRegion() {
        return this.getCurrentFrame().getTextureRegion();
    }

    public void setAnimationIntervals(int[] object) {
        if (((int[])object).length == this.animationIntervals.length) {
            this.animationIntervals = object;
            this.loopDuration = 0;
            for (int i = 0; i < ((int[])object).length; ++i) {
                this.loopDuration += object[i];
            }
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Cannot set ");
        stringBuilder.append(((int[])object).length);
        stringBuilder.append(" frame intervals. The given int[] must have a size of ");
        stringBuilder.append(this.animationIntervals.length);
        stringBuilder.append(".");
        object = new GdxRuntimeException(stringBuilder.toString());
        throw object;
    }

    @Override
    public void setBlendMode(TiledMapTile.BlendMode blendMode) {
        this.blendMode = blendMode;
    }

    @Override
    public void setId(int n) {
        this.id = n;
    }

    @Override
    public void setOffsetX(float f) {
        throw new GdxRuntimeException("Cannot set offset of AnimatedTiledMapTile.");
    }

    @Override
    public void setOffsetY(float f) {
        throw new GdxRuntimeException("Cannot set offset of AnimatedTiledMapTile.");
    }

    @Override
    public void setTextureRegion(TextureRegion textureRegion) {
        throw new GdxRuntimeException("Cannot set the texture region of AnimatedTiledMapTile.");
    }
}

