/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.ImmediateModeRenderer;
import com.badlogic.gdx.graphics.glutils.ImmediateModeRenderer20;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Disposable;

public class ShapeRenderer
implements Disposable {
    private boolean autoShapeType;
    private final Color color;
    private final Matrix4 combinedMatrix;
    private float defaultRectLineWidth = 0.75f;
    private boolean matrixDirty = false;
    private final Matrix4 projectionMatrix = new Matrix4();
    private final ImmediateModeRenderer renderer;
    private ShapeType shapeType;
    private final Vector2 tmp;
    private final Matrix4 transformMatrix = new Matrix4();

    public ShapeRenderer() {
        this(5000);
    }

    public ShapeRenderer(int n) {
        this(n, null);
    }

    public ShapeRenderer(int n, ShaderProgram shaderProgram) {
        this.combinedMatrix = new Matrix4();
        this.tmp = new Vector2();
        this.color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        this.renderer = shaderProgram == null ? new ImmediateModeRenderer20(n, false, true, 0) : new ImmediateModeRenderer20(n, false, true, 0, shaderProgram);
        this.projectionMatrix.setToOrtho2D(0.0f, 0.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.matrixDirty = true;
    }

    private void check(ShapeType shapeType, ShapeType object, int n) {
        Object object2 = this.shapeType;
        if (object2 != null) {
            if (object2 != shapeType && object2 != object) {
                if (!this.autoShapeType) {
                    if (object == null) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Must call begin(ShapeType.");
                        ((StringBuilder)object).append((Object)shapeType);
                        ((StringBuilder)object).append(").");
                        throw new IllegalStateException(((StringBuilder)object).toString());
                    }
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("Must call begin(ShapeType.");
                    ((StringBuilder)object2).append((Object)shapeType);
                    ((StringBuilder)object2).append(") or begin(ShapeType.");
                    ((StringBuilder)object2).append(object);
                    ((StringBuilder)object2).append(").");
                    throw new IllegalStateException(((StringBuilder)object2).toString());
                }
                this.end();
                this.begin(shapeType);
            } else if (this.matrixDirty) {
                shapeType = this.shapeType;
                this.end();
                this.begin(shapeType);
            } else if (this.renderer.getMaxVertices() - this.renderer.getNumVertices() < n) {
                shapeType = this.shapeType;
                this.end();
                this.begin(shapeType);
            }
            return;
        }
        throw new IllegalStateException("begin must be called first.");
    }

    public void arc(float f, float f2, float f3, float f4, float f5) {
        this.arc(f, f2, f3, f4, f5, Math.max(1, (int)((float)Math.cbrt(f3) * 6.0f * (f5 / 360.0f))));
    }

    public void arc(float f, float f2, float f3, float f4, float f5, int n) {
        if (n > 0) {
            int n2;
            float f6 = this.color.toFloatBits();
            f5 = f5 / 360.0f * ((float)Math.PI * 2) / (float)n;
            float f7 = MathUtils.cos(f5);
            float f8 = MathUtils.sin(f5);
            f5 = f4 * ((float)Math.PI / 180);
            f4 = MathUtils.cos(f5) * f3;
            f3 *= MathUtils.sin(f5);
            ShapeType shapeType = this.shapeType;
            ShapeType shapeType2 = ShapeType.Line;
            int n3 = 0;
            if (shapeType == shapeType2) {
                this.check(ShapeType.Line, ShapeType.Filled, n * 2 + 2);
                this.renderer.color(f6);
                this.renderer.vertex(f, f2, 0.0f);
                this.renderer.color(f6);
                this.renderer.vertex(f + f4, f2 + f3, 0.0f);
                for (n2 = 0; n2 < n; ++n2) {
                    this.renderer.color(f6);
                    this.renderer.vertex(f + f4, f2 + f3, 0.0f);
                    f5 = f7 * f4 - f8 * f3;
                    f3 = f3 * f7 + f4 * f8;
                    this.renderer.color(f6);
                    this.renderer.vertex(f + f5, f2 + f3, 0.0f);
                    f4 = f5;
                }
                this.renderer.color(f6);
                this.renderer.vertex(f4 + f, f3 + f2, 0.0f);
            } else {
                this.check(ShapeType.Line, ShapeType.Filled, n * 3 + 3);
                for (n2 = n3; n2 < n; ++n2) {
                    this.renderer.color(f6);
                    this.renderer.vertex(f, f2, 0.0f);
                    this.renderer.color(f6);
                    this.renderer.vertex(f + f4, f2 + f3, 0.0f);
                    f5 = f7 * f4 - f8 * f3;
                    f3 = f3 * f7 + f4 * f8;
                    this.renderer.color(f6);
                    this.renderer.vertex(f + f5, f2 + f3, 0.0f);
                    f4 = f5;
                }
                this.renderer.color(f6);
                this.renderer.vertex(f, f2, 0.0f);
                this.renderer.color(f6);
                this.renderer.vertex(f4 + f, f3 + f2, 0.0f);
            }
            this.renderer.color(f6);
            this.renderer.vertex(f + 0.0f, f2 + 0.0f, 0.0f);
            return;
        }
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("segments must be > 0.");
        throw illegalArgumentException;
    }

    public void begin() {
        if (this.autoShapeType) {
            this.begin(ShapeType.Line);
            return;
        }
        throw new IllegalStateException("autoShapeType must be true to use this method.");
    }

    public void begin(ShapeType shapeType) {
        if (this.shapeType == null) {
            this.shapeType = shapeType;
            if (this.matrixDirty) {
                this.combinedMatrix.set(this.projectionMatrix);
                Matrix4.mul(this.combinedMatrix.val, this.transformMatrix.val);
                this.matrixDirty = false;
            }
            this.renderer.begin(this.combinedMatrix, this.shapeType.getGlType());
            return;
        }
        throw new IllegalStateException("Call end() before beginning a new shape batch.");
    }

    public void box(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = -f6;
        f6 = this.color.toFloatBits();
        if (this.shapeType == ShapeType.Line) {
            this.check(ShapeType.Line, ShapeType.Filled, 24);
            this.renderer.color(f6);
            this.renderer.vertex(f, f2, f3);
            this.renderer.color(f6);
            ImmediateModeRenderer immediateModeRenderer = this.renderer;
            immediateModeRenderer.vertex(f4 += f, f2, f3);
            this.renderer.color(f6);
            this.renderer.vertex(f4, f2, f3);
            this.renderer.color(f6);
            immediateModeRenderer = this.renderer;
            immediateModeRenderer.vertex(f4, f2, f7 += f3);
            this.renderer.color(f6);
            this.renderer.vertex(f4, f2, f7);
            this.renderer.color(f6);
            this.renderer.vertex(f, f2, f7);
            this.renderer.color(f6);
            this.renderer.vertex(f, f2, f7);
            this.renderer.color(f6);
            this.renderer.vertex(f, f2, f3);
            this.renderer.color(f6);
            this.renderer.vertex(f, f2, f3);
            this.renderer.color(f6);
            immediateModeRenderer = this.renderer;
            immediateModeRenderer.vertex(f, f5 += f2, f3);
            this.renderer.color(f6);
            this.renderer.vertex(f, f5, f3);
            this.renderer.color(f6);
            this.renderer.vertex(f4, f5, f3);
            this.renderer.color(f6);
            this.renderer.vertex(f4, f5, f3);
            this.renderer.color(f6);
            this.renderer.vertex(f4, f5, f7);
            this.renderer.color(f6);
            this.renderer.vertex(f4, f5, f7);
            this.renderer.color(f6);
            this.renderer.vertex(f, f5, f7);
            this.renderer.color(f6);
            this.renderer.vertex(f, f5, f7);
            this.renderer.color(f6);
            this.renderer.vertex(f, f5, f3);
            this.renderer.color(f6);
            this.renderer.vertex(f4, f2, f3);
            this.renderer.color(f6);
            this.renderer.vertex(f4, f5, f3);
            this.renderer.color(f6);
            this.renderer.vertex(f4, f2, f7);
            this.renderer.color(f6);
            this.renderer.vertex(f4, f5, f7);
            this.renderer.color(f6);
            this.renderer.vertex(f, f2, f7);
            this.renderer.color(f6);
            this.renderer.vertex(f, f5, f7);
        } else {
            this.check(ShapeType.Line, ShapeType.Filled, 36);
            this.renderer.color(f6);
            this.renderer.vertex(f, f2, f3);
            this.renderer.color(f6);
            ImmediateModeRenderer immediateModeRenderer = this.renderer;
            immediateModeRenderer.vertex(f4 += f, f2, f3);
            this.renderer.color(f6);
            immediateModeRenderer = this.renderer;
            immediateModeRenderer.vertex(f4, f5 += f2, f3);
            this.renderer.color(f6);
            this.renderer.vertex(f, f2, f3);
            this.renderer.color(f6);
            this.renderer.vertex(f4, f5, f3);
            this.renderer.color(f6);
            this.renderer.vertex(f, f5, f3);
            this.renderer.color(f6);
            immediateModeRenderer = this.renderer;
            immediateModeRenderer.vertex(f4, f2, f7 += f3);
            this.renderer.color(f6);
            this.renderer.vertex(f, f2, f7);
            this.renderer.color(f6);
            this.renderer.vertex(f4, f5, f7);
            this.renderer.color(f6);
            this.renderer.vertex(f4, f5, f7);
            this.renderer.color(f6);
            this.renderer.vertex(f, f2, f7);
            this.renderer.color(f6);
            this.renderer.vertex(f, f5, f7);
            this.renderer.color(f6);
            this.renderer.vertex(f, f2, f7);
            this.renderer.color(f6);
            this.renderer.vertex(f, f2, f3);
            this.renderer.color(f6);
            this.renderer.vertex(f, f5, f3);
            this.renderer.color(f6);
            this.renderer.vertex(f, f2, f7);
            this.renderer.color(f6);
            this.renderer.vertex(f, f5, f3);
            this.renderer.color(f6);
            this.renderer.vertex(f, f5, f7);
            this.renderer.color(f6);
            this.renderer.vertex(f4, f2, f3);
            this.renderer.color(f6);
            this.renderer.vertex(f4, f2, f7);
            this.renderer.color(f6);
            this.renderer.vertex(f4, f5, f7);
            this.renderer.color(f6);
            this.renderer.vertex(f4, f2, f3);
            this.renderer.color(f6);
            this.renderer.vertex(f4, f5, f7);
            this.renderer.color(f6);
            this.renderer.vertex(f4, f5, f3);
            this.renderer.color(f6);
            this.renderer.vertex(f, f5, f3);
            this.renderer.color(f6);
            this.renderer.vertex(f4, f5, f3);
            this.renderer.color(f6);
            this.renderer.vertex(f4, f5, f7);
            this.renderer.color(f6);
            this.renderer.vertex(f, f5, f3);
            this.renderer.color(f6);
            this.renderer.vertex(f4, f5, f7);
            this.renderer.color(f6);
            this.renderer.vertex(f, f5, f7);
            this.renderer.color(f6);
            this.renderer.vertex(f, f2, f7);
            this.renderer.color(f6);
            this.renderer.vertex(f4, f2, f7);
            this.renderer.color(f6);
            this.renderer.vertex(f4, f2, f3);
            this.renderer.color(f6);
            this.renderer.vertex(f, f2, f7);
            this.renderer.color(f6);
            this.renderer.vertex(f4, f2, f3);
            this.renderer.color(f6);
            this.renderer.vertex(f, f2, f3);
        }
    }

    public void circle(float f, float f2, float f3) {
        this.circle(f, f2, f3, Math.max(1, (int)((float)Math.cbrt(f3) * 6.0f)));
    }

    public void circle(float f, float f2, float f3, int n) {
        if (n > 0) {
            int n2;
            float f4 = this.color.toFloatBits();
            float f5 = (float)Math.PI * 2 / (float)n;
            float f6 = MathUtils.cos(f5);
            float f7 = MathUtils.sin(f5);
            ShapeType shapeType = this.shapeType;
            ShapeType shapeType2 = ShapeType.Line;
            int n3 = 0;
            if (shapeType == shapeType2) {
                this.check(ShapeType.Line, ShapeType.Filled, n * 2 + 2);
                f5 = f3;
                float f8 = 0.0f;
                for (n2 = 0; n2 < n; ++n2) {
                    this.renderer.color(f4);
                    this.renderer.vertex(f + f5, f2 + f8, 0.0f);
                    float f9 = f6 * f5 - f7 * f8;
                    f8 = f8 * f6 + f5 * f7;
                    this.renderer.color(f4);
                    this.renderer.vertex(f + f9, f2 + f8, 0.0f);
                    f5 = f9;
                }
                this.renderer.color(f4);
                this.renderer.vertex(f5 + f, f8 + f2, 0.0f);
            } else {
                this.check(ShapeType.Line, ShapeType.Filled, n * 3 + 3);
                f5 = f3;
                float f10 = 0.0f;
                for (n2 = n3; n2 < n - 1; ++n2) {
                    this.renderer.color(f4);
                    this.renderer.vertex(f, f2, 0.0f);
                    this.renderer.color(f4);
                    this.renderer.vertex(f + f5, f2 + f10, 0.0f);
                    float f11 = f6 * f5 - f7 * f10;
                    f10 = f10 * f6 + f5 * f7;
                    this.renderer.color(f4);
                    this.renderer.vertex(f + f11, f2 + f10, 0.0f);
                    f5 = f11;
                }
                this.renderer.color(f4);
                this.renderer.vertex(f, f2, 0.0f);
                this.renderer.color(f4);
                this.renderer.vertex(f5 + f, f10 + f2, 0.0f);
            }
            this.renderer.color(f4);
            this.renderer.vertex(f + f3, f2 + 0.0f, 0.0f);
            return;
        }
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("segments must be > 0.");
        throw illegalArgumentException;
    }

    public void cone(float f, float f2, float f3, float f4, float f5) {
        this.cone(f, f2, f3, f4, f5, Math.max(1, (int)((float)Math.sqrt(f4) * 4.0f)));
    }

    public void cone(float f, float f2, float f3, float f4, float f5, int n) {
        if (n > 0) {
            float f6;
            int n2;
            float f7;
            this.check(ShapeType.Line, ShapeType.Filled, n * 4 + 2);
            float f8 = this.color.toFloatBits();
            float f9 = (float)Math.PI * 2 / (float)n;
            float f10 = MathUtils.cos(f9);
            float f11 = MathUtils.sin(f9);
            Object object = this.shapeType;
            ShapeType shapeType = ShapeType.Line;
            int n3 = 0;
            if (object == shapeType) {
                f7 = f4;
                f9 = 0.0f;
                for (n2 = 0; n2 < n; ++n2) {
                    this.renderer.color(f8);
                    object = this.renderer;
                    f6 = f + f7;
                    float f12 = f2 + f9;
                    object.vertex(f6, f12, f3);
                    this.renderer.color(f8);
                    this.renderer.vertex(f, f2, f3 + f5);
                    this.renderer.color(f8);
                    this.renderer.vertex(f6, f12, f3);
                    f6 = f10 * f7 - f11 * f9;
                    f9 = f9 * f10 + f7 * f11;
                    this.renderer.color(f8);
                    this.renderer.vertex(f + f6, f2 + f9, f3);
                    f7 = f6;
                }
                this.renderer.color(f8);
                this.renderer.vertex(f + f7, f2 + f9, f3);
                f6 = f7;
                f7 = f9;
            } else {
                f9 = f4;
                f7 = 0.0f;
                for (n2 = n3; n2 < n - 1; ++n2) {
                    this.renderer.color(f8);
                    this.renderer.vertex(f, f2, f3);
                    this.renderer.color(f8);
                    object = this.renderer;
                    float f13 = f + f9;
                    float f14 = f2 + f7;
                    object.vertex(f13, f14, f3);
                    f6 = f10 * f9 - f11 * f7;
                    f7 = f7 * f10 + f9 * f11;
                    this.renderer.color(f8);
                    object = this.renderer;
                    float f15 = f + f6;
                    f9 = f2 + f7;
                    object.vertex(f15, f9, f3);
                    this.renderer.color(f8);
                    this.renderer.vertex(f13, f14, f3);
                    this.renderer.color(f8);
                    this.renderer.vertex(f15, f9, f3);
                    this.renderer.color(f8);
                    this.renderer.vertex(f, f2, f3 + f5);
                    f9 = f6;
                }
                this.renderer.color(f8);
                this.renderer.vertex(f, f2, f3);
                this.renderer.color(f8);
                this.renderer.vertex(f + f9, f2 + f7, f3);
                f6 = f9;
            }
            this.renderer.color(f8);
            object = this.renderer;
            f4 = f + f4;
            f9 = 0.0f + f2;
            object.vertex(f4, f9, f3);
            if (this.shapeType != ShapeType.Line) {
                this.renderer.color(f8);
                this.renderer.vertex(f6 + f, f7 + f2, f3);
                this.renderer.color(f8);
                this.renderer.vertex(f4, f9, f3);
                this.renderer.color(f8);
                this.renderer.vertex(f, f2, f3 + f5);
            }
            return;
        }
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("segments must be > 0.");
        throw illegalArgumentException;
    }

    public void curve(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, int n) {
        this.check(ShapeType.Line, null, n * 2 + 2);
        float f9 = this.color.toFloatBits();
        float f10 = 1.0f / (float)n;
        float f11 = f10 * f10;
        float f12 = f11 * f10;
        float f13 = f10 * 3.0f;
        float f14 = f11 * 3.0f;
        f10 = f11 * 6.0f;
        float f15 = 6.0f * f12;
        float f16 = f - f3 * 2.0f + f5;
        float f17 = f2 - 2.0f * f4 + f6;
        float f18 = (f3 - f5) * 3.0f - f + f7;
        f5 = (f4 - f6) * 3.0f - f2 + f8;
        f11 = (f3 - f) * f13 + f16 * f14 + f18 * f12;
        f3 = (f4 - f2) * f13 + f14 * f17 + f12 * f5;
        f12 = f18 * f15;
        f4 = f16 * f10 + f12;
        f15 = f5 * f15;
        f10 = f17 * f10 + f15;
        f6 = f;
        f5 = f2;
        f = f4;
        f2 = f10;
        f4 = f11;
        while (n > 0) {
            this.renderer.color(f9);
            this.renderer.vertex(f6, f5, 0.0f);
            f6 += f4;
            f5 += f3;
            f4 += f;
            f3 += f2;
            f += f12;
            f2 += f15;
            this.renderer.color(f9);
            this.renderer.vertex(f6, f5, 0.0f);
            --n;
        }
        this.renderer.color(f9);
        this.renderer.vertex(f6, f5, 0.0f);
        this.renderer.color(f9);
        this.renderer.vertex(f7, f8, 0.0f);
    }

    @Override
    public void dispose() {
        this.renderer.dispose();
    }

    public void ellipse(float f, float f2, float f3, float f4) {
        this.ellipse(f, f2, f3, f4, Math.max(1, (int)((float)Math.cbrt(Math.max(f3 * 0.5f, 0.5f * f4)) * 12.0f)));
    }

    public void ellipse(float f, float f2, float f3, float f4, float f5) {
        this.ellipse(f, f2, f3, f4, f5, Math.max(1, (int)((float)Math.cbrt(Math.max(f3 * 0.5f, 0.5f * f4)) * 12.0f)));
    }

    public void ellipse(float f, float f2, float f3, float f4, float f5, int n) {
        if (n > 0) {
            this.check(ShapeType.Line, ShapeType.Filled, n * 3);
            float f6 = this.color.toFloatBits();
            float f7 = (float)Math.PI * 2 / (float)n;
            f5 = (float)Math.PI * f5 / 180.0f;
            float f8 = MathUtils.sin(f5);
            float f9 = MathUtils.cos(f5);
            float f10 = f + f3 / 2.0f;
            float f11 = f2 + f4 / 2.0f;
            f = f3 * 0.5f;
            ShapeType shapeType = this.shapeType;
            ShapeType shapeType2 = ShapeType.Line;
            int n2 = 0;
            int n3 = 0;
            if (shapeType == shapeType2) {
                f2 = f;
                f5 = 0.0f;
                f3 = f2;
                while (n3 < n) {
                    this.renderer.color(f6);
                    this.renderer.vertex(f9 * f3 + f10 - f8 * f5, f3 * f8 + f11 + f5 * f9, 0.0f);
                    f2 = (float)(++n3) * f7;
                    f3 = MathUtils.cos(f2) * f;
                    f2 = MathUtils.sin(f2) * (f4 * 0.5f);
                    this.renderer.color(f6);
                    this.renderer.vertex(f9 * f3 + f10 - f8 * f2, f11 + f8 * f3 + f9 * f2, 0.0f);
                    f5 = f2;
                }
            } else {
                f2 = f;
                f5 = 0.0f;
                n3 = n2;
                f3 = f2;
                while (n3 < n) {
                    this.renderer.color(f6);
                    this.renderer.vertex(f9 * f3 + f10 - f8 * f5, f3 * f8 + f11 + f5 * f9, 0.0f);
                    this.renderer.color(f6);
                    this.renderer.vertex(f10, f11, 0.0f);
                    f2 = (float)(++n3) * f7;
                    f3 = MathUtils.cos(f2) * f;
                    f2 = MathUtils.sin(f2) * (f4 * 0.5f);
                    this.renderer.color(f6);
                    this.renderer.vertex(f9 * f3 + f10 - f8 * f2, f11 + f8 * f3 + f9 * f2, 0.0f);
                    f5 = f2;
                }
            }
            return;
        }
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("segments must be > 0.");
        throw illegalArgumentException;
    }

    public void ellipse(float f, float f2, float f3, float f4, int n) {
        if (n > 0) {
            this.check(ShapeType.Line, ShapeType.Filled, n * 3);
            float f5 = this.color.toFloatBits();
            float f6 = (float)Math.PI * 2 / (float)n;
            f += f3 / 2.0f;
            f2 += f4 / 2.0f;
            ShapeType shapeType = this.shapeType;
            Object object = ShapeType.Line;
            int n2 = 0;
            int n3 = 0;
            if (shapeType == object) {
                n2 = n3;
                while (n2 < n) {
                    this.renderer.color(f5);
                    object = this.renderer;
                    float f7 = f3 * 0.5f;
                    float f8 = (float)n2 * f6;
                    float f9 = MathUtils.cos(f8);
                    float f10 = f4 * 0.5f;
                    object.vertex(f9 * f7 + f, MathUtils.sin(f8) * f10 + f2, 0.0f);
                    this.renderer.color(f5);
                    object = this.renderer;
                    f8 = (float)(++n2) * f6;
                    object.vertex(f7 * MathUtils.cos(f8) + f, f10 * MathUtils.sin(f8) + f2, 0.0f);
                }
            } else {
                while (n2 < n) {
                    this.renderer.color(f5);
                    object = this.renderer;
                    float f11 = f3 * 0.5f;
                    float f12 = (float)n2 * f6;
                    float f13 = MathUtils.cos(f12);
                    float f14 = f4 * 0.5f;
                    object.vertex(f13 * f11 + f, MathUtils.sin(f12) * f14 + f2, 0.0f);
                    this.renderer.color(f5);
                    this.renderer.vertex(f, f2, 0.0f);
                    this.renderer.color(f5);
                    object = this.renderer;
                    f13 = (float)(++n2) * f6;
                    object.vertex(f11 * MathUtils.cos(f13) + f, f14 * MathUtils.sin(f13) + f2, 0.0f);
                }
            }
            return;
        }
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("segments must be > 0.");
        throw illegalArgumentException;
    }

    public void end() {
        this.renderer.end();
        this.shapeType = null;
    }

    public void flush() {
        ShapeType shapeType = this.shapeType;
        if (shapeType == null) {
            return;
        }
        this.end();
        this.begin(shapeType);
    }

    public Color getColor() {
        return this.color;
    }

    public ShapeType getCurrentType() {
        return this.shapeType;
    }

    public Matrix4 getProjectionMatrix() {
        return this.projectionMatrix;
    }

    public ImmediateModeRenderer getRenderer() {
        return this.renderer;
    }

    public Matrix4 getTransformMatrix() {
        return this.transformMatrix;
    }

    public void identity() {
        this.transformMatrix.idt();
        this.matrixDirty = true;
    }

    public boolean isDrawing() {
        boolean bl = this.shapeType != null;
        return bl;
    }

    public final void line(float f, float f2, float f3, float f4) {
        Color color2 = this.color;
        this.line(f, f2, 0.0f, f3, f4, 0.0f, color2, color2);
    }

    public final void line(float f, float f2, float f3, float f4, float f5, float f6) {
        Color color2 = this.color;
        this.line(f, f2, f3, f4, f5, f6, color2, color2);
    }

    public void line(float f, float f2, float f3, float f4, float f5, float f6, Color color2, Color color3) {
        if (this.shapeType == ShapeType.Filled) {
            this.rectLine(f, f2, f4, f5, this.defaultRectLineWidth, color2, color3);
            return;
        }
        this.check(ShapeType.Line, null, 2);
        this.renderer.color(color2.r, color2.g, color2.b, color2.a);
        this.renderer.vertex(f, f2, f3);
        this.renderer.color(color3.r, color3.g, color3.b, color3.a);
        this.renderer.vertex(f4, f5, f6);
    }

    public final void line(float f, float f2, float f3, float f4, Color color2, Color color3) {
        this.line(f, f2, 0.0f, f3, f4, 0.0f, color2, color3);
    }

    public final void line(Vector2 object, Vector2 vector2) {
        float f = ((Vector2)object).x;
        float f2 = ((Vector2)object).y;
        float f3 = vector2.x;
        float f4 = vector2.y;
        object = this.color;
        this.line(f, f2, 0.0f, f3, f4, 0.0f, (Color)object, (Color)object);
    }

    public final void line(Vector3 object, Vector3 vector3) {
        float f = ((Vector3)object).x;
        float f2 = ((Vector3)object).y;
        float f3 = ((Vector3)object).z;
        float f4 = vector3.x;
        float f5 = vector3.y;
        float f6 = vector3.z;
        object = this.color;
        this.line(f, f2, f3, f4, f5, f6, (Color)object, (Color)object);
    }

    public void point(float f, float f2, float f3) {
        if (this.shapeType == ShapeType.Line) {
            float f4 = this.defaultRectLineWidth * 0.5f;
            this.line(f - f4, f2 - f4, f3, f + f4, f2 + f4, f3);
            return;
        }
        if (this.shapeType == ShapeType.Filled) {
            float f5 = this.defaultRectLineWidth;
            float f6 = 0.5f * f5;
            this.box(f - f6, f2 - f6, f3 - f6, f5, f5, f5);
            return;
        }
        this.check(ShapeType.Point, null, 1);
        this.renderer.color(this.color);
        this.renderer.vertex(f, f2, f3);
    }

    public void polygon(float[] fArray) {
        this.polygon(fArray, 0, fArray.length);
    }

    public void polygon(float[] object, int n, int n2) {
        if (n2 >= 6) {
            if (n2 % 2 == 0) {
                int n3;
                this.check(ShapeType.Line, null, n2);
                float f = this.color.toFloatBits();
                float f2 = object[0];
                float f3 = object[1];
                int n4 = n;
                while ((n3 = n4) < n + n2) {
                    float f4;
                    float f5;
                    float f6 = object[n3];
                    float f7 = object[n3 + 1];
                    n4 = n3 + 2;
                    if (n4 >= n2) {
                        f5 = f2;
                        f4 = f3;
                    } else {
                        f5 = object[n4];
                        f4 = object[n3 + 3];
                    }
                    this.renderer.color(f);
                    this.renderer.vertex(f6, f7, 0.0f);
                    this.renderer.color(f);
                    this.renderer.vertex(f5, f4, 0.0f);
                }
                return;
            }
            throw new IllegalArgumentException("Polygons must have an even number of vertices.");
        }
        object = new IllegalArgumentException("Polygons must contain at least 3 points.");
        throw object;
    }

    public void polyline(float[] fArray) {
        this.polyline(fArray, 0, fArray.length);
    }

    public void polyline(float[] object, int n, int n2) {
        if (n2 >= 4) {
            if (n2 % 2 == 0) {
                int n3;
                this.check(ShapeType.Line, null, n2);
                float f = this.color.toFloatBits();
                int n4 = n;
                while ((n3 = n4) < n2 + n - 2) {
                    float f2 = object[n3];
                    float f3 = object[n3 + 1];
                    n4 = n3 + 2;
                    float f4 = object[n4];
                    float f5 = object[n3 + 3];
                    this.renderer.color(f);
                    this.renderer.vertex(f2, f3, 0.0f);
                    this.renderer.color(f);
                    this.renderer.vertex(f4, f5, 0.0f);
                }
                return;
            }
            throw new IllegalArgumentException("Polylines must have an even number of vertices.");
        }
        object = new IllegalArgumentException("Polylines must contain at least 2 points.");
        throw object;
    }

    public void rect(float f, float f2, float f3, float f4) {
        this.check(ShapeType.Line, ShapeType.Filled, 8);
        float f5 = this.color.toFloatBits();
        if (this.shapeType == ShapeType.Line) {
            this.renderer.color(f5);
            this.renderer.vertex(f, f2, 0.0f);
            this.renderer.color(f5);
            ImmediateModeRenderer immediateModeRenderer = this.renderer;
            immediateModeRenderer.vertex(f3 += f, f2, 0.0f);
            this.renderer.color(f5);
            this.renderer.vertex(f3, f2, 0.0f);
            this.renderer.color(f5);
            immediateModeRenderer = this.renderer;
            immediateModeRenderer.vertex(f3, f4 += f2, 0.0f);
            this.renderer.color(f5);
            this.renderer.vertex(f3, f4, 0.0f);
            this.renderer.color(f5);
            this.renderer.vertex(f, f4, 0.0f);
            this.renderer.color(f5);
            this.renderer.vertex(f, f4, 0.0f);
            this.renderer.color(f5);
            this.renderer.vertex(f, f2, 0.0f);
        } else {
            this.renderer.color(f5);
            this.renderer.vertex(f, f2, 0.0f);
            this.renderer.color(f5);
            ImmediateModeRenderer immediateModeRenderer = this.renderer;
            immediateModeRenderer.vertex(f3 += f, f2, 0.0f);
            this.renderer.color(f5);
            immediateModeRenderer = this.renderer;
            immediateModeRenderer.vertex(f3, f4 += f2, 0.0f);
            this.renderer.color(f5);
            this.renderer.vertex(f3, f4, 0.0f);
            this.renderer.color(f5);
            this.renderer.vertex(f, f4, 0.0f);
            this.renderer.color(f5);
            this.renderer.vertex(f, f2, 0.0f);
        }
    }

    public void rect(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        Color color2 = this.color;
        this.rect(f, f2, f3, f4, f5, f6, f7, f8, f9, color2, color2, color2, color2);
    }

    public void rect(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, Color color2, Color color3, Color color4, Color color5) {
        float f10;
        float f11;
        float f12;
        block6: {
            float f13;
            float f14;
            float f15;
            float f16;
            block5: {
                this.check(ShapeType.Line, ShapeType.Filled, 8);
                f12 = MathUtils.cosDeg(f9);
                f11 = MathUtils.sinDeg(f9);
                f16 = -f3;
                f15 = -f4;
                f14 = f5 - f3;
                f13 = f6 - f4;
                if (f7 != 1.0f) break block5;
                f10 = f16;
                f9 = f15;
                f6 = f14;
                f5 = f13;
                if (f8 == 1.0f) break block6;
            }
            f10 = f16 * f7;
            f9 = f15 * f8;
            f6 = f14 * f7;
            f5 = f13 * f8;
        }
        f3 = f + f3;
        f4 = f2 + f4;
        f7 = f11 * f9;
        f = f12 * f10 - f7 + f3;
        f8 = f9 * f12;
        f2 = f10 * f11 + f8 + f4;
        f9 = f12 * f6;
        f7 = f9 - f7 + f3;
        f10 = f6 * f11;
        f6 = f8 + f10 + f4;
        f3 = f9 - f11 * f5 + f3;
        f4 = f10 + f12 * f5 + f4;
        f8 = f3 - f7 + f;
        f5 = f4 - (f6 - f2);
        if (this.shapeType == ShapeType.Line) {
            this.renderer.color(color2.r, color2.g, color2.b, color2.a);
            this.renderer.vertex(f, f2, 0.0f);
            this.renderer.color(color3.r, color3.g, color3.b, color3.a);
            this.renderer.vertex(f7, f6, 0.0f);
            this.renderer.color(color3.r, color3.g, color3.b, color3.a);
            this.renderer.vertex(f7, f6, 0.0f);
            this.renderer.color(color4.r, color4.g, color4.b, color4.a);
            this.renderer.vertex(f3, f4, 0.0f);
            this.renderer.color(color4.r, color4.g, color4.b, color4.a);
            this.renderer.vertex(f3, f4, 0.0f);
            this.renderer.color(color5.r, color5.g, color5.b, color5.a);
            this.renderer.vertex(f8, f5, 0.0f);
            this.renderer.color(color5.r, color5.g, color5.b, color5.a);
            this.renderer.vertex(f8, f5, 0.0f);
            this.renderer.color(color2.r, color2.g, color2.b, color2.a);
            this.renderer.vertex(f, f2, 0.0f);
        } else {
            this.renderer.color(color2.r, color2.g, color2.b, color2.a);
            this.renderer.vertex(f, f2, 0.0f);
            this.renderer.color(color3.r, color3.g, color3.b, color3.a);
            this.renderer.vertex(f7, f6, 0.0f);
            this.renderer.color(color4.r, color4.g, color4.b, color4.a);
            this.renderer.vertex(f3, f4, 0.0f);
            this.renderer.color(color4.r, color4.g, color4.b, color4.a);
            this.renderer.vertex(f3, f4, 0.0f);
            this.renderer.color(color5.r, color5.g, color5.b, color5.a);
            this.renderer.vertex(f8, f5, 0.0f);
            this.renderer.color(color2.r, color2.g, color2.b, color2.a);
            this.renderer.vertex(f, f2, 0.0f);
        }
    }

    public void rect(float f, float f2, float f3, float f4, Color color2, Color object, Color color3, Color color4) {
        this.check(ShapeType.Line, ShapeType.Filled, 8);
        if (this.shapeType == ShapeType.Line) {
            this.renderer.color(color2.r, color2.g, color2.b, color2.a);
            this.renderer.vertex(f, f2, 0.0f);
            this.renderer.color(((Color)object).r, ((Color)object).g, ((Color)object).b, ((Color)object).a);
            ImmediateModeRenderer immediateModeRenderer = this.renderer;
            immediateModeRenderer.vertex(f3 += f, f2, 0.0f);
            this.renderer.color(((Color)object).r, ((Color)object).g, ((Color)object).b, ((Color)object).a);
            this.renderer.vertex(f3, f2, 0.0f);
            this.renderer.color(color3.r, color3.g, color3.b, color3.a);
            object = this.renderer;
            object.vertex(f3, f4 += f2, 0.0f);
            this.renderer.color(color3.r, color3.g, color3.b, color3.a);
            this.renderer.vertex(f3, f4, 0.0f);
            this.renderer.color(color4.r, color4.g, color4.b, color4.a);
            this.renderer.vertex(f, f4, 0.0f);
            this.renderer.color(color4.r, color4.g, color4.b, color4.a);
            this.renderer.vertex(f, f4, 0.0f);
            this.renderer.color(color2.r, color2.g, color2.b, color2.a);
            this.renderer.vertex(f, f2, 0.0f);
        } else {
            this.renderer.color(color2.r, color2.g, color2.b, color2.a);
            this.renderer.vertex(f, f2, 0.0f);
            this.renderer.color(((Color)object).r, ((Color)object).g, ((Color)object).b, ((Color)object).a);
            object = this.renderer;
            object.vertex(f3 += f, f2, 0.0f);
            this.renderer.color(color3.r, color3.g, color3.b, color3.a);
            object = this.renderer;
            object.vertex(f3, f4 += f2, 0.0f);
            this.renderer.color(color3.r, color3.g, color3.b, color3.a);
            this.renderer.vertex(f3, f4, 0.0f);
            this.renderer.color(color4.r, color4.g, color4.b, color4.a);
            this.renderer.vertex(f, f4, 0.0f);
            this.renderer.color(color2.r, color2.g, color2.b, color2.a);
            this.renderer.vertex(f, f2, 0.0f);
        }
    }

    public void rectLine(float f, float f2, float f3, float f4, float f5) {
        this.check(ShapeType.Line, ShapeType.Filled, 8);
        float f6 = this.color.toFloatBits();
        Object object = this.tmp.set(f4 - f2, f - f3).nor();
        float f7 = f5 * 0.5f;
        f5 = ((Vector2)object).x * f7;
        f7 = ((Vector2)object).y * f7;
        if (this.shapeType == ShapeType.Line) {
            this.renderer.color(f6);
            object = this.renderer;
            float f8 = f + f5;
            float f9 = f2 + f7;
            object.vertex(f8, f9, 0.0f);
            this.renderer.color(f6);
            object = this.renderer;
            float f10 = f2 - f7;
            object.vertex(f -= f5, f10, 0.0f);
            this.renderer.color(f6);
            object = this.renderer;
            float f11 = f3 + f5;
            f2 = f4 + f7;
            object.vertex(f11, f2, 0.0f);
            this.renderer.color(f6);
            object = this.renderer;
            object.vertex(f3 -= f5, f4 -= f7, 0.0f);
            this.renderer.color(f6);
            this.renderer.vertex(f11, f2, 0.0f);
            this.renderer.color(f6);
            this.renderer.vertex(f8, f9, 0.0f);
            this.renderer.color(f6);
            this.renderer.vertex(f3, f4, 0.0f);
            this.renderer.color(f6);
            this.renderer.vertex(f, f10, 0.0f);
        } else {
            this.renderer.color(f6);
            this.renderer.vertex(f + f5, f2 + f7, 0.0f);
            this.renderer.color(f6);
            object = this.renderer;
            object.vertex(f -= f5, f2 -= f7, 0.0f);
            this.renderer.color(f6);
            object = this.renderer;
            float f12 = f3 + f5;
            float f13 = f4 + f7;
            object.vertex(f12, f13, 0.0f);
            this.renderer.color(f6);
            this.renderer.vertex(f3 - f5, f4 - f7, 0.0f);
            this.renderer.color(f6);
            this.renderer.vertex(f12, f13, 0.0f);
            this.renderer.color(f6);
            this.renderer.vertex(f, f2, 0.0f);
        }
    }

    public void rectLine(float f, float f2, float f3, float f4, float f5, Color object, Color color2) {
        this.check(ShapeType.Line, ShapeType.Filled, 8);
        float f6 = ((Color)object).toFloatBits();
        float f7 = color2.toFloatBits();
        object = this.tmp.set(f4 - f2, f - f3).nor();
        float f8 = f5 * 0.5f;
        f5 = ((Vector2)object).x * f8;
        f8 = ((Vector2)object).y * f8;
        if (this.shapeType == ShapeType.Line) {
            this.renderer.color(f6);
            object = this.renderer;
            float f9 = f + f5;
            float f10 = f2 + f8;
            object.vertex(f9, f10, 0.0f);
            this.renderer.color(f6);
            object = this.renderer;
            float f11 = f2 - f8;
            object.vertex(f -= f5, f11, 0.0f);
            this.renderer.color(f7);
            object = this.renderer;
            float f12 = f3 + f5;
            f2 = f4 + f8;
            object.vertex(f12, f2, 0.0f);
            this.renderer.color(f7);
            object = this.renderer;
            object.vertex(f3 -= f5, f4 -= f8, 0.0f);
            this.renderer.color(f7);
            this.renderer.vertex(f12, f2, 0.0f);
            this.renderer.color(f6);
            this.renderer.vertex(f9, f10, 0.0f);
            this.renderer.color(f7);
            this.renderer.vertex(f3, f4, 0.0f);
            this.renderer.color(f6);
            this.renderer.vertex(f, f11, 0.0f);
        } else {
            this.renderer.color(f6);
            this.renderer.vertex(f + f5, f2 + f8, 0.0f);
            this.renderer.color(f6);
            object = this.renderer;
            float f13 = f2 - f8;
            object.vertex(f -= f5, f13, 0.0f);
            this.renderer.color(f7);
            object = this.renderer;
            f2 = f3 + f5;
            float f14 = f4 + f8;
            object.vertex(f2, f14, 0.0f);
            this.renderer.color(f7);
            this.renderer.vertex(f3 - f5, f4 - f8, 0.0f);
            this.renderer.color(f7);
            this.renderer.vertex(f2, f14, 0.0f);
            this.renderer.color(f6);
            this.renderer.vertex(f, f13, 0.0f);
        }
    }

    public void rectLine(Vector2 vector2, Vector2 vector22, float f) {
        this.rectLine(vector2.x, vector2.y, vector22.x, vector22.y, f);
    }

    public void rotate(float f, float f2, float f3, float f4) {
        this.transformMatrix.rotate(f, f2, f3, f4);
        this.matrixDirty = true;
    }

    public void scale(float f, float f2, float f3) {
        this.transformMatrix.scale(f, f2, f3);
        this.matrixDirty = true;
    }

    public void set(ShapeType shapeType) {
        ShapeType shapeType2 = this.shapeType;
        if (shapeType2 == shapeType) {
            return;
        }
        if (shapeType2 != null) {
            if (this.autoShapeType) {
                this.end();
                this.begin(shapeType);
                return;
            }
            throw new IllegalStateException("autoShapeType must be enabled.");
        }
        throw new IllegalStateException("begin must be called first.");
    }

    public void setAutoShapeType(boolean bl) {
        this.autoShapeType = bl;
    }

    public void setColor(float f, float f2, float f3, float f4) {
        this.color.set(f, f2, f3, f4);
    }

    public void setColor(Color color2) {
        this.color.set(color2);
    }

    public void setProjectionMatrix(Matrix4 matrix4) {
        this.projectionMatrix.set(matrix4);
        this.matrixDirty = true;
    }

    public void setTransformMatrix(Matrix4 matrix4) {
        this.transformMatrix.set(matrix4);
        this.matrixDirty = true;
    }

    public void translate(float f, float f2, float f3) {
        this.transformMatrix.translate(f, f2, f3);
        this.matrixDirty = true;
    }

    public void triangle(float f, float f2, float f3, float f4, float f5, float f6) {
        this.check(ShapeType.Line, ShapeType.Filled, 6);
        float f7 = this.color.toFloatBits();
        if (this.shapeType == ShapeType.Line) {
            this.renderer.color(f7);
            this.renderer.vertex(f, f2, 0.0f);
            this.renderer.color(f7);
            this.renderer.vertex(f3, f4, 0.0f);
            this.renderer.color(f7);
            this.renderer.vertex(f3, f4, 0.0f);
            this.renderer.color(f7);
            this.renderer.vertex(f5, f6, 0.0f);
            this.renderer.color(f7);
            this.renderer.vertex(f5, f6, 0.0f);
            this.renderer.color(f7);
            this.renderer.vertex(f, f2, 0.0f);
        } else {
            this.renderer.color(f7);
            this.renderer.vertex(f, f2, 0.0f);
            this.renderer.color(f7);
            this.renderer.vertex(f3, f4, 0.0f);
            this.renderer.color(f7);
            this.renderer.vertex(f5, f6, 0.0f);
        }
    }

    public void triangle(float f, float f2, float f3, float f4, float f5, float f6, Color color2, Color color3, Color color4) {
        this.check(ShapeType.Line, ShapeType.Filled, 6);
        if (this.shapeType == ShapeType.Line) {
            this.renderer.color(color2.r, color2.g, color2.b, color2.a);
            this.renderer.vertex(f, f2, 0.0f);
            this.renderer.color(color3.r, color3.g, color3.b, color3.a);
            this.renderer.vertex(f3, f4, 0.0f);
            this.renderer.color(color3.r, color3.g, color3.b, color3.a);
            this.renderer.vertex(f3, f4, 0.0f);
            this.renderer.color(color4.r, color4.g, color4.b, color4.a);
            this.renderer.vertex(f5, f6, 0.0f);
            this.renderer.color(color4.r, color4.g, color4.b, color4.a);
            this.renderer.vertex(f5, f6, 0.0f);
            this.renderer.color(color2.r, color2.g, color2.b, color2.a);
            this.renderer.vertex(f, f2, 0.0f);
        } else {
            this.renderer.color(color2.r, color2.g, color2.b, color2.a);
            this.renderer.vertex(f, f2, 0.0f);
            this.renderer.color(color3.r, color3.g, color3.b, color3.a);
            this.renderer.vertex(f3, f4, 0.0f);
            this.renderer.color(color4.r, color4.g, color4.b, color4.a);
            this.renderer.vertex(f5, f6, 0.0f);
        }
    }

    public void updateMatrices() {
        this.matrixDirty = true;
    }

    public void x(float f, float f2, float f3) {
        float f4 = f - f3;
        float f5 = f2 - f3;
        this.line(f4, f5, f += f3, f2 += f3);
        this.line(f4, f2, f, f5);
    }

    public void x(Vector2 vector2, float f) {
        this.x(vector2.x, vector2.y, f);
    }

    public static enum ShapeType {
        Point(0),
        Line(1),
        Filled(4);

        private final int glType;

        private ShapeType(int n2) {
            this.glType = n2;
        }

        public int getGlType() {
            return this.glType;
        }
    }
}

