/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.ObjectIntMap;
import com.badlogic.gdx.utils.ObjectMap;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class ShaderProgram
implements Disposable {
    public static final String BINORMAL_ATTRIBUTE = "a_binormal";
    public static final String BONEWEIGHT_ATTRIBUTE = "a_boneWeight";
    public static final String COLOR_ATTRIBUTE = "a_color";
    public static final String NORMAL_ATTRIBUTE = "a_normal";
    public static final String POSITION_ATTRIBUTE = "a_position";
    public static final String TANGENT_ATTRIBUTE = "a_tangent";
    public static final String TEXCOORD_ATTRIBUTE = "a_texCoord";
    static final IntBuffer intbuf;
    public static boolean pedantic = true;
    public static String prependFragmentCode = "";
    public static String prependVertexCode = "";
    private static final ObjectMap<Application, Array<ShaderProgram>> shaders;
    private String[] attributeNames;
    private final ObjectIntMap<String> attributeSizes;
    private final ObjectIntMap<String> attributeTypes;
    private final ObjectIntMap<String> attributes;
    private int fragmentShaderHandle;
    private final String fragmentShaderSource;
    private boolean invalidated;
    private boolean isCompiled;
    private String log = "";
    private final FloatBuffer matrix;
    IntBuffer params;
    private int program;
    private int refCount = 0;
    IntBuffer type;
    private String[] uniformNames;
    private final ObjectIntMap<String> uniformSizes;
    private final ObjectIntMap<String> uniformTypes;
    private final ObjectIntMap<String> uniforms = new ObjectIntMap();
    private int vertexShaderHandle;
    private final String vertexShaderSource;

    static {
        shaders = new ObjectMap();
        intbuf = BufferUtils.newIntBuffer(1);
    }

    public ShaderProgram(FileHandle fileHandle, FileHandle fileHandle2) {
        this(fileHandle.readString(), fileHandle2.readString());
    }

    public ShaderProgram(String charSequence, String string2) {
        this.uniformTypes = new ObjectIntMap();
        this.uniformSizes = new ObjectIntMap();
        this.attributes = new ObjectIntMap();
        this.attributeTypes = new ObjectIntMap();
        this.attributeSizes = new ObjectIntMap();
        this.params = BufferUtils.newIntBuffer(1);
        this.type = BufferUtils.newIntBuffer(1);
        if (charSequence != null) {
            if (string2 != null) {
                String string3 = prependVertexCode;
                CharSequence charSequence2 = charSequence;
                if (string3 != null) {
                    charSequence2 = charSequence;
                    if (string3.length() > 0) {
                        charSequence2 = new StringBuilder();
                        ((StringBuilder)charSequence2).append(prependVertexCode);
                        ((StringBuilder)charSequence2).append((String)charSequence);
                        charSequence2 = ((StringBuilder)charSequence2).toString();
                    }
                }
                string3 = prependFragmentCode;
                charSequence = string2;
                if (string3 != null) {
                    charSequence = string2;
                    if (string3.length() > 0) {
                        charSequence = new StringBuilder();
                        ((StringBuilder)charSequence).append(prependFragmentCode);
                        ((StringBuilder)charSequence).append(string2);
                        charSequence = ((StringBuilder)charSequence).toString();
                    }
                }
                this.vertexShaderSource = charSequence2;
                this.fragmentShaderSource = charSequence;
                this.matrix = BufferUtils.newFloatBuffer(16);
                this.compileShaders((String)charSequence2, (String)charSequence);
                if (this.isCompiled()) {
                    this.fetchAttributes();
                    this.fetchUniforms();
                    this.addManagedShader(Gdx.app, this);
                }
                return;
            }
            throw new IllegalArgumentException("fragment shader must not be null");
        }
        throw new IllegalArgumentException("vertex shader must not be null");
    }

    private void addManagedShader(Application application, ShaderProgram shaderProgram) {
        Array<ShaderProgram> array;
        Array<ShaderProgram> array2 = array = shaders.get(application);
        if (array == null) {
            array2 = new Array();
        }
        array2.add(shaderProgram);
        shaders.put(application, array2);
    }

    private void checkManaged() {
        if (this.invalidated) {
            this.compileShaders(this.vertexShaderSource, this.fragmentShaderSource);
            this.invalidated = false;
        }
    }

    public static void clearAllShaderPrograms(Application application) {
        shaders.remove(application);
    }

    private void compileShaders(String string2, String string3) {
        this.vertexShaderHandle = this.loadShader(35633, string2);
        this.fragmentShaderHandle = this.loadShader(35632, string3);
        if (this.vertexShaderHandle != -1 && this.fragmentShaderHandle != -1) {
            this.program = this.linkProgram(this.createProgram());
            if (this.program == -1) {
                this.isCompiled = false;
                return;
            }
            this.isCompiled = true;
            return;
        }
        this.isCompiled = false;
    }

    private int fetchAttributeLocation(String string2) {
        int n;
        GL20 gL20 = Gdx.gl20;
        int n2 = n = this.attributes.get(string2, -2);
        if (n == -2) {
            n2 = gL20.glGetAttribLocation(this.program, string2);
            this.attributes.put(string2, n2);
        }
        return n2;
    }

    private void fetchAttributes() {
        this.params.clear();
        Gdx.gl20.glGetProgramiv(this.program, 35721, this.params);
        int n = this.params.get(0);
        this.attributeNames = new String[n];
        for (int i = 0; i < n; ++i) {
            this.params.clear();
            this.params.put(0, 1);
            this.type.clear();
            String string2 = Gdx.gl20.glGetActiveAttrib(this.program, i, this.params, this.type);
            int n2 = Gdx.gl20.glGetAttribLocation(this.program, string2);
            this.attributes.put(string2, n2);
            this.attributeTypes.put(string2, this.type.get(0));
            this.attributeSizes.put(string2, this.params.get(0));
            this.attributeNames[i] = string2;
        }
    }

    private int fetchUniformLocation(String string2) {
        return this.fetchUniformLocation(string2, pedantic);
    }

    private void fetchUniforms() {
        this.params.clear();
        Gdx.gl20.glGetProgramiv(this.program, 35718, this.params);
        int n = this.params.get(0);
        this.uniformNames = new String[n];
        for (int i = 0; i < n; ++i) {
            this.params.clear();
            this.params.put(0, 1);
            this.type.clear();
            String string2 = Gdx.gl20.glGetActiveUniform(this.program, i, this.params, this.type);
            int n2 = Gdx.gl20.glGetUniformLocation(this.program, string2);
            this.uniforms.put(string2, n2);
            this.uniformTypes.put(string2, this.type.get(0));
            this.uniformSizes.put(string2, this.params.get(0));
            this.uniformNames[i] = string2;
        }
    }

    public static String getManagedStatus() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Managed shaders/app: { ");
        for (Application application : shaders.keys()) {
            stringBuilder.append(ShaderProgram.shaders.get((Application)application).size);
            stringBuilder.append(" ");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static int getNumManagedShaderPrograms() {
        return ShaderProgram.shaders.get((Application)Gdx.app).size;
    }

    public static void invalidateAllShaderPrograms(Application object) {
        if (Gdx.gl20 == null) {
            return;
        }
        if ((object = shaders.get((Application)object)) == null) {
            return;
        }
        for (int i = 0; i < ((Array)object).size; ++i) {
            ((ShaderProgram)((Array)object).get((int)i)).invalidated = true;
            ((ShaderProgram)((Array)object).get(i)).checkManaged();
        }
    }

    private int linkProgram(int n) {
        GL20 gL20 = Gdx.gl20;
        if (n == -1) {
            return -1;
        }
        gL20.glAttachShader(n, this.vertexShaderHandle);
        gL20.glAttachShader(n, this.fragmentShaderHandle);
        gL20.glLinkProgram(n);
        Buffer buffer = ByteBuffer.allocateDirect(4);
        ((ByteBuffer)buffer).order(ByteOrder.nativeOrder());
        buffer = ((ByteBuffer)buffer).asIntBuffer();
        gL20.glGetProgramiv(n, 35714, (IntBuffer)buffer);
        if (((IntBuffer)buffer).get(0) == 0) {
            this.log = Gdx.gl20.glGetProgramInfoLog(n);
            return -1;
        }
        return n;
    }

    private int loadShader(int n, String charSequence) {
        Object object = Gdx.gl20;
        Comparable<IntBuffer> comparable = BufferUtils.newIntBuffer(1);
        int n2 = object.glCreateShader(n);
        if (n2 == 0) {
            return -1;
        }
        object.glShaderSource(n2, (String)charSequence);
        object.glCompileShader(n2);
        object.glGetShaderiv(n2, 35713, (IntBuffer)comparable);
        if (((IntBuffer)comparable).get(0) == 0) {
            object = object.glGetShaderInfoLog(n2);
            comparable = new StringBuilder();
            ((StringBuilder)comparable).append(this.log);
            charSequence = n == 35633 ? "Vertex shader\n" : "Fragment shader:\n";
            ((StringBuilder)comparable).append((String)charSequence);
            this.log = ((StringBuilder)comparable).toString();
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append(this.log);
            ((StringBuilder)charSequence).append((String)object);
            this.log = ((StringBuilder)charSequence).toString();
            return -1;
        }
        return n2;
    }

    public void begin() {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        gL20.glUseProgram(this.program);
    }

    protected int createProgram() {
        int n = Gdx.gl20.glCreateProgram();
        if (n == 0) {
            n = -1;
        }
        return n;
    }

    public void disableVertexAttribute(int n) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        gL20.glDisableVertexAttribArray(n);
    }

    public void disableVertexAttribute(String string2) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        int n = this.fetchAttributeLocation(string2);
        if (n == -1) {
            return;
        }
        gL20.glDisableVertexAttribArray(n);
    }

    @Override
    public void dispose() {
        GL20 gL20 = Gdx.gl20;
        gL20.glUseProgram(0);
        gL20.glDeleteShader(this.vertexShaderHandle);
        gL20.glDeleteShader(this.fragmentShaderHandle);
        gL20.glDeleteProgram(this.program);
        if (shaders.get(Gdx.app) != null) {
            shaders.get(Gdx.app).removeValue(this, true);
        }
    }

    public void enableVertexAttribute(int n) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        gL20.glEnableVertexAttribArray(n);
    }

    public void enableVertexAttribute(String string2) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        int n = this.fetchAttributeLocation(string2);
        if (n == -1) {
            return;
        }
        gL20.glEnableVertexAttribArray(n);
    }

    public void end() {
        Gdx.gl20.glUseProgram(0);
    }

    public int fetchUniformLocation(String string2, boolean bl) {
        int n;
        Object object = Gdx.gl20;
        int n2 = n = this.uniforms.get(string2, -2);
        if (n == -2) {
            n2 = object.glGetUniformLocation(this.program, string2);
            if (n2 == -1 && bl) {
                object = new StringBuilder();
                ((StringBuilder)object).append("no uniform with name '");
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append("' in shader");
                throw new IllegalArgumentException(((StringBuilder)object).toString());
            }
            this.uniforms.put(string2, n2);
        }
        return n2;
    }

    public int getAttributeLocation(String string2) {
        return this.attributes.get(string2, -1);
    }

    public int getAttributeSize(String string2) {
        return this.attributeSizes.get(string2, 0);
    }

    public int getAttributeType(String string2) {
        return this.attributeTypes.get(string2, 0);
    }

    public String[] getAttributes() {
        return this.attributeNames;
    }

    public String getFragmentShaderSource() {
        return this.fragmentShaderSource;
    }

    public String getLog() {
        if (this.isCompiled) {
            this.log = Gdx.gl20.glGetProgramInfoLog(this.program);
            return this.log;
        }
        return this.log;
    }

    public int getUniformLocation(String string2) {
        return this.uniforms.get(string2, -1);
    }

    public int getUniformSize(String string2) {
        return this.uniformSizes.get(string2, 0);
    }

    public int getUniformType(String string2) {
        return this.uniformTypes.get(string2, 0);
    }

    public String[] getUniforms() {
        return this.uniformNames;
    }

    public String getVertexShaderSource() {
        return this.vertexShaderSource;
    }

    public boolean hasAttribute(String string2) {
        return this.attributes.containsKey(string2);
    }

    public boolean hasUniform(String string2) {
        return this.uniforms.containsKey(string2);
    }

    public boolean isCompiled() {
        return this.isCompiled;
    }

    public void setAttributef(String string2, float f, float f2, float f3, float f4) {
        Gdx.gl20.glVertexAttrib4f(this.fetchAttributeLocation(string2), f, f2, f3, f4);
    }

    public void setUniform1fv(int n, float[] fArray, int n2, int n3) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        gL20.glUniform1fv(n, n3, fArray, n2);
    }

    public void setUniform1fv(String string2, float[] fArray, int n, int n2) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        gL20.glUniform1fv(this.fetchUniformLocation(string2), n2, fArray, n);
    }

    public void setUniform2fv(int n, float[] fArray, int n2, int n3) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        gL20.glUniform2fv(n, n3 / 2, fArray, n2);
    }

    public void setUniform2fv(String string2, float[] fArray, int n, int n2) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        gL20.glUniform2fv(this.fetchUniformLocation(string2), n2 / 2, fArray, n);
    }

    public void setUniform3fv(int n, float[] fArray, int n2, int n3) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        gL20.glUniform3fv(n, n3 / 3, fArray, n2);
    }

    public void setUniform3fv(String string2, float[] fArray, int n, int n2) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        gL20.glUniform3fv(this.fetchUniformLocation(string2), n2 / 3, fArray, n);
    }

    public void setUniform4fv(int n, float[] fArray, int n2, int n3) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        gL20.glUniform4fv(n, n3 / 4, fArray, n2);
    }

    public void setUniform4fv(String string2, float[] fArray, int n, int n2) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        gL20.glUniform4fv(this.fetchUniformLocation(string2), n2 / 4, fArray, n);
    }

    public void setUniformMatrix(int n, Matrix3 matrix3) {
        this.setUniformMatrix(n, matrix3, false);
    }

    public void setUniformMatrix(int n, Matrix3 matrix3, boolean bl) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        gL20.glUniformMatrix3fv(n, 1, bl, matrix3.val, 0);
    }

    public void setUniformMatrix(int n, Matrix4 matrix4) {
        this.setUniformMatrix(n, matrix4, false);
    }

    public void setUniformMatrix(int n, Matrix4 matrix4, boolean bl) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        gL20.glUniformMatrix4fv(n, 1, bl, matrix4.val, 0);
    }

    public void setUniformMatrix(String string2, Matrix3 matrix3) {
        this.setUniformMatrix(string2, matrix3, false);
    }

    public void setUniformMatrix(String string2, Matrix3 matrix3, boolean bl) {
        this.setUniformMatrix(this.fetchUniformLocation(string2), matrix3, bl);
    }

    public void setUniformMatrix(String string2, Matrix4 matrix4) {
        this.setUniformMatrix(string2, matrix4, false);
    }

    public void setUniformMatrix(String string2, Matrix4 matrix4, boolean bl) {
        this.setUniformMatrix(this.fetchUniformLocation(string2), matrix4, bl);
    }

    public void setUniformMatrix3fv(String string2, FloatBuffer floatBuffer, int n, boolean bl) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        floatBuffer.position(0);
        gL20.glUniformMatrix3fv(this.fetchUniformLocation(string2), n, bl, floatBuffer);
    }

    public void setUniformMatrix4fv(int n, float[] fArray, int n2, int n3) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        gL20.glUniformMatrix4fv(n, n3 / 16, false, fArray, n2);
    }

    public void setUniformMatrix4fv(String string2, FloatBuffer floatBuffer, int n, boolean bl) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        floatBuffer.position(0);
        gL20.glUniformMatrix4fv(this.fetchUniformLocation(string2), n, bl, floatBuffer);
    }

    public void setUniformMatrix4fv(String string2, float[] fArray, int n, int n2) {
        this.setUniformMatrix4fv(this.fetchUniformLocation(string2), fArray, n, n2);
    }

    public void setUniformf(int n, float f) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        gL20.glUniform1f(n, f);
    }

    public void setUniformf(int n, float f, float f2) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        gL20.glUniform2f(n, f, f2);
    }

    public void setUniformf(int n, float f, float f2, float f3) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        gL20.glUniform3f(n, f, f2, f3);
    }

    public void setUniformf(int n, float f, float f2, float f3, float f4) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        gL20.glUniform4f(n, f, f2, f3, f4);
    }

    public void setUniformf(int n, Color color2) {
        this.setUniformf(n, color2.r, color2.g, color2.b, color2.a);
    }

    public void setUniformf(int n, Vector2 vector2) {
        this.setUniformf(n, vector2.x, vector2.y);
    }

    public void setUniformf(int n, Vector3 vector3) {
        this.setUniformf(n, vector3.x, vector3.y, vector3.z);
    }

    public void setUniformf(String string2, float f) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        gL20.glUniform1f(this.fetchUniformLocation(string2), f);
    }

    public void setUniformf(String string2, float f, float f2) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        gL20.glUniform2f(this.fetchUniformLocation(string2), f, f2);
    }

    public void setUniformf(String string2, float f, float f2, float f3) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        gL20.glUniform3f(this.fetchUniformLocation(string2), f, f2, f3);
    }

    public void setUniformf(String string2, float f, float f2, float f3, float f4) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        gL20.glUniform4f(this.fetchUniformLocation(string2), f, f2, f3, f4);
    }

    public void setUniformf(String string2, Color color2) {
        this.setUniformf(string2, color2.r, color2.g, color2.b, color2.a);
    }

    public void setUniformf(String string2, Vector2 vector2) {
        this.setUniformf(string2, vector2.x, vector2.y);
    }

    public void setUniformf(String string2, Vector3 vector3) {
        this.setUniformf(string2, vector3.x, vector3.y, vector3.z);
    }

    public void setUniformi(int n, int n2) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        gL20.glUniform1i(n, n2);
    }

    public void setUniformi(int n, int n2, int n3) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        gL20.glUniform2i(n, n2, n3);
    }

    public void setUniformi(int n, int n2, int n3, int n4) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        gL20.glUniform3i(n, n2, n3, n4);
    }

    public void setUniformi(int n, int n2, int n3, int n4, int n5) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        gL20.glUniform4i(n, n2, n3, n4, n5);
    }

    public void setUniformi(String string2, int n) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        gL20.glUniform1i(this.fetchUniformLocation(string2), n);
    }

    public void setUniformi(String string2, int n, int n2) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        gL20.glUniform2i(this.fetchUniformLocation(string2), n, n2);
    }

    public void setUniformi(String string2, int n, int n2, int n3) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        gL20.glUniform3i(this.fetchUniformLocation(string2), n, n2, n3);
    }

    public void setUniformi(String string2, int n, int n2, int n3, int n4) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        gL20.glUniform4i(this.fetchUniformLocation(string2), n, n2, n3, n4);
    }

    public void setVertexAttribute(int n, int n2, int n3, boolean bl, int n4, int n5) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        gL20.glVertexAttribPointer(n, n2, n3, bl, n4, n5);
    }

    public void setVertexAttribute(int n, int n2, int n3, boolean bl, int n4, Buffer buffer) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        gL20.glVertexAttribPointer(n, n2, n3, bl, n4, buffer);
    }

    public void setVertexAttribute(String string2, int n, int n2, boolean bl, int n3, int n4) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        int n5 = this.fetchAttributeLocation(string2);
        if (n5 == -1) {
            return;
        }
        gL20.glVertexAttribPointer(n5, n, n2, bl, n3, n4);
    }

    public void setVertexAttribute(String string2, int n, int n2, boolean bl, int n3, Buffer buffer) {
        GL20 gL20 = Gdx.gl20;
        this.checkManaged();
        int n4 = this.fetchAttributeLocation(string2);
        if (n4 == -1) {
            return;
        }
        gL20.glVertexAttribPointer(n4, n, n2, bl, n3, buffer);
    }
}

