/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.glutils.IndexData;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;

public class IndexBufferObjectSubData
implements IndexData {
    final ShortBuffer buffer;
    int bufferHandle;
    final ByteBuffer byteBuffer;
    boolean isBound = false;
    final boolean isDirect;
    boolean isDirty = true;
    final int usage;

    public IndexBufferObjectSubData(int n) {
        this.byteBuffer = BufferUtils.newByteBuffer(n * 2);
        this.isDirect = true;
        this.usage = 35044;
        this.buffer = this.byteBuffer.asShortBuffer();
        this.buffer.flip();
        this.byteBuffer.flip();
        this.bufferHandle = this.createBufferObject();
    }

    public IndexBufferObjectSubData(boolean bl, int n) {
        this.byteBuffer = BufferUtils.newByteBuffer(n * 2);
        this.isDirect = true;
        n = bl ? 35044 : 35048;
        this.usage = n;
        this.buffer = this.byteBuffer.asShortBuffer();
        this.buffer.flip();
        this.byteBuffer.flip();
        this.bufferHandle = this.createBufferObject();
    }

    private int createBufferObject() {
        int n = Gdx.gl20.glGenBuffer();
        Gdx.gl20.glBindBuffer(34963, n);
        Gdx.gl20.glBufferData(34963, this.byteBuffer.capacity(), null, this.usage);
        Gdx.gl20.glBindBuffer(34963, 0);
        return n;
    }

    @Override
    public void bind() {
        if (this.bufferHandle != 0) {
            Gdx.gl20.glBindBuffer(34963, this.bufferHandle);
            if (this.isDirty) {
                this.byteBuffer.limit(this.buffer.limit() * 2);
                Gdx.gl20.glBufferSubData(34963, 0, this.byteBuffer.limit(), this.byteBuffer);
                this.isDirty = false;
            }
            this.isBound = true;
            return;
        }
        throw new GdxRuntimeException("IndexBufferObject cannot be used after it has been disposed.");
    }

    @Override
    public void dispose() {
        GL20 gL20 = Gdx.gl20;
        gL20.glBindBuffer(34963, 0);
        gL20.glDeleteBuffer(this.bufferHandle);
        this.bufferHandle = 0;
    }

    @Override
    public ShortBuffer getBuffer() {
        this.isDirty = true;
        return this.buffer;
    }

    @Override
    public int getNumIndices() {
        return this.buffer.limit();
    }

    @Override
    public int getNumMaxIndices() {
        return this.buffer.capacity();
    }

    @Override
    public void invalidate() {
        this.bufferHandle = this.createBufferObject();
        this.isDirty = true;
    }

    @Override
    public void setIndices(ShortBuffer shortBuffer) {
        int n = shortBuffer.position();
        this.isDirty = true;
        this.buffer.clear();
        this.buffer.put(shortBuffer);
        this.buffer.flip();
        shortBuffer.position(n);
        this.byteBuffer.position(0);
        this.byteBuffer.limit(this.buffer.limit() << 1);
        if (this.isBound) {
            Gdx.gl20.glBufferSubData(34963, 0, this.byteBuffer.limit(), this.byteBuffer);
            this.isDirty = false;
        }
    }

    @Override
    public void setIndices(short[] sArray, int n, int n2) {
        this.isDirty = true;
        this.buffer.clear();
        this.buffer.put(sArray, n, n2);
        this.buffer.flip();
        this.byteBuffer.position(0);
        this.byteBuffer.limit(n2 << 1);
        if (this.isBound) {
            Gdx.gl20.glBufferSubData(34963, 0, this.byteBuffer.limit(), this.byteBuffer);
            this.isDirty = false;
        }
    }

    @Override
    public void unbind() {
        Gdx.gl20.glBindBuffer(34963, 0);
        this.isBound = false;
    }

    @Override
    public void updateIndices(int n, short[] sArray, int n2, int n3) {
        this.isDirty = true;
        int n4 = this.byteBuffer.position();
        this.byteBuffer.position(n * 2);
        BufferUtils.copy(sArray, n2, (Buffer)this.byteBuffer, n3);
        this.byteBuffer.position(n4);
        this.buffer.position(0);
        if (this.isBound) {
            Gdx.gl20.glBufferSubData(34963, 0, this.byteBuffer.limit(), this.byteBuffer);
            this.isDirty = false;
        }
    }
}

