/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ETC1 {
    public static int ETC1_RGB8_OES = 36196;
    public static int PKM_HEADER_SIZE = 16;

    public static Pixmap decodeImage(ETC1Data eTC1Data, Pixmap.Format object) {
        int n;
        int n2;
        int n3;
        if (eTC1Data.hasPKMHeader()) {
            n3 = ETC1.getWidthPKM(eTC1Data.compressedData, 0);
            n2 = ETC1.getHeightPKM(eTC1Data.compressedData, 0);
            n = 16;
        } else {
            n3 = eTC1Data.width;
            n2 = eTC1Data.height;
            n = 0;
        }
        int n4 = ETC1.getPixelSize((Pixmap.Format)((Object)object));
        object = new Pixmap(n3, n2, (Pixmap.Format)((Object)object));
        ETC1.decodeImage(eTC1Data.compressedData, n, ((Pixmap)object).getPixels(), 0, n3, n2, n4);
        return object;
    }

    private static native void decodeImage(ByteBuffer var0, int var1, ByteBuffer var2, int var3, int var4, int var5, int var6);

    public static ETC1Data encodeImage(Pixmap pixmap) {
        int n = ETC1.getPixelSize(pixmap.getFormat());
        ByteBuffer byteBuffer = ETC1.encodeImage(pixmap.getPixels(), 0, pixmap.getWidth(), pixmap.getHeight(), n);
        BufferUtils.newUnsafeByteBuffer(byteBuffer);
        return new ETC1Data(pixmap.getWidth(), pixmap.getHeight(), byteBuffer, 0);
    }

    private static native ByteBuffer encodeImage(ByteBuffer var0, int var1, int var2, int var3, int var4);

    public static ETC1Data encodeImagePKM(Pixmap pixmap) {
        int n = ETC1.getPixelSize(pixmap.getFormat());
        ByteBuffer byteBuffer = ETC1.encodeImagePKM(pixmap.getPixels(), 0, pixmap.getWidth(), pixmap.getHeight(), n);
        BufferUtils.newUnsafeByteBuffer(byteBuffer);
        return new ETC1Data(pixmap.getWidth(), pixmap.getHeight(), byteBuffer, 16);
    }

    private static native ByteBuffer encodeImagePKM(ByteBuffer var0, int var1, int var2, int var3, int var4);

    public static native void formatHeader(ByteBuffer var0, int var1, int var2, int var3);

    public static native int getCompressedDataSize(int var0, int var1);

    static native int getHeightPKM(ByteBuffer var0, int var1);

    private static int getPixelSize(Pixmap.Format format) {
        if (format == Pixmap.Format.RGB565) {
            return 2;
        }
        if (format == Pixmap.Format.RGB888) {
            return 3;
        }
        throw new GdxRuntimeException("Can only handle RGB565 or RGB888 images");
    }

    static native int getWidthPKM(ByteBuffer var0, int var1);

    static native boolean isValidPKM(ByteBuffer var0, int var1);

    public static final class ETC1Data
    implements Disposable {
        public final ByteBuffer compressedData;
        public final int dataOffset;
        public final int height;
        public final int width;

        public ETC1Data(int n, int n2, ByteBuffer byteBuffer, int n3) {
            this.width = n;
            this.height = n2;
            this.compressedData = byteBuffer;
            this.dataOffset = n3;
            this.checkNPOT();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public ETC1Data(FileHandle fileHandle) {
            void var1_4;
            DataInputStream dataInputStream;
            block8: {
                DataInputStream dataInputStream2;
                Object object;
                StringBuilder stringBuilder;
                block9: {
                    DataInputStream dataInputStream3;
                    byte[] byArray = new byte[10240];
                    stringBuilder = null;
                    dataInputStream = dataInputStream3 = null;
                    try {
                        dataInputStream = dataInputStream3;
                        dataInputStream = dataInputStream3;
                        dataInputStream = dataInputStream3;
                        GZIPInputStream gZIPInputStream = new GZIPInputStream(fileHandle.read());
                        dataInputStream = dataInputStream3;
                        object = new BufferedInputStream(gZIPInputStream);
                        dataInputStream = dataInputStream3;
                        dataInputStream2 = new DataInputStream((InputStream)object);
                    }
                    catch (Throwable throwable) {
                        break block8;
                    }
                    catch (Exception exception) {
                        dataInputStream2 = stringBuilder;
                        break block9;
                    }
                    try {
                        int n;
                        this.compressedData = BufferUtils.newUnsafeByteBuffer(dataInputStream2.readInt());
                        while ((n = dataInputStream2.read(byArray)) != -1) {
                            this.compressedData.put(byArray, 0, n);
                        }
                        this.compressedData.position(0);
                        this.compressedData.limit(this.compressedData.capacity());
                    }
                    catch (Throwable throwable) {
                        dataInputStream = dataInputStream2;
                        break block8;
                    }
                    catch (Exception exception) {
                        break block9;
                    }
                    StreamUtils.closeQuietly(dataInputStream2);
                    this.width = ETC1.getWidthPKM(this.compressedData, 0);
                    this.height = ETC1.getHeightPKM(this.compressedData, 0);
                    this.dataOffset = PKM_HEADER_SIZE;
                    this.compressedData.position(this.dataOffset);
                    this.checkNPOT();
                    return;
                }
                dataInputStream = dataInputStream2;
                {
                    void var4_10;
                    dataInputStream = dataInputStream2;
                    dataInputStream = dataInputStream2;
                    stringBuilder = new StringBuilder();
                    dataInputStream = dataInputStream2;
                    stringBuilder.append("Couldn't load pkm file '");
                    dataInputStream = dataInputStream2;
                    stringBuilder.append(fileHandle);
                    dataInputStream = dataInputStream2;
                    stringBuilder.append("'");
                    dataInputStream = dataInputStream2;
                    object = new GdxRuntimeException(stringBuilder.toString(), (Throwable)var4_10);
                    dataInputStream = dataInputStream2;
                    throw object;
                }
            }
            StreamUtils.closeQuietly(dataInputStream);
            throw var1_4;
        }

        private void checkNPOT() {
            if (!MathUtils.isPowerOfTwo(this.width) || !MathUtils.isPowerOfTwo(this.height)) {
                System.out.println("ETC1Data warning: non-power-of-two ETC1 textures may crash the driver of PowerVR GPUs");
            }
        }

        @Override
        public void dispose() {
            BufferUtils.disposeUnsafeByteBuffer(this.compressedData);
        }

        public boolean hasPKMHeader() {
            boolean bl = this.dataOffset == 16;
            return bl;
        }

        public String toString() {
            if (this.hasPKMHeader()) {
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = ETC1.isValidPKM(this.compressedData, 0) ? "valid" : "invalid";
                stringBuilder.append(string2);
                stringBuilder.append(" pkm [");
                stringBuilder.append(ETC1.getWidthPKM(this.compressedData, 0));
                stringBuilder.append("x");
                stringBuilder.append(ETC1.getHeightPKM(this.compressedData, 0));
                stringBuilder.append("], compressed: ");
                stringBuilder.append(this.compressedData.capacity() - PKM_HEADER_SIZE);
                return stringBuilder.toString();
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("raw [");
            stringBuilder.append(this.width);
            stringBuilder.append("x");
            stringBuilder.append(this.height);
            stringBuilder.append("], compressed: ");
            stringBuilder.append(this.compressedData.capacity() - PKM_HEADER_SIZE);
            return stringBuilder.toString();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void write(FileHandle object) {
            void var1_4;
            Object object2;
            block8: {
                DataOutputStream dataOutputStream;
                GdxRuntimeException gdxRuntimeException;
                Object object3;
                block9: {
                    object3 = new byte[10240];
                    this.compressedData.position(0);
                    object2 = this.compressedData;
                    ((ByteBuffer)object2).limit(((Buffer)object2).capacity());
                    gdxRuntimeException = null;
                    Object var5_8 = null;
                    object2 = var5_8;
                    try {
                        object2 = var5_8;
                        object2 = var5_8;
                        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(((FileHandle)object).write(false));
                        object2 = var5_8;
                        dataOutputStream = new DataOutputStream(gZIPOutputStream);
                    }
                    catch (Throwable throwable) {
                        break block8;
                    }
                    catch (Exception exception) {
                        dataOutputStream = gdxRuntimeException;
                        break block9;
                    }
                    try {
                        int n;
                        dataOutputStream.writeInt(this.compressedData.capacity());
                        for (int i = 0; i != this.compressedData.capacity(); i += n) {
                            n = Math.min(this.compressedData.remaining(), ((Object)object3).length);
                            this.compressedData.get((byte[])object3, 0, n);
                            dataOutputStream.write((byte[])object3, 0, n);
                        }
                    }
                    catch (Throwable throwable) {
                        object2 = dataOutputStream;
                        break block8;
                    }
                    catch (Exception exception) {
                        break block9;
                    }
                    StreamUtils.closeQuietly(dataOutputStream);
                    this.compressedData.position(this.dataOffset);
                    object = this.compressedData;
                    ((ByteBuffer)object).limit(((Buffer)object).capacity());
                    return;
                }
                object2 = dataOutputStream;
                {
                    void var5_11;
                    object2 = dataOutputStream;
                    object3 = new StringBuilder;
                    object2 = dataOutputStream;
                    ((StringBuilder)object3)();
                    object2 = dataOutputStream;
                    ((StringBuilder)object3).append("Couldn't write PKM file to '");
                    object2 = dataOutputStream;
                    ((StringBuilder)object3).append(object);
                    object2 = dataOutputStream;
                    ((StringBuilder)object3).append("'");
                    object2 = dataOutputStream;
                    gdxRuntimeException = new GdxRuntimeException(((StringBuilder)object3).toString(), (Throwable)var5_11);
                    object2 = dataOutputStream;
                    throw gdxRuntimeException;
                }
            }
            StreamUtils.closeQuietly((Closeable)object2);
            throw var1_4;
        }
    }
}

