/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.utils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.g3d.utils.TextureBinder;
import com.badlogic.gdx.graphics.g3d.utils.TextureDescriptor;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.nio.IntBuffer;

public final class DefaultTextureBinder
implements TextureBinder {
    public static final int MAX_GLES_UNITS = 32;
    public static final int ROUNDROBIN = 0;
    public static final int WEIGHTED = 1;
    private int bindCount = 0;
    private final int count;
    private int currentTexture = 0;
    private final int method;
    private final int offset;
    private int reuseCount = 0;
    private final int reuseWeight;
    private boolean reused;
    private final TextureDescriptor tempDesc = new TextureDescriptor();
    private final GLTexture[] textures;
    private final int[] weights;

    public DefaultTextureBinder(int n) {
        this(n, 0);
    }

    public DefaultTextureBinder(int n, int n2) {
        this(n, n2, -1);
    }

    public DefaultTextureBinder(int n, int n2, int n3) {
        this(n, n2, n3, 10);
    }

    public DefaultTextureBinder(int n, int n2, int n3, int n4) {
        int n5 = Math.min(DefaultTextureBinder.getMaxTextureUnits(), 32);
        int n6 = n3;
        if (n3 < 0) {
            n6 = n5 - n2;
        }
        if (n2 >= 0 && n6 >= 0 && n2 + n6 <= n5 && n4 >= 1) {
            this.method = n;
            this.offset = n2;
            this.count = n6;
            this.textures = new GLTexture[n6];
            this.reuseWeight = n4;
            int[] nArray = n == 1 ? new int[n6] : null;
            this.weights = nArray;
            return;
        }
        throw new GdxRuntimeException("Illegal arguments");
    }

    private final int bindTexture(TextureDescriptor textureDescriptor, boolean bl) {
        int n;
        Object t = textureDescriptor.texture;
        this.reused = false;
        int n2 = this.method;
        if (n2 != 0) {
            if (n2 != 1) {
                return -1;
            }
            n = this.offset;
            n2 = this.bindTextureWeighted((GLTexture)t);
        } else {
            n = this.offset;
            n2 = this.bindTextureRoundRobin((GLTexture)t);
        }
        n2 = n + n2;
        if (this.reused) {
            ++this.reuseCount;
            if (bl) {
                ((GLTexture)t).bind(n2);
            } else {
                Gdx.gl.glActiveTexture(33984 + n2);
            }
        } else {
            ++this.bindCount;
        }
        ((GLTexture)t).unsafeSetWrap(textureDescriptor.uWrap, textureDescriptor.vWrap);
        ((GLTexture)t).unsafeSetFilter(textureDescriptor.minFilter, textureDescriptor.magFilter);
        return n2;
    }

    private final int bindTextureRoundRobin(GLTexture gLTexture) {
        int n;
        int n2;
        for (n2 = 0; n2 < (n = this.count); ++n2) {
            if (this.textures[n = (this.currentTexture + n2) % n] != gLTexture) continue;
            this.reused = true;
            return n;
        }
        this.currentTexture = (this.currentTexture + 1) % n;
        GLTexture[] gLTextureArray = this.textures;
        n2 = this.currentTexture;
        gLTextureArray[n2] = gLTexture;
        gLTexture.bind(this.offset + n2);
        return this.currentTexture;
    }

    private final int bindTextureWeighted(GLTexture gLTexture) {
        int[] nArray = this.weights;
        int n = nArray[0];
        int n2 = -1;
        int n3 = 0;
        for (int i = 0; i < this.count; ++i) {
            int n4;
            int n5;
            block7: {
                block8: {
                    int n6;
                    block6: {
                        if (this.textures[i] != gLTexture) break block6;
                        nArray = this.weights;
                        nArray[i] = nArray[i] + this.reuseWeight;
                        n5 = i;
                        n4 = n;
                        break block7;
                    }
                    nArray = this.weights;
                    if (nArray[i] < 0) break block8;
                    nArray[i] = n6 = nArray[i] - 1;
                    n5 = n2;
                    n4 = n;
                    if (n6 >= n) break block7;
                }
                n4 = this.weights[i];
                n3 = i;
                n5 = n2;
            }
            n2 = n5;
            n = n4;
        }
        if (n2 < 0) {
            this.textures[n3] = gLTexture;
            this.weights[n3] = 100;
            gLTexture.bind(this.offset + n3);
            n2 = n3;
        } else {
            this.reused = true;
        }
        return n2;
    }

    private static int getMaxTextureUnits() {
        IntBuffer intBuffer = BufferUtils.newIntBuffer(16);
        Gdx.gl.glGetIntegerv(34930, intBuffer);
        return intBuffer.get(0);
    }

    @Override
    public void begin() {
        for (int i = 0; i < this.count; ++i) {
            this.textures[i] = null;
            int[] nArray = this.weights;
            if (nArray == null) continue;
            nArray[i] = 0;
        }
    }

    @Override
    public final int bind(GLTexture gLTexture) {
        this.tempDesc.set(gLTexture, null, null, null, null);
        return this.bindTexture(this.tempDesc, false);
    }

    @Override
    public final int bind(TextureDescriptor textureDescriptor) {
        return this.bindTexture(textureDescriptor, false);
    }

    @Override
    public void end() {
        Gdx.gl.glActiveTexture(33984);
    }

    @Override
    public final int getBindCount() {
        return this.bindCount;
    }

    @Override
    public final int getReuseCount() {
        return this.reuseCount;
    }

    @Override
    public final void resetCounts() {
        this.reuseCount = 0;
        this.bindCount = 0;
    }
}

