/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles.emitters;

import com.badlogic.gdx.graphics.g3d.particles.ParallelArray;
import com.badlogic.gdx.graphics.g3d.particles.ParticleChannels;
import com.badlogic.gdx.graphics.g3d.particles.ParticleControllerComponent;
import com.badlogic.gdx.graphics.g3d.particles.emitters.Emitter;
import com.badlogic.gdx.graphics.g3d.particles.values.RangedNumericValue;
import com.badlogic.gdx.graphics.g3d.particles.values.ScaledNumericValue;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;

public class RegularEmitter
extends Emitter
implements Json.Serializable {
    private boolean continuous;
    protected float delay;
    protected float delayTimer;
    public RangedNumericValue delayValue = new RangedNumericValue();
    protected float duration;
    protected float durationTimer;
    public RangedNumericValue durationValue = new RangedNumericValue();
    protected int emission;
    protected int emissionDelta;
    protected int emissionDiff;
    private EmissionMode emissionMode;
    public ScaledNumericValue emissionValue;
    protected int life;
    private ParallelArray.FloatChannel lifeChannel;
    protected int lifeDiff;
    protected int lifeOffset;
    protected int lifeOffsetDiff;
    public ScaledNumericValue lifeOffsetValue = new ScaledNumericValue();
    public ScaledNumericValue lifeValue = new ScaledNumericValue();

    public RegularEmitter() {
        this.emissionValue = new ScaledNumericValue();
        this.durationValue.setActive(true);
        this.emissionValue.setActive(true);
        this.lifeValue.setActive(true);
        this.continuous = true;
        this.emissionMode = EmissionMode.Enabled;
    }

    public RegularEmitter(RegularEmitter regularEmitter) {
        this();
        this.set(regularEmitter);
    }

    private void addParticles(int n) {
        if ((n = Math.min(n, this.maxParticleCount - this.controller.particles.size)) <= 0) {
            return;
        }
        this.controller.activateParticles(this.controller.particles.size, n);
        ParallelArray parallelArray = this.controller.particles;
        parallelArray.size += n;
    }

    @Override
    public void activateParticles(int n, int n2) {
        int n3;
        int n4 = this.life + (int)((float)this.lifeDiff * this.lifeValue.getScale(this.percent));
        int n5 = (int)((float)this.lifeOffset + (float)this.lifeOffsetDiff * this.lifeOffsetValue.getScale(this.percent));
        if (n5 > 0) {
            n3 = n5;
            if (n5 >= n4) {
                n3 = n4 - 1;
            }
            n3 = n4 - n3;
        } else {
            n3 = n4;
        }
        float f = n3;
        float f2 = n4;
        float f3 = f / f2;
        n3 = n * this.lifeChannel.strideSize;
        n4 = this.lifeChannel.strideSize;
        for (n = n3; n < n2 * n4 + n3; n += this.lifeChannel.strideSize) {
            this.lifeChannel.data[n + 0] = f;
            this.lifeChannel.data[n + 1] = f2;
            this.lifeChannel.data[n + 2] = 1.0f - f3;
        }
    }

    @Override
    public void allocateChannels() {
        this.lifeChannel = (ParallelArray.FloatChannel)this.controller.particles.addChannel(ParticleChannels.Life);
    }

    @Override
    public ParticleControllerComponent copy() {
        return new RegularEmitter(this);
    }

    public RangedNumericValue getDelay() {
        return this.delayValue;
    }

    public RangedNumericValue getDuration() {
        return this.durationValue;
    }

    public ScaledNumericValue getEmission() {
        return this.emissionValue;
    }

    public EmissionMode getEmissionMode() {
        return this.emissionMode;
    }

    public ScaledNumericValue getLife() {
        return this.lifeValue;
    }

    public ScaledNumericValue getLifeOffset() {
        return this.lifeOffsetValue;
    }

    public float getPercentComplete() {
        if (this.delayTimer < this.delay) {
            return 0.0f;
        }
        return Math.min(1.0f, this.durationTimer / this.duration);
    }

    @Override
    public void init() {
        super.init();
        this.emissionDelta = 0;
        this.durationTimer = this.duration;
    }

    @Override
    public boolean isComplete() {
        float f = this.delayTimer;
        float f2 = this.delay;
        boolean bl = false;
        if (f < f2) {
            return false;
        }
        boolean bl2 = bl;
        if (this.durationTimer >= this.duration) {
            bl2 = bl;
            if (this.controller.particles.size == 0) {
                bl2 = true;
            }
        }
        return bl2;
    }

    public boolean isContinuous() {
        return this.continuous;
    }

    @Override
    public void read(Json json, JsonValue jsonValue) {
        super.read(json, jsonValue);
        this.continuous = json.readValue("continous", Boolean.TYPE, jsonValue);
        this.emissionValue = json.readValue("emission", ScaledNumericValue.class, jsonValue);
        this.delayValue = json.readValue("delay", RangedNumericValue.class, jsonValue);
        this.durationValue = json.readValue("duration", RangedNumericValue.class, jsonValue);
        this.lifeValue = json.readValue("life", ScaledNumericValue.class, jsonValue);
        this.lifeOffsetValue = json.readValue("lifeOffset", ScaledNumericValue.class, jsonValue);
    }

    public void set(RegularEmitter regularEmitter) {
        super.set(regularEmitter);
        this.delayValue.load(regularEmitter.delayValue);
        this.durationValue.load(regularEmitter.durationValue);
        this.lifeOffsetValue.load(regularEmitter.lifeOffsetValue);
        this.lifeValue.load(regularEmitter.lifeValue);
        this.emissionValue.load(regularEmitter.emissionValue);
        this.emission = regularEmitter.emission;
        this.emissionDiff = regularEmitter.emissionDiff;
        this.emissionDelta = regularEmitter.emissionDelta;
        this.lifeOffset = regularEmitter.lifeOffset;
        this.lifeOffsetDiff = regularEmitter.lifeOffsetDiff;
        this.life = regularEmitter.life;
        this.lifeDiff = regularEmitter.lifeDiff;
        this.duration = regularEmitter.duration;
        this.delay = regularEmitter.delay;
        this.durationTimer = regularEmitter.durationTimer;
        this.delayTimer = regularEmitter.delayTimer;
        this.continuous = regularEmitter.continuous;
    }

    public void setContinuous(boolean bl) {
        this.continuous = bl;
    }

    public void setEmissionMode(EmissionMode emissionMode) {
        this.emissionMode = emissionMode;
    }

    @Override
    public void start() {
        float f = this.delayValue.active ? this.delayValue.newLowValue() : 0.0f;
        this.delay = f;
        this.delayTimer = 0.0f;
        this.durationTimer = 0.0f;
        this.duration = this.durationValue.newLowValue();
        this.percent = this.durationTimer / this.duration;
        this.emission = (int)this.emissionValue.newLowValue();
        this.emissionDiff = (int)this.emissionValue.newHighValue();
        if (!this.emissionValue.isRelative()) {
            this.emissionDiff -= this.emission;
        }
        this.life = (int)this.lifeValue.newLowValue();
        this.lifeDiff = (int)this.lifeValue.newHighValue();
        if (!this.lifeValue.isRelative()) {
            this.lifeDiff -= this.life;
        }
        int n = this.lifeOffsetValue.active ? (int)this.lifeOffsetValue.newLowValue() : 0;
        this.lifeOffset = n;
        this.lifeOffsetDiff = (int)this.lifeOffsetValue.newHighValue();
        if (!this.lifeOffsetValue.isRelative()) {
            this.lifeOffsetDiff -= this.lifeOffset;
        }
    }

    @Override
    public void update() {
        int n;
        float f = this.controller.deltaTime * 1000.0f;
        float f2 = this.delayTimer;
        float f3 = this.delay;
        int n2 = 0;
        if (f2 < f3) {
            this.delayTimer = f2 + f;
        } else {
            n = this.emissionMode != EmissionMode.Disabled ? 1 : 0;
            f2 = this.durationTimer;
            f3 = this.duration;
            if (f2 < f3) {
                this.durationTimer = f2 + f;
                this.percent = this.durationTimer / f3;
            } else if (this.continuous && n != 0 && this.emissionMode == EmissionMode.Enabled) {
                this.controller.start();
            } else {
                n = 0;
            }
            if (n != 0) {
                this.emissionDelta = (int)((float)this.emissionDelta + f);
                f2 = (float)this.emission + (float)this.emissionDiff * this.emissionValue.getScale(this.percent);
                if (f2 > 0.0f && (float)(n = this.emissionDelta) >= (f2 = 1000.0f / f2)) {
                    n = Math.min((int)((float)n / f2), this.maxParticleCount - this.controller.particles.size);
                    this.emissionDelta = (int)((float)this.emissionDelta - (float)n * f2);
                    this.emissionDelta = (int)((float)this.emissionDelta % f2);
                    this.addParticles(n);
                }
                if (this.controller.particles.size < this.minParticleCount) {
                    this.addParticles(this.minParticleCount - this.controller.particles.size);
                }
            }
        }
        int n3 = this.controller.particles.size;
        n = 0;
        while (n2 < this.controller.particles.size) {
            float[] fArray = this.lifeChannel.data;
            int n4 = n + 0;
            fArray[n4] = f2 = fArray[n4] - f;
            if (f2 <= 0.0f) {
                this.controller.particles.removeElement(n2);
                continue;
            }
            this.lifeChannel.data[n + 2] = 1.0f - this.lifeChannel.data[n4] / this.lifeChannel.data[n + 1];
            ++n2;
            n += this.lifeChannel.strideSize;
        }
        if (this.controller.particles.size < n3) {
            this.controller.killParticles(this.controller.particles.size, n3 - this.controller.particles.size);
        }
    }

    @Override
    public void write(Json json) {
        super.write(json);
        json.writeValue("continous", this.continuous);
        json.writeValue("emission", this.emissionValue);
        json.writeValue("delay", this.delayValue);
        json.writeValue("duration", this.durationValue);
        json.writeValue("life", this.lifeValue);
        json.writeValue("lifeOffset", this.lifeOffsetValue);
    }

    public static enum EmissionMode {
        Enabled,
        EnabledUntilCycleEnd,
        Disabled;

    }
}

