/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles.batches;

import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.Shader;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.DepthTestAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.particles.ParallelArray;
import com.badlogic.gdx.graphics.g3d.particles.ParticleShader;
import com.badlogic.gdx.graphics.g3d.particles.ResourceData;
import com.badlogic.gdx.graphics.g3d.particles.batches.BufferedParticleBatch;
import com.badlogic.gdx.graphics.g3d.particles.renderers.BillboardControllerRenderData;
import com.badlogic.gdx.graphics.g3d.shaders.DefaultShader;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import java.util.Iterator;

public class BillboardParticleBatch
extends BufferedParticleBatch<BillboardControllerRenderData> {
    private static final VertexAttributes CPU_ATTRIBUTES;
    private static final int CPU_COLOR_OFFSET;
    private static final int CPU_POSITION_OFFSET;
    private static final int CPU_UV_OFFSET;
    private static final int CPU_VERTEX_SIZE;
    private static final VertexAttributes GPU_ATTRIBUTES;
    private static final int GPU_COLOR_OFFSET;
    private static final int GPU_POSITION_OFFSET;
    private static final int GPU_SIZE_ROTATION_OFFSET;
    private static final int GPU_UV_OFFSET;
    private static final int GPU_VERTEX_SIZE;
    private static final int MAX_PARTICLES_PER_MESH = 8191;
    private static final int MAX_VERTICES_PER_MESH = 32764;
    protected static final Matrix3 TMP_M3;
    protected static final Vector3 TMP_V1;
    protected static final Vector3 TMP_V2;
    protected static final Vector3 TMP_V3;
    protected static final Vector3 TMP_V4;
    protected static final Vector3 TMP_V5;
    protected static final Vector3 TMP_V6;
    protected static final int directionUsage = 1024;
    protected static final int sizeAndRotationUsage = 512;
    protected BlendingAttribute blendingAttribute;
    private VertexAttributes currentAttributes;
    private int currentVertexSize = 0;
    protected DepthTestAttribute depthTestAttribute;
    private short[] indices;
    protected ParticleShader.AlignMode mode = ParticleShader.AlignMode.Screen;
    private RenderablePool renderablePool;
    private Array<Renderable> renderables = new Array();
    Shader shader;
    protected Texture texture;
    protected boolean useGPU = false;
    private float[] vertices;

    static {
        TMP_V1 = new Vector3();
        TMP_V2 = new Vector3();
        TMP_V3 = new Vector3();
        TMP_V4 = new Vector3();
        TMP_V5 = new Vector3();
        TMP_V6 = new Vector3();
        TMP_M3 = new Matrix3();
        GPU_ATTRIBUTES = new VertexAttributes(new VertexAttribute(1, 3, "a_position"), new VertexAttribute(16, 2, "a_texCoord0"), new VertexAttribute(2, 4, "a_color"), new VertexAttribute(512, 4, "a_sizeAndRotation"));
        CPU_ATTRIBUTES = new VertexAttributes(new VertexAttribute(1, 3, "a_position"), new VertexAttribute(16, 2, "a_texCoord0"), new VertexAttribute(2, 4, "a_color"));
        GPU_POSITION_OFFSET = (short)(BillboardParticleBatch.GPU_ATTRIBUTES.findByUsage((int)1).offset / 4);
        GPU_UV_OFFSET = (short)(BillboardParticleBatch.GPU_ATTRIBUTES.findByUsage((int)16).offset / 4);
        GPU_SIZE_ROTATION_OFFSET = (short)(BillboardParticleBatch.GPU_ATTRIBUTES.findByUsage((int)512).offset / 4);
        GPU_COLOR_OFFSET = (short)(BillboardParticleBatch.GPU_ATTRIBUTES.findByUsage((int)2).offset / 4);
        GPU_VERTEX_SIZE = BillboardParticleBatch.GPU_ATTRIBUTES.vertexSize / 4;
        CPU_POSITION_OFFSET = (short)(BillboardParticleBatch.CPU_ATTRIBUTES.findByUsage((int)1).offset / 4);
        CPU_UV_OFFSET = (short)(BillboardParticleBatch.CPU_ATTRIBUTES.findByUsage((int)16).offset / 4);
        CPU_COLOR_OFFSET = (short)(BillboardParticleBatch.CPU_ATTRIBUTES.findByUsage((int)2).offset / 4);
        CPU_VERTEX_SIZE = BillboardParticleBatch.CPU_ATTRIBUTES.vertexSize / 4;
    }

    public BillboardParticleBatch() {
        this(ParticleShader.AlignMode.Screen, false, 100);
    }

    public BillboardParticleBatch(int n) {
        this(ParticleShader.AlignMode.Screen, false, n);
    }

    public BillboardParticleBatch(ParticleShader.AlignMode alignMode, boolean bl, int n) {
        this(alignMode, bl, n, null, null);
    }

    public BillboardParticleBatch(ParticleShader.AlignMode alignMode, boolean bl, int n, BlendingAttribute blendingAttribute, DepthTestAttribute depthTestAttribute) {
        super(BillboardControllerRenderData.class);
        this.renderablePool = new RenderablePool();
        this.blendingAttribute = blendingAttribute;
        this.depthTestAttribute = depthTestAttribute;
        if (this.blendingAttribute == null) {
            this.blendingAttribute = new BlendingAttribute(1, 771, 1.0f);
        }
        if (this.depthTestAttribute == null) {
            this.depthTestAttribute = new DepthTestAttribute(515, false);
        }
        this.allocIndices();
        this.initRenderData();
        this.ensureCapacity(n);
        this.setUseGpu(bl);
        this.setAlignMode(alignMode);
    }

    private void allocIndices() {
        this.indices = new short[49146];
        int n = 0;
        int n2 = 0;
        while (n < 49146) {
            short[] sArray = this.indices;
            short s = (short)n2;
            sArray[n] = s;
            sArray[n + 1] = (short)(n2 + 1);
            short s2 = (short)(n2 + 2);
            sArray[n + 2] = s2;
            sArray[n + 3] = s2;
            sArray[n + 4] = (short)(n2 + 3);
            sArray[n + 5] = s;
            n += 6;
            n2 += 4;
        }
    }

    private void allocRenderables(int n) {
        int n2 = MathUtils.ceil(n / 8191);
        int n3 = this.renderablePool.getFree();
        if (n3 < n2) {
            for (n = 0; n < n2 - n3; ++n) {
                RenderablePool renderablePool = this.renderablePool;
                renderablePool.free(renderablePool.newObject());
            }
        }
    }

    private void allocShader() {
        Shader shader;
        Renderable renderable = this.allocRenderable();
        renderable.shader = shader = this.getShader(renderable);
        this.shader = shader;
        this.renderablePool.free(renderable);
    }

    private void clearRenderablesPool() {
        this.renderablePool.freeAll(this.renderables);
        int n = this.renderablePool.getFree();
        for (int i = 0; i < n; ++i) {
            ((Renderable)this.renderablePool.obtain()).meshPart.mesh.dispose();
        }
        this.renderables.clear();
    }

    private void fillVerticesGPU(int[] nArray) {
        Iterator iterator = this.renderData.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object object = (BillboardControllerRenderData)iterator.next();
            ParallelArray.FloatChannel floatChannel = ((BillboardControllerRenderData)object).scaleChannel;
            ParallelArray.FloatChannel floatChannel2 = ((BillboardControllerRenderData)object).regionChannel;
            ParallelArray.FloatChannel floatChannel3 = ((BillboardControllerRenderData)object).positionChannel;
            ParallelArray.FloatChannel floatChannel4 = ((BillboardControllerRenderData)object).colorChannel;
            ParallelArray.FloatChannel floatChannel5 = ((BillboardControllerRenderData)object).rotationChannel;
            int n2 = ((BillboardControllerRenderData)object).controller.particles.size;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = nArray[n] * this.currentVertexSize * 4;
                float f = floatChannel.data[floatChannel.strideSize * n3];
                int n5 = floatChannel2.strideSize * n3;
                int n6 = floatChannel3.strideSize * n3;
                int n7 = floatChannel4.strideSize * n3;
                int n8 = floatChannel5.strideSize * n3;
                float f2 = floatChannel3.data[n6 + 0];
                float f3 = floatChannel3.data[n6 + 1];
                float f4 = floatChannel3.data[n6 + 2];
                float f5 = floatChannel2.data[n5 + 0];
                float f6 = floatChannel2.data[n5 + 1];
                float f7 = floatChannel2.data[n5 + 2];
                float f8 = floatChannel2.data[n5 + 3];
                float f9 = floatChannel2.data[n5 + 4] * f;
                float f10 = floatChannel2.data[n5 + 5] * f;
                float f11 = floatChannel4.data[n7 + 0];
                f = floatChannel4.data[n7 + 1];
                float f12 = floatChannel4.data[n7 + 2];
                float f13 = floatChannel4.data[n7 + 3];
                float f14 = floatChannel5.data[n8 + 0];
                float f15 = floatChannel5.data[n8 + 1];
                object = this.vertices;
                float f16 = -f9;
                float f17 = -f10;
                BillboardParticleBatch.putVertex((float[])object, n4, f2, f3, f4, f5, f8, f16, f17, f14, f15, f11, f, f12, f13);
                n5 = n4 + this.currentVertexSize;
                BillboardParticleBatch.putVertex(this.vertices, n5, f2, f3, f4, f7, f8, f9, f17, f14, f15, f11, f, f12, f13);
                n8 = n5 + this.currentVertexSize;
                BillboardParticleBatch.putVertex(this.vertices, n8, f2, f3, f4, f7, f6, f9, f10, f14, f15, f11, f, f12, f13);
                n5 = this.currentVertexSize;
                BillboardParticleBatch.putVertex(this.vertices, n8 + n5, f2, f3, f4, f5, f6, f16, f10, f14, f15, f11, f, f12, f13);
                n5 = this.currentVertexSize;
                ++n3;
                ++n;
            }
        }
    }

    private void fillVerticesToScreenCPU(int[] nArray) {
        Vector3 vector3 = TMP_V3.set(this.camera.direction).scl(-1.0f);
        Object object = TMP_V4.set(this.camera.up).crs(vector3).nor();
        Vector3 vector32 = this.camera.up;
        Object object2 = this.renderData.iterator();
        int n = 0;
        while (object2.hasNext()) {
            Object object3 = (BillboardControllerRenderData)object2.next();
            ParallelArray.FloatChannel floatChannel = ((BillboardControllerRenderData)object3).scaleChannel;
            ParallelArray.FloatChannel floatChannel2 = ((BillboardControllerRenderData)object3).regionChannel;
            ParallelArray.FloatChannel floatChannel3 = ((BillboardControllerRenderData)object3).positionChannel;
            ParallelArray.FloatChannel floatChannel4 = ((BillboardControllerRenderData)object3).colorChannel;
            ParallelArray.FloatChannel floatChannel5 = ((BillboardControllerRenderData)object3).rotationChannel;
            int n2 = ((BillboardControllerRenderData)object3).controller.particles.size;
            int n3 = 0;
            object3 = object2;
            object2 = object;
            while (n3 < n2) {
                int n4 = nArray[n] * this.currentVertexSize * 4;
                float f = floatChannel.data[floatChannel.strideSize * n3];
                int n5 = floatChannel2.strideSize * n3;
                int n6 = floatChannel3.strideSize * n3;
                int n7 = floatChannel4.strideSize * n3;
                int n8 = floatChannel5.strideSize * n3;
                float f2 = floatChannel3.data[n6 + 0];
                float f3 = floatChannel3.data[n6 + 1];
                float f4 = floatChannel3.data[n6 + 2];
                float f5 = floatChannel2.data[n5 + 0];
                float f6 = floatChannel2.data[n5 + 1];
                float f7 = floatChannel2.data[n5 + 2];
                float f8 = floatChannel2.data[n5 + 3];
                float f9 = floatChannel2.data[n5 + 4];
                float f10 = floatChannel2.data[n5 + 5];
                float f11 = floatChannel4.data[n7 + 0];
                float f12 = floatChannel4.data[n7 + 1];
                float f13 = floatChannel4.data[n7 + 2];
                float f14 = floatChannel4.data[n7 + 3];
                float f15 = floatChannel5.data[n8 + 0];
                float f16 = floatChannel5.data[n8 + 1];
                TMP_V1.set((Vector3)object2).scl(f9 * f);
                TMP_V2.set(vector32).scl(f10 * f);
                if (f15 != 1.0f) {
                    TMP_M3.setToRotation(vector3, f15, f16);
                    BillboardParticleBatch.putVertex(this.vertices, n4, TMP_V6.set(-BillboardParticleBatch.TMP_V1.x - BillboardParticleBatch.TMP_V2.x, -BillboardParticleBatch.TMP_V1.y - BillboardParticleBatch.TMP_V2.y, -BillboardParticleBatch.TMP_V1.z - BillboardParticleBatch.TMP_V2.z).mul(TMP_M3).add(f2, f3, f4), f5, f8, f11, f12, f13, f14);
                    n8 = n4 + this.currentVertexSize;
                    BillboardParticleBatch.putVertex(this.vertices, n8, TMP_V6.set(BillboardParticleBatch.TMP_V1.x - BillboardParticleBatch.TMP_V2.x, BillboardParticleBatch.TMP_V1.y - BillboardParticleBatch.TMP_V2.y, BillboardParticleBatch.TMP_V1.z - BillboardParticleBatch.TMP_V2.z).mul(TMP_M3).add(f2, f3, f4), f7, f8, f11, f12, f13, f14);
                    BillboardParticleBatch.putVertex(this.vertices, n8 += this.currentVertexSize, TMP_V6.set(BillboardParticleBatch.TMP_V1.x + BillboardParticleBatch.TMP_V2.x, BillboardParticleBatch.TMP_V1.y + BillboardParticleBatch.TMP_V2.y, BillboardParticleBatch.TMP_V1.z + BillboardParticleBatch.TMP_V2.z).mul(TMP_M3).add(f2, f3, f4), f7, f6, f11, f12, f13, f14);
                    n6 = this.currentVertexSize;
                    BillboardParticleBatch.putVertex(this.vertices, n8 + n6, TMP_V6.set(-BillboardParticleBatch.TMP_V1.x + BillboardParticleBatch.TMP_V2.x, -BillboardParticleBatch.TMP_V1.y + BillboardParticleBatch.TMP_V2.y, -BillboardParticleBatch.TMP_V1.z + BillboardParticleBatch.TMP_V2.z).mul(TMP_M3).add(f2, f3, f4), f5, f6, f11, f12, f13, f14);
                } else {
                    BillboardParticleBatch.putVertex(this.vertices, n4, TMP_V6.set(-BillboardParticleBatch.TMP_V1.x - BillboardParticleBatch.TMP_V2.x + f2, -BillboardParticleBatch.TMP_V1.y - BillboardParticleBatch.TMP_V2.y + f3, -BillboardParticleBatch.TMP_V1.z - BillboardParticleBatch.TMP_V2.z + f4), f5, f8, f11, f12, f13, f14);
                    n8 = n4 + this.currentVertexSize;
                    BillboardParticleBatch.putVertex(this.vertices, n8, TMP_V6.set(BillboardParticleBatch.TMP_V1.x - BillboardParticleBatch.TMP_V2.x + f2, BillboardParticleBatch.TMP_V1.y - BillboardParticleBatch.TMP_V2.y + f3, BillboardParticleBatch.TMP_V1.z - BillboardParticleBatch.TMP_V2.z + f4), f7, f8, f11, f12, f13, f14);
                    n6 = n8 + this.currentVertexSize;
                    BillboardParticleBatch.putVertex(this.vertices, n6, TMP_V6.set(BillboardParticleBatch.TMP_V1.x + BillboardParticleBatch.TMP_V2.x + f2, BillboardParticleBatch.TMP_V1.y + BillboardParticleBatch.TMP_V2.y + f3, BillboardParticleBatch.TMP_V1.z + BillboardParticleBatch.TMP_V2.z + f4), f7, f6, f11, f12, f13, f14);
                    n8 = this.currentVertexSize;
                    BillboardParticleBatch.putVertex(this.vertices, n6 + n8, TMP_V6.set(-BillboardParticleBatch.TMP_V1.x + BillboardParticleBatch.TMP_V2.x + f2, -BillboardParticleBatch.TMP_V1.y + BillboardParticleBatch.TMP_V2.y + f3, -BillboardParticleBatch.TMP_V1.z + BillboardParticleBatch.TMP_V2.z + f4), f5, f6, f11, f12, f13, f14);
                }
                ++n3;
                ++n;
            }
            object = object2;
            object2 = object3;
        }
    }

    private void fillVerticesToViewPointCPU(int[] nArray) {
        Iterator iterator = this.renderData.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object object = (BillboardControllerRenderData)iterator.next();
            ParallelArray.FloatChannel floatChannel = ((BillboardControllerRenderData)object).scaleChannel;
            ParallelArray.FloatChannel floatChannel2 = ((BillboardControllerRenderData)object).regionChannel;
            ParallelArray.FloatChannel floatChannel3 = ((BillboardControllerRenderData)object).positionChannel;
            ParallelArray.FloatChannel floatChannel4 = ((BillboardControllerRenderData)object).colorChannel;
            ParallelArray.FloatChannel floatChannel5 = ((BillboardControllerRenderData)object).rotationChannel;
            int n2 = ((BillboardControllerRenderData)object).controller.particles.size;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = nArray[n] * this.currentVertexSize * 4;
                float f = floatChannel.data[floatChannel.strideSize * n3];
                int n5 = floatChannel2.strideSize * n3;
                int n6 = floatChannel3.strideSize * n3;
                int n7 = floatChannel4.strideSize * n3;
                int n8 = floatChannel5.strideSize * n3;
                float f2 = floatChannel3.data[n6 + 0];
                float f3 = floatChannel3.data[n6 + 1];
                float f4 = floatChannel3.data[n6 + 2];
                float f5 = floatChannel2.data[n5 + 0];
                float f6 = floatChannel2.data[n5 + 1];
                float f7 = floatChannel2.data[n5 + 2];
                float f8 = floatChannel2.data[n5 + 3];
                float f9 = floatChannel2.data[n5 + 4];
                float f10 = floatChannel2.data[n5 + 5];
                float f11 = floatChannel4.data[n7 + 0];
                float f12 = floatChannel4.data[n7 + 1];
                float f13 = floatChannel4.data[n7 + 2];
                float f14 = floatChannel4.data[n7 + 3];
                float f15 = floatChannel5.data[n8 + 0];
                float f16 = floatChannel5.data[n8 + 1];
                object = TMP_V3.set(this.camera.position).sub(f2, f3, f4).nor();
                Vector3 vector3 = TMP_V1.set(this.camera.up).crs((Vector3)object).nor();
                Vector3 vector32 = TMP_V2.set((Vector3)object).crs(vector3);
                vector3.scl(f9 * f);
                vector32.scl(f10 * f);
                if (f15 != 1.0f) {
                    TMP_M3.setToRotation((Vector3)object, f15, f16);
                    BillboardParticleBatch.putVertex(this.vertices, n4, TMP_V6.set(-BillboardParticleBatch.TMP_V1.x - BillboardParticleBatch.TMP_V2.x, -BillboardParticleBatch.TMP_V1.y - BillboardParticleBatch.TMP_V2.y, -BillboardParticleBatch.TMP_V1.z - BillboardParticleBatch.TMP_V2.z).mul(TMP_M3).add(f2, f3, f4), f5, f8, f11, f12, f13, f14);
                    n6 = this.currentVertexSize + n4;
                    BillboardParticleBatch.putVertex(this.vertices, n6, TMP_V6.set(BillboardParticleBatch.TMP_V1.x - BillboardParticleBatch.TMP_V2.x, BillboardParticleBatch.TMP_V1.y - BillboardParticleBatch.TMP_V2.y, BillboardParticleBatch.TMP_V1.z - BillboardParticleBatch.TMP_V2.z).mul(TMP_M3).add(f2, f3, f4), f7, f8, f11, f12, f13, f14);
                    n4 = n6 + this.currentVertexSize;
                    BillboardParticleBatch.putVertex(this.vertices, n4, TMP_V6.set(BillboardParticleBatch.TMP_V1.x + BillboardParticleBatch.TMP_V2.x, BillboardParticleBatch.TMP_V1.y + BillboardParticleBatch.TMP_V2.y, BillboardParticleBatch.TMP_V1.z + BillboardParticleBatch.TMP_V2.z).mul(TMP_M3).add(f2, f3, f4), f7, f6, f11, f12, f13, f14);
                    n6 = this.currentVertexSize;
                    BillboardParticleBatch.putVertex(this.vertices, n4 + n6, TMP_V6.set(-BillboardParticleBatch.TMP_V1.x + BillboardParticleBatch.TMP_V2.x, -BillboardParticleBatch.TMP_V1.y + BillboardParticleBatch.TMP_V2.y, -BillboardParticleBatch.TMP_V1.z + BillboardParticleBatch.TMP_V2.z).mul(TMP_M3).add(f2, f3, f4), f5, f6, f11, f12, f13, f14);
                } else {
                    BillboardParticleBatch.putVertex(this.vertices, n4, TMP_V6.set(-BillboardParticleBatch.TMP_V1.x - BillboardParticleBatch.TMP_V2.x + f2, -BillboardParticleBatch.TMP_V1.y - BillboardParticleBatch.TMP_V2.y + f3, -BillboardParticleBatch.TMP_V1.z - BillboardParticleBatch.TMP_V2.z + f4), f5, f8, f11, f12, f13, f14);
                    n6 = this.currentVertexSize + n4;
                    BillboardParticleBatch.putVertex(this.vertices, n6, TMP_V6.set(BillboardParticleBatch.TMP_V1.x - BillboardParticleBatch.TMP_V2.x + f2, BillboardParticleBatch.TMP_V1.y - BillboardParticleBatch.TMP_V2.y + f3, BillboardParticleBatch.TMP_V1.z - BillboardParticleBatch.TMP_V2.z + f4), f7, f8, f11, f12, f13, f14);
                    n4 = n6 + this.currentVertexSize;
                    BillboardParticleBatch.putVertex(this.vertices, n4, TMP_V6.set(BillboardParticleBatch.TMP_V1.x + BillboardParticleBatch.TMP_V2.x + f2, BillboardParticleBatch.TMP_V1.y + BillboardParticleBatch.TMP_V2.y + f3, BillboardParticleBatch.TMP_V1.z + BillboardParticleBatch.TMP_V2.z + f4), f7, f6, f11, f12, f13, f14);
                    n6 = this.currentVertexSize;
                    BillboardParticleBatch.putVertex(this.vertices, n4 + n6, TMP_V6.set(-BillboardParticleBatch.TMP_V1.x + BillboardParticleBatch.TMP_V2.x + f2, -BillboardParticleBatch.TMP_V1.y + BillboardParticleBatch.TMP_V2.y + f3, -BillboardParticleBatch.TMP_V1.z + BillboardParticleBatch.TMP_V2.z + f4), f5, f6, f11, f12, f13, f14);
                }
                ++n3;
                ++n;
            }
        }
    }

    private void initRenderData() {
        this.setVertexData();
        this.clearRenderablesPool();
        this.allocShader();
        this.resetCapacity();
    }

    private static void putVertex(float[] fArray, int n, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13) {
        int n2 = GPU_POSITION_OFFSET;
        fArray[n + n2] = f;
        fArray[n + n2 + 1] = f2;
        fArray[n2 + n + 2] = f3;
        n2 = GPU_UV_OFFSET;
        fArray[n + n2] = f4;
        fArray[n2 + n + 1] = f5;
        n2 = GPU_SIZE_ROTATION_OFFSET;
        fArray[n + n2] = f6;
        fArray[n + n2 + 1] = f7;
        fArray[n + n2 + 2] = f8;
        fArray[n2 + n + 3] = f9;
        n2 = GPU_COLOR_OFFSET;
        fArray[n + n2] = f10;
        fArray[n + n2 + 1] = f11;
        fArray[n + n2 + 2] = f12;
        fArray[n2 + n + 3] = f13;
    }

    private static void putVertex(float[] fArray, int n, Vector3 vector3, float f, float f2, float f3, float f4, float f5, float f6) {
        fArray[BillboardParticleBatch.CPU_POSITION_OFFSET + n] = vector3.x;
        fArray[BillboardParticleBatch.CPU_POSITION_OFFSET + n + 1] = vector3.y;
        fArray[BillboardParticleBatch.CPU_POSITION_OFFSET + n + 2] = vector3.z;
        int n2 = CPU_UV_OFFSET;
        fArray[n + n2] = f;
        fArray[n2 + n + 1] = f2;
        n2 = CPU_COLOR_OFFSET;
        fArray[n + n2] = f3;
        fArray[n + n2 + 1] = f4;
        fArray[n + n2 + 2] = f5;
        fArray[n + n2 + 3] = f6;
    }

    @Override
    public void allocParticlesData(int n) {
        this.vertices = new float[this.currentVertexSize * 4 * n];
        this.allocRenderables(n);
    }

    protected Renderable allocRenderable() {
        Renderable renderable = new Renderable();
        renderable.meshPart.primitiveType = 4;
        renderable.meshPart.offset = 0;
        renderable.material = new Material(this.blendingAttribute, this.depthTestAttribute, TextureAttribute.createDiffuse(this.texture));
        renderable.meshPart.mesh = new Mesh(false, 32764, 49146, this.currentAttributes);
        renderable.meshPart.mesh.setIndices(this.indices);
        renderable.shader = this.shader;
        return renderable;
    }

    @Override
    public void begin() {
        super.begin();
        this.renderablePool.freeAll(this.renderables);
        this.renderables.clear();
    }

    @Override
    protected void flush(int[] object) {
        int n;
        if (this.useGPU) {
            this.fillVerticesGPU((int[])object);
        } else if (this.mode == ParticleShader.AlignMode.Screen) {
            this.fillVerticesToScreenCPU((int[])object);
        } else if (this.mode == ParticleShader.AlignMode.ViewPoint) {
            this.fillVerticesToViewPointCPU((int[])object);
        }
        int n2 = this.bufferedParticlesCount * 4;
        for (int i = 0; i < n2; i += n) {
            n = Math.min(n2 - i, 32764);
            object = (Renderable)this.renderablePool.obtain();
            object.meshPart.size = n / 4 * 6;
            Mesh mesh = object.meshPart.mesh;
            float[] fArray = this.vertices;
            int n3 = this.currentVertexSize;
            mesh.setVertices(fArray, n3 * i, n3 * n);
            object.meshPart.update();
            this.renderables.add((Renderable)object);
        }
    }

    public ParticleShader.AlignMode getAlignMode() {
        return this.mode;
    }

    @Override
    public void getRenderables(Array<Renderable> array, Pool<Renderable> pool) {
        for (Renderable renderable : this.renderables) {
            array.add(pool.obtain().set(renderable));
        }
    }

    protected Shader getShader(Renderable object) {
        object = this.useGPU ? new ParticleShader((Renderable)object, new ParticleShader.Config(this.mode)) : new DefaultShader((Renderable)object);
        object.init();
        return object;
    }

    public Texture getTexture() {
        return this.texture;
    }

    public boolean isUseGPU() {
        return this.useGPU;
    }

    @Override
    public void load(AssetManager object, ResourceData serializable) {
        if ((serializable = ((ResourceData)serializable).getSaveData("billboardBatch")) != null) {
            this.setTexture((Texture)((AssetManager)object).get(((ResourceData.SaveData)serializable).loadAsset()));
            object = (Config)((ResourceData.SaveData)serializable).load("cfg");
            this.setUseGpu(((Config)object).useGPU);
            this.setAlignMode(((Config)object).mode);
        }
    }

    @Override
    public void save(AssetManager assetManager, ResourceData serializable) {
        serializable = ((ResourceData)serializable).createSaveData("billboardBatch");
        ((ResourceData.SaveData)serializable).save("cfg", new Config(this.useGPU, this.mode));
        ((ResourceData.SaveData)serializable).saveAsset(assetManager.getAssetFileName(this.texture), Texture.class);
    }

    public void setAlignMode(ParticleShader.AlignMode alignMode) {
        if (alignMode != this.mode) {
            this.mode = alignMode;
            if (this.useGPU) {
                this.initRenderData();
                this.allocRenderables(this.bufferedParticlesCount);
            }
        }
    }

    public void setTexture(Texture texture) {
        this.renderablePool.freeAll(this.renderables);
        this.renderables.clear();
        int n = this.renderablePool.getFree();
        for (int i = 0; i < n; ++i) {
            ((TextureAttribute)((Renderable)this.renderablePool.obtain()).material.get((long)TextureAttribute.Diffuse)).textureDescription.texture = texture;
        }
        this.texture = texture;
    }

    public void setUseGpu(boolean bl) {
        if (this.useGPU != bl) {
            this.useGPU = bl;
            this.initRenderData();
            this.allocRenderables(this.bufferedParticlesCount);
        }
    }

    public void setVertexData() {
        if (this.useGPU) {
            this.currentAttributes = GPU_ATTRIBUTES;
            this.currentVertexSize = GPU_VERTEX_SIZE;
        } else {
            this.currentAttributes = CPU_ATTRIBUTES;
            this.currentVertexSize = CPU_VERTEX_SIZE;
        }
    }

    public static class Config {
        ParticleShader.AlignMode mode;
        boolean useGPU;

        public Config() {
        }

        public Config(boolean bl, ParticleShader.AlignMode alignMode) {
            this.useGPU = bl;
            this.mode = alignMode;
        }
    }

    private class RenderablePool
    extends Pool<Renderable> {
        @Override
        public Renderable newObject() {
            return BillboardParticleBatch.this.allocRenderable();
        }
    }
}

