/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.g3d.particles.renderers.ParticleControllerRenderData;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;

public abstract class ParticleSorter {
    static final Vector3 TMP_V1 = new Vector3();
    protected Camera camera;

    public void ensureCapacity(int n) {
    }

    public void setCamera(Camera camera) {
        this.camera = camera;
    }

    public abstract <T extends ParticleControllerRenderData> int[] sort(Array<T> var1);

    public static class Distance
    extends ParticleSorter {
        private int currentSize = 0;
        private float[] distances;
        private int[] particleIndices;
        private int[] particleOffsets;

        @Override
        public void ensureCapacity(int n) {
            if (this.currentSize < n) {
                this.distances = new float[n];
                this.particleIndices = new int[n];
                this.particleOffsets = new int[n];
                this.currentSize = n;
            }
        }

        public void qsort(int n, int n2) {
            if (n < n2) {
                Object[] objectArray;
                int n3;
                if (n2 - n <= 8) {
                    for (int i = n; i <= n2; ++i) {
                        int n4;
                        Object[] objectArray2;
                        for (int j = i; j > n && (objectArray2 = this.distances)[n4 = j - 1] > objectArray2[j]; --j) {
                            float f = objectArray2[j];
                            objectArray2[j] = objectArray2[n4];
                            objectArray2[n4] = f;
                            objectArray2 = this.particleIndices;
                            float f2 = objectArray2[j];
                            objectArray2[j] = objectArray2[n4];
                            objectArray2[n4] = f2;
                        }
                    }
                    return;
                }
                float f = this.distances[n];
                int n5 = this.particleIndices[n];
                int n6 = n3;
                for (n3 = n + 1; n3 <= n2; ++n3) {
                    objectArray = this.distances;
                    int n7 = n6;
                    if (f > objectArray[n3]) {
                        if (n3 > n6) {
                            float f3 = objectArray[n3];
                            objectArray[n3] = objectArray[n6];
                            objectArray[n6] = f3;
                            objectArray = this.particleIndices;
                            n7 = (int)objectArray[n3];
                            objectArray[n3] = objectArray[n6];
                            objectArray[n6] = n7;
                        }
                        n7 = n6 + 1;
                    }
                    n6 = n7;
                }
                objectArray = this.distances;
                n3 = n6 - 1;
                objectArray[n] = objectArray[n3];
                objectArray[n3] = f;
                objectArray = this.particleIndices;
                objectArray[n] = objectArray[n3];
                objectArray[n3] = n5;
                this.qsort(n, n6 - 2);
                this.qsort(n6, n2);
            }
        }

        @Override
        public <T extends ParticleControllerRenderData> int[] sort(Array<T> object) {
            Object object2 = this.camera.view.val;
            float f = object2[2];
            float f2 = object2[6];
            float f3 = object2[10];
            object = ((Array)object).iterator();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (true) {
                int n4 = n3;
                if (!object.hasNext()) break;
                object2 = (ParticleControllerRenderData)object.next();
                int n5 = object2.controller.particles.size;
                int n6 = 0;
                n3 = n4;
                while (n3 < n5 + n4) {
                    this.distances[n3] = object2.positionChannel.data[n6 + 0] * f + object2.positionChannel.data[n6 + 1] * f2 + object2.positionChannel.data[n6 + 2] * f3;
                    this.particleIndices[n3] = n3;
                    ++n3;
                    n6 += object2.positionChannel.strideSize;
                }
                n2 += object2.controller.particles.size;
            }
            this.qsort(0, n2 - 1);
            for (n3 = n; n3 < n2; ++n3) {
                this.particleOffsets[this.particleIndices[n3]] = n3;
            }
            return this.particleOffsets;
        }
    }

    public static class None
    extends ParticleSorter {
        int currentCapacity = 0;
        int[] indices;

        @Override
        public void ensureCapacity(int n) {
            if (this.currentCapacity < n) {
                this.indices = new int[n];
                for (int i = 0; i < n; ++i) {
                    this.indices[i] = i;
                }
                this.currentCapacity = n;
            }
        }

        @Override
        public <T extends ParticleControllerRenderData> int[] sort(Array<T> array) {
            return this.indices;
        }
    }
}

