/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles;

import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.g3d.particles.ParticleController;
import com.badlogic.gdx.graphics.g3d.particles.ResourceData;
import com.badlogic.gdx.graphics.g3d.particles.batches.ParticleBatch;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import java.util.Iterator;

public class ParticleEffect
implements ResourceData.Configurable,
Disposable {
    private BoundingBox bounds;
    private Array<ParticleController> controllers;

    public ParticleEffect() {
        this.controllers = new Array(true, 3, ParticleController.class);
    }

    public ParticleEffect(ParticleEffect particleEffect) {
        this.controllers = new Array(true, particleEffect.controllers.size);
        int n = particleEffect.controllers.size;
        for (int i = 0; i < n; ++i) {
            this.controllers.add(particleEffect.controllers.get(i).copy());
        }
    }

    public ParticleEffect(ParticleController ... particleControllerArray) {
        this.controllers = new Array<ParticleController>(particleControllerArray);
    }

    public ParticleEffect copy() {
        return new ParticleEffect(this);
    }

    @Override
    public void dispose() {
        int n = this.controllers.size;
        for (int i = 0; i < n; ++i) {
            this.controllers.get(i).dispose();
        }
    }

    public void draw() {
        int n = this.controllers.size;
        for (int i = 0; i < n; ++i) {
            this.controllers.get(i).draw();
        }
    }

    public void end() {
        int n = this.controllers.size;
        for (int i = 0; i < n; ++i) {
            this.controllers.get(i).end();
        }
    }

    public ParticleController findController(String string2) {
        int n = this.controllers.size;
        for (int i = 0; i < n; ++i) {
            ParticleController particleController = this.controllers.get(i);
            if (!particleController.name.equals(string2)) continue;
            return particleController;
        }
        return null;
    }

    public BoundingBox getBoundingBox() {
        if (this.bounds == null) {
            this.bounds = new BoundingBox();
        }
        BoundingBox boundingBox = this.bounds;
        boundingBox.inf();
        Iterator<ParticleController> iterator = this.controllers.iterator();
        while (iterator.hasNext()) {
            boundingBox.ext(iterator.next().getBoundingBox());
        }
        return boundingBox;
    }

    public Array<ParticleController> getControllers() {
        return this.controllers;
    }

    public void init() {
        int n = this.controllers.size;
        for (int i = 0; i < n; ++i) {
            this.controllers.get(i).init();
        }
    }

    public boolean isComplete() {
        int n = this.controllers.size;
        for (int i = 0; i < n; ++i) {
            if (this.controllers.get(i).isComplete()) continue;
            return false;
        }
        return true;
    }

    public void load(AssetManager assetManager, ResourceData resourceData) {
        Iterator<ParticleController> iterator = this.controllers.iterator();
        while (iterator.hasNext()) {
            iterator.next().load(assetManager, resourceData);
        }
    }

    public void reset() {
        int n = this.controllers.size;
        for (int i = 0; i < n; ++i) {
            this.controllers.get(i).reset();
        }
    }

    public void rotate(Quaternion quaternion) {
        int n = this.controllers.size;
        for (int i = 0; i < n; ++i) {
            this.controllers.get(i).rotate(quaternion);
        }
    }

    public void rotate(Vector3 vector3, float f) {
        int n = this.controllers.size;
        for (int i = 0; i < n; ++i) {
            this.controllers.get(i).rotate(vector3, f);
        }
    }

    public void save(AssetManager assetManager, ResourceData resourceData) {
        Iterator<ParticleController> iterator = this.controllers.iterator();
        while (iterator.hasNext()) {
            iterator.next().save(assetManager, resourceData);
        }
    }

    public void scale(float f, float f2, float f3) {
        int n = this.controllers.size;
        for (int i = 0; i < n; ++i) {
            this.controllers.get(i).scale(f, f2, f3);
        }
    }

    public void scale(Vector3 vector3) {
        int n = this.controllers.size;
        for (int i = 0; i < n; ++i) {
            this.controllers.get(i).scale(vector3.x, vector3.y, vector3.z);
        }
    }

    public void setBatch(Array<ParticleBatch<?>> array) {
        for (ParticleController particleController : this.controllers) {
            for (ParticleBatch<?> particleBatch : array) {
                if (particleController.renderer.setBatch(particleBatch)) break;
            }
        }
    }

    public void setTransform(Matrix4 matrix4) {
        int n = this.controllers.size;
        for (int i = 0; i < n; ++i) {
            this.controllers.get(i).setTransform(matrix4);
        }
    }

    public void start() {
        int n = this.controllers.size;
        for (int i = 0; i < n; ++i) {
            this.controllers.get(i).start();
        }
    }

    public void translate(Vector3 vector3) {
        int n = this.controllers.size;
        for (int i = 0; i < n; ++i) {
            this.controllers.get(i).translate(vector3);
        }
    }

    public void update() {
        int n = this.controllers.size;
        for (int i = 0; i < n; ++i) {
            this.controllers.get(i).update();
        }
    }

    public void update(float f) {
        int n = this.controllers.size;
        for (int i = 0; i < n; ++i) {
            this.controllers.get(i).update(f);
        }
    }
}

