/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.environment;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class AmbientCubemap {
    private static final int NUM_VALUES = 18;
    public final float[] data;

    public AmbientCubemap() {
        this.data = new float[18];
    }

    public AmbientCubemap(AmbientCubemap ambientCubemap) {
        this(ambientCubemap.data);
    }

    public AmbientCubemap(float[] fArray) {
        if (fArray.length == 18) {
            float[] fArray2 = this.data = new float[fArray.length];
            System.arraycopy(fArray, 0, fArray2, 0, fArray2.length);
            return;
        }
        throw new GdxRuntimeException("Incorrect array size");
    }

    private static final float clamp(float f) {
        float f2;
        if (f < 0.0f) {
            f2 = 0.0f;
        } else {
            f2 = f;
            if (f > 1.0f) {
                f2 = 1.0f;
            }
        }
        return f2;
    }

    public AmbientCubemap add(float f, float f2, float f3) {
        float[] fArray;
        for (int i = 0; i < (fArray = this.data).length; ++i) {
            int n = i + 1;
            fArray[i] = fArray[i] + f;
            i = n + 1;
            fArray[n] = fArray[n] + f2;
            fArray[i] = fArray[i] + f3;
        }
        return this;
    }

    public AmbientCubemap add(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = f4 * f4;
        float f8 = f5 * f5;
        float f9 = f6 * f6;
        float f10 = f7 + f8 + f9;
        if (f10 == 0.0f) {
            return this;
        }
        f10 = 1.0f / f10 * (f10 + 1.0f);
        f2 *= f10;
        f3 *= f10;
        int n = f4 > 0.0f ? 0 : 3;
        float[] fArray = this.data;
        fArray[n] = fArray[n] + f7 * (f *= f10);
        int n2 = n + 1;
        fArray[n2] = fArray[n2] + f7 * f2;
        fArray[n += 2] = fArray[n] + f7 * f3;
        n = f5 > 0.0f ? 6 : 9;
        fArray = this.data;
        fArray[n] = fArray[n] + f8 * f;
        n2 = n + 1;
        fArray[n2] = fArray[n2] + f8 * f2;
        fArray[n += 2] = fArray[n] + f8 * f3;
        n = f6 > 0.0f ? 12 : 15;
        fArray = this.data;
        fArray[n] = fArray[n] + f * f9;
        n2 = n + 1;
        fArray[n2] = fArray[n2] + f2 * f9;
        fArray[n += 2] = fArray[n] + f9 * f3;
        return this;
    }

    public AmbientCubemap add(float f, float f2, float f3, Vector3 vector3) {
        return this.add(f, f2, f3, vector3.x, vector3.y, vector3.z);
    }

    public AmbientCubemap add(Color color2) {
        return this.add(color2.r, color2.g, color2.b);
    }

    public AmbientCubemap add(Color color2, float f, float f2, float f3) {
        return this.add(color2.r, color2.g, color2.b, f, f2, f3);
    }

    public AmbientCubemap add(Color color2, Vector3 vector3) {
        return this.add(color2.r, color2.g, color2.b, vector3.x, vector3.y, vector3.z);
    }

    public AmbientCubemap add(Color color2, Vector3 vector3, Vector3 vector32) {
        return this.add(color2.r, color2.g, color2.b, vector32.x - vector3.x, vector32.y - vector3.y, vector32.z - vector3.z);
    }

    public AmbientCubemap add(Color color2, Vector3 vector3, Vector3 vector32, float f) {
        return this.add(color2.r * (f /= vector32.dst(vector3) + 1.0f), color2.g * f, color2.b * f, vector32.x - vector3.x, vector32.y - vector3.y, vector32.z - vector3.z);
    }

    public AmbientCubemap clamp() {
        float[] fArray;
        for (int i = 0; i < (fArray = this.data).length; ++i) {
            fArray[i] = AmbientCubemap.clamp(fArray[i]);
        }
        return this;
    }

    public AmbientCubemap clear() {
        float[] fArray;
        for (int i = 0; i < (fArray = this.data).length; ++i) {
            fArray[i] = 0.0f;
        }
        return this;
    }

    public Color getColor(Color color2, int n) {
        float[] fArray = this.data;
        return color2.set(fArray[n *= 3], fArray[n + 1], fArray[n + 2], 1.0f);
    }

    public AmbientCubemap set(float f, float f2, float f3) {
        for (int i = 0; i < 18; i += 3) {
            float[] fArray = this.data;
            fArray[i] = f;
            fArray[i + 1] = f2;
            fArray[i + 2] = f3;
        }
        return this;
    }

    public AmbientCubemap set(Color color2) {
        return this.set(color2.r, color2.g, color2.b);
    }

    public AmbientCubemap set(AmbientCubemap ambientCubemap) {
        return this.set(ambientCubemap.data);
    }

    public AmbientCubemap set(float[] fArray) {
        float[] fArray2;
        for (int i = 0; i < (fArray2 = this.data).length; ++i) {
            fArray2[i] = fArray[i];
        }
        return this;
    }

    public String toString() {
        String string2 = "";
        for (int i = 0; i < this.data.length; i += 3) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
            stringBuilder.append(Float.toString(this.data[i]));
            stringBuilder.append(", ");
            stringBuilder.append(Float.toString(this.data[i + 1]));
            stringBuilder.append(", ");
            stringBuilder.append(Float.toString(this.data[i + 2]));
            stringBuilder.append("\n");
            string2 = stringBuilder.toString();
        }
        return string2;
    }
}

