/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d;

import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.model.Animation;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.graphics.g3d.model.NodeAnimation;
import com.badlogic.gdx.graphics.g3d.model.NodeKeyframe;
import com.badlogic.gdx.graphics.g3d.model.NodePart;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import java.util.Iterator;

public class ModelInstance
implements RenderableProvider {
    public static boolean defaultShareKeyframes = true;
    public final Array<Animation> animations;
    public final Array<Material> materials = new Array();
    public final Model model;
    public final Array<Node> nodes = new Array();
    public Matrix4 transform;
    public Object userData;

    public ModelInstance(Model model) {
        this(model, (String[])null);
    }

    public ModelInstance(Model model, float f, float f2, float f3) {
        this(model);
        this.transform.setToTranslation(f, f2, f3);
    }

    public ModelInstance(Model model, Matrix4 matrix4) {
        this(model, matrix4, (String[])null);
    }

    public ModelInstance(Model model, Matrix4 matrix4, Array<String> array) {
        this(model, matrix4, array, defaultShareKeyframes);
    }

    public ModelInstance(Model model, Matrix4 matrix4, Array<String> array, boolean bl) {
        this.animations = new Array();
        this.model = model;
        Matrix4 matrix42 = matrix4;
        if (matrix4 == null) {
            matrix42 = new Matrix4();
        }
        this.transform = matrix42;
        this.copyNodes(model.nodes, array);
        this.copyAnimations(model.animations, bl);
        this.calculateTransforms();
    }

    public ModelInstance(Model model, Matrix4 matrix4, String string2, boolean bl) {
        this(model, matrix4, string2, false, false, bl);
    }

    public ModelInstance(Model model, Matrix4 matrix4, String string2, boolean bl, boolean bl2) {
        this(model, matrix4, string2, true, bl, bl2);
    }

    public ModelInstance(Model model, Matrix4 matrix4, String string2, boolean bl, boolean bl2, boolean bl3) {
        this(model, matrix4, string2, bl, bl2, bl3, defaultShareKeyframes);
    }

    public ModelInstance(Model model, Matrix4 object, String object2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.animations = new Array();
        this.model = model;
        Object object3 = object;
        if (object == null) {
            object3 = new Matrix4();
        }
        this.transform = object3;
        object = model.getNode((String)object2, bl);
        object3 = this.nodes;
        object2 = ((Node)object).copy();
        ((Array)object3).add(object2);
        if (bl3) {
            object3 = this.transform;
            object = bl2 ? ((Node)object).globalTransform : ((Node)object).localTransform;
            ((Matrix4)object3).mul((Matrix4)object);
            ((Node)object2).translation.set(0.0f, 0.0f, 0.0f);
            ((Node)object2).rotation.idt();
            ((Node)object2).scale.set(1.0f, 1.0f, 1.0f);
        } else if (bl2 && ((Node)object2).hasParent()) {
            this.transform.mul(((Node)object).getParent().globalTransform);
        }
        this.invalidate();
        this.copyAnimations(model.animations, bl4);
        this.calculateTransforms();
    }

    public ModelInstance(Model model, Matrix4 matrix4, String ... stringArray) {
        this.animations = new Array();
        this.model = model;
        Matrix4 matrix42 = matrix4;
        if (matrix4 == null) {
            matrix42 = new Matrix4();
        }
        this.transform = matrix42;
        if (stringArray == null) {
            this.copyNodes(model.nodes);
        } else {
            this.copyNodes(model.nodes, stringArray);
        }
        this.copyAnimations(model.animations, defaultShareKeyframes);
        this.calculateTransforms();
    }

    public ModelInstance(Model model, Vector3 vector3) {
        this(model);
        this.transform.setToTranslation(vector3);
    }

    public ModelInstance(Model model, Array<String> array) {
        this(model, null, array);
    }

    public ModelInstance(Model model, String string2, boolean bl) {
        this(model, null, string2, false, false, bl);
    }

    public ModelInstance(Model model, String string2, boolean bl, boolean bl2) {
        this(model, null, string2, true, bl, bl2);
    }

    public ModelInstance(Model model, String string2, boolean bl, boolean bl2, boolean bl3) {
        this(model, null, string2, bl, bl2, bl3);
    }

    public ModelInstance(Model model, String ... stringArray) {
        this(model, (Matrix4)null, stringArray);
    }

    public ModelInstance(ModelInstance modelInstance) {
        this(modelInstance, modelInstance.transform.cpy());
    }

    public ModelInstance(ModelInstance modelInstance, Matrix4 matrix4) {
        this(modelInstance, matrix4, defaultShareKeyframes);
    }

    public ModelInstance(ModelInstance modelInstance, Matrix4 matrix4, boolean bl) {
        this.animations = new Array();
        this.model = modelInstance.model;
        Matrix4 matrix42 = matrix4;
        if (matrix4 == null) {
            matrix42 = new Matrix4();
        }
        this.transform = matrix42;
        this.copyNodes(modelInstance.nodes);
        this.copyAnimations(modelInstance.animations, bl);
        this.calculateTransforms();
    }

    private void copyNodes(Array<Node> array) {
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            Node node = array.get(i);
            this.nodes.add(node.copy());
        }
        this.invalidate();
    }

    private void copyNodes(Array<Node> array, Array<String> array2) {
        int n = array.size;
        block0: for (int i = 0; i < n; ++i) {
            Node node = array.get(i);
            Iterator<String> iterator = array2.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().equals(node.id)) continue;
                this.nodes.add(node.copy());
                continue block0;
            }
        }
        this.invalidate();
    }

    private void copyNodes(Array<Node> array, String ... stringArray) {
        int n = array.size;
        block0: for (int i = 0; i < n; ++i) {
            Node node = array.get(i);
            int n2 = stringArray.length;
            for (int j = 0; j < n2; ++j) {
                if (!stringArray[j].equals(node.id)) continue;
                this.nodes.add(node.copy());
                continue block0;
            }
        }
        this.invalidate();
    }

    private void invalidate() {
        int n = this.nodes.size;
        for (int i = 0; i < n; ++i) {
            this.invalidate(this.nodes.get(i));
        }
    }

    private void invalidate(Node node) {
        int n;
        int n2;
        int n3 = node.parts.size;
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            NodePart nodePart = node.parts.get(n2);
            Iterable iterable = nodePart.invBoneBindTransforms;
            if (iterable != null) {
                for (n = 0; n < iterable.size; ++n) {
                    ((Node[])iterable.keys)[n] = this.getNode(((Node[])iterable.keys)[n].id);
                }
            }
            if (this.materials.contains(nodePart.material, true)) continue;
            n = this.materials.indexOf(nodePart.material, false);
            if (n < 0) {
                Array<Material> array = this.materials;
                iterable = nodePart.material.copy();
                nodePart.material = iterable;
                array.add((Material)iterable);
                continue;
            }
            nodePart.material = this.materials.get(n);
        }
        n = node.getChildCount();
        for (n2 = n4; n2 < n; ++n2) {
            this.invalidate(node.getChild(n2));
        }
    }

    public BoundingBox calculateBoundingBox(BoundingBox boundingBox) {
        boundingBox.inf();
        return this.extendBoundingBox(boundingBox);
    }

    public void calculateTransforms() {
        int n = this.nodes.size;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            if (n3 >= n) break;
            this.nodes.get(n3).calculateTransforms(true);
            ++n3;
        }
        for (int i = n2; i < n; ++i) {
            this.nodes.get(i).calculateBoneTransforms(true);
        }
    }

    public ModelInstance copy() {
        return new ModelInstance(this);
    }

    public void copyAnimation(Animation animation) {
        this.copyAnimation(animation, defaultShareKeyframes);
    }

    public void copyAnimation(Animation object, boolean bl) {
        Animation animation = new Animation();
        animation.id = ((Animation)object).id;
        animation.duration = ((Animation)object).duration;
        for (NodeAnimation nodeAnimation : ((Animation)object).nodeAnimations) {
            Node node = this.getNode(nodeAnimation.node.id);
            if (node == null) continue;
            object = new NodeAnimation();
            ((NodeAnimation)object).node = node;
            if (bl) {
                ((NodeAnimation)object).translation = nodeAnimation.translation;
                ((NodeAnimation)object).rotation = nodeAnimation.rotation;
                ((NodeAnimation)object).scaling = nodeAnimation.scaling;
            } else {
                if (nodeAnimation.translation != null) {
                    ((NodeAnimation)object).translation = new Array();
                    for (NodeKeyframe<Vector3> nodeKeyframe : nodeAnimation.translation) {
                        ((NodeAnimation)object).translation.add(new NodeKeyframe(nodeKeyframe.keytime, nodeKeyframe.value));
                    }
                }
                if (nodeAnimation.rotation != null) {
                    ((NodeAnimation)object).rotation = new Array();
                    for (NodeKeyframe<Quaternion> nodeKeyframe : nodeAnimation.rotation) {
                        ((NodeAnimation)object).rotation.add(new NodeKeyframe(nodeKeyframe.keytime, nodeKeyframe.value));
                    }
                }
                if (nodeAnimation.scaling != null) {
                    ((NodeAnimation)object).scaling = new Array();
                    for (NodeKeyframe<Vector3> nodeKeyframe : nodeAnimation.scaling) {
                        ((NodeAnimation)object).scaling.add(new NodeKeyframe(nodeKeyframe.keytime, nodeKeyframe.value));
                    }
                }
            }
            if (((NodeAnimation)object).translation == null && ((NodeAnimation)object).rotation == null && ((NodeAnimation)object).scaling == null) continue;
            animation.nodeAnimations.add((NodeAnimation)object);
        }
        if (animation.nodeAnimations.size > 0) {
            this.animations.add(animation);
        }
    }

    public void copyAnimations(Iterable<Animation> object) {
        object = object.iterator();
        while (object.hasNext()) {
            this.copyAnimation((Animation)object.next(), defaultShareKeyframes);
        }
    }

    public void copyAnimations(Iterable<Animation> object, boolean bl) {
        object = object.iterator();
        while (object.hasNext()) {
            this.copyAnimation((Animation)object.next(), bl);
        }
    }

    public BoundingBox extendBoundingBox(BoundingBox boundingBox) {
        int n = this.nodes.size;
        for (int i = 0; i < n; ++i) {
            this.nodes.get(i).extendBoundingBox(boundingBox);
        }
        return boundingBox;
    }

    public Animation getAnimation(String string2) {
        return this.getAnimation(string2, false);
    }

    public Animation getAnimation(String string2, boolean bl) {
        int n;
        int n2 = this.animations.size;
        int n3 = 0;
        if (bl) {
            for (n = n3; n < n2; ++n) {
                Animation animation = this.animations.get(n);
                if (!animation.id.equalsIgnoreCase(string2)) continue;
                return animation;
            }
        } else {
            for (n = 0; n < n2; ++n) {
                Animation animation = this.animations.get(n);
                if (!animation.id.equals(string2)) continue;
                return animation;
            }
        }
        return null;
    }

    public Material getMaterial(String string2) {
        return this.getMaterial(string2, true);
    }

    public Material getMaterial(String string2, boolean bl) {
        int n;
        int n2 = this.materials.size;
        int n3 = 0;
        if (bl) {
            for (n = n3; n < n2; ++n) {
                Material material = this.materials.get(n);
                if (!material.id.equalsIgnoreCase(string2)) continue;
                return material;
            }
        } else {
            for (n = 0; n < n2; ++n) {
                Material material = this.materials.get(n);
                if (!material.id.equals(string2)) continue;
                return material;
            }
        }
        return null;
    }

    public Node getNode(String string2) {
        return this.getNode(string2, true);
    }

    public Node getNode(String string2, boolean bl) {
        return this.getNode(string2, bl, false);
    }

    public Node getNode(String string2, boolean bl, boolean bl2) {
        return Node.getNode(this.nodes, string2, bl, bl2);
    }

    public Renderable getRenderable(Renderable renderable) {
        return this.getRenderable(renderable, this.nodes.get(0));
    }

    public Renderable getRenderable(Renderable renderable, Node node) {
        return this.getRenderable(renderable, node, node.parts.get(0));
    }

    public Renderable getRenderable(Renderable renderable, Node node, NodePart nodePart) {
        nodePart.setRenderable(renderable);
        if (nodePart.bones == null && this.transform != null) {
            renderable.worldTransform.set(this.transform).mul(node.globalTransform);
        } else if (this.transform != null) {
            renderable.worldTransform.set(this.transform);
        } else {
            renderable.worldTransform.idt();
        }
        renderable.userData = this.userData;
        return renderable;
    }

    protected void getRenderables(Node object, Array<Renderable> array, Pool<Renderable> pool) {
        if (((Node)object).parts.size > 0) {
            for (NodePart nodePart : ((Node)object).parts) {
                if (!nodePart.enabled) continue;
                array.add(this.getRenderable(pool.obtain(), (Node)object, nodePart));
            }
        }
        object = ((Node)object).getChildren().iterator();
        while (object.hasNext()) {
            this.getRenderables((Node)object.next(), array, pool);
        }
    }

    @Override
    public void getRenderables(Array<Renderable> array, Pool<Renderable> pool) {
        Iterator<Node> iterator = this.nodes.iterator();
        while (iterator.hasNext()) {
            this.getRenderables(iterator.next(), array, pool);
        }
    }
}

