/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.graphics.Texture;

public class TextureRegion {
    int regionHeight;
    int regionWidth;
    Texture texture;
    float u;
    float u2;
    float v;
    float v2;

    public TextureRegion() {
    }

    public TextureRegion(Texture texture) {
        if (texture != null) {
            this.texture = texture;
            this.setRegion(0, 0, texture.getWidth(), texture.getHeight());
            return;
        }
        throw new IllegalArgumentException("texture cannot be null.");
    }

    public TextureRegion(Texture texture, float f, float f2, float f3, float f4) {
        this.texture = texture;
        this.setRegion(f, f2, f3, f4);
    }

    public TextureRegion(Texture texture, int n, int n2) {
        this.texture = texture;
        this.setRegion(0, 0, n, n2);
    }

    public TextureRegion(Texture texture, int n, int n2, int n3, int n4) {
        this.texture = texture;
        this.setRegion(n, n2, n3, n4);
    }

    public TextureRegion(TextureRegion textureRegion) {
        this.setRegion(textureRegion);
    }

    public TextureRegion(TextureRegion textureRegion, int n, int n2, int n3, int n4) {
        this.setRegion(textureRegion, n, n2, n3, n4);
    }

    public static TextureRegion[][] split(Texture texture, int n, int n2) {
        return new TextureRegion(texture).split(n, n2);
    }

    public void flip(boolean bl, boolean bl2) {
        float f;
        if (bl) {
            f = this.u;
            this.u = this.u2;
            this.u2 = f;
        }
        if (bl2) {
            f = this.v;
            this.v = this.v2;
            this.v2 = f;
        }
    }

    public int getRegionHeight() {
        return this.regionHeight;
    }

    public int getRegionWidth() {
        return this.regionWidth;
    }

    public int getRegionX() {
        return Math.round(this.u * (float)this.texture.getWidth());
    }

    public int getRegionY() {
        return Math.round(this.v * (float)this.texture.getHeight());
    }

    public Texture getTexture() {
        return this.texture;
    }

    public float getU() {
        return this.u;
    }

    public float getU2() {
        return this.u2;
    }

    public float getV() {
        return this.v;
    }

    public float getV2() {
        return this.v2;
    }

    public boolean isFlipX() {
        boolean bl = this.u > this.u2;
        return bl;
    }

    public boolean isFlipY() {
        boolean bl = this.v > this.v2;
        return bl;
    }

    public void scroll(float f, float f2) {
        float f3;
        float f4;
        if (f != 0.0f) {
            f4 = this.u2;
            float f5 = this.u;
            f3 = this.texture.getWidth();
            this.u = (this.u + f) % 1.0f;
            this.u2 = this.u + (f4 - f5) * f3 / (float)this.texture.getWidth();
        }
        if (f2 != 0.0f) {
            f = this.v2;
            f3 = this.v;
            f4 = this.texture.getHeight();
            this.v = (this.v + f2) % 1.0f;
            this.v2 = this.v + (f - f3) * f4 / (float)this.texture.getHeight();
        }
    }

    public void setRegion(float f, float f2, float f3, float f4) {
        int n = this.texture.getWidth();
        int n2 = this.texture.getHeight();
        float f5 = Math.abs(f3 - f);
        float f6 = n;
        this.regionWidth = Math.round(f5 * f6);
        f5 = Math.abs(f4 - f2);
        float f7 = n2;
        this.regionHeight = Math.round(f5 * f7);
        float f8 = f;
        float f9 = f2;
        float f10 = f3;
        f5 = f4;
        if (this.regionWidth == 1) {
            f8 = f;
            f9 = f2;
            f10 = f3;
            f5 = f4;
            if (this.regionHeight == 1) {
                f5 = 0.25f / f6;
                f8 = f + f5;
                f10 = f3 - f5;
                f = 0.25f / f7;
                f9 = f2 + f;
                f5 = f4 - f;
            }
        }
        this.u = f8;
        this.v = f9;
        this.u2 = f10;
        this.v2 = f5;
    }

    public void setRegion(int n, int n2, int n3, int n4) {
        float f = 1.0f / (float)this.texture.getWidth();
        float f2 = 1.0f / (float)this.texture.getHeight();
        this.setRegion((float)n * f, (float)n2 * f2, (float)(n + n3) * f, (float)(n2 + n4) * f2);
        this.regionWidth = Math.abs(n3);
        this.regionHeight = Math.abs(n4);
    }

    public void setRegion(Texture texture) {
        this.texture = texture;
        this.setRegion(0, 0, texture.getWidth(), texture.getHeight());
    }

    public void setRegion(TextureRegion textureRegion) {
        this.texture = textureRegion.texture;
        this.setRegion(textureRegion.u, textureRegion.v, textureRegion.u2, textureRegion.v2);
    }

    public void setRegion(TextureRegion textureRegion, int n, int n2, int n3, int n4) {
        this.texture = textureRegion.texture;
        this.setRegion(textureRegion.getRegionX() + n, textureRegion.getRegionY() + n2, n3, n4);
    }

    public void setRegionHeight(int n) {
        if (this.isFlipY()) {
            this.setV(this.v2 + (float)n / (float)this.texture.getHeight());
        } else {
            this.setV2(this.v + (float)n / (float)this.texture.getHeight());
        }
    }

    public void setRegionWidth(int n) {
        if (this.isFlipX()) {
            this.setU(this.u2 + (float)n / (float)this.texture.getWidth());
        } else {
            this.setU2(this.u + (float)n / (float)this.texture.getWidth());
        }
    }

    public void setRegionX(int n) {
        this.setU((float)n / (float)this.texture.getWidth());
    }

    public void setRegionY(int n) {
        this.setV((float)n / (float)this.texture.getHeight());
    }

    public void setTexture(Texture texture) {
        this.texture = texture;
    }

    public void setU(float f) {
        this.u = f;
        this.regionWidth = Math.round(Math.abs(this.u2 - f) * (float)this.texture.getWidth());
    }

    public void setU2(float f) {
        this.u2 = f;
        this.regionWidth = Math.round(Math.abs(f - this.u) * (float)this.texture.getWidth());
    }

    public void setV(float f) {
        this.v = f;
        this.regionHeight = Math.round(Math.abs(this.v2 - f) * (float)this.texture.getHeight());
    }

    public void setV2(float f) {
        this.v2 = f;
        this.regionHeight = Math.round(Math.abs(f - this.v) * (float)this.texture.getHeight());
    }

    public TextureRegion[][] split(int n, int n2) {
        int n3 = this.getRegionX();
        int n4 = this.getRegionY();
        int n5 = this.regionWidth;
        int n6 = this.regionHeight / n2;
        int n7 = n5 / n;
        TextureRegion[][] textureRegionArray = new TextureRegion[n6][n7];
        n5 = 0;
        while (n5 < n6) {
            int n8 = n3;
            int n9 = 0;
            while (n9 < n7) {
                textureRegionArray[n5][n9] = new TextureRegion(this.texture, n8, n4, n, n2);
                ++n9;
                n8 += n;
            }
            ++n5;
            n4 += n2;
        }
        return textureRegionArray;
    }
}

