/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.graphics.g2d.TextureRegion;

public class PolygonRegion {
    final TextureRegion region;
    final float[] textureCoords;
    final short[] triangles;
    final float[] vertices;

    public PolygonRegion(TextureRegion textureRegion, float[] fArray, short[] objectArray) {
        this.region = textureRegion;
        this.vertices = fArray;
        this.triangles = objectArray;
        objectArray = new float[fArray.length];
        this.textureCoords = objectArray;
        float f = textureRegion.u;
        float f2 = textureRegion.v;
        float f3 = textureRegion.u2;
        float f4 = textureRegion.v2;
        int n = textureRegion.regionWidth;
        int n2 = textureRegion.regionHeight;
        int n3 = fArray.length;
        for (int i = 0; i < n3; i += 2) {
            objectArray[i] = (short)(fArray[i] / (float)n * (f3 - f) + f);
            int n4 = i + 1;
            objectArray[n4] = (short)((1.0f - fArray[n4] / (float)n2) * (f4 - f2) + f2);
        }
    }

    public TextureRegion getRegion() {
        return this.region;
    }

    public float[] getTextureCoords() {
        return this.textureCoords;
    }

    public short[] getTriangles() {
        return this.triangles;
    }

    public float[] getVertices() {
        return this.vertices;
    }
}

