/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android.surfaceview;

import android.annotation.TargetApi;
import android.content.Context;
import android.opengl.GLSurfaceView;
import android.os.Build;
import android.os.SystemClock;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import com.badlogic.gdx.backends.android.surfaceview.ResolutionStrategy;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;

public class GLSurfaceView20
extends GLSurfaceView {
    private static final boolean DEBUG = false;
    static String TAG = "GL2JNIView";
    static int targetGLESVersion;
    final ResolutionStrategy resolutionStrategy;

    public GLSurfaceView20(Context context, ResolutionStrategy resolutionStrategy) {
        this(context, resolutionStrategy, 2);
    }

    public GLSurfaceView20(Context context, ResolutionStrategy resolutionStrategy, int n) {
        super(context);
        targetGLESVersion = n;
        this.resolutionStrategy = resolutionStrategy;
        this.init(false, 16, 0);
    }

    public GLSurfaceView20(Context context, boolean bl, int n, int n2, ResolutionStrategy resolutionStrategy) {
        super(context);
        this.resolutionStrategy = resolutionStrategy;
        this.init(bl, n, n2);
    }

    static boolean checkEglError(String string2, EGL10 eGL10) {
        int n;
        boolean bl = true;
        while ((n = eGL10.eglGetError()) != 12288) {
            Log.e((String)TAG, (String)String.format("%s: EGL error: 0x%x", string2, n));
            bl = false;
        }
        return bl;
    }

    private void init(boolean bl, int n, int n2) {
        if (bl) {
            this.getHolder().setFormat(-3);
        }
        this.setEGLContextFactory(new ContextFactory());
        ConfigChooser configChooser = bl ? new ConfigChooser(8, 8, 8, 8, n, n2) : new ConfigChooser(5, 6, 5, 0, n, n2);
        this.setEGLConfigChooser(configChooser);
    }

    public InputConnection onCreateInputConnection(EditorInfo editorInfo) {
        if (editorInfo != null) {
            editorInfo.imeOptions |= 0x10000000;
        }
        return new BaseInputConnection((View)this, false){

            @TargetApi(value=16)
            private void sendDownUpKeyEventForBackwardCompatibility(int n) {
                long l = SystemClock.uptimeMillis();
                super.sendKeyEvent(new KeyEvent(l, l, 0, n, 0, 0, -1, 0, 6));
                super.sendKeyEvent(new KeyEvent(SystemClock.uptimeMillis(), l, 1, n, 0, 0, -1, 0, 6));
            }

            public boolean deleteSurroundingText(int n, int n2) {
                if (Build.VERSION.SDK_INT >= 16 && n == 1 && n2 == 0) {
                    this.sendDownUpKeyEventForBackwardCompatibility(67);
                    return true;
                }
                return super.deleteSurroundingText(n, n2);
            }
        };
    }

    protected void onMeasure(int n, int n2) {
        ResolutionStrategy.MeasuredDimension measuredDimension = this.resolutionStrategy.calcMeasures(n, n2);
        this.setMeasuredDimension(measuredDimension.width, measuredDimension.height);
    }

    private static class ConfigChooser
    implements GLSurfaceView.EGLConfigChooser {
        private static int EGL_OPENGL_ES2_BIT = 4;
        private static int[] s_configAttribs2 = new int[]{12324, 4, 12323, 4, 12322, 4, 12352, EGL_OPENGL_ES2_BIT, 12344};
        protected int mAlphaSize;
        protected int mBlueSize;
        protected int mDepthSize;
        protected int mGreenSize;
        protected int mRedSize;
        protected int mStencilSize;
        private int[] mValue = new int[1];

        public ConfigChooser(int n, int n2, int n3, int n4, int n5, int n6) {
            this.mRedSize = n;
            this.mGreenSize = n2;
            this.mBlueSize = n3;
            this.mAlphaSize = n4;
            this.mDepthSize = n5;
            this.mStencilSize = n6;
        }

        private int findConfigAttrib(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig, int n, int n2) {
            if (eGL10.eglGetConfigAttrib(eGLDisplay, eGLConfig, n, this.mValue)) {
                return this.mValue[0];
            }
            return n2;
        }

        private void printConfig(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig) {
            int[] nArray;
            int[] nArray2 = nArray = new int[33];
            nArray[0] = 12320;
            nArray2[1] = 12321;
            nArray2[2] = 12322;
            nArray2[3] = 12323;
            nArray2[4] = 12324;
            nArray2[5] = 12325;
            nArray2[6] = 12326;
            nArray2[7] = 12327;
            nArray2[8] = 12328;
            nArray2[9] = 12329;
            nArray2[10] = 12330;
            nArray2[11] = 12331;
            nArray2[12] = 12332;
            nArray2[13] = 12333;
            nArray2[14] = 12334;
            nArray2[15] = 12335;
            nArray2[16] = 12336;
            nArray2[17] = 12337;
            nArray2[18] = 12338;
            nArray2[19] = 12339;
            nArray2[20] = 12340;
            nArray2[21] = 12343;
            nArray2[22] = 12342;
            nArray2[23] = 12341;
            nArray2[24] = 12345;
            nArray2[25] = 12346;
            nArray2[26] = 12347;
            nArray2[27] = 12348;
            nArray2[28] = 12349;
            nArray2[29] = 12350;
            nArray2[30] = 12351;
            nArray2[31] = 12352;
            nArray2[32] = 12354;
            int[] nArray3 = new int[1];
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                String string2 = (new String[]{"EGL_BUFFER_SIZE", "EGL_ALPHA_SIZE", "EGL_BLUE_SIZE", "EGL_GREEN_SIZE", "EGL_RED_SIZE", "EGL_DEPTH_SIZE", "EGL_STENCIL_SIZE", "EGL_CONFIG_CAVEAT", "EGL_CONFIG_ID", "EGL_LEVEL", "EGL_MAX_PBUFFER_HEIGHT", "EGL_MAX_PBUFFER_PIXELS", "EGL_MAX_PBUFFER_WIDTH", "EGL_NATIVE_RENDERABLE", "EGL_NATIVE_VISUAL_ID", "EGL_NATIVE_VISUAL_TYPE", "EGL_PRESERVED_RESOURCES", "EGL_SAMPLES", "EGL_SAMPLE_BUFFERS", "EGL_SURFACE_TYPE", "EGL_TRANSPARENT_TYPE", "EGL_TRANSPARENT_RED_VALUE", "EGL_TRANSPARENT_GREEN_VALUE", "EGL_TRANSPARENT_BLUE_VALUE", "EGL_BIND_TO_TEXTURE_RGB", "EGL_BIND_TO_TEXTURE_RGBA", "EGL_MIN_SWAP_INTERVAL", "EGL_MAX_SWAP_INTERVAL", "EGL_LUMINANCE_SIZE", "EGL_ALPHA_MASK_SIZE", "EGL_COLOR_BUFFER_TYPE", "EGL_RENDERABLE_TYPE", "EGL_CONFORMANT"})[i];
                if (eGL10.eglGetConfigAttrib(eGLDisplay, eGLConfig, n, nArray3)) {
                    Log.w((String)TAG, (String)String.format("  %s: %d\n", string2, nArray3[0]));
                    continue;
                }
                while (eGL10.eglGetError() != 12288) {
                }
            }
        }

        private void printConfigs(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig[] eGLConfigArray) {
            int n = eGLConfigArray.length;
            Log.w((String)TAG, (String)String.format("%d configurations", n));
            for (int i = 0; i < n; ++i) {
                Log.w((String)TAG, (String)String.format("Configuration %d:\n", i));
                this.printConfig(eGL10, eGLDisplay, eGLConfigArray[i]);
            }
        }

        public EGLConfig chooseConfig(EGL10 eGL10, EGLDisplay eGLDisplay) {
            int[] nArray = new int[1];
            eGL10.eglChooseConfig(eGLDisplay, s_configAttribs2, null, 0, nArray);
            int n = nArray[0];
            if (n > 0) {
                EGLConfig[] eGLConfigArray = new EGLConfig[n];
                eGL10.eglChooseConfig(eGLDisplay, s_configAttribs2, eGLConfigArray, n, nArray);
                return this.chooseConfig(eGL10, eGLDisplay, eGLConfigArray);
            }
            throw new IllegalArgumentException("No configs match configSpec");
        }

        public EGLConfig chooseConfig(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig[] eGLConfigArray) {
            for (EGLConfig eGLConfig : eGLConfigArray) {
                int n = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12325, 0);
                int n2 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12326, 0);
                if (n < this.mDepthSize || n2 < this.mStencilSize) continue;
                n = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12324, 0);
                int n3 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12323, 0);
                int n4 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12322, 0);
                n2 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12321, 0);
                if (n != this.mRedSize || n3 != this.mGreenSize || n4 != this.mBlueSize || n2 != this.mAlphaSize) continue;
                return eGLConfig;
            }
            return null;
        }
    }

    static class ContextFactory
    implements GLSurfaceView.EGLContextFactory {
        private static int EGL_CONTEXT_CLIENT_VERSION = 12440;

        ContextFactory() {
        }

        public EGLContext createContext(EGL10 object, EGLDisplay object2, EGLConfig eGLConfig) {
            CharSequence charSequence = TAG;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("creating OpenGL ES ");
            stringBuilder.append(targetGLESVersion);
            stringBuilder.append(".0 context");
            Log.w((String)charSequence, (String)stringBuilder.toString());
            stringBuilder = new StringBuilder();
            stringBuilder.append("Before eglCreateContext ");
            stringBuilder.append(targetGLESVersion);
            GLSurfaceView20.checkEglError(stringBuilder.toString(), (EGL10)object);
            int n = EGL_CONTEXT_CLIENT_VERSION;
            int n2 = targetGLESVersion;
            stringBuilder = object.eglCreateContext(object2, eGLConfig, EGL10.EGL_NO_CONTEXT, new int[]{n, n2, 12344});
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("After eglCreateContext ");
            ((StringBuilder)charSequence).append(targetGLESVersion);
            if (!(GLSurfaceView20.checkEglError(((StringBuilder)charSequence).toString(), (EGL10)object) && stringBuilder != null || targetGLESVersion <= 2)) {
                Log.w((String)TAG, (String)"Falling back to GLES 2");
                targetGLESVersion = 2;
                return this.createContext((EGL10)object, (EGLDisplay)object2, eGLConfig);
            }
            object2 = TAG;
            object = new StringBuilder();
            ((StringBuilder)object).append("Returning a GLES ");
            ((StringBuilder)object).append(targetGLESVersion);
            ((StringBuilder)object).append(" context");
            Log.w((String)object2, (String)((StringBuilder)object).toString());
            return stringBuilder;
        }

        public void destroyContext(EGL10 eGL10, EGLDisplay eGLDisplay, EGLContext eGLContext) {
            eGL10.eglDestroyContext(eGLDisplay, eGLContext);
        }
    }
}

