/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.view.MotionEvent;
import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.android.AndroidInput;

public class AndroidMouseHandler {
    private int deltaX = 0;
    private int deltaY = 0;

    private void logAction(int n) {
        CharSequence charSequence;
        if (n == 9) {
            charSequence = "HOVER_ENTER";
        } else if (n == 7) {
            charSequence = "HOVER_MOVE";
        } else if (n == 10) {
            charSequence = "HOVER_EXIT";
        } else if (n == 8) {
            charSequence = "SCROLL";
        } else {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("UNKNOWN (");
            ((StringBuilder)charSequence).append(n);
            ((StringBuilder)charSequence).append(")");
            charSequence = ((StringBuilder)charSequence).toString();
        }
        Application application = Gdx.app;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("action ");
        stringBuilder.append((String)charSequence);
        application.log("AndroidMouseHandler", stringBuilder.toString());
    }

    private void postTouchEvent(AndroidInput androidInput, int n, int n2, int n3, int n4, long l) {
        AndroidInput.TouchEvent touchEvent = androidInput.usedTouchEvents.obtain();
        touchEvent.timeStamp = l;
        touchEvent.x = n2;
        touchEvent.y = n3;
        touchEvent.type = n;
        touchEvent.scrollAmount = n4;
        androidInput.touchEvents.add(touchEvent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onGenericMotion(MotionEvent motionEvent, AndroidInput androidInput) {
        if ((motionEvent.getSource() & 2) == 0) {
            return false;
        }
        int n = motionEvent.getAction() & 0xFF;
        long l = System.nanoTime();
        synchronized (androidInput) {
            if (n != 7) {
                if (n == 8) {
                    this.postTouchEvent(androidInput, 3, 0, 0, (int)(-Math.signum(motionEvent.getAxisValue(9))), l);
                }
            } else {
                int n2 = (int)motionEvent.getX();
                n = (int)motionEvent.getY();
                if (n2 != this.deltaX || n != this.deltaY) {
                    this.postTouchEvent(androidInput, 4, n2, n, 0, l);
                    this.deltaX = n2;
                    this.deltaY = n;
                }
            }
        }
        Gdx.app.getGraphics().requestRendering();
        return true;
    }
}

