/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.assets;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetErrorListener;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetLoadingTask;
import com.badlogic.gdx.assets.RefCountedContainer;
import com.badlogic.gdx.assets.loaders.AssetLoader;
import com.badlogic.gdx.assets.loaders.BitmapFontLoader;
import com.badlogic.gdx.assets.loaders.CubemapLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.I18NBundleLoader;
import com.badlogic.gdx.assets.loaders.MusicLoader;
import com.badlogic.gdx.assets.loaders.ParticleEffectLoader;
import com.badlogic.gdx.assets.loaders.PixmapLoader;
import com.badlogic.gdx.assets.loaders.ShaderProgramLoader;
import com.badlogic.gdx.assets.loaders.SkinLoader;
import com.badlogic.gdx.assets.loaders.SoundLoader;
import com.badlogic.gdx.assets.loaders.TextureAtlasLoader;
import com.badlogic.gdx.assets.loaders.TextureLoader;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Cubemap;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.PolygonRegion;
import com.badlogic.gdx.graphics.g2d.PolygonRegionLoader;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.loader.G3dModelLoader;
import com.badlogic.gdx.graphics.g3d.loader.ObjLoader;
import com.badlogic.gdx.graphics.g3d.particles.ParticleEffect;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.I18NBundle;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.Logger;
import com.badlogic.gdx.utils.ObjectIntMap;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.ObjectSet;
import com.badlogic.gdx.utils.TimeUtils;
import com.badlogic.gdx.utils.UBJsonReader;
import com.badlogic.gdx.utils.async.AsyncExecutor;
import com.badlogic.gdx.utils.async.ThreadUtils;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Stack;

public class AssetManager
implements Disposable {
    final ObjectMap<String, Array<String>> assetDependencies;
    final ObjectMap<String, Class> assetTypes;
    final ObjectMap<Class, ObjectMap<String, RefCountedContainer>> assets = new ObjectMap();
    final AsyncExecutor executor;
    final ObjectSet<String> injected;
    AssetErrorListener listener = null;
    final Array<AssetDescriptor> loadQueue;
    int loaded = 0;
    final ObjectMap<Class, ObjectMap<String, AssetLoader>> loaders;
    Logger log;
    int peakTasks = 0;
    final FileHandleResolver resolver;
    final Stack<AssetLoadingTask> tasks;
    int toLoad = 0;

    public AssetManager() {
        this(new InternalFileHandleResolver());
    }

    public AssetManager(FileHandleResolver fileHandleResolver) {
        this(fileHandleResolver, true);
    }

    public AssetManager(FileHandleResolver fileHandleResolver, boolean bl) {
        this.assetTypes = new ObjectMap();
        this.assetDependencies = new ObjectMap();
        this.injected = new ObjectSet();
        this.loaders = new ObjectMap();
        this.loadQueue = new Array();
        this.tasks = new Stack();
        this.log = new Logger("AssetManager", 0);
        this.resolver = fileHandleResolver;
        if (bl) {
            this.setLoader(BitmapFont.class, new BitmapFontLoader(fileHandleResolver));
            this.setLoader(Music.class, new MusicLoader(fileHandleResolver));
            this.setLoader(Pixmap.class, new PixmapLoader(fileHandleResolver));
            this.setLoader(Sound.class, new SoundLoader(fileHandleResolver));
            this.setLoader(TextureAtlas.class, new TextureAtlasLoader(fileHandleResolver));
            this.setLoader(Texture.class, new TextureLoader(fileHandleResolver));
            this.setLoader(Skin.class, new SkinLoader(fileHandleResolver));
            this.setLoader(com.badlogic.gdx.graphics.g2d.ParticleEffect.class, new ParticleEffectLoader(fileHandleResolver));
            this.setLoader(ParticleEffect.class, new com.badlogic.gdx.graphics.g3d.particles.ParticleEffectLoader(fileHandleResolver));
            this.setLoader(PolygonRegion.class, new PolygonRegionLoader(fileHandleResolver));
            this.setLoader(I18NBundle.class, new I18NBundleLoader(fileHandleResolver));
            this.setLoader(Model.class, ".g3dj", new G3dModelLoader(new JsonReader(), fileHandleResolver));
            this.setLoader(Model.class, ".g3db", new G3dModelLoader(new UBJsonReader(), fileHandleResolver));
            this.setLoader(Model.class, ".obj", new ObjLoader(fileHandleResolver));
            this.setLoader(ShaderProgram.class, new ShaderProgramLoader(fileHandleResolver));
            this.setLoader(Cubemap.class, new CubemapLoader(fileHandleResolver));
        }
        this.executor = new AsyncExecutor(1, "AssetManager");
    }

    private void addTask(AssetDescriptor assetDescriptor) {
        Object object = this.getLoader(assetDescriptor.type, assetDescriptor.fileName);
        if (object != null) {
            this.tasks.push(new AssetLoadingTask(this, assetDescriptor, (AssetLoader)object, this.executor));
            ++this.peakTasks;
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("No loader for type: ");
        ((StringBuilder)object).append(ClassReflection.getSimpleName(assetDescriptor.type));
        throw new GdxRuntimeException(((StringBuilder)object).toString());
    }

    private void handleTaskError(Throwable throwable) {
        this.log.error("Error loading asset.", throwable);
        if (!this.tasks.isEmpty()) {
            Iterator<AssetDescriptor> iterator = this.tasks.pop();
            AssetDescriptor assetDescriptor = ((AssetLoadingTask)((Object)iterator)).assetDesc;
            if (((AssetLoadingTask)((Object)iterator)).dependenciesLoaded && ((AssetLoadingTask)((Object)iterator)).dependencies != null) {
                iterator = ((AssetLoadingTask)((Object)iterator)).dependencies.iterator();
                while (iterator.hasNext()) {
                    this.unload(iterator.next().fileName);
                }
            }
            this.tasks.clear();
            iterator = this.listener;
            if (iterator != null) {
                iterator.error(assetDescriptor, throwable);
                return;
            }
            throw new GdxRuntimeException(throwable);
        }
        throwable = new GdxRuntimeException(throwable);
        throw throwable;
    }

    private void incrementRefCountedDependencies(String iterator) {
        if ((iterator = this.assetDependencies.get((String)((Object)iterator))) == null) {
            return;
        }
        iterator = ((Array)((Object)iterator)).iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Class clazz = this.assetTypes.get(string2);
            this.assets.get(clazz).get(string2).incRefCount();
            this.incrementRefCountedDependencies(string2);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void injectDependency(String object, AssetDescriptor assetDescriptor) {
        synchronized (this) {
            void var2_2;
            Array<String> array = this.assetDependencies.get((String)object);
            Object object2 = array;
            if (array == null) {
                object2 = new Array();
                this.assetDependencies.put((String)object, (Array<String>)object2);
            }
            ((Array)object2).add(var2_2.fileName);
            if (this.isLoaded(var2_2.fileName)) {
                object2 = this.log;
                object = new StringBuilder();
                ((StringBuilder)object).append("Dependency already loaded: ");
                ((StringBuilder)object).append(var2_2);
                ((Logger)object2).debug(((StringBuilder)object).toString());
                object = this.assetTypes.get(var2_2.fileName);
                this.assets.get((Class)object).get(var2_2.fileName).incRefCount();
                this.incrementRefCountedDependencies(var2_2.fileName);
            } else {
                object = this.log;
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Loading dependency: ");
                ((StringBuilder)object2).append(var2_2);
                ((Logger)object).info(((StringBuilder)object2).toString());
                this.addTask((AssetDescriptor)var2_2);
            }
            return;
        }
    }

    private void nextTask() {
        AssetDescriptor assetDescriptor = this.loadQueue.removeIndex(0);
        if (this.isLoaded(assetDescriptor.fileName)) {
            Object object = this.log;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Already loaded: ");
            stringBuilder.append(assetDescriptor);
            ((Logger)object).debug(stringBuilder.toString());
            object = this.assetTypes.get(assetDescriptor.fileName);
            this.assets.get((Class)object).get(assetDescriptor.fileName).incRefCount();
            this.incrementRefCountedDependencies(assetDescriptor.fileName);
            if (assetDescriptor.params != null && assetDescriptor.params.loadedCallback != null) {
                assetDescriptor.params.loadedCallback.finishedLoading(this, assetDescriptor.fileName, assetDescriptor.type);
            }
            ++this.loaded;
        } else {
            Logger logger = this.log;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Loading: ");
            stringBuilder.append(assetDescriptor);
            logger.info(stringBuilder.toString());
            this.addTask(assetDescriptor);
        }
    }

    private boolean updateTask() {
        boolean bl;
        AssetLoadingTask assetLoadingTask;
        block7: {
            block6: {
                assetLoadingTask = this.tasks.peek();
                try {
                    boolean bl2;
                    if (assetLoadingTask.cancel || (bl2 = assetLoadingTask.update())) break block6;
                    bl = false;
                    break block7;
                }
                catch (RuntimeException runtimeException) {
                    assetLoadingTask.cancel = true;
                    this.taskFailed(assetLoadingTask.assetDesc, runtimeException);
                }
            }
            bl = true;
        }
        if (bl) {
            if (this.tasks.size() == 1) {
                ++this.loaded;
                this.peakTasks = 0;
            }
            this.tasks.pop();
            if (assetLoadingTask.cancel) {
                return true;
            }
            this.addAsset(assetLoadingTask.assetDesc.fileName, assetLoadingTask.assetDesc.type, assetLoadingTask.getAsset());
            if (assetLoadingTask.assetDesc.params != null && assetLoadingTask.assetDesc.params.loadedCallback != null) {
                assetLoadingTask.assetDesc.params.loadedCallback.finishedLoading(this, assetLoadingTask.assetDesc.fileName, assetLoadingTask.assetDesc.type);
            }
            long l = TimeUtils.nanoTime();
            Logger logger = this.log;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Loaded: ");
            stringBuilder.append((float)(l - assetLoadingTask.startTime) / 1000000.0f);
            stringBuilder.append("ms ");
            stringBuilder.append(assetLoadingTask.assetDesc);
            logger.debug(stringBuilder.toString());
            return true;
        }
        return false;
    }

    protected <T> void addAsset(String string2, Class<T> clazz, T t) {
        ObjectMap<String, RefCountedContainer> objectMap;
        this.assetTypes.put(string2, clazz);
        ObjectMap<String, RefCountedContainer> objectMap2 = objectMap = this.assets.get(clazz);
        if (objectMap == null) {
            objectMap2 = new ObjectMap();
            this.assets.put(clazz, objectMap2);
        }
        objectMap2.put(string2, new RefCountedContainer(t));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clear() {
        synchronized (this) {
            this.loadQueue.clear();
            while (!this.update()) {
            }
            ObjectIntMap<Object> objectIntMap = new ObjectIntMap<Object>();
            block4: while (true) {
                if (this.assetTypes.size <= 0) {
                    this.assets.clear();
                    this.assetTypes.clear();
                    this.assetDependencies.clear();
                    this.loaded = 0;
                    this.toLoad = 0;
                    this.peakTasks = 0;
                    this.loadQueue.clear();
                    this.tasks.clear();
                    return;
                }
                objectIntMap.clear();
                Object object = this.assetTypes.keys().toArray();
                Iterator<String> iterator = ((Array)object).iterator();
                while (iterator.hasNext()) {
                    objectIntMap.put(iterator.next(), 0);
                }
                iterator = ((Array)object).iterator();
                while (iterator.hasNext()) {
                    Object object2 = iterator.next();
                    if ((object2 = this.assetDependencies.get((String)object2)) == null) continue;
                    Iterator iterator2 = ((Array)object2).iterator();
                    while (iterator2.hasNext()) {
                        object2 = (String)iterator2.next();
                        objectIntMap.put(object2, objectIntMap.get(object2, 0) + 1);
                    }
                }
                iterator = ((Array)object).iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block4;
                    object = iterator.next();
                    if (objectIntMap.get(object, 0) != 0) continue;
                    this.unload((String)object);
                }
                break;
            }
        }
    }

    public boolean contains(String string2) {
        synchronized (this) {
            boolean bl;
            block6: {
                if (this.tasks.size() <= 0 || !(bl = ((AssetLoadingTask)this.tasks.firstElement()).assetDesc.fileName.equals(string2))) break block6;
                return true;
            }
            int n = 0;
            while (true) {
                block7: {
                    if (n >= this.loadQueue.size) break;
                    bl = this.loadQueue.get((int)n).fileName.equals(string2);
                    if (!bl) break block7;
                    return true;
                }
                ++n;
            }
            try {
                bl = this.isLoaded(string2);
                return bl;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    public boolean contains(String string2, Class clazz) {
        synchronized (this) {
            boolean bl;
            AssetDescriptor assetDescriptor;
            block6: {
                if (this.tasks.size() <= 0) break block6;
                assetDescriptor = ((AssetLoadingTask)this.tasks.firstElement()).assetDesc;
                if (assetDescriptor.type != clazz || !(bl = assetDescriptor.fileName.equals(string2))) break block6;
                return true;
            }
            int n = 0;
            while (true) {
                block7: {
                    if (n >= this.loadQueue.size) break;
                    assetDescriptor = this.loadQueue.get(n);
                    if (assetDescriptor.type != clazz || !(bl = assetDescriptor.fileName.equals(string2))) break block7;
                    return true;
                }
                ++n;
            }
            try {
                bl = this.isLoaded(string2, clazz);
                return bl;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    public <T> boolean containsAsset(T t) {
        synchronized (this) {
            Object object;
            ObjectMap<String, RefCountedContainer> objectMap;
            block6: {
                objectMap = this.assets.get(t.getClass());
                if (objectMap != null) break block6;
                return false;
            }
            try {
                Iterator iterator = objectMap.keys().iterator();
                while (iterator.hasNext()) {
                    object = objectMap.get((String)iterator.next()).getObject(Object.class);
                    if (object == t) break block7;
                }
            }
            catch (Throwable throwable) {}
            {
                throw throwable;
            }
            {
                block7: {
                    boolean bl = t.equals(object);
                    if (!bl) continue;
                }
                return true;
            }
            return false;
        }
    }

    @Override
    public void dispose() {
        synchronized (this) {
            this.log.debug("Disposing.");
            this.clear();
            this.executor.dispose();
            return;
        }
    }

    public void finishLoading() {
        this.log.debug("Waiting for loading to complete...");
        while (!this.update()) {
            ThreadUtils.yield();
        }
        this.log.debug("Loading complete.");
    }

    public <T> T finishLoadingAsset(AssetDescriptor assetDescriptor) {
        return this.finishLoadingAsset(assetDescriptor.fileName);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T finishLoadingAsset(String string2) {
        Object object = this.log;
        Serializable serializable = new StringBuilder();
        serializable.append("Waiting for asset to be loaded: ");
        serializable.append(string2);
        ((Logger)object).debug(serializable.toString());
        while (true) {
            synchronized (this) {
                serializable = this.assetTypes.get(string2);
                if (serializable != null && (object = this.assets.get((Class)serializable)) != null && (object = (RefCountedContainer)((ObjectMap)object).get(string2)) != null && (serializable = ((RefCountedContainer)object).getObject(serializable)) != null) {
                    object = this.log;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Asset loaded: ");
                    stringBuilder.append(string2);
                    ((Logger)object).debug(stringBuilder.toString());
                    return (T)serializable;
                }
                this.update();
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
            }
            ThreadUtils.yield();
        }
    }

    public <T> T get(AssetDescriptor<T> assetDescriptor) {
        synchronized (this) {
            assetDescriptor = this.get(assetDescriptor.fileName, assetDescriptor.type);
            return (T)assetDescriptor;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T get(String string2) {
        synchronized (this) {
            Serializable serializable = this.assetTypes.get(string2);
            if (serializable == null) {
                serializable = new StringBuilder();
                ((StringBuilder)serializable).append("Asset not loaded: ");
                ((StringBuilder)serializable).append(string2);
                GdxRuntimeException gdxRuntimeException = new GdxRuntimeException(((StringBuilder)serializable).toString());
                throw gdxRuntimeException;
            }
            ObjectMap<String, RefCountedContainer> objectMap = this.assets.get((Class)serializable);
            if (objectMap == null) {
                objectMap = new StringBuilder();
                ((StringBuilder)((Object)objectMap)).append("Asset not loaded: ");
                ((StringBuilder)((Object)objectMap)).append(string2);
                serializable = new GdxRuntimeException(((StringBuilder)((Object)objectMap)).toString());
                throw serializable;
            }
            if ((objectMap = objectMap.get(string2)) == null) {
                serializable = new StringBuilder();
                ((StringBuilder)serializable).append("Asset not loaded: ");
                ((StringBuilder)serializable).append(string2);
                objectMap = new GdxRuntimeException(((StringBuilder)serializable).toString());
                throw objectMap;
            }
            if ((serializable = ((RefCountedContainer)((Object)objectMap)).getObject(serializable)) != null) {
                return (T)serializable;
            }
            serializable = new StringBuilder();
            ((StringBuilder)serializable).append("Asset not loaded: ");
            ((StringBuilder)serializable).append(string2);
            objectMap = new GdxRuntimeException(((StringBuilder)serializable).toString());
            throw objectMap;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T get(String string2, Class<T> serializable) {
        synchronized (this) {
            Serializable serializable2;
            Object object = this.assets.get((Class)serializable2);
            if (object == null) {
                serializable2 = new StringBuilder();
                ((StringBuilder)serializable2).append("Asset not loaded: ");
                ((StringBuilder)serializable2).append(string2);
                object = new GdxRuntimeException(((StringBuilder)serializable2).toString());
                throw object;
            }
            if ((object = ((ObjectMap)object).get((String)string2)) == null) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Asset not loaded: ");
                ((StringBuilder)object).append(string2);
                serializable2 = new GdxRuntimeException(((StringBuilder)object).toString());
                throw serializable2;
            }
            if ((serializable2 = ((RefCountedContainer)object).getObject(serializable2)) != null) {
                return (T)serializable2;
            }
            serializable2 = new StringBuilder();
            ((StringBuilder)serializable2).append("Asset not loaded: ");
            ((StringBuilder)serializable2).append(string2);
            object = new GdxRuntimeException(((StringBuilder)serializable2).toString());
            throw object;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> Array<T> getAll(Class<T> clazz, Array<T> array) {
        synchronized (this) {
            Object object = this.assets.get(clazz);
            if (object == null) return array;
            object = ((ObjectMap)object).entries().iterator();
            while (object.hasNext()) {
                array.add(((RefCountedContainer)((ObjectMap.Entry)object.next()).value).getObject(clazz));
            }
            return array;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> String getAssetFileName(T t) {
        synchronized (this) {
            String string2;
            Iterator iterator = this.assets.keys().iterator();
            block5: while (true) {
                Object object;
                boolean bl;
                if (!iterator.hasNext()) return null;
                Class clazz = (Class)iterator.next();
                ObjectMap<String, RefCountedContainer> objectMap = this.assets.get(clazz);
                Iterator iterator2 = objectMap.keys().iterator();
                do {
                    if (!iterator2.hasNext()) continue block5;
                    string2 = (String)iterator2.next();
                    object = objectMap.get(string2).getObject(Object.class);
                    if (object == t) return string2;
                } while (!(bl = t.equals(object)));
                break;
            }
            return string2;
        }
    }

    public Array<String> getAssetNames() {
        synchronized (this) {
            Array<String> array = this.assetTypes.keys().toArray();
            return array;
        }
    }

    public Class getAssetType(String object) {
        synchronized (this) {
            object = this.assetTypes.get((String)object);
            return object;
        }
    }

    public Array<String> getDependencies(String object) {
        synchronized (this) {
            object = this.assetDependencies.get((String)object);
            return object;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getDiagnostics() {
        synchronized (this) {
            StringBuilder stringBuilder = new StringBuilder(256);
            Iterator iterator = this.assetTypes.keys().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return stringBuilder.toString();
                }
                String string2 = (String)iterator.next();
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append(string2);
                stringBuilder.append(", ");
                Object object = this.assetTypes.get(string2);
                RefCountedContainer refCountedContainer = this.assets.get((Class)object).get(string2);
                Array<String> array = this.assetDependencies.get(string2);
                stringBuilder.append(ClassReflection.getSimpleName((Class)object));
                stringBuilder.append(", refs: ");
                stringBuilder.append(refCountedContainer.getRefCount());
                if (array == null) continue;
                stringBuilder.append(", deps: [");
                object = array.iterator();
                while (object.hasNext()) {
                    stringBuilder.append((String)object.next());
                    stringBuilder.append(",");
                }
                stringBuilder.append("]");
            }
        }
    }

    public FileHandleResolver getFileHandleResolver() {
        return this.resolver;
    }

    public int getLoadedAssets() {
        synchronized (this) {
            int n = this.assetTypes.size;
            return n;
        }
    }

    public <T> AssetLoader getLoader(Class<T> clazz) {
        return this.getLoader(clazz, null);
    }

    public <T> AssetLoader getLoader(Class<T> object, String string2) {
        ObjectMap<String, AssetLoader> objectMap = this.loaders.get((Class)object);
        Iterator iterator = null;
        object = null;
        Object object2 = iterator;
        if (objectMap != null) {
            if (objectMap.size < 1) {
                object2 = iterator;
            } else {
                if (string2 == null) {
                    return objectMap.get("");
                }
                int n = -1;
                iterator = objectMap.entries().iterator();
                while (true) {
                    object2 = object;
                    if (!iterator.hasNext()) break;
                    object2 = (ObjectMap.Entry)iterator.next();
                    if (((String)((ObjectMap.Entry)object2).key).length() <= n || !string2.endsWith((String)((ObjectMap.Entry)object2).key)) continue;
                    object = (AssetLoader)((ObjectMap.Entry)object2).value;
                    n = ((String)((ObjectMap.Entry)object2).key).length();
                }
            }
        }
        return object2;
    }

    public Logger getLogger() {
        return this.log;
    }

    public float getProgress() {
        synchronized (this) {
            float f;
            block6: {
                int n = this.toLoad;
                if (n != 0) break block6;
                return 1.0f;
            }
            float f2 = f = (float)this.loaded;
            if (this.peakTasks > 0) {
                f2 = f + (float)(this.peakTasks - this.tasks.size()) / (float)this.peakTasks;
            }
            f2 = Math.min(1.0f, f2 / (float)this.toLoad);
            return f2;
        }
    }

    public int getQueuedAssets() {
        synchronized (this) {
            int n = this.loadQueue.size;
            int n2 = this.tasks.size();
            return n + n2;
        }
    }

    public int getReferenceCount(String string2) {
        synchronized (this) {
            Serializable serializable;
            block5: {
                serializable = this.assetTypes.get(string2);
                if (serializable == null) break block5;
                int n = this.assets.get((Class)serializable).get(string2).getRefCount();
                return n;
            }
            serializable = new StringBuilder();
            ((StringBuilder)serializable).append("Asset not loaded: ");
            ((StringBuilder)serializable).append(string2);
            GdxRuntimeException gdxRuntimeException = new GdxRuntimeException(((StringBuilder)serializable).toString());
            throw gdxRuntimeException;
        }
    }

    void injectDependencies(String string2, Array<AssetDescriptor> object) {
        synchronized (this) {
            try {
                ObjectSet<String> objectSet = this.injected;
                object = ((Array)object).iterator();
                while (object.hasNext()) {
                    AssetDescriptor assetDescriptor = (AssetDescriptor)object.next();
                    if (objectSet.contains(assetDescriptor.fileName)) continue;
                    objectSet.add(assetDescriptor.fileName);
                    this.injectDependency(string2, assetDescriptor);
                }
                objectSet.clear(32);
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    public boolean isFinished() {
        synchronized (this) {
            int n;
            boolean bl = this.loadQueue.size == 0 && (n = this.tasks.size()) == 0;
            return bl;
        }
    }

    public boolean isLoaded(AssetDescriptor assetDescriptor) {
        synchronized (this) {
            boolean bl = this.isLoaded(assetDescriptor.fileName);
            return bl;
        }
    }

    public boolean isLoaded(String string2) {
        synchronized (this) {
            if (string2 == null) {
                return false;
            }
            boolean bl = this.assetTypes.containsKey(string2);
            return bl;
        }
    }

    public boolean isLoaded(String object, Class clazz) {
        synchronized (this) {
            boolean bl;
            block7: {
                block6: {
                    ObjectMap<String, RefCountedContainer> objectMap;
                    block5: {
                        objectMap = this.assets.get(clazz);
                        bl = false;
                        if (objectMap != null) break block5;
                        return false;
                    }
                    object = objectMap.get((String)object);
                    if (object != null) break block6;
                    return false;
                }
                object = ((RefCountedContainer)object).getObject(clazz);
                if (object == null) break block7;
                bl = true;
            }
            return bl;
        }
    }

    public void load(AssetDescriptor assetDescriptor) {
        synchronized (this) {
            this.load(assetDescriptor.fileName, assetDescriptor.type, assetDescriptor.params);
            return;
        }
    }

    public <T> void load(String string2, Class<T> clazz) {
        synchronized (this) {
            this.load(string2, clazz, null);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> void load(String object, Class<T> object2, AssetLoaderParameters<T> object3) {
        synchronized (this) {
            Object object4;
            if (this.getLoader((Class<T>)object2, (String)object) != null) {
                int n = this.loadQueue.size;
                int n2 = 0;
                if (n == 0) {
                    this.loaded = 0;
                    this.toLoad = 0;
                    this.peakTasks = 0;
                }
                n = 0;
                while (true) {
                    if (n < this.loadQueue.size) {
                        object4 = this.loadQueue.get(n);
                        if (((AssetDescriptor)object4).fileName.equals(object) && !((AssetDescriptor)object4).type.equals(object2)) {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("Asset with name '");
                            stringBuilder.append((String)object);
                            stringBuilder.append("' already in preload queue, but has different type (expected: ");
                            stringBuilder.append(ClassReflection.getSimpleName((Class)object2));
                            stringBuilder.append(", found: ");
                            stringBuilder.append(ClassReflection.getSimpleName(((AssetDescriptor)object4).type));
                            stringBuilder.append(")");
                            object3 = new GdxRuntimeException(stringBuilder.toString());
                            throw object3;
                        }
                        ++n;
                        continue;
                    }
                    break;
                }
            } else {
                object3 = new StringBuilder();
                ((StringBuilder)object3).append("No loader for type: ");
                ((StringBuilder)object3).append(ClassReflection.getSimpleName((Class)object2));
                object = new GdxRuntimeException(((StringBuilder)object3).toString());
                throw object;
            }
            for (int i = n2; i < this.tasks.size(); ++i) {
                object4 = ((AssetLoadingTask)this.tasks.get((int)i)).assetDesc;
                if (!((AssetDescriptor)object4).fileName.equals(object) || ((AssetDescriptor)object4).type.equals(object2)) continue;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Asset with name '");
                stringBuilder.append((String)object);
                stringBuilder.append("' already in task list, but has different type (expected: ");
                stringBuilder.append(ClassReflection.getSimpleName((Class)object2));
                stringBuilder.append(", found: ");
                stringBuilder.append(ClassReflection.getSimpleName(((AssetDescriptor)object4).type));
                stringBuilder.append(")");
                object3 = new GdxRuntimeException(stringBuilder.toString());
                throw object3;
            }
            object4 = this.assetTypes.get((String)object);
            if (object4 == null || object4.equals(object2)) break block12;
            object3 = new StringBuilder();
            ((StringBuilder)object3).append("Asset with name '");
            {
                block12: {
                    ((StringBuilder)object3).append((String)object);
                    ((StringBuilder)object3).append("' already loaded, but has different type (expected: ");
                    ((StringBuilder)object3).append(ClassReflection.getSimpleName((Class)object2));
                    ((StringBuilder)object3).append(", found: ");
                    ((StringBuilder)object3).append(ClassReflection.getSimpleName(object4));
                    ((StringBuilder)object3).append(")");
                    GdxRuntimeException gdxRuntimeException = new GdxRuntimeException(((StringBuilder)object3).toString());
                    throw gdxRuntimeException;
                }
                ++this.toLoad;
                object4 = new Object((String)object, object2, object3);
                this.loadQueue.add((AssetDescriptor)object4);
                object2 = this.log;
                object = new StringBuilder();
                ((StringBuilder)object).append("Queued: ");
                ((StringBuilder)object).append(object4);
                ((Logger)object2).debug(((StringBuilder)object).toString());
                return;
            }
        }
    }

    public void setErrorListener(AssetErrorListener assetErrorListener) {
        synchronized (this) {
            this.listener = assetErrorListener;
            return;
        }
    }

    public <T, P extends AssetLoaderParameters<T>> void setLoader(Class<T> clazz, AssetLoader<T, P> assetLoader) {
        synchronized (this) {
            this.setLoader(clazz, null, assetLoader);
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T, P extends AssetLoaderParameters<T>> void setLoader(Class<T> object, String string2, AssetLoader<T, P> assetLoader) {
        synchronized (this) {
            void var2_2;
            void var3_3;
            if (object == null) {
                object = new IllegalArgumentException("type cannot be null.");
                throw object;
            }
            if (var3_3 == null) {
                object = new IllegalArgumentException("loader cannot be null.");
                throw object;
            }
            ObjectMap<Object, void> objectMap = this.log;
            ObjectMap<Class, ObjectMap<String, AssetLoader>> objectMap2 = new ObjectMap<Class, ObjectMap<String, AssetLoader>>();
            ((StringBuilder)((Object)objectMap2)).append("Loader set: ");
            ((StringBuilder)((Object)objectMap2)).append(ClassReflection.getSimpleName((Class)object));
            ((StringBuilder)((Object)objectMap2)).append(" -> ");
            ((StringBuilder)((Object)objectMap2)).append(ClassReflection.getSimpleName(var3_3.getClass()));
            ((Logger)((Object)objectMap)).debug(((StringBuilder)((Object)objectMap2)).toString());
            objectMap2 = this.loaders.get((Class)object);
            objectMap = objectMap2;
            if (objectMap2 == null) {
                objectMap2 = this.loaders;
                objectMap = new ObjectMap<Object, void>();
                objectMap2.put((Class)object, objectMap);
            }
            object = var2_2;
            if (var2_2 == null) {
                object = "";
            }
            objectMap.put(object, var3_3);
            return;
        }
    }

    public void setLogger(Logger logger) {
        this.log = logger;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setReferenceCount(String string2, int n) {
        synchronized (this) {
            Class clazz = this.assetTypes.get(string2);
            if (clazz != null) {
                void var2_2;
                this.assets.get(clazz).get(string2).setRefCount((int)var2_2);
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Asset not loaded: ");
            stringBuilder.append(string2);
            GdxRuntimeException gdxRuntimeException = new GdxRuntimeException(stringBuilder.toString());
            throw gdxRuntimeException;
        }
    }

    protected void taskFailed(AssetDescriptor assetDescriptor, RuntimeException runtimeException) {
        throw runtimeException;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unload(String string2) {
        synchronized (this) {
            Object object;
            Object object2;
            int n;
            Object object3;
            block15: {
                if (this.tasks.size() > 0) {
                    object3 = (AssetLoadingTask)this.tasks.firstElement();
                    if (((AssetLoadingTask)object3).assetDesc.fileName.equals(string2)) {
                        ((AssetLoadingTask)object3).cancel = true;
                        Logger logger = this.log;
                        object3 = new StringBuilder();
                        ((StringBuilder)object3).append("Unload (from tasks): ");
                        ((StringBuilder)object3).append(string2);
                        logger.info(((StringBuilder)object3).toString());
                        return;
                    }
                }
                for (n = 0; n < this.loadQueue.size; ++n) {
                    if (!this.loadQueue.get((int)n).fileName.equals(string2)) {
                        continue;
                    }
                    break block15;
                }
                n = -1;
            }
            if (n != -1) {
                --this.toLoad;
                this.loadQueue.removeIndex(n);
                object3 = this.log;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Unload (from queue): ");
                stringBuilder.append(string2);
                ((Logger)object3).info(stringBuilder.toString());
                return;
            }
            Class clazz = this.assetTypes.get(string2);
            if (clazz == null) {
                object3 = new StringBuilder();
                ((StringBuilder)object3).append("Asset not loaded: ");
                ((StringBuilder)object3).append(string2);
                GdxRuntimeException gdxRuntimeException = new GdxRuntimeException(((StringBuilder)object3).toString());
                throw gdxRuntimeException;
            }
            object3 = this.assets.get(clazz).get(string2);
            ((RefCountedContainer)object3).decRefCount();
            if (((RefCountedContainer)object3).getRefCount() <= 0) {
                object2 = this.log;
                object = new StringBuilder();
                ((StringBuilder)object).append("Unload (dispose): ");
                ((StringBuilder)object).append(string2);
                ((Logger)object2).info(((StringBuilder)object).toString());
                if (((RefCountedContainer)object3).getObject(Object.class) instanceof Disposable) {
                    ((Disposable)((RefCountedContainer)object3).getObject(Object.class)).dispose();
                }
                this.assetTypes.remove(string2);
                this.assets.get(clazz).remove(string2);
            } else {
                object = this.log;
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Unload (decrement): ");
                ((StringBuilder)object2).append(string2);
                ((Logger)object).info(((StringBuilder)object2).toString());
            }
            object = this.assetDependencies.get(string2);
            if (object != null) {
                object = ((Array)object).iterator();
                while (object.hasNext()) {
                    object2 = (String)object.next();
                    if (!this.isLoaded((String)object2)) continue;
                    this.unload((String)object2);
                }
            }
            if (((RefCountedContainer)object3).getRefCount() > 0) return;
            this.assetDependencies.remove(string2);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean update() {
        synchronized (this) {
            Throwable throwable22222;
            block8: {
                boolean bl;
                int n;
                boolean bl2;
                block7: {
                    boolean bl3 = false;
                    bl2 = false;
                    if (this.tasks.size() != 0) break block7;
                    while (this.loadQueue.size != 0 && this.tasks.size() == 0) {
                        this.nextTask();
                    }
                    n = this.tasks.size();
                    if (n != 0) break block7;
                    {
                        catch (Throwable throwable22222) {
                            break block8;
                        }
                        catch (Throwable throwable3) {}
                        {
                            this.handleTaskError(throwable3);
                            n = this.loadQueue.size;
                            bl = bl3;
                            if (n != 0) return bl;
                            return true;
                        }
                    }
                    return true;
                }
                bl = bl2;
                {
                    if (!this.updateTask()) return bl;
                    bl = bl2;
                    if (this.loadQueue.size != 0) return bl;
                    n = this.tasks.size();
                    bl = bl2;
                    if (n != 0) return bl;
                    return true;
                }
            }
            throw throwable22222;
        }
    }

    public boolean update(int n) {
        boolean bl;
        long l = TimeUtils.millis();
        long l2 = n;
        while (!(bl = this.update()) && TimeUtils.millis() <= l + l2) {
            ThreadUtils.yield();
        }
        return bl;
    }
}

