/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx;

import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.SnapshotArray;

public class InputMultiplexer
implements InputProcessor {
    private SnapshotArray<InputProcessor> processors = new SnapshotArray(4);

    public InputMultiplexer() {
    }

    public InputMultiplexer(InputProcessor ... inputProcessorArray) {
        this.processors.addAll((InputProcessor[])inputProcessorArray);
    }

    public void addProcessor(int n, InputProcessor inputProcessor) {
        if (inputProcessor != null) {
            this.processors.insert(n, inputProcessor);
            return;
        }
        throw new NullPointerException("processor cannot be null");
    }

    public void addProcessor(InputProcessor inputProcessor) {
        if (inputProcessor != null) {
            this.processors.add(inputProcessor);
            return;
        }
        throw new NullPointerException("processor cannot be null");
    }

    public void clear() {
        this.processors.clear();
    }

    public SnapshotArray<InputProcessor> getProcessors() {
        return this.processors;
    }

    @Override
    public boolean keyDown(int n) {
        int n2;
        InputProcessor[] inputProcessorArray = this.processors.begin();
        try {
            n2 = this.processors.size;
        }
        catch (Throwable throwable) {
            this.processors.end();
            throw throwable;
        }
        for (int i = 0; i < n2; ++i) {
            boolean bl = inputProcessorArray[i].keyDown(n);
            if (!bl) continue;
            this.processors.end();
            return true;
        }
        this.processors.end();
        return false;
    }

    @Override
    public boolean keyTyped(char c) {
        int n;
        InputProcessor[] inputProcessorArray = this.processors.begin();
        try {
            n = this.processors.size;
        }
        catch (Throwable throwable) {
            this.processors.end();
            throw throwable;
        }
        for (int i = 0; i < n; ++i) {
            boolean bl = inputProcessorArray[i].keyTyped(c);
            if (!bl) continue;
            this.processors.end();
            return true;
        }
        this.processors.end();
        return false;
    }

    @Override
    public boolean keyUp(int n) {
        int n2;
        InputProcessor[] inputProcessorArray = this.processors.begin();
        try {
            n2 = this.processors.size;
        }
        catch (Throwable throwable) {
            this.processors.end();
            throw throwable;
        }
        for (int i = 0; i < n2; ++i) {
            boolean bl = inputProcessorArray[i].keyUp(n);
            if (!bl) continue;
            this.processors.end();
            return true;
        }
        this.processors.end();
        return false;
    }

    @Override
    public boolean mouseMoved(int n, int n2) {
        int n3;
        InputProcessor[] inputProcessorArray = this.processors.begin();
        try {
            n3 = this.processors.size;
        }
        catch (Throwable throwable) {
            this.processors.end();
            throw throwable;
        }
        for (int i = 0; i < n3; ++i) {
            boolean bl = inputProcessorArray[i].mouseMoved(n, n2);
            if (!bl) continue;
            this.processors.end();
            return true;
        }
        this.processors.end();
        return false;
    }

    public void removeProcessor(int n) {
        this.processors.removeIndex(n);
    }

    public void removeProcessor(InputProcessor inputProcessor) {
        this.processors.removeValue(inputProcessor, true);
    }

    @Override
    public boolean scrolled(int n) {
        int n2;
        InputProcessor[] inputProcessorArray = this.processors.begin();
        try {
            n2 = this.processors.size;
        }
        catch (Throwable throwable) {
            this.processors.end();
            throw throwable;
        }
        for (int i = 0; i < n2; ++i) {
            boolean bl = inputProcessorArray[i].scrolled(n);
            if (!bl) continue;
            this.processors.end();
            return true;
        }
        this.processors.end();
        return false;
    }

    public void setProcessors(Array<InputProcessor> array) {
        this.processors.clear();
        this.processors.addAll(array);
    }

    public void setProcessors(InputProcessor ... inputProcessorArray) {
        this.processors.clear();
        this.processors.addAll((InputProcessor[])inputProcessorArray);
    }

    public int size() {
        return this.processors.size;
    }

    @Override
    public boolean touchDown(int n, int n2, int n3, int n4) {
        int n5;
        InputProcessor[] inputProcessorArray = this.processors.begin();
        try {
            n5 = this.processors.size;
        }
        catch (Throwable throwable) {
            this.processors.end();
            throw throwable;
        }
        for (int i = 0; i < n5; ++i) {
            boolean bl = inputProcessorArray[i].touchDown(n, n2, n3, n4);
            if (!bl) continue;
            this.processors.end();
            return true;
        }
        this.processors.end();
        return false;
    }

    @Override
    public boolean touchDragged(int n, int n2, int n3) {
        int n4;
        InputProcessor[] inputProcessorArray = this.processors.begin();
        try {
            n4 = this.processors.size;
        }
        catch (Throwable throwable) {
            this.processors.end();
            throw throwable;
        }
        for (int i = 0; i < n4; ++i) {
            boolean bl = inputProcessorArray[i].touchDragged(n, n2, n3);
            if (!bl) continue;
            this.processors.end();
            return true;
        }
        this.processors.end();
        return false;
    }

    @Override
    public boolean touchUp(int n, int n2, int n3, int n4) {
        int n5;
        InputProcessor[] inputProcessorArray = this.processors.begin();
        try {
            n5 = this.processors.size;
        }
        catch (Throwable throwable) {
            this.processors.end();
            throw throwable;
        }
        for (int i = 0; i < n5; ++i) {
            boolean bl = inputProcessorArray[i].touchUp(n, n2, n3, n4);
            if (!bl) continue;
            this.processors.end();
            return true;
        }
        this.processors.end();
        return false;
    }
}

