/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.CFG;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class HolyRomanEmpire_GameData
implements Serializable {
    private static final long serialVersionUID = 0L;
    private int iElectorsSize = 0;
    private int iEmperorAuthority = 0;
    private int iEmperorID = -1;
    private int iNextElectionsIn = 30;
    private int iPrincesSize = 0;
    private int iProvincesSize = 0;
    private List<Integer> lElectors;
    private List<Integer> lPrinces;
    private List<Integer> lProvinces = new ArrayList<Integer>();
    protected List<Integer> lVotesFor;

    public HolyRomanEmpire_GameData() {
        this.lElectors = new ArrayList<Integer>();
        this.lPrinces = new ArrayList<Integer>();
        this.lVotesFor = new ArrayList<Integer>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void addElector(int n) {
        if (this.getElectorsSize() >= 7) return;
        int n2 = 0;
        while (n2 < this.getPrincesSize()) {
            if (this.getPrince(n2) == n) {
                this.lElectors.add(n2);
                this.iElectorsSize = this.lElectors.size();
                this.buildVotesFor();
                return;
            }
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void addPrince(int n) {
        for (int i = 0; i < this.getPrincesSize(); ++i) {
            if (this.getPrince(i) != n) continue;
            return;
        }
        this.lPrinces.add(n);
        this.iPrincesSize = this.lPrinces.size();
        CFG.game.getCiv(n).setIsPartOfHolyRomanEmpire(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean addProvince(int n) {
        boolean bl = false;
        for (int i = 0; i < this.getProvincesSize(); ++i) {
            if (this.getProvinces(i) != n) continue;
            return bl;
        }
        this.lProvinces.add(n);
        this.iProvincesSize = this.lProvinces.size();
        CFG.game.getProvince(n).setIsPartOfHolyRomanEmpire(true);
        return true;
    }

    protected final void addStrongestPrinceAsElector() {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 0; n < this.getPrincesSize(); ++n) {
            if (CFG.game.getCiv(this.getPrince(n)).getNumOfProvinces() <= 0 || this.getIsElector(this.getPrince(n)) || this.getIsEmperor(this.getPrince(n))) continue;
            arrayList.add(this.getPrince(n));
        }
        if (arrayList.size() > 0) {
            int n2 = 0;
            for (n = 0; n < arrayList.size(); ++n) {
                if (CFG.game.getCiv((Integer)arrayList.get(n)).countPopulation() <= CFG.game.getCiv((Integer)arrayList.get(n2)).countPopulation()) continue;
                n2 = n;
            }
            this.addElector((Integer)arrayList.get(n2));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void buildVotesFor() {
        int n = 0;
        int n2 = 0;
        if (this.lVotesFor == null) {
            this.lVotesFor = new ArrayList<Integer>();
        }
        if (this.lVotesFor.size() == 0) {
            while (n2 < this.getElectorsSize()) {
                this.lVotesFor.add(this.getPrince(this.getElector(n2)));
                ++n2;
            }
            return;
        } else {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n2 = 0; n2 < this.lVotesFor.size(); ++n2) {
                arrayList.add(this.lVotesFor.get(n2));
            }
            this.lVotesFor.clear();
            for (n2 = n; n2 < this.getElectorsSize(); ++n2) {
                if (CFG.game.getCiv(this.getPrince(this.getElector(n2))).getControlledByPlayer()) {
                    try {
                        this.lVotesFor.add((Integer)arrayList.get(n2));
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        this.lVotesFor.add(this.getPrince(this.getElector(n2)));
                    }
                    continue;
                }
                this.lVotesFor.add(this.getPrince(this.getElector(n2)));
            }
        }
    }

    protected final int getElector(int n) {
        return this.lElectors.get(n);
    }

    protected final int getElectorsSize() {
        return this.iElectorsSize;
    }

    protected final int getEmperor() {
        return this.lPrinces.get(this.iEmperorID);
    }

    protected final int getEmperorAuthority() {
        return this.iEmperorAuthority;
    }

    protected final boolean getIsElector(int n) {
        boolean bl = false;
        int n2 = 0;
        while (true) {
            block4: {
                boolean bl2;
                block3: {
                    bl2 = bl;
                    if (n2 >= this.getElectorsSize()) break block3;
                    if (this.getPrince(this.getElector(n2)) != n) break block4;
                    bl2 = true;
                }
                return bl2;
            }
            ++n2;
        }
    }

    protected boolean getIsEmperor(int n) {
        boolean bl;
        int n2 = this.iEmperorID;
        boolean bl2 = bl = false;
        if (n2 >= 0) {
            bl2 = bl;
            if (this.getPrince(n2) == n) {
                bl2 = true;
            }
        }
        return bl2;
    }

    protected final boolean getIsImperialProvince(int n) {
        boolean bl = false;
        int n2 = 0;
        while (true) {
            block4: {
                boolean bl2;
                block3: {
                    bl2 = bl;
                    if (n2 >= this.getPrincesSize()) break block3;
                    if (this.getProvinces(n2) != n) break block4;
                    bl2 = true;
                }
                return bl2;
            }
            ++n2;
        }
    }

    protected final boolean getIsPrince(int n) {
        boolean bl = false;
        int n2 = 0;
        while (true) {
            block4: {
                boolean bl2;
                block3: {
                    bl2 = bl;
                    if (n2 >= this.getPrincesSize()) break block3;
                    if (this.getPrince(n2) != n) break block4;
                    bl2 = true;
                }
                return bl2;
            }
            ++n2;
        }
    }

    protected final int getNextElectionsIn() {
        return this.iNextElectionsIn;
    }

    protected final int getPrince(int n) {
        return this.lPrinces.get(n);
    }

    protected final int getPrincesSize() {
        return this.iPrincesSize;
    }

    protected final int getPrincesSize_True() {
        int n = 0;
        for (int i = 0; i < this.getPrincesSize(); ++i) {
            int n2 = n;
            if (CFG.game.getCiv(this.getPrince(i)).getNumOfProvinces() > 0) {
                n2 = n + 1;
            }
            n = n2;
        }
        return n;
    }

    protected final int getProvinces(int n) {
        return this.lProvinces.get(n);
    }

    protected final int getProvincesSize() {
        return this.iProvincesSize;
    }

    protected final void randomNextElections() {
        this.iNextElectionsIn = CFG.oR.nextInt(60) + 32;
    }

    protected final void removeElector(int n) {
        int n2 = 0;
        while (true) {
            block4: {
                block3: {
                    if (n2 >= this.getElectorsSize()) break block3;
                    if (this.getPrince(this.lElectors.get(n2)) != n) break block4;
                    this.lElectors.remove(n2);
                    this.iElectorsSize = this.lElectors.size();
                    this.buildVotesFor();
                }
                return;
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void removePrince(int n) {
        int n2 = 0;
        while (n2 < this.getPrincesSize()) {
            if (this.getPrince(n2) == n) {
                CFG.game.getCiv(n).setIsPartOfHolyRomanEmpire(false);
                this.removeElector(n);
                this.lPrinces.remove(n2);
                this.iPrincesSize = this.lPrinces.size();
                for (n = 0; n < this.getElectorsSize(); ++n) {
                    if (this.lElectors.get(n) <= n2) continue;
                    List<Integer> list = this.lElectors;
                    list.set(n, list.get(n) - 1);
                }
                n = this.iEmperorID;
                if (n != n2) {
                    if (n <= n2) return;
                    this.iEmperorID = n - 1;
                    return;
                }
                if (this.getElectorsSize() > 0) {
                    this.iEmperorID = this.getElector(0);
                    return;
                }
                this.iEmperorID = -1;
                return;
            }
            ++n2;
        }
    }

    protected final void removePrinceID(int n) {
        this.removePrince(this.getPrince(n));
    }

    protected final boolean removeProvince(int n) {
        boolean bl = false;
        int n2 = 0;
        while (true) {
            block4: {
                boolean bl2;
                block3: {
                    bl2 = bl;
                    if (n2 >= this.getProvincesSize()) break block3;
                    if (this.getProvinces(n2) != n) break block4;
                    CFG.game.getProvince(n).setIsPartOfHolyRomanEmpire(false);
                    this.lProvinces.remove(n2);
                    this.iProvincesSize = this.lProvinces.size();
                    bl2 = true;
                }
                return bl2;
            }
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void setElectorID(int n) {
        block4: {
            block3: {
                if (n >= this.getPrincesSize()) break block3;
                if (!this.getIsElector(this.getPrince(n))) break block4;
                this.removeElector(this.getPrince(n));
            }
            return;
        }
        this.addElector(this.getPrince(n));
    }

    protected final void setEmperor(int n) {
        int n2 = 0;
        while (true) {
            block4: {
                block3: {
                    if (n2 >= this.getPrincesSize()) break block3;
                    if (this.getPrince(n2) != n) break block4;
                    this.iEmperorID = n2;
                    this.removeElector(n);
                }
                return;
            }
            ++n2;
        }
    }

    protected final void setEmperorAuthority(int n) {
        this.iEmperorAuthority = n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void setEmperorID(int n) {
        if (this.iEmperorID == n || n >= this.getPrincesSize()) {
            this.iEmperorID = -1;
            return;
        }
        this.iEmperorID = n;
    }

    protected final void setNextElectionsIn(int n) {
        this.iNextElectionsIn = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void updateHRE_AfterRemoveCivilization(int n) {
        int n2 = 0;
        while (n2 < this.getPrincesSize()) {
            int n3;
            if (this.getPrince(n2) == n) {
                this.removePrince(n);
                n3 = n2 - 1;
            } else {
                n3 = n2;
                if (this.getPrince(n2) > n) {
                    List<Integer> list = this.lPrinces;
                    list.set(n2, list.get(n2) - 1);
                    n3 = n2;
                }
            }
            n2 = n3 + 1;
        }
        return;
    }
}

