/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.AI;
import age.of.civilizations2.jakowski.lukasz.BuildingsManager;
import age.of.civilizations2.jakowski.lukasz.CFG;
import age.of.civilizations2.jakowski.lukasz.Civilization;
import age.of.civilizations2.jakowski.lukasz.Game_Calendar;
import age.of.civilizations2.jakowski.lukasz.Message_HighInflation;
import age.of.civilizations2.jakowski.lukasz.Province;
import age.of.civilizations2.jakowski.lukasz.Save_Provinces_GameData;
import com.badlogic.gdx.Gdx;
import java.util.ArrayList;

class Game_NextTurnUpdate {
    protected static final int BUDGET_MAX = 200;
    protected static final float DEFENSIVE_POSITION_MILITARY_UPKEEP_PER_TUR = 0.008f;
    protected static final float EMPLOYEMENT_PER_ECONOMY = 1.025f;
    protected static final float EMPLOYEMENT_PER_ECONOMY_OLD = 1.775f;
    protected static final float INFLATION_MODIFIER = 18.12746f;
    protected static int INFLATION_PEAK_VALUE = 100;
    protected static final float INFLATION_STARTS_AT = 0.235f;
    protected static float LEAGUE_BUDGET = 1.0f;
    protected static final int PERCENTAGE_OF_INCOME_FOR_LORD_DEFAULT = 9;
    protected static final int PERCENTAGE_OF_INCOME_FOR_LORD_MAX = 20;
    protected static final int PERCENTAGE_OF_INCOME_FOR_LORD_MIN = 0;
    protected static final float PERCENTAGE_OF_INCOME_FOR_WAR_REPARATIONS = 0.08f;
    protected static final float TAXES_INFLUENCE_POP = 0.3f;
    protected static final float TAXES_INFLUENCE_PRODUCTION = 0.175f;

    Game_NextTurnUpdate() {
    }

    protected final void buildLevelsOfCities() {
        int n;
        for (n = 0; n < CFG.game.getProvincesSize(); ++n) {
            for (int i = 0; i < CFG.game.getProvince(n).getCitiesSize(); ++i) {
                CFG.game.getProvince(n).getCity(i).setCityLevel(CFG.getEditorCityLevel(4));
            }
        }
        for (n = 1; n < CFG.game.getCivsSize(); ++n) {
            this.buildLevelsOfCities(n);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void buildLevelsOfCities(int n) {
        int n2;
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < CFG.game.getCiv(n).getNumOfProvinces(); ++n3) {
            n2 = n4;
            if (n4 < CFG.game.getProvince(CFG.game.getCiv(n).getProvinceID(n3)).getPopulationData().getPopulation()) {
                n2 = CFG.game.getProvince(CFG.game.getCiv(n).getProvinceID(n3)).getPopulationData().getPopulation();
            }
            n4 = n2;
        }
        for (n2 = 0; n2 < CFG.game.getCiv(n).getNumOfProvinces(); ++n2) {
            for (n3 = 0; n3 < CFG.game.getProvince(CFG.game.getCiv(n).getProvinceID(n2)).getCitiesSize(); ++n3) {
                CFG.game.getProvince(CFG.game.getCiv(n).getProvinceID(n2)).getCity(n3).setCityLevel(CFG.getCityLevel_Population(n4, CFG.game.getProvince(CFG.game.getCiv(n).getProvinceID(n2)).getPopulationData().getPopulation(), n3));
            }
        }
        try {
            CFG.game.getProvince(CFG.game.getCiv(n).getCapitalProvinceID()).getCity(0).setCityLevel(CFG.getEditorCityLevel(0));
            return;
        }
        catch (NullPointerException nullPointerException) {
            if (!CFG.LOGS) return;
            CFG.exceptionStack(nullPointerException);
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (!CFG.LOGS) return;
            CFG.exceptionStack(indexOutOfBoundsException);
            return;
        }
    }

    protected final float getAdministrationCost_Update(int n) {
        int n2 = 0;
        float f = 0.0f;
        while (true) {
            try {
                if (n2 >= CFG.game.getCiv(n).getNumOfProvinces()) break;
                float f2 = this.getProvinceAdministration(CFG.game.getCiv(n).getProvinceID(n2), CFG.game_NextTurnUpdate.getAdministration_Capital(n));
                f += f2;
                ++n2;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (!CFG.LOGS) break;
                CFG.exceptionStack(indexOutOfBoundsException);
                break;
            }
        }
        return f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final int getAdministration_Capital(int n) {
        int n2 = 0;
        if (CFG.game.getCiv(n).getCapitalProvinceID() >= 0) return CFG.game.getCiv(n).getCapitalProvinceID();
        if (CFG.game.getCiv(n).getNumOfProvinces() <= 0) return n2;
        return CFG.game.getCiv(n).getProvinceID(0);
    }

    protected final int getBalance(int n) {
        return (int)(this.getIncome(n) - this.getExpenses(n));
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void getBalance_UpdateBudget_Prepare(int n) {
        CFG.game.getCiv((int)n).iIncomeTaxation = 0;
        CFG.game.getCiv((int)n).iIncomeProduction = 0;
        CFG.game.getCiv((int)n).iAdministrationCosts = 0;
        int n2 = this.getAdministration_Capital(n);
        float f = this.taxIncome_Modifier(n);
        int n3 = 0;
        while (true) {
            if (n3 >= CFG.game.getCiv(n).getNumOfProvinces()) {
                CFG.game.getCiv((int)n).iBudget = (int)(this.getIncome(n) - (float)CFG.game.getCiv((int)n).iAdministrationCosts);
                return;
            }
            CFG.game.getProvince((int)CFG.game.getCiv((int)n).getProvinceID((int)n3)).iIncome_Taxation = this.getProvinceIncome_Taxation(CFG.game.getCiv(n).getProvinceID(n3), n, f);
            CFG.game.getProvince((int)CFG.game.getCiv((int)n).getProvinceID((int)n3)).iIncome_Production = this.getProvinceIncome_Production(CFG.game.getCiv(n).getProvinceID(n3), n, f);
            CFG.game.getProvince((int)CFG.game.getCiv((int)n).getProvinceID((int)n3)).iAdministrationCost = Math.min(CFG.game.getProvince((int)CFG.game.getCiv((int)n).getProvinceID((int)n3)).iIncome_Taxation + CFG.game.getProvince((int)CFG.game.getCiv((int)n).getProvinceID((int)n3)).iIncome_Production, this.getProvinceAdministration(CFG.game.getCiv(n).getProvinceID(n3), n2));
            Object object = CFG.game.getCiv(n);
            ((Civilization)object).iIncomeTaxation = (int)((float)((Civilization)object).iIncomeTaxation + CFG.game.getProvince((int)CFG.game.getCiv((int)n).getProvinceID((int)n3)).iIncome_Taxation);
            object = CFG.game.getCiv(n);
            ((Civilization)object).iIncomeProduction = (int)((float)((Civilization)object).iIncomeProduction + CFG.game.getProvince((int)CFG.game.getCiv((int)n).getProvinceID((int)n3)).iIncome_Production);
            object = CFG.game.getCiv(n);
            ((Civilization)object).iAdministrationCosts = (int)((float)((Civilization)object).iAdministrationCosts + CFG.game.getProvince((int)CFG.game.getCiv((int)n).getProvinceID((int)n3)).iAdministrationCost);
            if (CFG.game.getProvince(CFG.game.getCiv(n).getProvinceID(n3)).getBalance_LastTurn() < 0) {
                object = CFG.game.getProvince((int)CFG.game.getCiv((int)n).getProvinceID((int)n3)).saveProvinceData;
                ++((Save_Provinces_GameData)object).iNumOfTurnsWithBalanceOnMinus;
            } else {
                CFG.game.getProvince((int)CFG.game.getCiv((int)n).getProvinceID((int)n3)).saveProvinceData.iNumOfTurnsWithBalanceOnMinus = 0;
            }
            ++n3;
        }
    }

    protected final float getDistanceFromAToB_PercOfMax(int n, int n2) {
        return this.getDistanceFromCapital(n, n2) / (float)CFG.map.getMapBG().getMaxDistance();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final float getDistanceFromCapital(int n, int n2) {
        block3: {
            try {
                if (!CFG.map.getMapWorldMap(CFG.map.getActiveMapID())) break block3;
                return Math.min(Math.min((float)Math.sqrt(Math.pow(CFG.game.getProvince(n2).getCenterX_Real() + CFG.map.getMapBG().getWidth_Real() - CFG.game.getProvince(n).getCenterX_Real(), 2.0) + Math.pow(CFG.game.getProvince(n2).getCenterY_Real() - CFG.game.getProvince(n).getCenterY_Real(), 2.0)), (float)Math.sqrt(Math.pow(CFG.game.getProvince(n2).getCenterX_Real() - (CFG.game.getProvince(n).getCenterX_Real() + CFG.map.getMapBG().getWidth_Real()), 2.0) + Math.pow(CFG.game.getProvince(n2).getCenterY_Real() - CFG.game.getProvince(n).getCenterY_Real(), 2.0))), (float)Math.sqrt(Math.pow(CFG.game.getProvince(n2).getCenterX_Real() - CFG.game.getProvince(n).getCenterX_Real(), 2.0) + Math.pow(CFG.game.getProvince(n2).getCenterY_Real() - CFG.game.getProvince(n).getCenterY_Real(), 2.0)));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return CFG.map.getMapBG().getMaxDistance();
            }
        }
        double d = Math.sqrt(Math.pow(CFG.game.getProvince(n2).getCenterX_Real() - CFG.game.getProvince(n).getCenterX_Real(), 2.0) + Math.pow(CFG.game.getProvince(n2).getCenterY_Real() - CFG.game.getProvince(n).getCenterY_Real(), 2.0));
        return (float)d;
    }

    protected final float getDistanceFromCapital_PercOfMax(int n, int n2) {
        return this.getDistanceFromCapital(n, n2) / (float)CFG.map.getMapBG().getMaxDistance();
    }

    protected final int getEmploymentPopulation(int n) {
        int n2 = 0;
        for (int i = 0; i < CFG.game.getCiv(n).getNumOfProvinces(); ++i) {
            int n3 = this.getProvince_EmploymentPopulation(CFG.game.getCiv(n).getProvinceID(i));
            n2 = n3 + n2;
        }
        return n2;
    }

    protected final float getExpenses(int n) {
        return (int)Math.ceil((float)CFG.game.getCiv((int)n).iAdministrationCosts + 0.0f + this.getMilitaryUpkeep_Total(n) + this.getInvestments_Total(n, CFG.game.getCiv((int)n).iBudget) + this.getGoodsSpendings(n, CFG.game.getCiv((int)n).iBudget) + this.getInterestCost(n) + this.getInflation(n) + (float)CFG.game.getCiv(n).getLoans_GoldTotalPerTurn());
    }

    protected final float getExpenses_Budget(int n) {
        return (int)Math.ceil((float)CFG.game.getCiv((int)n).iAdministrationCosts + 0.0f);
    }

    protected final float getGoodsSpendings(int n, int n2) {
        return (float)n2 * CFG.game.getCiv(n).getSpendings_Goods();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final float getHappinessChange_ByTaxation(int n) {
        float f;
        float f2 = CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)n).getIdeologyID()).ACCEPTABLE_TAXATION;
        float f3 = CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)n).getIdeologyID()).ACCEPTABLE_TAXATION * CFG.game.getCiv(n).getTechnologyLevel() / 21.73f;
        float f4 = CFG.game.getCiv(n).getTaxationLevel();
        if (CFG.game.getCiv(n).getTaxationLevel() > CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)n).getIdeologyID()).ACCEPTABLE_TAXATION) {
            f = 1.45f;
            return f * ((f2 + f3) * 100.0f - f4 * 100.0f) * 0.02675f + 0.042f;
        }
        f = 1.0f;
        return f * ((f2 + f3) * 100.0f - f4 * 100.0f) * 0.02675f + 0.042f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final float getHappinessChange_ByTaxation_Occupied(int n) {
        float f;
        float f2 = CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)n).getIdeologyID()).ACCEPTABLE_TAXATION;
        float f3 = CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)n).getIdeologyID()).ACCEPTABLE_TAXATION * CFG.game.getCiv(n).getTechnologyLevel() / 21.73f;
        float f4 = CFG.game.getCiv(n).getTaxationLevel();
        if (CFG.game.getCiv(n).getTaxationLevel() > CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)n).getIdeologyID()).ACCEPTABLE_TAXATION) {
            f = 1.45f;
            return f * ((f2 + f3) * 100.0f - f4 * 100.0f) * 0.02675f + 0.034f;
        }
        f = 1.0f;
        return f * ((f2 + f3) * 100.0f - f4 * 100.0f) * 0.02675f + 0.034f;
    }

    protected final float getIncome(int n) {
        return (int)((float)CFG.game.getCiv((int)n).iIncomeTaxation + 0.0f + (float)CFG.game.getCiv((int)n).iIncomeProduction + this.getIncome_FromVassalsOfCiv(n) + this.getIncome_Debuff_IsVassal(n) + this.getIncome_Buff_WarReparations(n) + this.getIncome_Debuff_WarReparations(n));
    }

    protected final float getIncome_Buff_WarReparations(int n) {
        float f = 0.0f;
        for (int i = CFG.game.getCiv(n).getWarReparationsGetsSize() - 1; i >= 0; --i) {
            f += this.getWarReparationsMoney(CFG.game.getCiv((int)n).getWarReparationsGets((int)i).iFromCivID);
        }
        return f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final float getIncome_Debuff_IsVassal(int n) {
        if (CFG.game.getCiv(n).getPuppetOfCivID() == n) return 0.0f;
        return -this.getIncome_Vassals(CFG.game.getCiv(n).getPuppetOfCivID(), n);
    }

    protected final float getIncome_Debuff_WarReparations(int n) {
        float f = 0.0f;
        for (int i = CFG.game.getCiv(n).getWarReparationsPaysSize() - 1; i >= 0; --i) {
            f -= this.getWarReparationsMoney(n);
        }
        return f;
    }

    protected final float getIncome_FromVassalsOfCiv(int n) {
        int n2 = CFG.game.getCiv((int)n).civGameData.lVassals.size();
        float f = 0.0f;
        --n2;
        while (n2 >= 0) {
            f += this.getIncome_Vassals(n, CFG.game.getCiv((int)n).civGameData.lVassals.get((int)n2).iCivID);
            --n2;
        }
        return f;
    }

    protected final float getIncome_TaxesLevel(int n) {
        return this.getIncome_TaxesLevel_Taxation(n) + this.getIncome_TaxesLevel_Production(n);
    }

    protected final float getIncome_TaxesLevel_Production(int n) {
        float f = 0.0f;
        for (int i = 0; i < CFG.game.getCiv(n).getNumOfProvinces(); ++i) {
            f += this.getProvinceIncome_Production(CFG.game.getCiv(n).getProvinceID(i));
        }
        return f;
    }

    protected final float getIncome_TaxesLevel_Taxation(int n) {
        float f = 0.0f;
        for (int i = 0; i < CFG.game.getCiv(n).getNumOfProvinces(); ++i) {
            f += this.getProvinceIncome_Taxation(CFG.game.getCiv(n).getProvinceID(i));
        }
        return f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final float getIncome_Vassals(int n, int n2) {
        if (CFG.game.getCiv(n2).getPuppetOfCivID() != n) return 0.0f;
        return this.getVassalizationMoney(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final float getInflation(int n) {
        float f;
        float f2 = 0.0f;
        if (CFG.game.getCiv(n).getMoney() < 0L) {
            return f2;
        }
        float f3 = f2;
        try {
            if (!((float)CFG.game.getCiv(n).getMoney() / (((float)INFLATION_PEAK_VALUE * 1.1275f + (float)(CFG.game.getCiv((int)n).iIncomeTaxation + CFG.game.getCiv((int)n).iIncomeProduction) * 0.4f) * 18.12746f) > 0.235f)) return f3;
            f3 = CFG.game.getCiv(n).getMoney();
            f = CFG.game.getCiv(n).getMoney();
            n = INFLATION_PEAK_VALUE;
        }
        catch (ArithmeticException arithmeticException) {
            return f2;
        }
        return (f / ((float)n * 18.12746f) - 0.235f) * f3 * 0.0679248f + 1.0f;
    }

    protected final float getInflationPerc(int n) {
        return Math.max(this.getInflation(n) / (float)CFG.game.getCiv(n).getMoney(), 0.0f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final float getInterestCost(int n) {
        if (CFG.game.getCiv(n).getMoney() >= 0L) return 0.0f;
        return Math.min((float)Math.abs(CFG.game.getCiv(n).getMoney()) * 0.01274f, Math.abs((float)CFG.game.getCiv((int)n).iBudget * 0.075f));
    }

    protected final float getInvestmentsSpendings(int n, int n2) {
        return (float)n2 * CFG.game.getCiv(n).getSpendings_Investments();
    }

    protected final float getInvestments_Total(int n, int n2) {
        return this.getResearchSpendings(n, n2) + this.getInvestmentsSpendings(n, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int getLevelOfCity(int n, int n2, int n3) {
        float f = (float)n2 / (float)n;
        if (f >= 0.765f) {
            n = 1;
            return CFG.getEditorCityLevel(n);
        }
        if (f >= 0.575f) {
            n = 2;
            return CFG.getEditorCityLevel(n);
        }
        if (f >= 0.325f) {
            n = 3;
            return CFG.getEditorCityLevel(n);
        }
        n = 4;
        return CFG.getEditorCityLevel(n);
    }

    protected final int getMilitarySpendings(int n, int n2) {
        return Math.max(0, (int)(this.getMilitaryUpkeep_Total(n) / (float)n2 * 100.0f));
    }

    protected final float getMilitaryUpkeep(int n, int n2) {
        return this.getMilitaryUpkeep(n, CFG.game.getProvince(n).getArmyCivID(n2), n2);
    }

    protected final float getMilitaryUpkeep(int n, int n2, int n3) {
        return (float)Math.pow((float)n2 * CFG.gameAges.getAge_MilitaryUpkeep(Game_Calendar.CURRENT_AGEID), 1.03f - CFG.game.getProvince(n).getDevelopmentLevel() * 0.1275f - CFG.game.getCiv(n3).getTechnologyLevel() * 0.10479f) * (CFG.terrainTypesManager.getMilitaryUpkeep(CFG.game.getProvince(n).getTerrainTypeID()) + 1.0f) * CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)n3).getIdeologyID()).MILITARY_UPKEEP * CFG.gameAges.getAge_TreasuryModifier_MilitaryUpkeep(Game_Calendar.CURRENT_AGEID) * ((float)CFG.game.getCiv(n3).getNumOfProvinces() / (float)CFG.game.getProvincesSize() * 0.425f + 1.0f + CFG.game.getCiv(n3).getWarWeariness() + CFG.game.getCiv(n3).getModifier_MilitaryUpkeep() - BuildingsManager.getSupply_Bonus(CFG.game.getProvince(n).getLevelOfSupply())) * Game_Calendar.GAME_SPEED * (1.0f - this.getMilitaryUpkeep_DefensivePosition(n));
    }

    protected final float getMilitaryUpkeep_DefensivePosition(int n) {
        return (float)CFG.game.getProvince(n).getDefensivePosition() * 0.008f;
    }

    protected final float getMilitaryUpkeep_Total(int n) {
        float f;
        int n2;
        int n3 = 0;
        float f2 = 0.0f;
        for (n2 = 0; n2 < CFG.game.getCiv(n).getNumOfProvinces(); ++n2) {
            f2 += this.getMilitaryUpkeep(CFG.game.getCiv(n).getProvinceID(n2), n);
        }
        for (n2 = 0; n2 < CFG.game.getCiv(n).getArmyInAnotherProvinceSize(); ++n2) {
            f2 += this.getMilitaryUpkeep(CFG.game.getCiv(n).getArmyInAnotherProvince(n2), n);
        }
        int n4 = 0;
        while (true) {
            f = f2;
            if (n4 >= CFG.game.getCiv(n).getMoveUnitsSize()) break;
            f2 += this.getMilitaryUpkeep(CFG.game.getCiv(n).getMoveUnits(n4).getFromProvinceID(), CFG.game.getCiv(n).getMoveUnits(n4).getNumOfUnits(), n);
            ++n4;
        }
        for (n2 = n3; n2 < CFG.game.getCiv(n).getMoveUnitsPlunderSize(); ++n2) {
            f += this.getMilitaryUpkeep(CFG.game.getCiv(n).getMoveUnits_Plunder(n2).getFromProvinceID(), CFG.game.getCiv(n).getMoveUnits_Plunder(n2).getNumOfUnits(), n);
        }
        return (int)Math.ceil(f);
    }

    protected final float getMilitaryUpkeep_WithAllRecruitmentsInProcess(int n, int n2, int n3) {
        int n4 = 0;
        for (int i = 0; i < CFG.game.getCiv(n3).getRecruitArmySize(); ++i) {
            int n5 = n4;
            if (CFG.game.getCiv(n3).getRecruitArmy(i).getProvinceID() != n) {
                n5 = (int)((float)n4 + this.getMilitaryUpkeep(CFG.game.getCiv(n3).getRecruitArmy(i).getProvinceID(), CFG.game.getCiv(n3).getRecruitArmy(i).getArmy(), n3));
            }
            n4 = n5;
        }
        return (float)n4 + this.getMilitaryUpkeep(n, n2, n3);
    }

    protected final float getMilitaryUpkeep_WithAllRecruitmentsInProcess_Disband(int n, int n2, int n3) {
        int n4 = 0;
        for (int i = 0; i < CFG.game.getCiv(n3).getRecruitArmySize(); ++i) {
            int n5 = n4;
            if (CFG.game.getCiv(n3).getRecruitArmy(i).getProvinceID() != n) {
                n5 = (int)((float)n4 + this.getMilitaryUpkeep(CFG.game.getCiv(n3).getRecruitArmy(i).getProvinceID(), CFG.game.getCiv(n3).getRecruitArmy(i).getArmy(), n3));
            }
            n4 = n5;
        }
        return (float)n4 - this.getMilitaryUpkeep(n, n2, n3);
    }

    protected final float getMilitaryUpkeep_WithoutDefensivePosition(int n, int n2, int n3) {
        return (float)Math.pow((float)n2 * CFG.gameAges.getAge_MilitaryUpkeep(Game_Calendar.CURRENT_AGEID), 1.03f - CFG.game.getProvince(n).getDevelopmentLevel() * 0.1275f - CFG.game.getCiv(n3).getTechnologyLevel() * 0.10479f) * (CFG.terrainTypesManager.getMilitaryUpkeep(CFG.game.getProvince(n).getTerrainTypeID()) + 1.0f) * CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)n3).getIdeologyID()).MILITARY_UPKEEP * CFG.gameAges.getAge_TreasuryModifier_MilitaryUpkeep(Game_Calendar.CURRENT_AGEID) * ((float)CFG.game.getCiv(n3).getNumOfProvinces() / (float)CFG.game.getProvincesSize() * 0.425f + 1.0f + CFG.game.getCiv(n3).getWarWeariness() + CFG.game.getCiv(n3).getModifier_MilitaryUpkeep() - BuildingsManager.getSupply_Bonus(CFG.game.getProvince(n).getLevelOfSupply())) * Game_Calendar.GAME_SPEED;
    }

    protected final float getProvinceAdministration(int n, int n2) {
        float f = CFG.game.getProvince(n).getEconomy();
        float f2 = (float)CFG.game.getProvince(n).getEconomy() / (float)CFG.game.getProvince(n).getPopulationData().getPopulation();
        float f3 = 1.0f;
        float f4 = (float)Math.pow(f * Math.min(1.0f, f2) * 0.003248f + (float)CFG.game.getProvince(n).getPopulationData().getPopulation() * (CFG.game.getProvince(n).getDevelopmentLevel() * 7.25E-4f + 0.0024f), 0.93478);
        float f5 = this.getDistanceFromCapital_PercOfMax(n2, n) / (CFG.game.getProvince(n).getProvinceStability() / 8.0f + 1.5275f);
        float f6 = CFG.gameAges.getAge_AdministrationCost_Distance(Game_Calendar.CURRENT_AGEID);
        float f7 = CFG.game.getProvince(n).getHappiness();
        float f8 = CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)CFG.game.getProvince((int)n).getCivID()).getIdeologyID()).ADMINISTRATION_COST_DISTANCE;
        float f9 = CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getTaxationLevel();
        f2 = CFG.game.getProvince(n).getProvinceStability();
        float f10 = CFG.gameAges.getAge_TreasuryModifier_Administration(Game_Calendar.CURRENT_AGEID);
        float f11 = CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)CFG.game.getProvince((int)n).getCivID()).getIdeologyID()).ADMINISTRATION_COST;
        f = CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getModifier_Administation();
        if (n == n2) {
            f3 = CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)CFG.game.getProvince((int)n).getCivID()).getIdeologyID()).ADMINISTRATION_COST_CAPITAL;
        }
        return f3 * (f4 * ((f5 * f6 + 0.13468f - 0.13468f * f7) * f8 + 1.0f) * (0.0715f * f9 + 0.9325f + (1.0f - f2) * 0.0325f) * f10 * (f11 + f)) * Game_Calendar.GAME_SPEED;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final float getProvinceIncomeAndExpenses_Total(int n) {
        float f;
        float f2 = this.getProvinceIncome_Taxation(n);
        float f3 = this.getProvinceIncome_Production(n);
        if (CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getCapitalProvinceID() >= 0) {
            f = this.getProvinceAdministration(n, CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getCapitalProvinceID());
            return f2 + f3 - f;
        }
        f = 0.0f;
        return f2 + f3 - f;
    }

    protected final float getProvinceIncome_Production(int n) {
        return this.getProvinceIncome_Production(n, CFG.game.getProvince(n).getCivID(), this.taxIncome_Modifier(CFG.game.getProvince(n).getCivID()));
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final float getProvinceIncome_Production(int n, int n2, float f) {
        boolean bl = CFG.game.getProvince(n).isOccupied();
        float f2 = 0.2f;
        if (bl) {
            float f3 = (int)Math.min((float)CFG.game.getProvince(n).getPopulationData().getPopulation() * (CFG.game.getProvince(n).getDevelopmentLevel() * 0.1725f + 1.025f + CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getTechnologyLevel() * 0.0425f), (float)CFG.game.getProvince(n).getEconomy());
            float f4 = CFG.gameAges.getAge_IncomeProduction_Base(Game_Calendar.CURRENT_AGEID);
            float f5 = CFG.gameAges.getAge_IncomeProduction_PerDevelopment(Game_Calendar.CURRENT_AGEID);
            float f6 = CFG.game.getProvince(n).getDevelopmentLevel();
            float f7 = CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getTechnologyLevel();
            float f8 = CFG.game.getProvince(n).getDevelopmentLevel();
            float f9 = CFG.game.getProvince(n).getProvinceStability();
            float f10 = CFG.gameAges.getAge_TreasuryModifier_Production(Game_Calendar.CURRENT_AGEID);
            float f11 = CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)CFG.game.getProvince((int)n).getCivID()).getIdeologyID()).INCOME_PRODUCTION;
            float f12 = BuildingsManager.getPort_IncomeProduction(CFG.game.getProvince(n).getLevelOfPort());
            float f13 = CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getModifier_IncomeProduction();
            if (!CFG.game.getProvince(n).getIsCapital()) {
                f2 = 0.0f;
            }
            float f14 = BuildingsManager.getWorkshop_IncomeProduction(CFG.game.getProvince(n).getLevelOfWorkshop());
            float f15 = CFG.game.getCiv(n2).getTaxationLevel();
            f2 = Game_Calendar.GAME_SPEED * ((f2 + (f11 + f12 + f13) + f14) * (f3 * (f4 + f5 * f6) * (0.575f * f7 + 0.0685f + 0.8625f * f8) * (0.575f * f9 + 0.425f) * f10) * (f15 * 0.175f + 0.825f) * f);
            f = 0.1f;
            return f * f2;
        }
        float f16 = (int)Math.min((float)CFG.game.getProvince(n).getPopulationData().getPopulation() * (CFG.game.getProvince(n).getDevelopmentLevel() * 0.1725f + 1.025f + CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getTechnologyLevel() * 0.0425f), (float)CFG.game.getProvince(n).getEconomy());
        float f17 = CFG.gameAges.getAge_IncomeProduction_Base(Game_Calendar.CURRENT_AGEID);
        float f18 = CFG.gameAges.getAge_IncomeProduction_PerDevelopment(Game_Calendar.CURRENT_AGEID);
        float f19 = CFG.game.getProvince(n).getDevelopmentLevel();
        float f20 = CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getTechnologyLevel();
        float f21 = CFG.game.getProvince(n).getDevelopmentLevel();
        float f22 = CFG.game.getProvince(n).getProvinceStability();
        float f23 = CFG.gameAges.getAge_TreasuryModifier_Production(Game_Calendar.CURRENT_AGEID);
        float f24 = CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)CFG.game.getProvince((int)n).getCivID()).getIdeologyID()).INCOME_PRODUCTION;
        float f25 = BuildingsManager.getPort_IncomeProduction(CFG.game.getProvince(n).getLevelOfPort());
        float f26 = CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getModifier_IncomeProduction();
        if (!CFG.game.getProvince(n).getIsCapital()) {
            f2 = 0.0f;
        }
        f2 = (f2 + (f24 + f25 + f26) + BuildingsManager.getWorkshop_IncomeProduction(CFG.game.getProvince(n).getLevelOfWorkshop())) * (f16 * (f17 + f18 * f19) * (0.575f * f20 + 0.0685f + 0.8625f * f21) * (0.575f * f22 + 0.425f) * f23) * (CFG.game.getCiv(n2).getTaxationLevel() * 0.175f + 0.825f) * f;
        f = Game_Calendar.GAME_SPEED;
        return f * f2;
    }

    protected final float getProvinceIncome_Taxation(int n) {
        return this.getProvinceIncome_Taxation(n, CFG.game.getProvince(n).getCivID(), this.taxIncome_Modifier(CFG.game.getProvince(n).getCivID()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final float getProvinceIncome_Taxation(int n, int n2, float f) {
        float f2;
        if (CFG.game.getProvince(n).isOccupied()) {
            return this.getProvinceAdministration(n, CFG.game_NextTurnUpdate.getAdministration_Capital(n2));
        }
        float f3 = (float)(Math.pow((float)this.getProvince_EmploymentPopulation(n) * (CFG.gameAges.getAge_IncomeTaxation_Base(Game_Calendar.CURRENT_AGEID) + CFG.gameAges.getAge_IncomeTaxation_PerTechnology(Game_Calendar.CURRENT_AGEID) * CFG.game.getCiv(n2).getTechnologyLevel() * 21.923813f), 0.8386) + Math.pow((float)this.getProvince_UnemploymentPopulation(n) * (CFG.gameAges.getAge_IncomeTaxation_Base(Game_Calendar.CURRENT_AGEID) + CFG.gameAges.getAge_IncomeTaxation_PerTechnology(Game_Calendar.CURRENT_AGEID) * CFG.game.getCiv(n2).getTechnologyLevel() * 21.923813f), 0.7936));
        float f4 = CFG.gameAges.getAge_TreasuryModifier(Game_Calendar.CURRENT_AGEID);
        float f5 = CFG.game.getProvince(n).getProvinceStability();
        float f6 = CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)n2).getIdeologyID()).INCOME_TAXATION;
        float f7 = CFG.game.getCiv(n2).getModifier_IncomeTaxation();
        if (CFG.game.getProvince(n).getIsCapital()) {
            f2 = 0.1f;
            return (f2 + (f6 + f7) - 0.16584f + CFG.game.getProvince(n).getHappiness() * 0.3674786f) * (f3 * f4 * (0.325f * f5 + 0.675f)) * (CFG.game.getCiv(n2).getTaxationLevel() * 0.3f + 0.7f) * f * Game_Calendar.GAME_SPEED;
        }
        f2 = 0.0f;
        return (f2 + (f6 + f7) - 0.16584f + CFG.game.getProvince(n).getHappiness() * 0.3674786f) * (f3 * f4 * (0.325f * f5 + 0.675f)) * (CFG.game.getCiv(n2).getTaxationLevel() * 0.3f + 0.7f) * f * Game_Calendar.GAME_SPEED;
    }

    protected final int getProvince_EmploymentPopulation(int n) {
        return (int)Math.min((float)CFG.game.getProvince(n).getPopulationData().getPopulation(), (float)CFG.game.getProvince(n).getEconomy() * (CFG.game.getProvince(n).getDevelopmentLevel() * 0.1725f + 1.775f + CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getTechnologyLevel() * 0.0925f));
    }

    protected final int getProvince_UnemploymentPopulation(int n) {
        return Math.max(CFG.game.getProvince(n).getPopulationData().getPopulation() - this.getProvince_EmploymentPopulation(n), 0);
    }

    protected final float getResearchSpendings(int n, int n2) {
        return (float)n2 * CFG.game.getCiv(n).getSpendings_Research();
    }

    protected final int getUnemploymentPopulation(int n) {
        int n2 = 0;
        for (int i = 0; i < CFG.game.getCiv(n).getNumOfProvinces(); ++i) {
            n2 += this.getProvince_UnemploymentPopulation(CFG.game.getCiv(n).getProvinceID(i));
        }
        return n2;
    }

    protected final float getVassalizationMoney(int n) {
        return (float)CFG.game.getCiv((int)n).iIncomeTaxation * ((float)CFG.game.getCiv(CFG.game.getCiv(n).getPuppetOfCivID()).getVassal_Tribute(n) / 100.0f);
    }

    protected final float getWarReparationsMoney(int n) {
        return (float)CFG.game.getCiv((int)n).iIncomeTaxation * 0.5f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected float taxIncome_Modifier(int n) {
        float f = 1.025f;
        if (CFG.game.getCiv(n).getControlledByPlayer()) {
            n = CFG.DIFFICULTY;
            if (n == 0) return 1.25f;
            if (n == 2) return 1.0f;
            if (n == 3) return 0.975f;
            if (n == 4) return 0.95f;
            return f;
        }
        n = CFG.DIFFICULTY;
        if (n == 0) return 0.925f;
        if (n == 2) return f;
        if (n == 3) return 1.04f;
        if (n == 4) return 1.065f;
        return 1.0f;
    }

    protected final void updateCities() {
        for (int i = 1; i < CFG.game.getCivsSize(); ++i) {
            this.updateCities(i);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void updateCities(int n) {
        int n2;
        int n3;
        int n4 = (int)Math.ceil((float)(CFG.game.getCiv(n).getNumOfProvinces() * CFG.settingsManager.PERCETANGE_OF_CITIES_ON_MAP) / 100.0f);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n5 = 1;
        for (n3 = 0; n3 < CFG.game.getCiv(n).getNumOfProvinces(); ++n3) {
            arrayList.add(CFG.game.getCiv(n).getProvinceID(n3));
            Province province = CFG.game.getProvince(CFG.game.getCiv(n).getProvinceID(n3));
            boolean bl = CFG.game.getProvince(CFG.game.getCiv(n).getProvinceID(n3)).getLevelOfPort() > 0 || CFG.game.getProvince(CFG.game.getCiv(n).getProvinceID(n3)).getLevelOfArmoury() > 0;
            province.setDrawCities(bl);
            n2 = n5;
            if (!CFG.game.getProvince(CFG.game.getCiv(n).getProvinceID(n3)).isOccupied()) {
                n2 = n5;
                if (n5 < CFG.game.getProvince(CFG.game.getCiv(n).getProvinceID(n3)).getPopulationData().getPopulation()) {
                    n2 = CFG.game.getProvince(CFG.game.getCiv(n).getProvinceID(n3)).getPopulationData().getPopulation();
                }
            }
            n5 = n2;
        }
        for (n2 = 0; n2 < CFG.game.getCiv(n).getNumOfProvinces(); ++n2) {
            for (n3 = 0; n3 < CFG.game.getProvince(CFG.game.getCiv(n).getProvinceID(n2)).getCitiesSize(); ++n3) {
                if (CFG.game.getProvince(CFG.game.getCiv(n).getProvinceID(n2)).getCity(n3).getCityLevel() == CFG.getEditorCityLevel(0)) continue;
                CFG.game.getProvince(CFG.game.getCiv(n).getProvinceID(n2)).getCity(n3).setCityLevel(this.getLevelOfCity(n5, CFG.game.getProvince(CFG.game.getCiv(n).getProvinceID(n2)).getPopulationData().getPopulation(), n3));
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = CFG.game.getProvince((Integer)arrayList.get(0)).getPopulationData().getPopulation();
            int n7 = arrayList.size();
            n2 = 0;
            for (n5 = 1; n5 < n7; ++n5) {
                if (n6 >= CFG.game.getProvince((Integer)arrayList.get(n5)).getPopulationData().getPopulation()) continue;
                n6 = CFG.game.getProvince((Integer)arrayList.get(n5)).getPopulationData().getPopulation();
                n2 = n5;
            }
            CFG.game.getProvince((Integer)arrayList.get(n2)).setDrawCities(true);
            arrayList.remove(n2);
        }
        if (CFG.game.getCiv(n).getCapitalProvinceID() >= 0) {
            CFG.game.getProvince(CFG.game.getCiv(n).getCapitalProvinceID()).setDrawCities(true);
        }
        arrayList.clear();
    }

    protected final void updateCivs_Money() {
        int n;
        int n2 = 1;
        Gdx.app.log("AoC", "updateCivs_Money 0000");
        for (n = 1; n < CFG.game.getCivsSize(); ++n) {
            this.getBalance_UpdateBudget_Prepare(n);
        }
        Gdx.app.log("AoC", "updateCivs_Money 11111");
        for (n = n2; n < CFG.game.getCivsSize(); ++n) {
            if (CFG.game.getCiv(n).getNumOfProvinces() <= 0) continue;
            CFG.game.getCiv(n).setMoney(CFG.game.getCiv(n).getMoney() + (long)this.getBalance(n));
            CFG.game.getCiv(n).updateLoansNextTurn();
        }
        Gdx.app.log("AoC", "updateCivs_Money END");
    }

    protected final void updateInflationPeakValue() {
        int n;
        int n2 = 1;
        INFLATION_PEAK_VALUE = 1;
        for (n = 1; n < CFG.game.getCivsSize(); ++n) {
            if (CFG.game.getCiv(n).getNumOfProvinces() <= 0) continue;
            INFLATION_PEAK_VALUE = Math.max(INFLATION_PEAK_VALUE, CFG.game.getCiv((int)n).iIncomeTaxation + CFG.game.getCiv((int)n).iIncomeProduction);
            LEAGUE_BUDGET = (int)Math.max(LEAGUE_BUDGET, (float)(CFG.game.getCiv((int)n).iIncomeTaxation + CFG.game.getCiv((int)n).iIncomeProduction - CFG.game.getCiv((int)n).iAdministrationCosts));
        }
        LEAGUE_BUDGET = (int)(LEAGUE_BUDGET * 0.9f);
        for (n = n2; n < CFG.game.getCivsSize(); ++n) {
            if (CFG.game.getCiv(n).getNumOfProvinces() <= 0) continue;
            CFG.game.getCiv((int)n).iLeague = Math.min((int)((float)Math.max(CFG.game.getCiv((int)n).iIncomeTaxation + CFG.game.getCiv((int)n).iIncomeProduction - CFG.game.getCiv((int)n).iAdministrationCosts, 0) / LEAGUE_BUDGET * 10.0f), 10);
        }
        for (n = 0; n < CFG.game.getPlayersSize(); ++n) {
            if (!(this.getInflationPerc(CFG.game.getPlayer(n).getCivID()) > 0.0049f)) continue;
            CFG.game.getCiv((int)CFG.game.getPlayer((int)n).getCivID()).getCivilization_Diplomacy_GameData().messageBox.addMessage(new Message_HighInflation(CFG.game.getPlayer(n).getCivID(), 0));
        }
    }

    protected final void updatePlayableProvinces() {
        AI aI;
        int n;
        CFG.oAI.PLAYABLE_PROVINCES = 0;
        for (n = 0; n < CFG.game.getProvincesSize(); ++n) {
            if (CFG.game.getProvince(n).getSeaProvince() || CFG.game.getProvince(n).getWasteland() >= 0) continue;
            aI = CFG.oAI;
            ++aI.PLAYABLE_PROVINCES;
        }
        CFG.oAI.NUM_OF_CIVS_IN_THE_GAME = 0;
        for (n = 1; n < CFG.game.getCivsSize(); ++n) {
            if (CFG.game.getCiv(n).getNumOfProvinces() <= 0) continue;
            aI = CFG.oAI;
            ++aI.NUM_OF_CIVS_IN_THE_GAME;
        }
        CFG.oAI.NUM_OF_CIVS_IN_THE_GAME = Math.max(1, CFG.oAI.NUM_OF_CIVS_IN_THE_GAME);
        CFG.oAI.updateMinRivals();
    }

    /*
     * Unable to fully structure code
     */
    protected final void updateProvinceStability() {
        var3_1 = 1;
        for (var1_2 = 1; var1_2 < CFG.game.getCivsSize(); ++var1_2) {
            CFG.game.getCiv((int)var1_2).lProvincesWithLowStability.clear();
            CFG.game.getCiv((int)var1_2).fStability = 0.0f;
        }
        var2_3 = 0;
        while (true) {
            var1_2 = var3_1;
            if (var2_3 >= CFG.game.getProvincesSize()) ** GOTO lbl19
            if (!CFG.game.getProvince(var2_3).getSeaProvince() && CFG.game.getProvince(var2_3).getWasteland() < 0) {
                CFG.game.getProvince(var2_3).updateProvinceStability();
                if (CFG.game.getProvince(var2_3).getCivID() > 0) {
                    var4_4 = CFG.game.getCiv(CFG.game.getProvince(var2_3).getCivID());
                    var4_4.fStability += CFG.game.getProvince(var2_3).getProvinceStability();
                }
            }
            ++var2_3;
        }
        {
            CFG.game.getCiv(var1_2).setStability(CFG.game.getCiv((int)var1_2).fStability / (float)CFG.game.getCiv(var1_2).getNumOfProvinces());
            ++var1_2;
lbl19:
            // 2 sources

            if (var1_2 >= CFG.game.getCivsSize()) break;
            var2_3 = CFG.game.getCiv((int)var1_2).lProvincesWithLowStability.size() - 1;
            while (true) {
                if (var2_3 < 0) continue block2;
                if (CFG.game.getCiv(var1_2).isAssimilateOrganized(CFG.game.getCiv((int)var1_2).lProvincesWithLowStability.get(var2_3))) {
                    CFG.game.getCiv((int)var1_2).lProvincesWithLowStability.remove(var2_3);
                }
                --var2_3;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void updateSpendingsOfCiv(int n, int n2) {
        block10: {
            block9: {
                if (CFG.game.getCiv(n).getCapitalProvinceID() < 0 || CFG.game.getCiv(n).getNumOfProvinces() <= 0) break block9;
                if (CFG.game.getCiv(n).getMoney() < -500L) {
                    CFG.game.getCiv(n).setSpendings_Research(0.0f);
                }
                if (n2 <= 0) {
                    CFG.game.getCiv(n).setSpendings_Goods(0.0f);
                    CFG.game.getCiv(n).setSpendings_Research(0.0f);
                    CFG.game.getCiv(n).setSpendings_Investments(0.0f);
                }
                n2 = this.getMilitarySpendings(n, n2);
                if ((int)(CFG.game.getCiv(n).getSpendings_Goods() * 100.0f) + n2 > 200) {
                    CFG.game.getCiv(n).setSpendings_Goods((float)(200 - n2) / 100.0f);
                }
                if ((int)(CFG.game.getCiv(n).getSpendings_Research() * 100.0f) + (n2 += (int)(CFG.game.getCiv(n).getSpendings_Goods() * 100.0f)) + (int)(CFG.game.getCiv(n).getSpendings_Investments() * 100.0f) <= 200) break block9;
                if (n2 <= 200) break block10;
                CFG.game.getCiv(n).setSpendings_Research(0.0f);
                CFG.game.getCiv(n).setSpendings_Investments(0.0f);
            }
            return;
        }
        int n3 = n2 + ((int)(CFG.game.getCiv(n).getSpendings_Research() * 100.0f) + (int)(CFG.game.getCiv(n).getSpendings_Investments() * 100.0f)) - 200;
        n2 = (int)(CFG.game.getCiv(n).getSpendings_Research() * 100.0f);
        CFG.game.getCiv(n).setSpendings_Research(CFG.game.getCiv(n).getSpendings_Research() - (float)n3 / 2.0f / 100.0f);
        n2 = n3 - (int)((float)n2 - CFG.game.getCiv(n).getSpendings_Research() * 100.0f);
        float f = n2;
        if (f < CFG.game.getCiv(n).getSpendings_Investments() * 100.0f) {
            CFG.game.getCiv(n).setSpendings_Investments(CFG.game.getCiv(n).getSpendings_Investments() - f / 100.0f);
            return;
        }
        n3 = (int)(CFG.game.getCiv(n).getSpendings_Investments() * 100.0f);
        CFG.game.getCiv(n).setSpendings_Investments(0.0f);
        CFG.game.getCiv(n).setSpendings_Research(CFG.game.getCiv(n).getSpendings_Research() - (float)(n2 - n3) / 100.0f);
    }
}

