/*
 * Decompiled with CFR 0.152.
 */
package com.codedisaster.steamworks;

import com.codedisaster.steamworks.SteamEncryptedAppTicketNative;
import com.codedisaster.steamworks.SteamException;
import com.codedisaster.steamworks.SteamID;
import com.codedisaster.steamworks.SteamInterface;
import com.codedisaster.steamworks.SteamSharedLibraryLoader;
import java.nio.ByteBuffer;

public class SteamEncryptedAppTicket
extends SteamInterface {
    public static final int SymmetricKeyLen = 32;

    public static void loadLibraries() throws SteamException {
        SteamEncryptedAppTicket.loadLibraries(null);
    }

    public static void loadLibraries(String libraryPath) throws SteamException {
        if (libraryPath == null && SteamSharedLibraryLoader.DEBUG) {
            String sdkPath = SteamSharedLibraryLoader.getSdkLibraryPath();
            SteamSharedLibraryLoader.loadLibrary("sdkencryptedappticket", sdkPath);
        } else {
            SteamSharedLibraryLoader.loadLibrary("sdkencryptedappticket", libraryPath);
        }
        SteamSharedLibraryLoader.loadLibrary("steamworks4j-encryptedappticket", libraryPath);
    }

    public SteamEncryptedAppTicket() {
        super(-1L);
    }

    public boolean decryptTicket(ByteBuffer ticketEncrypted, ByteBuffer ticketDecrypted, byte[] key, int[] ticketDecryptedOutputSize) throws SteamException {
        this.checkBuffer(ticketEncrypted);
        this.checkBuffer(ticketDecrypted);
        this.checkArray(key, 32);
        return SteamEncryptedAppTicketNative.decryptTicket(ticketEncrypted, ticketEncrypted.position(), ticketEncrypted.remaining(), ticketDecrypted, ticketDecrypted.position(), ticketDecrypted.remaining(), key, 32, ticketDecryptedOutputSize);
    }

    public boolean isTicketForApp(ByteBuffer ticketDecrypted, int appID) throws SteamException {
        this.checkBuffer(ticketDecrypted);
        return SteamEncryptedAppTicketNative.isTicketForApp(ticketDecrypted, ticketDecrypted.position(), ticketDecrypted.remaining(), appID);
    }

    public int getTicketIssueTime(ByteBuffer ticketDecrypted) throws SteamException {
        this.checkBuffer(ticketDecrypted);
        return SteamEncryptedAppTicketNative.getTicketIssueTime(ticketDecrypted, ticketDecrypted.position(), ticketDecrypted.remaining());
    }

    public SteamID getTicketSteamID(ByteBuffer ticketDecrypted) throws SteamException {
        this.checkBuffer(ticketDecrypted);
        return new SteamID(SteamEncryptedAppTicketNative.getTicketSteamID(ticketDecrypted, ticketDecrypted.position(), ticketDecrypted.remaining()));
    }

    public int getTicketAppID(ByteBuffer ticketDecrypted) throws SteamException {
        this.checkBuffer(ticketDecrypted);
        return SteamEncryptedAppTicketNative.getTicketAppID(ticketDecrypted, ticketDecrypted.position(), ticketDecrypted.remaining());
    }

    public boolean userOwnsAppInTicket(ByteBuffer ticketDecrypted, int appID) throws SteamException {
        this.checkBuffer(ticketDecrypted);
        return SteamEncryptedAppTicketNative.userOwnsAppInTicket(ticketDecrypted, ticketDecrypted.position(), ticketDecrypted.remaining(), appID);
    }

    public boolean userIsVacBanned(ByteBuffer ticketDecrypted) throws SteamException {
        this.checkBuffer(ticketDecrypted);
        return SteamEncryptedAppTicketNative.userIsVacBanned(ticketDecrypted, ticketDecrypted.position(), ticketDecrypted.remaining());
    }

    public int getUserVariableData(ByteBuffer ticketDecrypted, ByteBuffer userData) throws SteamException {
        this.checkBuffer(ticketDecrypted);
        this.checkBuffer(userData);
        return SteamEncryptedAppTicketNative.getUserVariableData(ticketDecrypted, ticketDecrypted.position(), ticketDecrypted.remaining(), userData, userData.position(), userData.remaining());
    }
}

