/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.viewport;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Scaling;
import com.badlogic.gdx.utils.viewport.Viewport;

public class ExtendViewport
extends Viewport {
    private float maxWorldHeight;
    private float maxWorldWidth;
    private float minWorldHeight;
    private float minWorldWidth;

    public ExtendViewport(float f, float f2) {
        this(f, f2, 0.0f, 0.0f, new OrthographicCamera());
    }

    public ExtendViewport(float f, float f2, float f3, float f4) {
        this(f, f2, f3, f4, new OrthographicCamera());
    }

    public ExtendViewport(float f, float f2, float f3, float f4, Camera camera) {
        this.minWorldWidth = f;
        this.minWorldHeight = f2;
        this.maxWorldWidth = f3;
        this.maxWorldHeight = f4;
        this.setCamera(camera);
    }

    public ExtendViewport(float f, float f2, Camera camera) {
        this(f, f2, 0.0f, 0.0f, camera);
    }

    public float getMaxWorldHeight() {
        return this.maxWorldHeight;
    }

    public float getMaxWorldWidth() {
        return this.maxWorldWidth;
    }

    public float getMinWorldHeight() {
        return this.minWorldHeight;
    }

    public float getMinWorldWidth() {
        return this.minWorldWidth;
    }

    public void setMaxWorldHeight(float f) {
        this.maxWorldHeight = f;
    }

    public void setMaxWorldWidth(float f) {
        this.maxWorldWidth = f;
    }

    public void setMinWorldHeight(float f) {
        this.minWorldHeight = f;
    }

    public void setMinWorldWidth(float f) {
        this.minWorldWidth = f;
    }

    @Override
    public void update(int n, int n2, boolean bl) {
        int n3;
        int n4;
        float f;
        float f2;
        float f3 = this.minWorldWidth;
        float f4 = this.minWorldHeight;
        Vector2 vector2 = Scaling.fit.apply(f3, f4, n, n2);
        int n5 = Math.round(vector2.x);
        int n6 = Math.round(vector2.y);
        if (n5 < n) {
            f2 = n6;
            float f5 = f2 / f4;
            f2 = f4 / f2;
            f = (float)(n - n5) * f2;
            float f6 = this.maxWorldWidth;
            f2 = f;
            if (f6 > 0.0f) {
                f2 = Math.min(f, f6 - this.minWorldWidth);
            }
            f = f3 + f2;
            n4 = n5 + Math.round(f2 * f5);
            f2 = f4;
            n3 = n6;
        } else {
            f = f3;
            f2 = f4;
            n3 = n6;
            n4 = n5;
            if (n6 < n2) {
                f2 = n5;
                float f7 = f2 / f3;
                f2 = f3 / f2;
                f = (float)(n2 - n6) * f2;
                float f8 = this.maxWorldHeight;
                f2 = f;
                if (f8 > 0.0f) {
                    f2 = Math.min(f, f8 - this.minWorldHeight);
                }
                f = f4 + f2;
                n3 = n6 + Math.round(f2 * f7);
                n4 = n5;
                f2 = f;
                f = f3;
            }
        }
        this.setWorldSize(f, f2);
        this.setScreenBounds((n - n4) / 2, (n2 - n3) / 2, n4, n3);
        this.apply(bl);
    }
}

