/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.reflect;

import com.badlogic.gdx.utils.reflect.Annotation;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;

public final class Method {
    private final java.lang.reflect.Method method;

    Method(java.lang.reflect.Method method) {
        this.method = method;
    }

    public Annotation getDeclaredAnnotation(Class<? extends java.lang.annotation.Annotation> clazz) {
        java.lang.annotation.Annotation[] annotationArray = this.method.getDeclaredAnnotations();
        if (annotationArray == null) {
            return null;
        }
        for (java.lang.annotation.Annotation annotation : annotationArray) {
            if (!annotation.annotationType().equals(clazz)) continue;
            return new Annotation(annotation);
        }
        return null;
    }

    public Annotation[] getDeclaredAnnotations() {
        java.lang.annotation.Annotation[] annotationArray = this.method.getDeclaredAnnotations();
        Annotation[] annotationArray2 = new Annotation[annotationArray.length];
        for (int i = 0; i < annotationArray.length; ++i) {
            annotationArray2[i] = new Annotation(annotationArray[i]);
        }
        return annotationArray2;
    }

    public Class getDeclaringClass() {
        return this.method.getDeclaringClass();
    }

    public String getName() {
        return this.method.getName();
    }

    public Class[] getParameterTypes() {
        return this.method.getParameterTypes();
    }

    public Class getReturnType() {
        return this.method.getReturnType();
    }

    public Object invoke(Object object, Object ... object2) throws ReflectionException {
        try {
            object = this.method.invoke(object, (Object[])object2);
            return object;
        }
        catch (InvocationTargetException invocationTargetException) {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Exception occurred in method: ");
            ((StringBuilder)object2).append(this.getName());
            throw new ReflectionException(((StringBuilder)object2).toString(), invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Illegal access to method: ");
            ((StringBuilder)object2).append(this.getName());
            throw new ReflectionException(((StringBuilder)object2).toString(), illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Illegal argument(s) supplied to method: ");
            ((StringBuilder)object).append(this.getName());
            throw new ReflectionException(((StringBuilder)object).toString(), illegalArgumentException);
        }
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.method.getModifiers());
    }

    public boolean isAccessible() {
        return this.method.isAccessible();
    }

    public boolean isAnnotationPresent(Class<? extends java.lang.annotation.Annotation> clazz) {
        return this.method.isAnnotationPresent(clazz);
    }

    public boolean isDefaultAccess() {
        boolean bl = !this.isPrivate() && !this.isProtected() && !this.isPublic();
        return bl;
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.method.getModifiers());
    }

    public boolean isNative() {
        return Modifier.isNative(this.method.getModifiers());
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.method.getModifiers());
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.method.getModifiers());
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.method.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    public boolean isVarArgs() {
        return this.method.isVarArgs();
    }

    public void setAccessible(boolean bl) {
        this.method.setAccessible(bl);
    }
}

