/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.compression.rangecoder;

import java.io.IOException;
import java.io.OutputStream;

public class Encoder {
    private static int[] ProbPrices = new int[512];
    static final int kBitModelTotal = 2048;
    static final int kNumBitModelTotalBits = 11;
    public static final int kNumBitPriceShiftBits = 6;
    static final int kNumMoveBits = 5;
    static final int kNumMoveReducingBits = 2;
    static final int kTopMask = -16777216;
    long Low;
    int Range;
    OutputStream Stream;
    int _cache;
    int _cacheSize;
    long _position;

    static {
        for (int i = 8; i >= 0; --i) {
            int n = 9 - i;
            int n2 = n - 1;
            n = 1 << n;
            for (int j = 1 << n2; j < n; ++j) {
                Encoder.ProbPrices[j] = (i << 6) + (n - j << 6 >>> n2);
            }
        }
    }

    public static int GetPrice(int n, int n2) {
        return ProbPrices[((n - n2 ^ -n2) & 0x7FF) >>> 2];
    }

    public static int GetPrice0(int n) {
        return ProbPrices[n >>> 2];
    }

    public static int GetPrice1(int n) {
        return ProbPrices[2048 - n >>> 2];
    }

    public static void InitBitModels(short[] sArray) {
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = (short)1024;
        }
    }

    public void Encode(short[] sArray, int n, int n2) throws IOException {
        short s = sArray[n];
        int n3 = this.Range;
        int n4 = (n3 >>> 11) * s;
        if (n2 == 0) {
            this.Range = n4;
            sArray[n] = (short)(s + (2048 - s >>> 5));
        } else {
            this.Low += (long)n4 & 0xFFFFFFFFL;
            this.Range = n3 - n4;
            sArray[n] = (short)(s - (s >>> 5));
        }
        n = this.Range;
        if ((0xFF000000 & n) == 0) {
            this.Range = n << 8;
            this.ShiftLow();
        }
    }

    public void EncodeDirectBits(int n, int n2) throws IOException {
        --n2;
        while (n2 >= 0) {
            int n3;
            this.Range >>>= 1;
            if ((n >>> n2 & 1) == 1) {
                this.Low += (long)this.Range;
            }
            if ((0xFF000000 & (n3 = this.Range)) == 0) {
                this.Range = n3 << 8;
                this.ShiftLow();
            }
            --n2;
        }
    }

    public void FlushData() throws IOException {
        for (int i = 0; i < 5; ++i) {
            this.ShiftLow();
        }
    }

    public void FlushStream() throws IOException {
        this.Stream.flush();
    }

    public long GetProcessedSizeAdd() {
        return (long)this._cacheSize + this._position + 4L;
    }

    public void Init() {
        this._position = 0L;
        this.Low = 0L;
        this.Range = -1;
        this._cacheSize = 1;
        this._cache = 0;
    }

    public void ReleaseStream() {
        this.Stream = null;
    }

    public void SetStream(OutputStream outputStream) {
        this.Stream = outputStream;
    }

    public void ShiftLow() throws IOException {
        long l = this.Low;
        int n = (int)(l >>> 32);
        if (n != 0 || l < 0xFF000000L) {
            int n2;
            this._position += (long)this._cacheSize;
            int n3 = this._cache;
            do {
                this.Stream.write(n3 + n);
                n3 = 255;
                this._cacheSize = n2 = this._cacheSize - 1;
            } while (n2 != 0);
            this._cache = (int)this.Low >>> 24;
        }
        ++this._cacheSize;
        this.Low = (this.Low & 0xFFFFFFL) << 8;
    }
}

