/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.compression.lz;

import java.io.IOException;
import java.io.InputStream;

public class InWindow {
    public int _blockSize;
    public byte[] _bufferBase;
    public int _bufferOffset;
    int _keepSizeAfter;
    int _keepSizeBefore;
    int _pointerToLastSafePosition;
    public int _pos;
    int _posLimit;
    InputStream _stream;
    boolean _streamEndWasReached;
    public int _streamPos;

    public void Create(int n, int n2, int n3) {
        this._keepSizeBefore = n;
        this._keepSizeAfter = n2;
        n = n + n2 + n3;
        if (this._bufferBase == null || this._blockSize != n) {
            this.Free();
            this._blockSize = n;
            this._bufferBase = new byte[this._blockSize];
        }
        this._pointerToLastSafePosition = this._blockSize - n2;
    }

    void Free() {
        this._bufferBase = null;
    }

    public byte GetIndexByte(int n) {
        return this._bufferBase[this._bufferOffset + this._pos + n];
    }

    public int GetMatchLen(int n, int n2, int n3) {
        int n4;
        byte[] byArray;
        int n5;
        int n6;
        int n7 = n3;
        if (this._streamEndWasReached) {
            n6 = this._pos;
            n5 = this._streamPos;
            n7 = n3;
            if (n6 + n + n3 > n5) {
                n7 = n5 - (n6 + n);
            }
        }
        n5 = this._bufferOffset;
        n6 = this._pos;
        for (n3 = 0; n3 < n7 && (byArray = this._bufferBase)[n4 = n5 + n6 + n + n3] == byArray[n4 - (n2 + 1)]; ++n3) {
        }
        return n3;
    }

    public int GetNumAvailableBytes() {
        return this._streamPos - this._pos;
    }

    public void Init() throws IOException {
        this._bufferOffset = 0;
        this._pos = 0;
        this._streamPos = 0;
        this._streamEndWasReached = false;
        this.ReadBlock();
    }

    public void MoveBlock() {
        int n;
        int n2 = n = this._bufferOffset + this._pos - this._keepSizeBefore;
        if (n > 0) {
            n2 = n - 1;
        }
        int n3 = this._bufferOffset;
        int n4 = this._streamPos;
        for (n = 0; n < n3 + n4 - n2; ++n) {
            byte[] byArray = this._bufferBase;
            byArray[n] = byArray[n2 + n];
        }
        this._bufferOffset -= n2;
    }

    public void MovePos() throws IOException {
        ++this._pos;
        int n = this._pos;
        if (n > this._posLimit) {
            if (this._bufferOffset + n > this._pointerToLastSafePosition) {
                this.MoveBlock();
            }
            this.ReadBlock();
        }
    }

    public void ReadBlock() throws IOException {
        if (this._streamEndWasReached) {
            return;
        }
        while (true) {
            int n = this._bufferOffset;
            int n2 = this._blockSize;
            int n3 = this._streamPos;
            if ((n2 = 0 - n + n2 - n3) == 0) {
                return;
            }
            if ((n3 = this._stream.read(this._bufferBase, n + n3, n2)) == -1) {
                this._posLimit = this._streamPos;
                n2 = this._posLimit;
                n = this._bufferOffset;
                n3 = this._pointerToLastSafePosition;
                if (n2 + n > n3) {
                    this._posLimit = n3 - n;
                }
                this._streamEndWasReached = true;
                return;
            }
            this._streamPos += n3;
            n = this._streamPos;
            n3 = this._pos;
            n2 = this._keepSizeAfter;
            if (n < n3 + n2) continue;
            this._posLimit = n - n2;
        }
    }

    public void ReduceOffsets(int n) {
        this._bufferOffset += n;
        this._posLimit -= n;
        this._pos -= n;
        this._streamPos -= n;
    }

    public void ReleaseStream() {
        this._stream = null;
    }

    public void SetStream(InputStream inputStream) {
        this._stream = inputStream;
    }
}

