/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;
import java.io.IOException;
import java.io.Writer;

public class XmlWriter
extends Writer {
    private String currentElement;
    public int indent;
    private boolean indentNextClose;
    private final Array<String> stack = new Array();
    private final Writer writer;

    public XmlWriter(Writer writer) {
        this.writer = writer;
    }

    private void indent() throws IOException {
        int n;
        int n2 = n = this.indent;
        if (this.currentElement != null) {
            n2 = n + 1;
        }
        for (n = 0; n < n2; ++n) {
            this.writer.write(9);
        }
    }

    private boolean startElementContent() throws IOException {
        String string2 = this.currentElement;
        if (string2 == null) {
            return false;
        }
        ++this.indent;
        this.stack.add(string2);
        this.currentElement = null;
        this.writer.write(">");
        return true;
    }

    public XmlWriter attribute(String string2, Object object) throws IOException {
        if (this.currentElement != null) {
            this.writer.write(32);
            this.writer.write(string2);
            this.writer.write("=\"");
            Writer writer = this.writer;
            string2 = object == null ? "null" : object.toString();
            writer.write(string2);
            this.writer.write(34);
            return this;
        }
        throw new IllegalStateException();
    }

    @Override
    public void close() throws IOException {
        while (this.stack.size != 0) {
            this.pop();
        }
        this.writer.close();
    }

    public XmlWriter element(String string2) throws IOException {
        if (this.startElementContent()) {
            this.writer.write(10);
        }
        this.indent();
        this.writer.write(60);
        this.writer.write(string2);
        this.currentElement = string2;
        return this;
    }

    public XmlWriter element(String string2, Object object) throws IOException {
        return this.element(string2).text(object).pop();
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    public XmlWriter pop() throws IOException {
        if (this.currentElement != null) {
            this.writer.write("/>\n");
            this.currentElement = null;
        } else {
            this.indent = Math.max(this.indent - 1, 0);
            if (this.indentNextClose) {
                this.indent();
            }
            this.writer.write("</");
            this.writer.write(this.stack.pop());
            this.writer.write(">\n");
        }
        this.indentNextClose = true;
        return this;
    }

    public XmlWriter text(Object object) throws IOException {
        this.startElementContent();
        object = object == null ? "null" : object.toString();
        boolean bl = ((String)object).length() > 64;
        this.indentNextClose = bl;
        if (this.indentNextClose) {
            this.writer.write(10);
            this.indent();
        }
        this.writer.write((String)object);
        if (this.indentNextClose) {
            this.writer.write(10);
        }
        return this;
    }

    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        this.startElementContent();
        this.writer.write(cArray, n, n2);
    }
}

