/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.LifecycleListener;
import com.badlogic.gdx.utils.Array;

public class Timer {
    static TimerThread thread;
    static final Object threadLock;
    final Array<Task> tasks = new Array(false, 8);

    static {
        threadLock = new Object();
    }

    public Timer() {
        this.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Timer instance() {
        Object object = threadLock;
        synchronized (object) {
            Timer timer;
            TimerThread timerThread = Timer.thread();
            if (timerThread.instance != null) return timerThread.instance;
            timerThread.instance = timer = new Timer();
            return timerThread.instance;
        }
    }

    public static Task post(Task task) {
        return Timer.instance().postTask(task);
    }

    public static Task schedule(Task task, float f) {
        return Timer.instance().scheduleTask(task, f);
    }

    public static Task schedule(Task task, float f, float f2) {
        return Timer.instance().scheduleTask(task, f, f2);
    }

    public static Task schedule(Task task, float f, float f2, int n) {
        return Timer.instance().scheduleTask(task, f, f2, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static TimerThread thread() {
        Object object = threadLock;
        synchronized (object) {
            TimerThread timerThread;
            if (thread != null) {
                if (Timer.thread.files == Gdx.files) return thread;
            }
            if (thread != null) {
                thread.dispose();
            }
            thread = timerThread = new TimerThread();
            return thread;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clear() {
        synchronized (this) {
            int n = this.tasks.size;
            for (int i = 0; i < n; ++i) {
                Task task = this.tasks.get(i);
                synchronized (task) {
                    task.executeTimeMillis = 0L;
                    task.timer = null;
                    continue;
                }
            }
            this.tasks.clear();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delay(long l) {
        synchronized (this) {
            int n = 0;
            int n2 = this.tasks.size;
            while (n < n2) {
                Task task = this.tasks.get(n);
                synchronized (task) {
                    task.executeTimeMillis += l;
                }
                ++n;
            }
            return;
        }
    }

    public boolean isEmpty() {
        synchronized (this) {
            int n = this.tasks.size;
            boolean bl = n == 0;
            return bl;
        }
    }

    public Task postTask(Task task) {
        return this.scheduleTask(task, 0.0f, 0.0f, 0);
    }

    public Task scheduleTask(Task task, float f) {
        return this.scheduleTask(task, f, 0.0f, 0);
    }

    public Task scheduleTask(Task task, float f, float f2) {
        return this.scheduleTask(task, f, f2, -1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Task scheduleTask(Task task, float f, float f2, int n) {
        synchronized (this) {
            synchronized (task) {
                if (task.timer == null) {
                    task.timer = this;
                    task.executeTimeMillis = System.nanoTime() / 1000000L + (long)(f * 1000.0f);
                    task.intervalMillis = (long)(f2 * 1000.0f);
                    task.repeatCount = n;
                    this.tasks.add(task);
                    // MONITOREXIT @DISABLED, blocks:[5, 6, 8] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                    // MONITOREXIT @DISABLED, blocks:[5, 8] lbl10 : MonitorExitStatement: MONITOREXIT : this
                    Object object = threadLock;
                    synchronized (object) {
                        threadLock.notifyAll();
                        return task;
                    }
                }
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("The same task may not be scheduled twice.");
                throw illegalArgumentException;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        Object object = threadLock;
        synchronized (object) {
            Array<Timer> array = Timer.thread().instances;
            if (array.contains(this, true)) {
                return;
            }
            array.add(this);
            threadLock.notifyAll();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        Object object = threadLock;
        synchronized (object) {
            Timer.thread().instances.removeValue(this, true);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long update(long l, long l2) {
        synchronized (this) {
            int n = 0;
            int n2 = this.tasks.size;
            while (n < n2) {
                Task task = this.tasks.get(n);
                synchronized (task) {
                    if (task.executeTimeMillis > l) {
                        l2 = Math.min(l2, task.executeTimeMillis - l);
                    } else {
                        int n3;
                        int n4;
                        if (task.repeatCount == 0) {
                            task.timer = null;
                            this.tasks.removeIndex(n);
                            n4 = n - 1;
                            n3 = n2 - 1;
                        } else {
                            task.executeTimeMillis = task.intervalMillis + l;
                            long l3 = Math.min(l2, task.intervalMillis);
                            n4 = n;
                            n3 = n2;
                            l2 = l3;
                            if (task.repeatCount > 0) {
                                --task.repeatCount;
                                l2 = l3;
                                n3 = n2;
                                n4 = n;
                            }
                        }
                        task.app.postRunnable(task);
                        // MONITOREXIT @DISABLED, blocks:[5, 6, 8, 12] lbl34 : MonitorExitStatement: MONITOREXIT : var7_5
                        n2 = n3;
                        n = n4;
                    }
                }
                ++n;
            }
            return l2;
        }
    }

    public static abstract class Task
    implements Runnable {
        final Application app = Gdx.app;
        long executeTimeMillis;
        long intervalMillis;
        int repeatCount;
        volatile Timer timer;

        public Task() {
            if (this.app != null) {
                return;
            }
            throw new IllegalStateException("Gdx.app not available.");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void cancel() {
            Timer timer = this.timer;
            if (timer != null) {
                synchronized (timer) {
                    synchronized (this) {
                        this.executeTimeMillis = 0L;
                        this.timer = null;
                        timer.tasks.removeValue(this, true);
                        return;
                    }
                }
            }
            synchronized (this) {
                this.executeTimeMillis = 0L;
                this.timer = null;
                return;
            }
        }

        public long getExecuteTimeMillis() {
            synchronized (this) {
                long l = this.executeTimeMillis;
                return l;
            }
        }

        public boolean isScheduled() {
            boolean bl = this.timer != null;
            return bl;
        }

        @Override
        public abstract void run();
    }

    static class TimerThread
    implements LifecycleListener,
    Runnable {
        final Files files;
        Timer instance;
        final Array<Timer> instances = new Array(1);
        private long pauseMillis;

        public TimerThread() {
            this.files = Gdx.files;
            Gdx.app.addLifecycleListener(this);
            this.resume();
            Thread thread = new Thread((Runnable)this, "Timer");
            thread.setDaemon(true);
            thread.start();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void dispose() {
            Object object = threadLock;
            synchronized (object) {
                if (thread == this) {
                    thread = null;
                }
                this.instances.clear();
                threadLock.notifyAll();
            }
            Gdx.app.removeLifecycleListener(this);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void pause() {
            Object object = threadLock;
            synchronized (object) {
                this.pauseMillis = System.nanoTime() / 1000000L;
                threadLock.notifyAll();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void resume() {
            Object object = threadLock;
            synchronized (object) {
                long l = System.nanoTime() / 1000000L;
                long l2 = this.pauseMillis;
                int n = this.instances.size;
                for (int i = 0; i < n; ++i) {
                    this.instances.get(i).delay(l - l2);
                }
                this.pauseMillis = 0L;
                threadLock.notifyAll();
                return;
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [12 : 224->229)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

