/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Collections;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.StringBuilder;
import com.badlogic.gdx.utils.reflect.ArrayReflection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Queue<T>
implements Iterable<T> {
    protected int head = 0;
    private QueueIterable iterable;
    public int size = 0;
    protected int tail = 0;
    protected T[] values;

    public Queue() {
        this(16);
    }

    public Queue(int n) {
        this.values = new Object[n];
    }

    public Queue(int n, Class<T> clazz) {
        this.values = (Object[])ArrayReflection.newInstance(clazz, n);
    }

    public void addFirst(T t) {
        int n;
        T[] TArray;
        T[] TArray2 = TArray = this.values;
        if (this.size == TArray.length) {
            this.resize(TArray.length << 1);
            TArray2 = this.values;
        }
        int n2 = n = this.head - 1;
        if (n == -1) {
            n2 = TArray2.length - 1;
        }
        TArray2[n2] = t;
        this.head = n2;
        ++this.size;
    }

    public void addLast(T t) {
        T[] TArray;
        T[] TArray2 = TArray = this.values;
        if (this.size == TArray.length) {
            this.resize(TArray.length << 1);
            TArray2 = this.values;
        }
        int n = this.tail;
        this.tail = n + 1;
        TArray2[n] = t;
        if (this.tail == TArray2.length) {
            this.tail = 0;
        }
        ++this.size;
    }

    public void clear() {
        int n;
        if (this.size == 0) {
            return;
        }
        T[] TArray = this.values;
        int n2 = this.tail;
        if (n < n2) {
            for (n = this.head; n < n2; ++n) {
                TArray[n] = null;
            }
        } else {
            int n3;
            for (n3 = n; n3 < TArray.length; ++n3) {
                TArray[n3] = null;
            }
            for (n3 = 0; n3 < n2; ++n3) {
                TArray[n3] = null;
            }
        }
        this.head = 0;
        this.tail = 0;
        this.size = 0;
    }

    public void ensureCapacity(int n) {
        if (this.values.length < (n = this.size + n)) {
            this.resize(n);
        }
    }

    public boolean equals(Object TArray) {
        if (this == TArray) {
            return true;
        }
        if (TArray != null && TArray instanceof Queue) {
            Queue<T> queue = (Queue)TArray;
            int n = this.size;
            if (queue.size != n) {
                return false;
            }
            TArray = this.values;
            int n2 = TArray.length;
            T[] TArray2 = queue.values;
            int n3 = TArray2.length;
            int n4 = this.head;
            int n5 = queue.head;
            for (int i = 0; i < n; ++i) {
                T t = TArray[n4];
                queue = TArray2[n5];
                if (!(t != null ? t.equals(queue) : queue == null)) {
                    return false;
                }
                int n6 = n4 + 1;
                int n7 = n5 + 1;
                n4 = n6;
                if (n6 == n2) {
                    n4 = 0;
                }
                n5 = n7;
                if (n7 != n3) continue;
                n5 = 0;
            }
            return true;
        }
        return false;
    }

    public boolean equalsIdentity(Object TArray) {
        if (this == TArray) {
            return true;
        }
        if (TArray != null && TArray instanceof Queue) {
            Queue queue = (Queue)TArray;
            int n = this.size;
            if (queue.size != n) {
                return false;
            }
            T[] TArray2 = this.values;
            int n2 = TArray2.length;
            TArray = queue.values;
            int n3 = TArray.length;
            int n4 = this.head;
            int n5 = queue.head;
            for (int i = 0; i < n; ++i) {
                if (TArray2[n4] != TArray[n5]) {
                    return false;
                }
                int n6 = n4 + 1;
                int n7 = n5 + 1;
                n4 = n6;
                if (n6 == n2) {
                    n4 = 0;
                }
                n5 = n7;
                if (n7 != n3) continue;
                n5 = 0;
            }
            return true;
        }
        return false;
    }

    public T first() {
        if (this.size != 0) {
            return this.values[this.head];
        }
        throw new NoSuchElementException("Queue is empty.");
    }

    public T get(int n) {
        if (n >= 0) {
            if (n < this.size) {
                int n2;
                T[] TArray = this.values;
                n = n2 = this.head + n;
                if (n2 >= TArray.length) {
                    n = n2 - TArray.length;
                }
                return TArray[n];
            }
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append("index can't be >= size: ");
            stringBuilder.append(n);
            stringBuilder.append(" >= ");
            stringBuilder.append(this.size);
            throw new IndexOutOfBoundsException(stringBuilder.toString());
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be < 0: ");
        stringBuilder.append(n);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public int hashCode() {
        int n = this.size;
        T[] TArray = this.values;
        int n2 = TArray.length;
        int n3 = this.head;
        int n4 = n + 1;
        for (int i = 0; i < n; ++i) {
            int n5;
            T t = TArray[n3];
            n4 = n5 = n4 * 31;
            if (t != null) {
                n4 = n5 + t.hashCode();
            }
            n3 = n5 = n3 + 1;
            if (n5 != n2) continue;
            n3 = 0;
        }
        return n4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int indexOf(T t, boolean bl) {
        int n;
        int n2;
        if (this.size == 0) {
            return -1;
        }
        T[] TArray = this.values;
        int n3 = this.head;
        int n4 = this.tail;
        int n5 = 0;
        int n6 = 0;
        if (!bl && t != null) {
            if (n3 < n4) {
                for (int i = n3; i < n4; ++i) {
                    if (!t.equals(TArray[i])) continue;
                    return i - n3;
                }
                return -1;
            } else {
                n5 = TArray.length;
                n2 = n3;
                while (true) {
                    if (n2 >= n5) break;
                    if (t.equals(TArray[n2])) {
                        return n2 - n3;
                    }
                    ++n2;
                }
                for (n = n6; n < n4; ++n) {
                    if (!t.equals(TArray[n])) continue;
                    n2 = TArray.length;
                    return n + n2 - n3;
                }
            }
            return -1;
        } else if (n3 < n4) {
            for (int i = n3; i < n4; ++i) {
                if (TArray[i] != t) continue;
                return i - n3;
            }
            return -1;
        } else {
            n6 = TArray.length;
            n2 = n3;
            while (true) {
                if (n2 >= n6) break;
                if (TArray[n2] == t) {
                    return n2 - n3;
                }
                ++n2;
            }
            for (n = n5; n < n4; ++n) {
                if (TArray[n] != t) continue;
                n2 = TArray.length;
                return n + n2 - n3;
            }
        }
        return -1;
    }

    public boolean isEmpty() {
        boolean bl = this.size == 0;
        return bl;
    }

    @Override
    public Iterator<T> iterator() {
        if (Collections.allocateIterators) {
            return new QueueIterator(this, true);
        }
        if (this.iterable == null) {
            this.iterable = new QueueIterable(this);
        }
        return this.iterable.iterator();
    }

    public T last() {
        if (this.size != 0) {
            int n;
            T[] TArray = this.values;
            int n2 = n = this.tail - 1;
            if (n == -1) {
                n2 = TArray.length - 1;
            }
            return TArray[n2];
        }
        throw new NoSuchElementException("Queue is empty.");
    }

    public boolean notEmpty() {
        boolean bl = this.size > 0;
        return bl;
    }

    public T removeFirst() {
        if (this.size != 0) {
            T[] TArray = this.values;
            int n = this.head;
            T t = TArray[n];
            TArray[n] = null;
            this.head = n + 1;
            if (this.head == TArray.length) {
                this.head = 0;
            }
            --this.size;
            return t;
        }
        throw new NoSuchElementException("Queue is empty.");
    }

    public T removeIndex(int n) {
        if (n >= 0) {
            if (n < this.size) {
                T t;
                T[] TArray = this.values;
                int n2 = this.head++;
                int n3 = this.tail--;
                n += n2;
                if (n2 < n3) {
                    t = TArray[n];
                    System.arraycopy(TArray, n + 1, TArray, n, n3 - n);
                    TArray[n3] = null;
                } else if (n >= TArray.length) {
                    t = TArray[n -= TArray.length];
                    System.arraycopy(TArray, n + 1, TArray, n, n3 - n);
                    --this.tail;
                } else {
                    t = TArray[n];
                    System.arraycopy(TArray, n2, TArray, n2 + 1, n - n2);
                    TArray[n2] = null;
                    if (this.head == TArray.length) {
                        this.head = 0;
                    }
                }
                --this.size;
                return t;
            }
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append("index can't be >= size: ");
            stringBuilder.append(n);
            stringBuilder.append(" >= ");
            stringBuilder.append(this.size);
            throw new IndexOutOfBoundsException(stringBuilder.toString());
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be < 0: ");
        stringBuilder.append(n);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public T removeLast() {
        if (this.size != 0) {
            int n;
            T[] TArray = this.values;
            int n2 = n = this.tail - 1;
            if (n == -1) {
                n2 = TArray.length - 1;
            }
            T t = TArray[n2];
            TArray[n2] = null;
            this.tail = n2;
            --this.size;
            return t;
        }
        throw new NoSuchElementException("Queue is empty.");
    }

    public boolean removeValue(T t, boolean bl) {
        int n = this.indexOf(t, bl);
        if (n == -1) {
            return false;
        }
        this.removeIndex(n);
        return true;
    }

    protected void resize(int n) {
        T[] TArray = this.values;
        int n2 = this.head;
        int n3 = this.tail;
        Object[] objectArray = (Object[])ArrayReflection.newInstance(TArray.getClass().getComponentType(), n);
        if (n2 < n3) {
            System.arraycopy(TArray, n2, objectArray, 0, n3 - n2);
        } else if (this.size > 0) {
            n = TArray.length - n2;
            System.arraycopy(TArray, n2, objectArray, 0, n);
            System.arraycopy(TArray, 0, objectArray, n, n3);
        }
        this.values = objectArray;
        this.head = 0;
        this.tail = this.size;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        T[] TArray = this.values;
        int n = this.head;
        int n2 = this.tail;
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append('[');
        stringBuilder.append(TArray[n]);
        while ((n = (n + 1) % TArray.length) != n2) {
            stringBuilder.append(", ").append(TArray[n]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static class QueueIterable<T>
    implements Iterable<T> {
        private final boolean allowRemove;
        private QueueIterator iterator1;
        private QueueIterator iterator2;
        private final Queue<T> queue;

        public QueueIterable(Queue<T> queue) {
            this(queue, true);
        }

        public QueueIterable(Queue<T> queue, boolean bl) {
            this.queue = queue;
            this.allowRemove = bl;
        }

        @Override
        public Iterator<T> iterator() {
            if (Collections.allocateIterators) {
                return new QueueIterator<T>(this.queue, this.allowRemove);
            }
            if (this.iterator1 == null) {
                this.iterator1 = new QueueIterator<T>(this.queue, this.allowRemove);
                this.iterator2 = new QueueIterator<T>(this.queue, this.allowRemove);
            }
            if (!this.iterator1.valid) {
                QueueIterator queueIterator = this.iterator1;
                queueIterator.index = 0;
                queueIterator.valid = true;
                this.iterator2.valid = false;
                return queueIterator;
            }
            QueueIterator queueIterator = this.iterator2;
            queueIterator.index = 0;
            queueIterator.valid = true;
            this.iterator1.valid = false;
            return queueIterator;
        }
    }

    public static class QueueIterator<T>
    implements Iterator<T>,
    Iterable<T> {
        private final boolean allowRemove;
        int index;
        private final Queue<T> queue;
        boolean valid = true;

        public QueueIterator(Queue<T> queue) {
            this(queue, true);
        }

        public QueueIterator(Queue<T> queue, boolean bl) {
            this.queue = queue;
            this.allowRemove = bl;
        }

        @Override
        public boolean hasNext() {
            if (this.valid) {
                boolean bl = this.index < this.queue.size;
                return bl;
            }
            throw new GdxRuntimeException("#iterator() cannot be used nested.");
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }

        @Override
        public T next() {
            if (this.index < this.queue.size) {
                if (this.valid) {
                    Queue<T> queue = this.queue;
                    int n = this.index;
                    this.index = n + 1;
                    return queue.get(n);
                }
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            throw new NoSuchElementException(String.valueOf(this.index));
        }

        @Override
        public void remove() {
            if (this.allowRemove) {
                --this.index;
                this.queue.removeIndex(this.index);
                return;
            }
            throw new GdxRuntimeException("Remove not allowed.");
        }

        public void reset() {
            this.index = 0;
        }
    }
}

