/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;

public abstract class Pool<T> {
    private final Array<T> freeObjects;
    public final int max;
    public int peak;

    public Pool() {
        this(16, Integer.MAX_VALUE);
    }

    public Pool(int n) {
        this(n, Integer.MAX_VALUE);
    }

    public Pool(int n, int n2) {
        this.freeObjects = new Array(false, n);
        this.max = n2;
    }

    public void clear() {
        this.freeObjects.clear();
    }

    public void free(T t) {
        if (t != null) {
            if (this.freeObjects.size < this.max) {
                this.freeObjects.add(t);
                this.peak = Math.max(this.peak, this.freeObjects.size);
            }
            this.reset(t);
            return;
        }
        throw new IllegalArgumentException("object cannot be null.");
    }

    public void freeAll(Array<T> object) {
        if (object != null) {
            Array array = this.freeObjects;
            int n = this.max;
            for (int i = 0; i < ((Array)object).size; ++i) {
                Object t = ((Array)object).get(i);
                if (t == null) continue;
                if (array.size < n) {
                    array.add(t);
                }
                this.reset(t);
            }
            this.peak = Math.max(this.peak, array.size);
            return;
        }
        object = new IllegalArgumentException("objects cannot be null.");
        throw object;
    }

    public int getFree() {
        return this.freeObjects.size;
    }

    protected abstract T newObject();

    public T obtain() {
        T t = this.freeObjects.size == 0 ? this.newObject() : this.freeObjects.pop();
        return t;
    }

    protected void reset(T t) {
        if (t instanceof Poolable) {
            ((Poolable)t).reset();
        }
    }

    public static interface Poolable {
        public void reset();
    }
}

