/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.Gdx;

public class Logger {
    public static final int DEBUG = 3;
    public static final int ERROR = 1;
    public static final int INFO = 2;
    public static final int NONE = 0;
    private int level;
    private final String tag;

    public Logger(String string2) {
        this(string2, 1);
    }

    public Logger(String string2, int n) {
        this.tag = string2;
        this.level = n;
    }

    public void debug(String string2) {
        if (this.level >= 3) {
            Gdx.app.debug(this.tag, string2);
        }
    }

    public void debug(String string2, Exception exception) {
        if (this.level >= 3) {
            Gdx.app.debug(this.tag, string2, exception);
        }
    }

    public void error(String string2) {
        if (this.level >= 1) {
            Gdx.app.error(this.tag, string2);
        }
    }

    public void error(String string2, Throwable throwable) {
        if (this.level >= 1) {
            Gdx.app.error(this.tag, string2, throwable);
        }
    }

    public int getLevel() {
        return this.level;
    }

    public void info(String string2) {
        if (this.level >= 2) {
            Gdx.app.log(this.tag, string2);
        }
    }

    public void info(String string2, Exception exception) {
        if (this.level >= 2) {
            Gdx.app.log(this.tag, string2, exception);
        }
    }

    public void setLevel(int n) {
        this.level = n;
    }
}

