/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Collections;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.StringBuilder;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IntIntMap
implements Iterable<Entry> {
    private static final int EMPTY = 0;
    private static final int PRIME1 = -1105259343;
    private static final int PRIME2 = -1262997959;
    private static final int PRIME3 = -825114047;
    int capacity;
    private Entries entries1;
    private Entries entries2;
    boolean hasZeroValue;
    private int hashShift;
    int[] keyTable;
    private Keys keys1;
    private Keys keys2;
    private float loadFactor;
    private int mask;
    private int pushIterations;
    public int size;
    private int stashCapacity;
    int stashSize;
    private int threshold;
    int[] valueTable;
    private Values values1;
    private Values values2;
    int zeroValue;

    public IntIntMap() {
        this(51, 0.8f);
    }

    public IntIntMap(int n) {
        this(n, 0.8f);
    }

    public IntIntMap(int n, float f) {
        if (n >= 0) {
            if ((n = MathUtils.nextPowerOfTwo((int)Math.ceil((float)n / f))) <= 0x40000000) {
                this.capacity = n;
                if (!(f <= 0.0f)) {
                    this.loadFactor = f;
                    n = this.capacity;
                    this.threshold = (int)((float)n * f);
                    this.mask = n - 1;
                    this.hashShift = 31 - Integer.numberOfTrailingZeros(n);
                    this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(this.capacity)) * 2);
                    this.pushIterations = Math.max(Math.min(this.capacity, 8), (int)Math.sqrt(this.capacity) / 8);
                    this.keyTable = new int[this.capacity + this.stashCapacity];
                    this.valueTable = new int[this.keyTable.length];
                    return;
                }
                java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
                stringBuilder.append("loadFactor must be > 0: ");
                stringBuilder.append(f);
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append("initialCapacity is too large: ");
            stringBuilder.append(n);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("initialCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public IntIntMap(IntIntMap intIntMap) {
        this((int)Math.floor((float)intIntMap.capacity * intIntMap.loadFactor), intIntMap.loadFactor);
        this.stashSize = intIntMap.stashSize;
        int[] nArray = intIntMap.keyTable;
        System.arraycopy(nArray, 0, this.keyTable, 0, nArray.length);
        nArray = intIntMap.valueTable;
        System.arraycopy(nArray, 0, this.valueTable, 0, nArray.length);
        this.size = intIntMap.size;
        this.zeroValue = intIntMap.zeroValue;
        this.hasZeroValue = intIntMap.hasZeroValue;
    }

    private boolean containsKeyStash(int n) {
        int[] nArray = this.keyTable;
        int n2 = this.capacity;
        int n3 = this.stashSize;
        for (int i = n2; i < n3 + n2; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    private int getAndIncrementStash(int n, int n2, int n3) {
        int[] nArray = this.keyTable;
        int n4 = this.capacity;
        int n5 = this.stashSize;
        for (int i = n4; i < n5 + n4; ++i) {
            if (n != nArray[i]) continue;
            nArray = this.valueTable;
            n = nArray[i];
            nArray[i] = n3 + n;
            return n;
        }
        this.put(n, n3 + n2);
        return n2;
    }

    private int getStash(int n, int n2) {
        int[] nArray = this.keyTable;
        int n3 = this.capacity;
        int n4 = this.stashSize;
        for (int i = n3; i < n4 + n3; ++i) {
            if (n != nArray[i]) continue;
            return this.valueTable[i];
        }
        return n2;
    }

    private int hash2(int n) {
        return ((n *= -1262997959) ^ n >>> this.hashShift) & this.mask;
    }

    private int hash3(int n) {
        return ((n *= -825114047) ^ n >>> this.hashShift) & this.mask;
    }

    private void push(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int[] nArray = this.keyTable;
        int[] nArray2 = this.valueTable;
        int n9 = this.mask;
        int n10 = this.pushIterations;
        int n11 = 0;
        int n12 = n7;
        int n13 = n5;
        int n14 = n3;
        n5 = n2;
        n7 = n;
        n3 = n11;
        do {
            if ((n = MathUtils.random(2)) != 0) {
                if (n != 1) {
                    n2 = nArray2[n12];
                    nArray[n12] = n7;
                    nArray2[n12] = n5;
                    n = n8;
                } else {
                    n2 = nArray2[n13];
                    nArray[n13] = n7;
                    nArray2[n13] = n5;
                    n = n6;
                }
            } else {
                n2 = nArray2[n14];
                nArray[n14] = n7;
                nArray2[n14] = n5;
                n = n4;
            }
            n14 = n & n9;
            n4 = nArray[n14];
            if (n4 == 0) {
                nArray[n14] = n;
                nArray2[n14] = n2;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n13 = this.hash2(n);
            n6 = nArray[n13];
            if (n6 == 0) {
                nArray[n13] = n;
                nArray2[n13] = n2;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n12 = this.hash3(n);
            n8 = nArray[n12];
            if (n8 == 0) {
                nArray[n12] = n;
                nArray2[n12] = n2;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n3 = n11 = n3 + 1;
            n7 = n;
            n5 = n2;
        } while (n11 != n10);
        this.putStash(n, n2);
    }

    private void putResize(int n, int n2) {
        if (n == 0) {
            this.zeroValue = n2;
            this.hasZeroValue = true;
            return;
        }
        int[] nArray = this.keyTable;
        int n3 = n & this.mask;
        int n4 = nArray[n3];
        if (n4 == 0) {
            nArray[n3] = n;
            this.valueTable[n3] = n2;
            n = this.size;
            this.size = n + 1;
            if (n >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        nArray = this.keyTable;
        int n5 = this.hash2(n);
        int n6 = nArray[n5];
        if (n6 == 0) {
            nArray[n5] = n;
            this.valueTable[n5] = n2;
            n = this.size;
            this.size = n + 1;
            if (n >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        nArray = this.keyTable;
        int n7 = this.hash3(n);
        int n8 = nArray[n7];
        if (n8 == 0) {
            nArray[n7] = n;
            this.valueTable[n7] = n2;
            n = this.size;
            this.size = n + 1;
            if (n >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(n, n2, n3, n4, n5, n6, n7, n8);
    }

    private void putStash(int n, int n2) {
        int n3 = this.stashSize;
        if (n3 == this.stashCapacity) {
            this.resize(this.capacity << 1);
            this.putResize(n, n2);
            return;
        }
        int n4 = this.capacity + n3;
        this.keyTable[n4] = n;
        this.valueTable[n4] = n2;
        this.stashSize = n3 + 1;
        ++this.size;
    }

    private void resize(int n) {
        int n2 = this.capacity;
        int n3 = this.stashSize;
        this.capacity = n;
        this.threshold = (int)((float)n * this.loadFactor);
        this.mask = n - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(n);
        double d = n;
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(d)) * 2);
        this.pushIterations = Math.max(Math.min(n, 8), (int)Math.sqrt(d) / 8);
        int[] nArray = this.keyTable;
        int[] nArray2 = this.valueTable;
        int n4 = this.stashCapacity;
        this.keyTable = new int[n + n4];
        this.valueTable = new int[n + n4];
        n4 = this.size;
        this.size = this.hasZeroValue ? 1 : 0;
        this.stashSize = 0;
        if (n4 > 0) {
            for (n = 0; n < n2 + n3; ++n) {
                n4 = nArray[n];
                if (n4 == 0) continue;
                this.putResize(n4, nArray2[n]);
            }
        }
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        int[] nArray = this.keyTable;
        int n = this.capacity + this.stashSize;
        while (true) {
            int n2 = n - 1;
            if (n <= 0) break;
            nArray[n2] = 0;
            n = n2;
        }
        this.size = 0;
        this.stashSize = 0;
        this.hasZeroValue = false;
    }

    public void clear(int n) {
        if (this.capacity <= n) {
            this.clear();
            return;
        }
        this.hasZeroValue = false;
        this.size = 0;
        this.resize(n);
    }

    public boolean containsKey(int n) {
        if (n == 0) {
            return this.hasZeroValue;
        }
        int n2 = this.mask;
        if (this.keyTable[n2 & n] != n && this.keyTable[n2 = this.hash2(n)] != n && this.keyTable[n2 = this.hash3(n)] != n) {
            return this.containsKeyStash(n);
        }
        return true;
    }

    public boolean containsValue(int n) {
        if (this.hasZeroValue && this.zeroValue == n) {
            return true;
        }
        int[] nArray = this.keyTable;
        int[] nArray2 = this.valueTable;
        int n2 = this.capacity + this.stashSize;
        while (true) {
            int n3 = n2 - 1;
            if (n2 <= 0) break;
            if (nArray[n3] != 0 && nArray2[n3] == n) {
                return true;
            }
            n2 = n3;
        }
        return false;
    }

    public void ensureCapacity(int n) {
        if (n >= 0) {
            if ((n = this.size + n) >= this.threshold) {
                this.resize(MathUtils.nextPowerOfTwo((int)Math.ceil((float)n / this.loadFactor)));
            }
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("additionalCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public Entries entries() {
        if (Collections.allocateIterators) {
            return new Entries(this);
        }
        if (this.entries1 == null) {
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        if (!this.entries1.valid) {
            this.entries1.reset();
            Entries entries = this.entries1;
            entries.valid = true;
            this.entries2.valid = false;
            return entries;
        }
        this.entries2.reset();
        Entries entries = this.entries2;
        entries.valid = true;
        this.entries1.valid = false;
        return entries;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntIntMap)) {
            return false;
        }
        IntIntMap intIntMap = (IntIntMap)object;
        if (intIntMap.size != this.size) {
            return false;
        }
        boolean bl = intIntMap.hasZeroValue;
        boolean bl2 = this.hasZeroValue;
        if (bl != bl2) {
            return false;
        }
        if (bl2 && intIntMap.zeroValue != this.zeroValue) {
            return false;
        }
        int[] nArray = this.keyTable;
        object = this.valueTable;
        int n = this.capacity;
        int n2 = this.stashSize;
        for (int i = 0; i < n + n2; ++i) {
            int n3 = nArray[i];
            if (n3 == 0) continue;
            int n4 = intIntMap.get(n3, 0);
            if (n4 == 0 && !intIntMap.containsKey(n3)) {
                return false;
            }
            if (n4 == object[i]) continue;
            return false;
        }
        return true;
    }

    public int findKey(int n, int n2) {
        if (this.hasZeroValue && this.zeroValue == n) {
            return 0;
        }
        int[] nArray = this.keyTable;
        int[] nArray2 = this.valueTable;
        int n3 = this.capacity + this.stashSize;
        while (true) {
            int n4 = n3 - 1;
            if (n3 <= 0) break;
            if (nArray[n4] != 0 && nArray2[n4] == n) {
                return nArray[n4];
            }
            n3 = n4;
        }
        return n2;
    }

    public int get(int n, int n2) {
        int n3;
        if (n == 0) {
            if (!this.hasZeroValue) {
                return n2;
            }
            return this.zeroValue;
        }
        int n4 = n3 = this.mask & n;
        if (this.keyTable[n3] != n) {
            n4 = n3 = this.hash2(n);
            if (this.keyTable[n3] != n) {
                n4 = n3 = this.hash3(n);
                if (this.keyTable[n3] != n) {
                    return this.getStash(n, n2);
                }
            }
        }
        return this.valueTable[n4];
    }

    public int getAndIncrement(int n, int n2, int n3) {
        int n4;
        if (n == 0) {
            if (this.hasZeroValue) {
                n = this.zeroValue;
                this.zeroValue = n3 + n;
                return n;
            }
            this.hasZeroValue = true;
            this.zeroValue = n3 + n2;
            ++this.size;
            return n2;
        }
        int n5 = n4 = this.mask & n;
        if (n != this.keyTable[n4]) {
            n5 = n4 = this.hash2(n);
            if (n != this.keyTable[n4]) {
                n5 = n4 = this.hash3(n);
                if (n != this.keyTable[n4]) {
                    return this.getAndIncrementStash(n, n2, n3);
                }
            }
        }
        int[] nArray = this.valueTable;
        n = nArray[n5];
        nArray[n5] = n3 + n;
        return n;
    }

    public int hashCode() {
        boolean bl = this.hasZeroValue;
        int n = bl ? Float.floatToIntBits(this.zeroValue) + 0 : 0;
        int[] nArray = this.keyTable;
        int[] nArray2 = this.valueTable;
        int n2 = this.capacity;
        int n3 = this.stashSize;
        for (int i = 0; i < n2 + n3; ++i) {
            int n4 = nArray[i];
            int n5 = n;
            if (n4 != 0) {
                n5 = n + n4 * 31 + nArray2[i];
            }
            n = n5;
        }
        return n;
    }

    public boolean isEmpty() {
        boolean bl = this.size == 0;
        return bl;
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.entries();
    }

    public Keys keys() {
        if (Collections.allocateIterators) {
            return new Keys(this);
        }
        if (this.keys1 == null) {
            this.keys1 = new Keys(this);
            this.keys2 = new Keys(this);
        }
        if (!this.keys1.valid) {
            this.keys1.reset();
            Keys keys = this.keys1;
            keys.valid = true;
            this.keys2.valid = false;
            return keys;
        }
        this.keys2.reset();
        Keys keys = this.keys2;
        keys.valid = true;
        this.keys1.valid = false;
        return keys;
    }

    public boolean notEmpty() {
        boolean bl = this.size > 0;
        return bl;
    }

    public void put(int n, int n2) {
        if (n == 0) {
            this.zeroValue = n2;
            if (!this.hasZeroValue) {
                this.hasZeroValue = true;
                ++this.size;
            }
            return;
        }
        int[] nArray = this.keyTable;
        int n3 = n & this.mask;
        int n4 = nArray[n3];
        if (n == n4) {
            this.valueTable[n3] = n2;
            return;
        }
        int n5 = this.hash2(n);
        int n6 = nArray[n5];
        if (n == n6) {
            this.valueTable[n5] = n2;
            return;
        }
        int n7 = this.hash3(n);
        int n8 = nArray[n7];
        if (n == n8) {
            this.valueTable[n7] = n2;
            return;
        }
        int n9 = this.capacity;
        int n10 = this.stashSize;
        for (int i = n9; i < n10 + n9; ++i) {
            if (n != nArray[i]) continue;
            this.valueTable[i] = n2;
            return;
        }
        if (n4 == 0) {
            nArray[n3] = n;
            this.valueTable[n3] = n2;
            n = this.size;
            this.size = n + 1;
            if (n >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        if (n6 == 0) {
            nArray[n5] = n;
            this.valueTable[n5] = n2;
            n = this.size;
            this.size = n + 1;
            if (n >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        if (n8 == 0) {
            nArray[n7] = n;
            this.valueTable[n7] = n2;
            n = this.size;
            this.size = n + 1;
            if (n >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(n, n2, n3, n4, n5, n6, n7, n8);
    }

    public void putAll(IntIntMap object2) {
        for (Object object2 : ((IntIntMap)object2).entries()) {
            this.put(((Entry)object2).key, ((Entry)object2).value);
        }
    }

    public int remove(int n, int n2) {
        if (n == 0) {
            if (!this.hasZeroValue) {
                return n2;
            }
            this.hasZeroValue = false;
            --this.size;
            return this.zeroValue;
        }
        int[] nArray = this.keyTable;
        int n3 = this.mask & n;
        if (n == nArray[n3]) {
            nArray[n3] = 0;
            n = this.valueTable[n3];
            --this.size;
            return n;
        }
        nArray = this.keyTable;
        n3 = this.hash2(n);
        if (n == nArray[n3]) {
            nArray[n3] = 0;
            n = this.valueTable[n3];
            --this.size;
            return n;
        }
        nArray = this.keyTable;
        n3 = this.hash3(n);
        if (n == nArray[n3]) {
            nArray[n3] = 0;
            n = this.valueTable[n3];
            --this.size;
            return n;
        }
        return this.removeStash(n, n2);
    }

    int removeStash(int n, int n2) {
        int[] nArray = this.keyTable;
        int n3 = this.capacity;
        int n4 = this.stashSize;
        for (int i = n3; i < n4 + n3; ++i) {
            if (n != nArray[i]) continue;
            n = this.valueTable[i];
            this.removeStashIndex(i);
            --this.size;
            return n;
        }
        return n2;
    }

    void removeStashIndex(int n) {
        --this.stashSize;
        int n2 = this.capacity + this.stashSize;
        if (n < n2) {
            int[] nArray = this.keyTable;
            nArray[n] = nArray[n2];
            nArray = this.valueTable;
            nArray[n] = nArray[n2];
        }
    }

    public void shrink(int n) {
        if (n >= 0) {
            int n2 = this.size;
            int n3 = n;
            if (n2 > n) {
                n3 = n2;
            }
            if (this.capacity <= n3) {
                return;
            }
            this.resize(MathUtils.nextPowerOfTwo(n3));
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("maximumCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public String toString() {
        int n;
        int n2;
        int[] nArray;
        int[] nArray2;
        StringBuilder stringBuilder;
        block6: {
            if (this.size == 0) {
                return "{}";
            }
            stringBuilder = new StringBuilder(32);
            stringBuilder.append('{');
            nArray2 = this.keyTable;
            nArray = this.valueTable;
            n = n2 = nArray2.length;
            if (this.hasZeroValue) {
                stringBuilder.append("0=");
                stringBuilder.append(this.zeroValue);
            } else {
                int n3;
                while (true) {
                    n2 = n3 = n - 1;
                    if (n <= 0) break block6;
                    n2 = nArray2[n3];
                    if (n2 != 0) break;
                    n = n3;
                }
                stringBuilder.append(n2);
                stringBuilder.append('=');
                stringBuilder.append(nArray[n3]);
                n2 = n3;
            }
        }
        while (true) {
            n = n2 - 1;
            if (n2 <= 0) break;
            n2 = nArray2[n];
            if (n2 == 0) {
                n2 = n;
                continue;
            }
            stringBuilder.append(", ");
            stringBuilder.append(n2);
            stringBuilder.append('=');
            stringBuilder.append(nArray[n]);
            n2 = n;
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public Values values() {
        if (Collections.allocateIterators) {
            return new Values(this);
        }
        if (this.values1 == null) {
            this.values1 = new Values(this);
            this.values2 = new Values(this);
        }
        if (!this.values1.valid) {
            this.values1.reset();
            Values values = this.values1;
            values.valid = true;
            this.values2.valid = false;
            return values;
        }
        this.values2.reset();
        Values values = this.values2;
        values.valid = true;
        this.values1.valid = false;
        return values;
    }

    public static class Entries
    extends MapIterator
    implements Iterable<Entry>,
    Iterator<Entry> {
        private Entry entry = new Entry();

        public Entries(IntIntMap intIntMap) {
            super(intIntMap);
        }

        @Override
        public boolean hasNext() {
            if (this.valid) {
                return this.hasNext;
            }
            throw new GdxRuntimeException("#iterator() cannot be used nested.");
        }

        @Override
        public Iterator<Entry> iterator() {
            return this;
        }

        @Override
        public Entry next() {
            if (this.hasNext) {
                if (this.valid) {
                    Object object = this.map.keyTable;
                    if (this.nextIndex == -1) {
                        object = this.entry;
                        object.key = 0;
                        object.value = this.map.zeroValue;
                    } else {
                        this.entry.key = object[this.nextIndex];
                        this.entry.value = this.map.valueTable[this.nextIndex];
                    }
                    this.currentIndex = this.nextIndex;
                    this.findNextIndex();
                    return this.entry;
                }
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            super.remove();
        }
    }

    public static class Entry {
        public int key;
        public int value;

        public String toString() {
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append(this.key);
            stringBuilder.append("=");
            stringBuilder.append(this.value);
            return stringBuilder.toString();
        }
    }

    public static class Keys
    extends MapIterator {
        public Keys(IntIntMap intIntMap) {
            super(intIntMap);
        }

        public boolean hasNext() {
            if (this.valid) {
                return this.hasNext;
            }
            throw new GdxRuntimeException("#iterator() cannot be used nested.");
        }

        public int next() {
            if (this.hasNext) {
                if (this.valid) {
                    int n = this.nextIndex == -1 ? 0 : this.map.keyTable[this.nextIndex];
                    this.currentIndex = this.nextIndex;
                    this.findNextIndex();
                    return n;
                }
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            throw new NoSuchElementException();
        }

        public IntArray toArray() {
            IntArray intArray = new IntArray(true, this.map.size);
            while (this.hasNext) {
                intArray.add(this.next());
            }
            return intArray;
        }
    }

    private static class MapIterator {
        static final int INDEX_ILLEGAL = -2;
        static final int INDEX_ZERO = -1;
        int currentIndex;
        public boolean hasNext;
        final IntIntMap map;
        int nextIndex;
        boolean valid = true;

        public MapIterator(IntIntMap intIntMap) {
            this.map = intIntMap;
            this.reset();
        }

        void findNextIndex() {
            block1: {
                this.hasNext = false;
                int[] nArray = this.map.keyTable;
                int n = this.map.capacity;
                int n2 = this.map.stashSize;
                do {
                    int n3;
                    this.nextIndex = n3 = this.nextIndex + 1;
                    if (n3 >= n + n2) break block1;
                } while (nArray[this.nextIndex] == 0);
                this.hasNext = true;
            }
        }

        public void remove() {
            block7: {
                block6: {
                    block5: {
                        if (this.currentIndex != -1 || !this.map.hasZeroValue) break block5;
                        this.map.hasZeroValue = false;
                        break block6;
                    }
                    int n = this.currentIndex;
                    if (n < 0) break block7;
                    if (n >= this.map.capacity) {
                        this.map.removeStashIndex(this.currentIndex);
                        this.nextIndex = this.currentIndex - 1;
                        this.findNextIndex();
                    } else {
                        this.map.keyTable[this.currentIndex] = 0;
                    }
                }
                this.currentIndex = -2;
                IntIntMap intIntMap = this.map;
                --intIntMap.size;
                return;
            }
            throw new IllegalStateException("next must be called before remove.");
        }

        public void reset() {
            this.currentIndex = -2;
            this.nextIndex = -1;
            if (this.map.hasZeroValue) {
                this.hasNext = true;
            } else {
                this.findNextIndex();
            }
        }
    }

    public static class Values
    extends MapIterator {
        public Values(IntIntMap intIntMap) {
            super(intIntMap);
        }

        public boolean hasNext() {
            if (this.valid) {
                return this.hasNext;
            }
            throw new GdxRuntimeException("#iterator() cannot be used nested.");
        }

        public int next() {
            if (this.hasNext) {
                if (this.valid) {
                    int n = this.nextIndex == -1 ? this.map.zeroValue : this.map.valueTable[this.nextIndex];
                    this.currentIndex = this.nextIndex;
                    this.findNextIndex();
                    return n;
                }
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            throw new NoSuchElementException();
        }

        public IntArray toArray() {
            IntArray intArray = new IntArray(true, this.map.size);
            while (this.hasNext) {
                intArray.add(this.next());
            }
            return intArray;
        }
    }
}

