/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Collections;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.StringBuilder;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IntFloatMap
implements Iterable<Entry> {
    private static final int EMPTY = 0;
    private static final int PRIME1 = -1105259343;
    private static final int PRIME2 = -1262997959;
    private static final int PRIME3 = -825114047;
    int capacity;
    private Entries entries1;
    private Entries entries2;
    boolean hasZeroValue;
    private int hashShift;
    int[] keyTable;
    private Keys keys1;
    private Keys keys2;
    private float loadFactor;
    private int mask;
    private int pushIterations;
    public int size;
    private int stashCapacity;
    int stashSize;
    private int threshold;
    float[] valueTable;
    private Values values1;
    private Values values2;
    float zeroValue;

    public IntFloatMap() {
        this(51, 0.8f);
    }

    public IntFloatMap(int n) {
        this(n, 0.8f);
    }

    public IntFloatMap(int n, float f) {
        if (n >= 0) {
            if ((n = MathUtils.nextPowerOfTwo((int)Math.ceil((float)n / f))) <= 0x40000000) {
                this.capacity = n;
                if (!(f <= 0.0f)) {
                    this.loadFactor = f;
                    n = this.capacity;
                    this.threshold = (int)((float)n * f);
                    this.mask = n - 1;
                    this.hashShift = 31 - Integer.numberOfTrailingZeros(n);
                    this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(this.capacity)) * 2);
                    this.pushIterations = Math.max(Math.min(this.capacity, 8), (int)Math.sqrt(this.capacity) / 8);
                    this.keyTable = new int[this.capacity + this.stashCapacity];
                    this.valueTable = new float[this.keyTable.length];
                    return;
                }
                java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
                stringBuilder.append("loadFactor must be > 0: ");
                stringBuilder.append(f);
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append("initialCapacity is too large: ");
            stringBuilder.append(n);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("initialCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public IntFloatMap(IntFloatMap intFloatMap) {
        this((int)Math.floor((float)intFloatMap.capacity * intFloatMap.loadFactor), intFloatMap.loadFactor);
        this.stashSize = intFloatMap.stashSize;
        Object[] objectArray = intFloatMap.keyTable;
        System.arraycopy(objectArray, 0, this.keyTable, 0, objectArray.length);
        objectArray = intFloatMap.valueTable;
        System.arraycopy(objectArray, 0, this.valueTable, 0, objectArray.length);
        this.size = intFloatMap.size;
        this.zeroValue = intFloatMap.zeroValue;
        this.hasZeroValue = intFloatMap.hasZeroValue;
    }

    private boolean containsKeyStash(int n) {
        int[] nArray = this.keyTable;
        int n2 = this.capacity;
        int n3 = this.stashSize;
        for (int i = n2; i < n3 + n2; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    private float getAndIncrementStash(int n, float f, float f2) {
        Object[] objectArray = this.keyTable;
        int n2 = this.capacity;
        int n3 = this.stashSize;
        for (int i = n2; i < n3 + n2; ++i) {
            if (n != objectArray[i]) continue;
            objectArray = this.valueTable;
            f = objectArray[i];
            objectArray[i] = (int)(f2 + f);
            return f;
        }
        this.put(n, f2 + f);
        return f;
    }

    private float getStash(int n, float f) {
        int[] nArray = this.keyTable;
        int n2 = this.capacity;
        int n3 = this.stashSize;
        for (int i = n2; i < n3 + n2; ++i) {
            if (n != nArray[i]) continue;
            return this.valueTable[i];
        }
        return f;
    }

    private int hash2(int n) {
        return ((n *= -1262997959) ^ n >>> this.hashShift) & this.mask;
    }

    private int hash3(int n) {
        return ((n *= -825114047) ^ n >>> this.hashShift) & this.mask;
    }

    private void push(int n, float f, int n2, int n3, int n4, int n5, int n6, int n7) {
        int[] nArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n8 = this.mask;
        int n9 = this.pushIterations;
        int n10 = 0;
        int n11 = n4;
        int n12 = n2;
        float f2 = f;
        n4 = n;
        n2 = n10;
        do {
            if ((n = MathUtils.random(2)) != 0) {
                if (n != 1) {
                    f = fArray[n6];
                    nArray[n6] = n4;
                    fArray[n6] = f2;
                    n = n7;
                } else {
                    f = fArray[n11];
                    nArray[n11] = n4;
                    fArray[n11] = f2;
                    n = n5;
                }
            } else {
                f = fArray[n12];
                nArray[n12] = n4;
                fArray[n12] = f2;
                n = n3;
            }
            n12 = n & n8;
            n3 = nArray[n12];
            if (n3 == 0) {
                nArray[n12] = n;
                fArray[n12] = f;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n11 = this.hash2(n);
            n5 = nArray[n11];
            if (n5 == 0) {
                nArray[n11] = n;
                fArray[n11] = f;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n6 = this.hash3(n);
            n7 = nArray[n6];
            if (n7 == 0) {
                nArray[n6] = n;
                fArray[n6] = f;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n2 = n10 = n2 + 1;
            n4 = n;
            f2 = f;
        } while (n10 != n9);
        this.putStash(n, f);
    }

    private void putResize(int n, float f) {
        if (n == 0) {
            this.zeroValue = f;
            this.hasZeroValue = true;
            return;
        }
        int[] nArray = this.keyTable;
        int n2 = n & this.mask;
        int n3 = nArray[n2];
        if (n3 == 0) {
            nArray[n2] = n;
            this.valueTable[n2] = f;
            n = this.size;
            this.size = n + 1;
            if (n >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        nArray = this.keyTable;
        int n4 = this.hash2(n);
        int n5 = nArray[n4];
        if (n5 == 0) {
            nArray[n4] = n;
            this.valueTable[n4] = f;
            n = this.size;
            this.size = n + 1;
            if (n >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        nArray = this.keyTable;
        int n6 = this.hash3(n);
        int n7 = nArray[n6];
        if (n7 == 0) {
            nArray[n6] = n;
            this.valueTable[n6] = f;
            n = this.size;
            this.size = n + 1;
            if (n >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(n, f, n2, n3, n4, n5, n6, n7);
    }

    private void putStash(int n, float f) {
        int n2 = this.stashSize;
        if (n2 == this.stashCapacity) {
            this.resize(this.capacity << 1);
            this.putResize(n, f);
            return;
        }
        int n3 = this.capacity + n2;
        this.keyTable[n3] = n;
        this.valueTable[n3] = f;
        this.stashSize = n2 + 1;
        ++this.size;
    }

    private void resize(int n) {
        int n2 = this.capacity;
        int n3 = this.stashSize;
        this.capacity = n;
        this.threshold = (int)((float)n * this.loadFactor);
        this.mask = n - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(n);
        double d = n;
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(d)) * 2);
        this.pushIterations = Math.max(Math.min(n, 8), (int)Math.sqrt(d) / 8);
        int[] nArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n4 = this.stashCapacity;
        this.keyTable = new int[n + n4];
        this.valueTable = new float[n + n4];
        n4 = this.size;
        this.size = this.hasZeroValue ? 1 : 0;
        this.stashSize = 0;
        if (n4 > 0) {
            for (n = 0; n < n2 + n3; ++n) {
                n4 = nArray[n];
                if (n4 == 0) continue;
                this.putResize(n4, fArray[n]);
            }
        }
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        int[] nArray = this.keyTable;
        int n = this.capacity + this.stashSize;
        while (true) {
            int n2 = n - 1;
            if (n <= 0) break;
            nArray[n2] = 0;
            n = n2;
        }
        this.hasZeroValue = false;
        this.size = 0;
        this.stashSize = 0;
    }

    public void clear(int n) {
        if (this.capacity <= n) {
            this.clear();
            return;
        }
        this.hasZeroValue = false;
        this.size = 0;
        this.resize(n);
    }

    public boolean containsKey(int n) {
        if (n == 0) {
            return this.hasZeroValue;
        }
        int n2 = this.mask;
        if (this.keyTable[n2 & n] != n && this.keyTable[n2 = this.hash2(n)] != n && this.keyTable[n2 = this.hash3(n)] != n) {
            return this.containsKeyStash(n);
        }
        return true;
    }

    public boolean containsValue(float f) {
        if (this.hasZeroValue && this.zeroValue == f) {
            return true;
        }
        int[] nArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n = this.capacity + this.stashSize;
        while (true) {
            int n2 = n - 1;
            if (n <= 0) break;
            if (nArray[n2] != 0 && fArray[n2] == f) {
                return true;
            }
            n = n2;
        }
        return false;
    }

    public boolean containsValue(float f, float f2) {
        if (this.hasZeroValue && Math.abs(this.zeroValue - f) <= f2) {
            return true;
        }
        float[] fArray = this.valueTable;
        int n = this.capacity + this.stashSize;
        while (true) {
            int n2 = n - 1;
            if (n <= 0) break;
            if (Math.abs(fArray[n2] - f) <= f2) {
                return true;
            }
            n = n2;
        }
        return false;
    }

    public void ensureCapacity(int n) {
        if (n >= 0) {
            if ((n = this.size + n) >= this.threshold) {
                this.resize(MathUtils.nextPowerOfTwo((int)Math.ceil((float)n / this.loadFactor)));
            }
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("additionalCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public Entries entries() {
        if (Collections.allocateIterators) {
            return new Entries(this);
        }
        if (this.entries1 == null) {
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        if (!this.entries1.valid) {
            this.entries1.reset();
            Entries entries = this.entries1;
            entries.valid = true;
            this.entries2.valid = false;
            return entries;
        }
        this.entries2.reset();
        Entries entries = this.entries2;
        entries.valid = true;
        this.entries1.valid = false;
        return entries;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntFloatMap)) {
            return false;
        }
        IntFloatMap intFloatMap = (IntFloatMap)object;
        if (intFloatMap.size != this.size) {
            return false;
        }
        boolean bl = intFloatMap.hasZeroValue;
        boolean bl2 = this.hasZeroValue;
        if (bl != bl2) {
            return false;
        }
        if (bl2 && intFloatMap.zeroValue != this.zeroValue) {
            return false;
        }
        object = this.keyTable;
        float[] fArray = this.valueTable;
        int n = this.capacity;
        int n2 = this.stashSize;
        for (int i = 0; i < n + n2; ++i) {
            Object object2 = object[i];
            if (object2 == false) continue;
            float f = intFloatMap.get((int)object2, 0.0f);
            if (f == 0.0f && !intFloatMap.containsKey((int)object2)) {
                return false;
            }
            if (f == fArray[i]) continue;
            return false;
        }
        return true;
    }

    public int findKey(float f, int n) {
        if (this.hasZeroValue && this.zeroValue == f) {
            return 0;
        }
        int[] nArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n2 = this.capacity + this.stashSize;
        while (true) {
            int n3 = n2 - 1;
            if (n2 <= 0) break;
            if (nArray[n3] != 0 && fArray[n3] == f) {
                return nArray[n3];
            }
            n2 = n3;
        }
        return n;
    }

    public float get(int n, float f) {
        int n2;
        if (n == 0) {
            if (!this.hasZeroValue) {
                return f;
            }
            return this.zeroValue;
        }
        int n3 = n2 = this.mask & n;
        if (this.keyTable[n2] != n) {
            n3 = n2 = this.hash2(n);
            if (this.keyTable[n2] != n) {
                n3 = n2 = this.hash3(n);
                if (this.keyTable[n2] != n) {
                    return this.getStash(n, f);
                }
            }
        }
        return this.valueTable[n3];
    }

    public float getAndIncrement(int n, float f, float f2) {
        int n2;
        if (n == 0) {
            if (this.hasZeroValue) {
                f = this.zeroValue;
                this.zeroValue = f2 + f;
                return f;
            }
            this.hasZeroValue = true;
            this.zeroValue = f2 + f;
            ++this.size;
            return f;
        }
        int n3 = n2 = this.mask & n;
        if (n != this.keyTable[n2]) {
            n3 = n2 = this.hash2(n);
            if (n != this.keyTable[n2]) {
                n3 = n2 = this.hash3(n);
                if (n != this.keyTable[n2]) {
                    return this.getAndIncrementStash(n, f, f2);
                }
            }
        }
        float[] fArray = this.valueTable;
        f = fArray[n3];
        fArray[n3] = f2 + f;
        return f;
    }

    public int hashCode() {
        boolean bl = this.hasZeroValue;
        int n = bl ? Float.floatToIntBits(this.zeroValue) + 0 : 0;
        int[] nArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n2 = this.capacity;
        int n3 = this.stashSize;
        for (int i = 0; i < n2 + n3; ++i) {
            int n4 = nArray[i];
            int n5 = n;
            if (n4 != 0) {
                n5 = n + n4 * 31 + Float.floatToIntBits(fArray[i]);
            }
            n = n5;
        }
        return n;
    }

    public boolean isEmpty() {
        boolean bl = this.size == 0;
        return bl;
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.entries();
    }

    public Keys keys() {
        if (Collections.allocateIterators) {
            return new Keys(this);
        }
        if (this.keys1 == null) {
            this.keys1 = new Keys(this);
            this.keys2 = new Keys(this);
        }
        if (!this.keys1.valid) {
            this.keys1.reset();
            Keys keys = this.keys1;
            keys.valid = true;
            this.keys2.valid = false;
            return keys;
        }
        this.keys2.reset();
        Keys keys = this.keys2;
        keys.valid = true;
        this.keys1.valid = false;
        return keys;
    }

    public boolean notEmpty() {
        boolean bl = this.size > 0;
        return bl;
    }

    public void put(int n, float f) {
        if (n == 0) {
            this.zeroValue = f;
            if (!this.hasZeroValue) {
                this.hasZeroValue = true;
                ++this.size;
            }
            return;
        }
        int[] nArray = this.keyTable;
        int n2 = n & this.mask;
        int n3 = nArray[n2];
        if (n == n3) {
            this.valueTable[n2] = f;
            return;
        }
        int n4 = this.hash2(n);
        int n5 = nArray[n4];
        if (n == n5) {
            this.valueTable[n4] = f;
            return;
        }
        int n6 = this.hash3(n);
        int n7 = nArray[n6];
        if (n == n7) {
            this.valueTable[n6] = f;
            return;
        }
        int n8 = this.capacity;
        int n9 = this.stashSize;
        for (int i = n8; i < n9 + n8; ++i) {
            if (n != nArray[i]) continue;
            this.valueTable[i] = f;
            return;
        }
        if (n3 == 0) {
            nArray[n2] = n;
            this.valueTable[n2] = f;
            n = this.size;
            this.size = n + 1;
            if (n >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        if (n5 == 0) {
            nArray[n4] = n;
            this.valueTable[n4] = f;
            n = this.size;
            this.size = n + 1;
            if (n >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        if (n7 == 0) {
            nArray[n6] = n;
            this.valueTable[n6] = f;
            n = this.size;
            this.size = n + 1;
            if (n >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(n, f, n2, n3, n4, n5, n6, n7);
    }

    public void putAll(IntFloatMap object) {
        for (Entry entry : ((IntFloatMap)object).entries()) {
            this.put(entry.key, entry.value);
        }
    }

    public float remove(int n, float f) {
        if (n == 0) {
            if (!this.hasZeroValue) {
                return f;
            }
            this.hasZeroValue = false;
            --this.size;
            return this.zeroValue;
        }
        int[] nArray = this.keyTable;
        int n2 = this.mask & n;
        if (n == nArray[n2]) {
            nArray[n2] = 0;
            f = this.valueTable[n2];
            --this.size;
            return f;
        }
        nArray = this.keyTable;
        n2 = this.hash2(n);
        if (n == nArray[n2]) {
            nArray[n2] = 0;
            f = this.valueTable[n2];
            --this.size;
            return f;
        }
        nArray = this.keyTable;
        n2 = this.hash3(n);
        if (n == nArray[n2]) {
            nArray[n2] = 0;
            f = this.valueTable[n2];
            --this.size;
            return f;
        }
        return this.removeStash(n, f);
    }

    float removeStash(int n, float f) {
        int[] nArray = this.keyTable;
        int n2 = this.capacity;
        int n3 = this.stashSize;
        for (int i = n2; i < n3 + n2; ++i) {
            if (n != nArray[i]) continue;
            f = this.valueTable[i];
            this.removeStashIndex(i);
            --this.size;
            return f;
        }
        return f;
    }

    void removeStashIndex(int n) {
        --this.stashSize;
        int n2 = this.capacity + this.stashSize;
        if (n < n2) {
            Object[] objectArray = this.keyTable;
            objectArray[n] = objectArray[n2];
            objectArray = this.valueTable;
            objectArray[n] = objectArray[n2];
        }
    }

    public void shrink(int n) {
        if (n >= 0) {
            int n2 = this.size;
            int n3 = n;
            if (n2 > n) {
                n3 = n2;
            }
            if (this.capacity <= n3) {
                return;
            }
            this.resize(MathUtils.nextPowerOfTwo(n3));
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("maximumCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public String toString() {
        int n;
        int n2;
        float[] fArray;
        int[] nArray;
        StringBuilder stringBuilder;
        block6: {
            if (this.size == 0) {
                return "{}";
            }
            stringBuilder = new StringBuilder(32);
            stringBuilder.append('{');
            nArray = this.keyTable;
            fArray = this.valueTable;
            int n3 = n2 = nArray.length;
            if (this.hasZeroValue) {
                stringBuilder.append("0=");
                stringBuilder.append(this.zeroValue);
            } else {
                while (true) {
                    n2 = n = n3 - 1;
                    if (n3 <= 0) break block6;
                    n2 = nArray[n];
                    if (n2 != 0) break;
                    n3 = n;
                }
                stringBuilder.append(n2);
                stringBuilder.append('=');
                stringBuilder.append(fArray[n]);
                n2 = n;
            }
        }
        while (true) {
            n = n2 - 1;
            if (n2 <= 0) break;
            n2 = nArray[n];
            if (n2 == 0) {
                n2 = n;
                continue;
            }
            stringBuilder.append(", ");
            stringBuilder.append(n2);
            stringBuilder.append('=');
            stringBuilder.append(fArray[n]);
            n2 = n;
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public Values values() {
        if (Collections.allocateIterators) {
            return new Values(this);
        }
        if (this.values1 == null) {
            this.values1 = new Values(this);
            this.values2 = new Values(this);
        }
        if (!this.values1.valid) {
            this.values1.reset();
            Values values = this.values1;
            values.valid = true;
            this.values2.valid = false;
            return values;
        }
        this.values2.reset();
        Values values = this.values2;
        values.valid = true;
        this.values1.valid = false;
        return values;
    }

    public static class Entries
    extends MapIterator
    implements Iterable<Entry>,
    Iterator<Entry> {
        private Entry entry = new Entry();

        public Entries(IntFloatMap intFloatMap) {
            super(intFloatMap);
        }

        @Override
        public boolean hasNext() {
            if (this.valid) {
                return this.hasNext;
            }
            throw new GdxRuntimeException("#iterator() cannot be used nested.");
        }

        @Override
        public Iterator<Entry> iterator() {
            return this;
        }

        @Override
        public Entry next() {
            if (this.hasNext) {
                if (this.valid) {
                    Object object = this.map.keyTable;
                    if (this.nextIndex == -1) {
                        object = this.entry;
                        object.key = 0;
                        object.value = this.map.zeroValue;
                    } else {
                        this.entry.key = object[this.nextIndex];
                        this.entry.value = this.map.valueTable[this.nextIndex];
                    }
                    this.currentIndex = this.nextIndex;
                    this.findNextIndex();
                    return this.entry;
                }
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            super.remove();
        }
    }

    public static class Entry {
        public int key;
        public float value;

        public String toString() {
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append(this.key);
            stringBuilder.append("=");
            stringBuilder.append(this.value);
            return stringBuilder.toString();
        }
    }

    public static class Keys
    extends MapIterator {
        public Keys(IntFloatMap intFloatMap) {
            super(intFloatMap);
        }

        public boolean hasNext() {
            if (this.valid) {
                return this.hasNext;
            }
            throw new GdxRuntimeException("#iterator() cannot be used nested.");
        }

        public int next() {
            if (this.hasNext) {
                if (this.valid) {
                    int n = this.nextIndex == -1 ? 0 : this.map.keyTable[this.nextIndex];
                    this.currentIndex = this.nextIndex;
                    this.findNextIndex();
                    return n;
                }
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            throw new NoSuchElementException();
        }

        public IntArray toArray() {
            IntArray intArray = new IntArray(true, this.map.size);
            while (this.hasNext) {
                intArray.add(this.next());
            }
            return intArray;
        }
    }

    private static class MapIterator {
        static final int INDEX_ILLEGAL = -2;
        static final int INDEX_ZERO = -1;
        int currentIndex;
        public boolean hasNext;
        final IntFloatMap map;
        int nextIndex;
        boolean valid = true;

        public MapIterator(IntFloatMap intFloatMap) {
            this.map = intFloatMap;
            this.reset();
        }

        void findNextIndex() {
            block1: {
                this.hasNext = false;
                int[] nArray = this.map.keyTable;
                int n = this.map.capacity;
                int n2 = this.map.stashSize;
                do {
                    int n3;
                    this.nextIndex = n3 = this.nextIndex + 1;
                    if (n3 >= n + n2) break block1;
                } while (nArray[this.nextIndex] == 0);
                this.hasNext = true;
            }
        }

        public void remove() {
            block7: {
                block6: {
                    block5: {
                        if (this.currentIndex != -1 || !this.map.hasZeroValue) break block5;
                        this.map.hasZeroValue = false;
                        break block6;
                    }
                    int n = this.currentIndex;
                    if (n < 0) break block7;
                    if (n >= this.map.capacity) {
                        this.map.removeStashIndex(this.currentIndex);
                        this.nextIndex = this.currentIndex - 1;
                        this.findNextIndex();
                    } else {
                        this.map.keyTable[this.currentIndex] = 0;
                    }
                }
                this.currentIndex = -2;
                IntFloatMap intFloatMap = this.map;
                --intFloatMap.size;
                return;
            }
            throw new IllegalStateException("next must be called before remove.");
        }

        public void reset() {
            this.currentIndex = -2;
            this.nextIndex = -1;
            if (this.map.hasZeroValue) {
                this.hasNext = true;
            } else {
                this.findNextIndex();
            }
        }
    }

    public static class Values
    extends MapIterator {
        public Values(IntFloatMap intFloatMap) {
            super(intFloatMap);
        }

        public boolean hasNext() {
            if (this.valid) {
                return this.hasNext;
            }
            throw new GdxRuntimeException("#iterator() cannot be used nested.");
        }

        public float next() {
            if (this.hasNext) {
                if (this.valid) {
                    float f = this.nextIndex == -1 ? this.map.zeroValue : this.map.valueTable[this.nextIndex];
                    this.currentIndex = this.nextIndex;
                    this.findNextIndex();
                    return f;
                }
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            throw new NoSuchElementException();
        }

        public FloatArray toArray() {
            FloatArray floatArray = new FloatArray(true, this.map.size);
            while (this.hasNext) {
                floatArray.add(this.next());
            }
            return floatArray;
        }
    }
}

